Ext.define('Keysystems.SActivityIndex.Edit', {
	extend: 'Keysystems.Base.Edit',
	isCodeEdit: true,
	codeEditCfg: {maxLength: 10, enforceMaxLength: true},
	isNameEdit: true,
	nameEditCfg: {maxLength: 1000, enforceMaxLength: true},
	isDHEdit: true,
	dhEditCfg: {maxWidth: 400},

	createItems: function () {
		var me = this,
			objs = me.objs;

		me.callParent(arguments);

		return [
			me.gksc('CODE'),
			me.gksc('NAME'),
			Ext.create('Ext.panel.Panel', {
				layout: {type: 'hbox', align: 'stretch'},
				border: 0,
				padding: '0 0 5 0',
				items: [
					me.ksControls.type = Ext.create('Ext.form.field.ComboBox', {
						labelWidth: me.labelWidth,
						fieldLabel: 'Тип',
						store: Ext.create('Ext.data.Store', {
							fields: CBDataLib.getFields(),
							data: CBDataLib.get('SActivityIndexType'),
							proxy: 'memory'
						}),
						displayField: 'value',
						valueField: 'index',
						value: 0,
						editable: false,
						listeners: {
							change: function (th, val) {
								var t = miscTypes.SActivityIndexType[val];
								me.gksc('list').setVisible(t === 'Список');
							}
						}
					}),

					me.ksControls.list = Ext.create('Ext.form.field.Text', {
						flex: 4,
						margin: '0 0 0 5',
						hidden: true,
						triggers: {
							btn: {
								cls: 'x_btn_keysystems x-dict-trigger',
								handler: function () {
									let editor = Ext.create('RevizorListEditor', {
										data: me.gksd('list'),
										okFunc: function (list) {
											me.gksc('list').setValue(me.sksd('list', list));
										},
									});
									editor.show();
								}
							}
						},
					})
				]
			}),
			me.ksControls.objType = Ext.create('Ext.form.field.ComboBox', {
				labelWidth: me.labelWidth,
				fieldLabel: 'Тип объекта',
				maxWidth: 300,
				store: Ext.create('Ext.data.Store', {
					fields: CBDataLib.getFields(),
					data: CBDataLib.get('ObjType').filter(r => r["index"] !== "0"),
					proxy: 'memory'
				}),
				displayField: 'value',
				valueField: 'index',
				value: 0,
				editable: false,
				ksAllowEmpty: true,
				listeners: {
					change: function (th, val) {
						if (me.isLoaded) return;
						me.filterCriteria(val);
					}
				}
			}),
			me.ksControls.groupCriteria = Ext.create('Ext.form.field.ComboBox', {
				labelWidth: me.labelWidth,
				fieldLabel: 'Группа критериев',
				maxWidth: 300,
				store: Ext.create('Ext.data.Store', {
					fields: CBDataLib.getFields(),
					proxy: 'memory'
				}),
				displayField: 'value',
				valueField: 'index',
				value: 0,
				editable: false
			}),
			me.sksc('ORD', Ext.create('Ext.form.field.Text', {
				labelWidth: me.labelWidth,
				fieldLabel: 'Порядок',
				maxWidth: 300
			})),
			me.gksc('DH')
		];
	},

	getExtra: function (callBack, link) {
		var me = this;
		me.baseGetExtra({link: link}, function (value) {
			me.autoFillControl(value.row);

			me.gksc('type').setValue(value.row.TYPE);
			me.gksc('list').setValue(me.sksd('list', value.list || []));

			me.gksc('objType').setValue(value.row.OBJTYPE);
			if (!value.isVFK || !value.isFincontrol) {
				me.gksc('objType').setVisible(false);
			}
			me.gksc('groupCriteria').setValue(value.row.CGROUP);
			me.filterCriteria(value.row.OBJTYPE);

			if ((value.ordAccess & ObjAccessMask.READ) === 0) {
				me.gksc('ORD').setVisible(false);
			} else if ((value.ordAccess & ObjAccessMask.EDIT) === 0) {
				me.gksc('ORD').setReadOnly(true);
			}
			me.gksc('ORD').setValue(value.row.ORD);

			if (callBack) callBack();
		});
	},

	filterCriteria: function (objType) {
		var me = this,
			cmbGroup = me.ksControls.groupCriteria;
		if (!objType) {
			cmbGroup.setDisabled(true);
		} else {
			cmbGroup.setDisabled(false);
			let data = parseInt(objType) === 1
				? CBDataLib.get('GroupCriteria', true).filter(r => !r.index || parseInt(r.index) === 1 || parseInt(r.index) === 2)
				: CBDataLib.get('GroupCriteria', true).filter(r => !r.index || parseInt(r.index) === 1 || parseInt(r.index) === 4);
			cmbGroup.bindStore(data);
			if ((parseInt(objType) === 1 && parseInt(cmbGroup.getValue()) === 4)
				|| (parseInt(objType) === 2 && parseInt(cmbGroup.getValue()) === 2))
				cmbGroup.setValue(0);
		}
	},
	dataCollector: function () {
		var me = this,
			data = me.callParent(arguments);

		data.type = me.gksc('type').getValue();
		data.list = miscTypes.SActivityIndexType[data.type] === 'Список' ? me.gksd('list') : '[]';
		data.objtype = me.gksc('objType').getValue();
		data.cgroup = me.gksc('groupCriteria').getValue();
		data.ord = me.gksc('ORD').getValue();

		return data;
	},
});