﻿Ext.define('Keysystems.Bk.Edit', {
	extend: 'Keysystems.Base.Edit',
	createItems: function() {
		var me = this,
			objs = me.objs,
			items = [
				objs.S_BUDGET = me.createDictEdit({
					mode: 'MULTI',
					code: dnl.S_BUDGET,
					labelWidth: me.labelWidth,
					fieldLabel: 'Бюджет',
				})
			];

		me.isCodeEdit = true;
		me.codeEditCfg = { maxLength: 20, enforceMaxLength: true };
		me.isNameEdit = true;
		me.nameEditCfg = { maxLength: 1024, enforceMaxLength: true };
		me.isSNameEdit = true;
		me.snameEditCfg = { maxLength: 60, enforceMaxLength: true };
		me.isDHEdit = true;

		return me.callParent([items]);
	},
	dataCollector: function() {
		var me = this,
			objs = me.objs,
			data = me.callParent(arguments);

		data.sBudget = objs.S_BUDGET.getLinks(1);

		return data;
	},
	getExtra: function(endFunc, link) {
		var me = this,
			objs = me.objs;

		me.baseGetExtra({ link: Ext.isNumber(link) ? link : me.data.data.LINK }, function(value) {
			me.autoFillControl(value.row);

			objs.S_BUDGET.setVisible(value.budgetAccess);
			objs.S_BUDGET.setValue(value.S_BUDGET);
			objs.CODE.maxLength = value.codeLength;

			endFunc && endFunc();
		});
	}
});