Ext.define('Keysystems.DFTask.Edit', {
	extend: 'Keysystems.Base.Edit',
	title: 'Задачи документооборота',
	isFileBtn: true,
	profileListeners: [{name: 'view', method: 'FormParam'}],
	labelWidth: 170,
	viewMinSize: [720, 470],
	config: {
		isTaskExecutor: false,
		sOrgOtv: [],
		dfDocument: 0,
		author: 0,
		FillFromDFDocuments: false
	},
	viewCfg: function () {
		let cfg = this.callParent(arguments);
		cfg.resizable = true;
		cfg.maximizable = true;
		return cfg;
	},
	//констркутор интерфейса
	createItems: function () {
		var me = this,
			items = [
				Ext.create('Ext.form.FieldContainer', {
					layout: {type: 'hbox', align: 'stretch'},
					items: [
						me.sksc('DT', Ext.create('Ext.form.field.Date', {
							labelWidth: me.labelWidth,
							format: 'd.m.Y',
							fieldLabel: 'Дата',
							ksAllowEmpty: true,
							minValue: longPeriod.begin,
							maxValue: longPeriod.end,
							value: now,
							width: me.labelWidth + 110
						})),
						me.sksc('TEMP_AUTHOR_FIO', Ext.create('Ext.form.field.Text',
							{
								labelWidth: 70,
								flex: 1,
								readOnly: true,
								fieldLabel: 'Автор',
								padding: '0 0 0 30'
							}))
					]
				}),
				me.createDictEdit({
					key: 'DF_S_TASK',
					code: dnl.DF_S_TASK,
					fieldLabel: 'Вид задачи',
					mode: 'SINGL',
					ksAllowEmpty: true,
					labelWidth: me.labelWidth,
					listeners: {
						change: function(th, newValue) {
							let newLink = newValue[0].LINK || newValue[0].data.LINK;
							
							if (newValue.length>0 && me.gksd('AllowEmptyDateList').includes(newLink)) {
								me.gksc('DTENDUTV').setKsAllowEmpty(false);
							}
							else{
								me.gksc('DTENDUTV').setKsAllowEmpty(true);
							} 
						}
					},
				}),
				me.sksc('DESCRIPTION', Ext.create('Ext.form.field.TextArea', {
					fieldLabel: 'Описание',
					labelWidth: me.labelWidth,
					fieldCls: 'rks-textarea',
					minHeight: 100,
					flex: 1
				})),
				me.createDictEdit({
					key: 'S_PERSON',
					code: dnl.S_PERSON,
					mode: 'MULTI',
					fieldLabel: 'Исполнитель',
					labelWidth: me.labelWidth,
					mainColumn: true,
					mainColumnSingleCheck: true,
					ksSetValue: function (v) {
						this.setValue(v);
						var sPerson = [];

						Ext.each(v,
							function(person) {
								person = person.data || person;

								sPerson.push({
									LINK: person.LINK,
									MAIN: person.MAIN || false
								});
							});

						me.sksd('sPerson', sPerson);
						
						if (me.isLoaded) return;
						me.setIsTaskExecutor(this.getLinks().indexOf(window.user.person.data.LINK) >= 0);						
					},
					initWhereArgs: function () {
						let wa = {
							DH1: {value: longPeriod.begin, type: 'Date'},
							DH2: {value: longPeriod.end, type: 'Date'},
							HasFilterOnLoad: {value: false, type: 'bool'}
						};

						let sOrgOtv = me.getSOrgOtv();
						if (sOrgOtv.length) {
							wa.SOrgs = {type: 'List_int', value: JSON.stringify(sOrgOtv)}
						} else {
							wa.SOrgs = {type: 'List_int', value: JSON.stringify([window.user.org])}
						}
						return wa;
					}
				}),
				me.sksc('DTENDUTV', Ext.create('Ext.form.field.Date', {
					labelWidth: me.labelWidth,
					format: 'd.m.Y',
					fieldLabel: 'Срок исполнения',
					ksAllowEmpty: false,
					minValue: longPeriod.begin,
					maxValue: longPeriod.end,
					value: now,
					maxWidth: me.labelWidth + 110
				})),
				Ext.create('Ext.form.FieldContainer', {
					layout: {type: 'hbox', align: 'stretch'},
					items: [
						me.sksc('DTUTV', Ext.create('Ext.form.field.Date', {
							labelWidth: me.labelWidth,
							format: 'd.m.Y',
							fieldLabel: 'Дата исполнения',
							minValue: longPeriod.begin,
							maxValue: longPeriod.end,
							value: now,
							width: me.labelWidth + 110,
							listeners: {
								change: function (th, v) {
									me.gksc('UTVPERSON').setValue(v ? window.user.person.data.NAME : null);
								}
							}

						})),
						me.sksc('UTVPERSON', Ext.create('Ext.form.field.Text',
							{
								labelWidth: 70,
								flex: 1,
								fieldLabel: 'Исполнил',
								padding: '0 0 0 30',
								readOnly: true
							}))
					]
				}),
				me.sksc('DTOZN', Ext.create('Ext.form.field.Date', {
					fieldLabel: 'Дата/время ознакомления',
					labelWidth: me.labelWidth,
					format: 'd.m.Y H:i:s',
					emptyText: "дд.мм.гггг чч:мм:сс",
					maxWidth: me.labelWidth + 210,
					minValue: longPeriod.begin,
					maxValue: longPeriod.end,
					visibleTime: true,
					afterSelect: function(m, d){
						var nowDate = new Date();
						this.setValue(new Date(d.getFullYear(), d.getMonth(), d.getDate(), nowDate.getHours(), nowDate.getMinutes(), nowDate.getSeconds()));
					}
				})),
				me.sksc('COMMENT', Ext.create('Ext.form.field.TextArea', {
					fieldLabel: 'Комментарий',
					labelWidth: me.labelWidth,
					fieldCls: 'rks-textarea',
					height: 70

				})),
				me.sksc('DTCONFIRMUTV', Ext.create('Ext.form.field.Date', {
					labelWidth: me.labelWidth,
					format: 'd.m.Y',
					fieldLabel: 'Подтверждение исполнения',
					minValue: longPeriod.begin,
					maxValue: longPeriod.end,
					value: now,
					maxWidth: me.labelWidth + 110
				})),
				me.sksc('ORD', Ext.create('Ext.form.field.Number', {
					fieldLabel: 'Порядковый номер',
					maxWidth: me.labelWidth + 110,
					maxValue: 32766,
					minValue: 0,
					ksLimitMaxMin: true,
					labelWidth: me.labelWidth
				}))
			]
		return items;
	},

	getExtra: function (callBack, link) {
		var me = this;
		me.baseGetExtra({
			link: link,
			FillFromDFDocuments: me.FillFromDFDocuments,
		}, function (value) {
			if (value.ErrorMsg) {
				showError(value.ErrorMsg);
				me.isExit = true;
				LoadMask.hide();
				return;
			}
			me.setDfDocument(value.row.DF_DOCUMENTS);
			me.setSOrgOtv(me.whereArgs.SOrgOtv ? JSON.parse(me.whereArgs.SOrgOtv.value) : [])
			me.setFillFromDFDocuments(me.FillFromDFDocuments);
			me.setAuthor(value.row.AUTHOR);

			if (!value.IsTaskCreator) {
				me.gksc('DT').setReadOnly(true);
				me.gksc('DF_S_TASK').setReadOnly(true);
				me.gksc('DESCRIPTION').setReadOnly(true);
				me.gksc('S_PERSON').setReadOnly(true);
				me.gksc('DTENDUTV').setReadOnly(true);
				me.gksc('DTCONFIRMUTV').setReadOnly(true);
			}
			me.sksd('EditByExecutor', value.EditByExecutor);
			me.sksd('AllowEmptyDateList', value.AllowEmptyDateList);
			me.setIsTaskExecutor(value.IsTaskExecutor);
			me.setObjsValues(value.row, ['DT', 'TEMP_AUTHOR_FIO', 'DESCRIPTION', 'DTENDUTV', 'DTUTV',
				'UTVPERSON', 'COMMENT', 'DTCONFIRMUTV', 'ORD']);

			if (value.row.DTOZN) me.gksc("DTOZN").setValue(new Date(value.row.DTOZN));
			me.gksc("DTOZN").setReadOnly(value.readOnlyOzn);

			me.setObjsValues(value, ['DF_S_TASK', 'S_PERSON']);//исполнитель
			me.objs.btnFile.setIconCls(getExtStyle(value.tempExt));

			if (callBack) callBack();
		});
	},

	loadNewData: function () {
		let me = this;
		me.callParent();
		if (!me.data) me.data = {data: {}};
		me.data.data.FILES = 0;
	},
	
	applyIsTaskExecutor: function (v) {
		let me = this;
		if (me.gksd('EditByExecutor')){
			me.gksc('DTUTV').setReadOnly(!v);
			me.gksc('COMMENT').setReadOnly(!v);			
		}
		if (!v) {
			me.gksc('DTUTV').setValue(null);
			me.gksc('COMMENT').setValue(null);
		}
		return v;
	},

	isFilled: function () {
		let me = this,
			dt = me.gksc('DT'),
			dtEndUtv = me.gksc('DTENDUTV');

		let res = true;
		if (!dt.getValue() || !dt.isValid()) {
			me.addToInvalidControls(dt);
			res = false;
		}

		if (me.gksc('DF_S_TASK').isEmpty()) {
			me.addToInvalidControls(me.gksc('DF_S_TASK'));
			res = false;
		}

		if ((!dtEndUtv.getValue() || !dtEndUtv.isValid()) && (me.gksc('DF_S_TASK').isEmpty() || !me.gksd('AllowEmptyDateList').includes(me.gksc('DF_S_TASK').getLink()))) {
			me.addToInvalidControls(dtEndUtv);
			res = false;
		}
		return res;
	},

	dataCollector: function () {
		let me = this,
			res = me.callParent();

		Ext.each(['DT', 'DESCRIPTION', 'DTENDUTV', 'DTUTV',
				'UTVPERSON', 'COMMENT', 'DTCONFIRMUTV', 'ORD'],
			(key) => res[key] = me.gksc(key).getValue());
		Ext.each(['DF_S_TASK'], (key) => res[key] = me.gksc(key).getLink());

		res.DF_DOCUMENTS = me.getDfDocument();
		res.DF_S_TASK = me.gksc('DF_S_TASK').getLink();
		res.AUTHOR = me.getAuthor();
		res.S_PERSON = JSON.stringify(me.gksd('sPerson'));
		res.files = me.data.data.FILES;
		res.DTOZN = me.gksc("DTOZN").getValue()?.toLocaleString();
		return res;
	},

	createFile: function (link, callback) {
		if (this.readOnly) return;
		UploaderLib.newFile(this.code, link, 0, -1, 0, this.getLoadMaskTarget(), callback);
	},
});