﻿Ext.define('Keysystems.DFDocuments.List', {
	extend: 'Keysystems.Base.List.Tree',
	iconCls: 'message_new',
	bodyPadding: 10,
	deleteCode: 'DOCUMENT_DF_DOCUMENTS',
	fileColumn: true,
	dfDocumentColor: {},
	dfDocumentRegularExpressions: {
		"DtEndUtvExpiredBGColor": /\/\*DtEndUtvExpiredBGColor\*\/.*\/\*/g,
		"DtEndUtvComeBGColor": /\/\*DtEndUtvComeBGColor\*\/.*\/\*/g
	},
	profileListeners: [
		{name: 'DT', method: 'KsPeriodChange'},
		{name: 'S_DOCVID', method: 'ksDictChange'}
	],
	beforeSetData: function (data, params) {
		let me = this,
			res = me.callParent(arguments),
			dfDocumentColor = data.dfDocumentColor;
		
		me.DFDocvids = data.data.DFDocvids;
		me.isFilterByDocType = data.data.isFilterByDocType;
		me.docTypeFilter = data.data.docTypeFilter;
		me.sksd('EDSSaveDocBehavior', data.EDSSaveDocBehavior);
		
		if (window.dfDocumentColor !== dfDocumentColor) {
			window.dfDocumentColor = dfDocumentColor;
			const dfDocumentColorNames = Object.keys(dfDocumentColor);
			//Получаем текущие стили
			let cssBlock = $('#dfdocuments-rows-styles');
			let reviz = cssBlock.text();

			dfDocumentColorNames.map(name => {
				let newProp = dfDocumentColor[name];
				let regexp = me.dfDocumentRegularExpressions[name];
				let newString = `/*${name}*/${newProp}/*`;
				reviz = reviz.replace(regexp, newString);
			});

			cssBlock.text(reviz);
		}
		return res;
	},

	createItems: function () {
		let me = this,
			items = me.callParent(arguments);

		items.unshift(objs.filterPanel = Ext.create('Ext.panel.Panel',
			{
				border: 0,
				bodyBorder: 0,
				collapsible: !me.hideBottomPanel,
				userCls: 'rks-filter-panel',
				header: {
					title: 'Фильтр по Документам',
					hidden: me.hideBottomPanel,
				},
				hideCollapseTool: me.hideBottomPanel,
				layout: {type: 'vbox', align: 'stretch'},
				bodyPadding: me.bodyPadding + ' ' + me.bodyPadding + ' 0 ' + me.bodyPadding,
				animCollapse: false,
				items: [
					Ext.create('Ext.form.FieldContainer',
						{
							layout: {type: 'hbox', align: 'stretch'},
							items: [
								me.sksc('DT', Ext.create('Keysystems.Controls.KsPeriod',
									{
										startYear: me.startYear,
										state: 4,
										allStates: 12,
										width: 400,
										fieldLabel: 'Период',
										listeners: {
											ksChange: function () {
												if (me.isLoading) return;
												me.refreshData();
											}
										}
									})),
								me.sksc('S_DOCVID', Ext.create('Keysystems.Controls.Dict.Edit',
									{
										fieldLabel: 'Вид документа',
										labelWidth: 100,
										padding: '0 10 0 10',
										flex: 1,
										mode: 'MULTI',
										clear: function () {
											this.setValue();
											me.refreshData();
										},
										handler: function () {
											dictFunc({
													mode: 'MULTI',
													parentView: objs.view,
													selectLinks: me.gksc('S_DOCVID').getValue(),
													code: dnl.S_DOCVID,
													control: me.gksc('S_DOCVID'),
													contextSearch: me.gksc('S_DOCVID').contextSearch,
													whereArgs: {
														InLinksOnly: {value: true, type: 'bool'},
														InLinks: {
															value: JSON.stringify(me.DFDocvids.map(r => r.LINK)),
															type: 'List_int'
														}
													}
												},
												{
													ok: function (value) {
														me.gksc('S_DOCVID').setValue(value);
														me.refreshData();
													}
												}
											);
										}
									}))
							]
						})
				]
			}));

		if (me.hideFilterPanel)
			objs.filterPanel.hide();
		return objs.items;
	},

	refreshData: function () {
		let me = this;
		me.setWhereArgs();
		me.refresh();
	},

	initializeFilter: function () {
		let me = this;
		if (!me.whereArgs) return;

		if (me.whereArgs.SDocVid) {
			let dictDocvid = me.gksc('S_DOCVID'),
				docvids = JSON.parse(me.whereArgs.SDocVid.value);

			if (!ArrayLib.equal(dictDocvid.getLinks(), docvids)) {
				dictDocvid.setValue(docvids.map(link => {
					return {LINK: link}
				}));
			}
		}

		if (me.whereArgs.HideSDocVid) {
			me.gksc('S_DOCVID').setVisible(!JSON.parse(me.whereArgs.HideSDocVid.value));
		}

		me.updateDateFromWhereArg(me.whereArgs.DTBegin.value, me.whereArgs.DTEnd.value, me.gksc('DT'));
	},


	setWhereArgs: function () {
		let me = this,
			dt = me.gksc('DT').getValue(),
			sDocvid = me.gksc('S_DOCVID').getLinks();

		let whereArgs = {
			DTBegin: {
				value: dt.dh1,
				type: 'Date'
			},
			DTEnd: {
				value: dt.dh2,
				type: 'Date'
			},
			SDocVid: {
				value: sDocvid ? JSON.stringify(sDocvid) : JSON.stringify([]),
				type: 'List_int'
			}
		};
		me.afterSetWhereArgs && me.afterSetWhereArgs(whereArgs);

		return Ext.apply(me.whereArgs, whereArgs);
	},
	getGridCfg: function () {
		let res = this.callParent(arguments);
		res.userCls = 'rks-grid-with-filter-panel';
		return res;
	},
	columnsAdapted: function (columns) {
		let me = this,
			c = ArrayLib.find(columns, ['dataIndex'], 'HAS_DOCUMENTS');

		if (c === -1) {
			columns.push({
				xtype: 'actioncolumn',
				dataIndex: 'IMG',
				align: 'center',
				width: 150,
				text: 'Документ мероприятия',
				tdCls: 'rks-action-col-noaction-td',
				items: [
					{
						getClass: function (v, meta, rec) {
							return rec.get('DOCUMENTS') ? 'x_btn_document' : '';
						},
					}
				]
			});
		}
		return me.callParent([columns]);
	},
	getRowClass: function (record) {
		var rowStyle = '';
		if (record.data.REMARK) {
			rowStyle += 'ks-overdue';
		}
		rowStyle += ' ' + record.data.rowStyle;
		return rowStyle;
	},
	getFileId: function (rec) {
		return rec.get('TEMP_EXT');
	},

	setSBText: function (allCount, selCount, checkCount) {
		let me = this;
		me.callParent(arguments);
		if (me.hideTBar) return;

		let tbarBtns = me.objs.tbarBtns,
			sel = me.Grid ? me.Grid.getFrstSelect() : null;

		//зарег-ть док-т мер-ия
		tbarBtns.tree_edit?.setDisabled(me.readOnly || me.accessReadOnly);

		//ред-ть мер-ие (request2), открыть док-т (opendoc), удалить связь с док-м (deldocrel)
		const revizExists = sel && sel.data.REVIZ;
		const docExists = sel && sel.data.DOCUMENTS;
		tbarBtns.request2?.setDisabled(!revizExists);
		tbarBtns.opendoc?.setDisabled(!revizExists || !docExists);
		tbarBtns.deldocrel?.setDisabled(me.readOnly || !revizExists || !docExists);
	},

	beforeShowFilterView: function (pars) {
		const parPersonOtv = pars.filter(p => p.Name === 'S_PERSON_OTV.DICTIONARY_SPERSON')[0];
		if (parPersonOtv) {
			parPersonOtv.initWhereArgs = function () {
				const parOrgOtv = pars.filter(p => p.Name === 'S_ORG_OTV.DICTIONARY_SORG')[0];
				const cond = parOrgOtv.fieldCondition.cbCondition;
				const dict = parOrgOtv.fieldCondition.elCondition;
				let whereArgs = {
					DH1: {value: window.objs.businessPeriod.getValue().DH1, type: 'Date'},
					DH2: {value: window.objs.businessPeriod.getValue().DH2, type: 'Date'},
					HasFilterOnLoad: {value: false, type: 'bool'}
				};
				if (cond.getValue() !== -1) {
					whereArgs.SOrgs = {value: dict.getLinks(1), type: 'List_int'};
				} else {
					whereArgs.STypeOrgs = {
						value: JSON.stringify([Ext.Object.getKey(miscTypes.TypeOrg, 'Проверяющая')]),
						type: 'List_int'
					};
				}
				return whereArgs;
			}
		}
	},
	/** Task Revizor.DfDocuments.New */
	new: function () {
		let me = this;
		me.addOrEdit(null);

		//me.edit('new', null, {LINK_SELF: 0, S_DOCVID: 13, TYPE: 1})
	},
	/** Task Revizor.DfDocuments.NewSelf */
	newSelf: function () {
		let me = this,
			sel = me.objs.Grid.getFrstSelect();

		me.addOrEdit(sel.get('LINK'), sel.get('TYPE'));
	},
	addOrEdit: function (linkSelf, type) {
		let me = this;
		dictFunc({
				parentView: tabView,
				mode: 'SINGL',
				code: dnl.S_DOCVID,
				accessReadOnly: true,
				initWhereArgs: function () {
					let wa = {
						InLinksOnly: {value: true, type: 'bool'},
						InLinks: {value: JSON.stringify(me.DFDocvids.map(r => r.LINK)), type: 'List_int'}
					};
					if (me.isFilterByDocType && me.docTypeFilter && type){
						if (me.docTypeFilter[type]){
							wa["SType"] = {type: 'List_int', value: JSON.stringify(me.docTypeFilter[type])};
						}
					}
					return wa; 
				}
			},
			{
				ok: function (value) {
					if (!value.length) return;

					let docType = value[0].data.TYPE,
						funcEdit = () => {
							me.edit('new', null, {LINK_SELF: linkSelf, S_DOCVID: value[0].data.LINK, TYPE: docType})
						};
					let docTypeFilter = 0;
					if (me.isFilterByDocType && me.docTypeFilter && me.docTypeFilter[type]){
						me.docTypeFilter[type].forEach(t => {docTypeFilter |= t;});
					}
					docType = docTypeFilter ? docTypeFilter : docType;
					if (docType !== 1 && docType !== 2 && docType !== 4) {
						Keysystems.Reviz.Edit.prototype.pickTaskDocType(docType, (value) => {
							docType = value;
							funcEdit();
						});
					} else
						funcEdit();
				}
			});
	},

	/**Task Revizor.DfDocuments.RegisterDoc
	 */
	registerDoc: function () {
		let me = this;
		dictFunc({
				parentView: tabView,
				mode: 'SINGL',
				code: dnl.DOCUMENTS,
				control: objs.S_OKSM,
				initWhereArgs: function () {
					let whereArgs = {};
					whereArgs.DFRegistered = {value: 2, type: 'int'};
					whereArgs.DocVid = {
						value: JSON.stringify(me.DFDocvids.map(r => r.LINK)),
						type: 'List_int',
						extValue: me.DFDocvids
					};
					return whereArgs;
				}
			},
			{
				ok: function (value) {
					if (!value.length) return;

					let doc = value[0].data;
					me.edit('new', null, {
						DOCUMENTS: doc.LINK,
						REVIZ: doc.REVIZ,
						S_DOCVID: doc.S_DOCVID,
						TYPE: doc.TYPE
					});
				}
			});
	},

	/**Task Revizor.Reviz.AlienEdit
	 */
	doEditReviz: function () {
		let me = this,
			rec = me.objs.Grid.getFrstSelect();
		if (!rec) return;

		let cfg = {
			f: 'edit',
			data: {data: {LINK: rec.data.REVIZ}},
			code: dnl.REVIZ,
			refreshFunc: function () {
				me.refresh();
			},
			tabMode: !me.isModalEdit(),
			parentView: me.isModalEdit() ? me.objs.view : me.parentView
		};
		Ext.apply(cfg, dictListController.DOCUMENT_REVIZ);
		Ext.create(cfg.editClass, cfg);
	},


	/**Task Revizor.DfDocuments.OpenDoc
	 */
	doEditDoc: function () {
		let me = this,
			rec = me.objs.Grid.getFrstSelect();
		if (!rec || !rec.data.DOCUMENTS) return;

		let cfg = {
			f: 'edit',
			data: {data: {LINK: rec.data.DOCUMENTS, REVIZ: rec.data.REVIZ}},
			code: dnl.DOCUMENTS,
			refreshFunc: function () {
				me.refresh();
			},
			tabMode: !me.isModalEdit(),
			parentView: me.isModalEdit() ? me.objs.view : me.parentView
		};
		Ext.apply(cfg, dictListController.DOCUMENTS);
		Ext.create(cfg.editClass, cfg);
	},

	/**Task Revizor.DfDocuments.DelDocRel */
	async deleteDocRelation() {
		let me = this,
			rec = me.objs.Grid.getFrstSelect();
		if (!rec || !rec.data.DOCUMENTS) return;

		const res = await selectDialogShowAsync(KS.L10n.attention, KS.L10n.DFDocumentsTasks_DfDocumentsDelDocRel_Удалить_связь_документа_с_записью_раздела__Документы__);
		if (res !== "yes") return;

		me.showLoadMask({
			msg: `${KS.L10n.DFDocumentsListPresenter_DFDeleteRelation_Удаление_связи_с_записью_раздела__Документы_}...`,
			rid: ajaxRequest({
				url: 'SDocuments/DeleteDFRelation_A',
				params: {
					dfDocuments: rec.data.LINK,
					reviz: rec.data.REVIZ,
					documents: rec.data.DOCUMENTS
				},
				success: function (response) {
					if (!response.res) {
						if(response.message){
							warning(response.message);
						}
						return;
					}
					let sel = me.Grid.getStore().findNode('LINK', rec.data.LINK);
					if (sel) {
						sel.set('DOCUMENTS', null);
						sel.set('DTRELATION', null);
						const sm = me.Grid.getSelectionModel();
						sm?.fireEvent('selectionchange', sm, [sel]);
					}
				},
				callback: function () {
					me.hideLoadMask();
				}
			})
		});
	},

	sign: async function() {
		const me = this;
		const sels = me.objs.Grid.getSelectionModel().getSelection();
		if (!sels.length) return;
		const result = await me.signAsync(sels.map(sel => sel.data));
		if (result) {
			me.afterSignCompleted(result.doc);
			me.afterFileSignCompleted(result.files);
		}
	},
	signAsync: async function(data, fromEditMode) {
		const me = this;
		const links = data.map(r => r.LINK);
		let files = [];

		const hasFiles = data.filter(r => r.FILES).length;
		if (hasFiles) {
			const res = await selectDialogShowAsync(KS.L10n.attention, "Подписать вложения?");
			if (res !== "yes" && res !== "no") return;

			if (res === "yes") {
				files = await ajaxRequestAsync({
					params: {links: JSON.stringify(links), code: "DOCUMENT_DF_DOCUMENTS"},
					url: 'SDocuments/GetFilesByDocs_A'
				});
			}
		}

		const serviceModule = Ext.create('Keysystems.EDSServiceModule');
		const responseDoc = await serviceModule.executeAsync({
			code: "DOCUMENT_DF_DOCUMENTS",
			links: links,
			mode: 'EDS_SET',
			target: me.getLoadMaskTarget(),
			silentMode: true,
			fromEditMode: fromEditMode,
		});
		if (!responseDoc) return;

		let responseFiles = null;
		if (files?.length) {
			responseFiles = await serviceModule.executeAsync({
				code: "FILES",
				links: files,
				mode: 'EDS_SET',
				target: me.getLoadMaskTarget(),
				silentMode: true,
				fromEditMode: fromEditMode,
				certData: responseDoc.certData
			});
		}

		const cfg = {
			text: responseDoc.htmlProtocol,
			title: KS.L10n["BaseRevizorPresenter_OnSignCompleted_Протокол_выполнения"],
			hasIgnoreButton: false,
			noPreStyle: true,
			width: 800,
			height: 600
		};
		ChooseBox.ShowHTMLLog(cfg);

		return {doc: responseDoc, files: responseFiles};
	},

	unSign: async function() {
		const me = this;
		const sels = me.objs.Grid.getSelectionModel().getSelection();
		const data = sels.map(sel => sel.data);
		const result = await me.unSignAsync(data);
		if (result) {
			me.afterSignCompleted(result.doc);
			me.afterFileSignCompleted(result.files);
		}
	},
	unSignAsync: async function(data, fromEditMode) {
		const me = this;
		if (!data || !data.length) return;

		const hasFiles = data.filter(r => r.FILES).length;
		const links = data.map(r => r[me.fieldLink]);
		let dialogResult;
		let files = [];
		if (hasFiles) {
			dialogResult = await dialogShowAsync({
				msg: KS.L10n.ListTasks_UnSign_Снять_ЭП,
				title: KS.L10n.attention,
				buttons: Ext.MessageBox.YESNOCANCEL,
				buttonText: {
					yes: data.length > 1 ? KS.L10n.DocumentsTasks_ShowDocUnSignMessage_Документ : KS.L10n.DocumentsTasks_ShowDocUnSignMessage_Документы,
					no: Ext.String.format(KS.L10n.DocumentsTasks_ShowDocUnSignMessage_Документы_и_вложения, data.length > 1 ? KS.L10n.DocumentsTasks_ShowDocUnSignMessage_Документ : KS.L10n.DocumentsTasks_ShowDocUnSignMessage_Документы),
					cancel: KS.L10n.Нет
				},
			});
			if (dialogResult !== "yes" && dialogResult !== "no") return;

			if (dialogResult === "no") {
				files = await ajaxRequestAsync({
					params: {links: JSON.stringify(links), code: "DOCUMENT_DF_DOCUMENTS"},
					url: 'SDocuments/GetFilesByDocs_A'
				});
			}

		} else {
			dialogResult = await selectDialogShowAsync(KS.L10n.attention, KS.L10n.ListTasks_UnSign_Снять_ЭП, 'no');
			if (dialogResult !== "yes") return;
		}

		const processFiles = dialogResult !== "yes";

		const serviceModule = Ext.create('Keysystems.EDSServiceModule', {
			target: me.getLoadMaskTarget(),
			mode: 'EDS_DELETE'
		});
		const responseDoc = await serviceModule.executeAsync({
			code: 'DOCUMENT_DF_DOCUMENTS',
			links: links,
		});

		let responseFiles = null;
		if (processFiles && files.length){
			responseFiles = await serviceModule.executeAsync({
				code: 'FILES',
				links: files,
				silentMode: true
			});
		}
		return {doc: responseDoc, files: responseFiles};
	},

	/**
	 * Можно ли редактировать файл в колонке Файл
	 * @param rec
	 * @returns {boolean}
	 */
	getFileReadOnly: function (rec) {
		const me = this;
		const data = (rec.data || rec);
		//если док-т подписан, то файл редактировать нельзя
		if (data.EDS_DATE && me.gksd('EDSSaveDocBehavior') >= 2) {
			return true;
		}
		//если файл подписан, то файл редактировать нельзя в случае, если настройка EDSSaveDocBehavior = 3
		if (data.EDS_FILES && me.gksd('EDSSaveDocBehavior') === 3) {
			return true;
		}
		return false;
	},

	/**
	 * Выполнить после подписи файлов из списка докумемнтов (для варианта "подписать вложения" - "да")
	 * @param response
	 */
	afterFileSignCompleted: function (response) {
		const me = this;
		if (!response?.rows) return;

		response.rows.forEach(row => {
			const rowUpd = { IS_FILES : true };
			Object.assign(rowUpd, row);
			rowUpd.EDS_FILES = row.EDS_DATE ? 1 : 0;
			me.updateRecord(rowUpd);
		});
	},

	/**
	 * Обновить запись списка
	 * @param row
	 */
	updateRecord: function(row){
		const me = this;
		if (row.IS_FILES) {
			const store = me.Grid.getStore();
			const rowDoc = store.findNode
				? store.findNode('FILES', (row.data || row).LINK)
				: store.findRecord('FILES', (row.data || row).LINK);
			if (rowDoc) {
				row.LINK = rowDoc.get('LINK');
				rowDoc.set(row);
			}
			return;
		}
		me.callParent(arguments);
	}
});