Ext.define('Keysystems.DFDocuments.Edit', {
	extend: 'Ext.tab.Panel',
	mixins: ['Keysystems.Base.Edit'],
	title: 'Регистрация документов',
	isWindow: true,
	labelWidth: 170,
	flex: 1,
	viewMinSize: [800, 600],
	width: 800,
	height: 600,
	bodyPadding: 0,
	isFileBtn: true,
	linkCode: 'SDfDocuments',
	fieldExt: 'EXTENTION',
	fieldMain: 'MAIN',
	userCls: 'rks-panel-edit',
	bodyCls: 'rks-panel-edit-body',

	profileListeners: [{name: 'view', method: 'FormParam'}],
	constructor: function (cfg) {
		Ext.apply(this, cfg);
		this.callParent(arguments);
	},

	initComponent: function () {
		let me = this;

		me.beforeInitComponent();
		me.baseInitComponent();

		me.callParent(arguments);

		me.afterInitComponent();
	},

	initKsControls: function (ksControls) {
		ksControls.allTab = this;
	},

	initEvents: function () {
		let me = this;
		me.callParent(arguments);

		me.on('beforetabchange', function (th, newTab) {
			if (me.isLoaded || me.inTabChange) 
				return true;
			
			me.checkSave(newTab, function () {
				me.inTabChange = true;
				me.setActiveTab(newTab);
				me.inTabChange = false;
			});
			return false;
		});

		me.on('tabchange', function (th, newTab) {
			if (newTab.tabKey === 'TASK')
				me.bindTask();
		});
	},

	createTBar: function () {
		const me = this;
		const tbar = this.callParent(arguments);

		me.btnSign = Ext.create('Ext.Button', {
			disabled: false,
			hidden: !window.useEDS,
			key: 'sign',
			iconCls: 'x_btn_document_protect',
			menu: [
				{
					text: 'Электронная подпись',
					iconCls: 'x_btn_document_protect',
					handler: function () {
						const serviceModule = Ext.create('Keysystems.EDSServiceModule', {
							target: me.parentView,
							code: "DOCUMENT_DF_DOCUMENTS",
							links: [me.getLink()],
							code_eds_list: "DF_DOCUMENTS_EDS_LIST",
							mode: 'SIGN_LIST',
							modal: window.modalEdit || me.parentView !== window.tabView
						});
						serviceModule.execute();
					}
				},
				{
					text: 'Печать информации об ЭЦП',
					iconCls: 'x_btn_protocol',
					handler: function () {
						const serviceModule = Ext.create('Keysystems.EDSServiceModule', {
							target: me.getLoadMaskTarget(),
							code: "DOCUMENT_DF_DOCUMENTS",
							links: [me.getLink()],
							mode: 'SIGNATURE_INFO_PROTOCOL'
						});
						serviceModule.execute();
					}
				},
				{ xtype: 'menuseparator', hidden: true },
				me.subBtnSign = Ext.create('Ext.Action', {
					text: 'Подписать',
					iconCls: 'x_btn_sign',
					handler: async function () {
						const saved = await me.saveMessageShowAsync({msg: "Для продолжения необходимо сохранить документ."});
						if (!saved) return;

						const files = me.getTab('Files').store.getDataExt();
						const data = [{LINK: me.getLink(), FILES: files?.length ? files[0].FILES : 0}];
						const result = await Keysystems.DFDocuments.List.prototype.signAsync.call(me, data, true);
						if (result) me.onSignCompleted(result);
					}
				}),
				me.subBtnUnSign = Ext.create('Ext.Action', {
					text: 'Снять подпись',
					iconCls: 'x_btn_delete_sign',
					handler: async function () {
						const saved = await me.saveMessageShowAsync();
						if (!saved) return;

						const files = me.getTab('Files').store.getDataExt();
						const data = [{LINK: me.getLink(), FILES: files?.length ? files[0].FILES : 0}];
						const result = await Keysystems.DFDocuments.List.prototype.unSignAsync.call(me, data, true);
						if (result) me.onSignCompleted(result);
					}
				})
			]
		});
		tbar.splice(1, 0, me.btnSign);
		return tbar;
	},

	checkSave: async function (newTab, callBack) {
		let me = this;
		let newData = me.saveChangesFn();
		if ((me.getLink() <= 0 || newData) && newTab.tabKey === 'TASK') {
			me.checkFilled(res => {
				if (!res) return res;
				let newData = me.saveChangesFn();
				newData.nextTab = newTab.tabKey;
				me.changeTabMsgShow({ok: () => me.saveData(callBack, newData)});
				return false;
			})
		}
		else {
			if (callBack) callBack();
			return true;
		}
	},

	//сообщение о наличии несохраненных данных при переключении таба
	changeTabMsgShow: function (cfg) {
		Ext.Msg.show({
			title: KS.L10n.attention,
			msg: wmc.get('NeedSaveDocument'),
			buttons: Ext.MessageBox.OKCANCEL,
			buttonText: {ok: 'Сохранить'},
			fn: function (buttonId) {
				let fn = cfg[buttonId] || cfg.default;
				if (fn) fn();
			},
			icon: Ext.MessageBox.INFO
		});
	},

	saveData: function (endFunc, params) {
		let me = this,
			nextTabName = params?.nextTab,
			funcAfterSave = function (result) {
				if (nextTabName) {
					let nextTab = me.gksc(nextTabName);
					if (nextTab) me.setActiveTab(nextTab);
				}
				if (endFunc) endFunc(result);
			};
		
		me.callParent([funcAfterSave, params]);
	},

	successSaveFunc: function(result) {
		var me = this;
		// Обновим поле Префикс Рег №
		if (result.row){
			me.gksc('RNUMBER_PREF').setValue(result.row.RNUMBER_PREF);
		}
		me.callParent(arguments);
	},
	
	getExtra: function (endFunc, link) {
		let me = this;

		me.baseGetExtra({
			link: link,
			linkSelf: me.LINK_SELF,
			type: me.TYPE,
			docvid: me.S_DOCVID,
			reviz: me.REVIZ,
			documents: me.DOCUMENTS,
			needResource: true
		}, function (value) {
			if (value.General) me.getExtraGeneral(value);

			// Вкладка Задачи
			me.createTabTask();
			// Вкладка корреспонденты
			me.getExtraCorr();
			// Вкладка реквизитов
			me.getExtraProp();
			// Вкладка файлы
			me.getExtraFiles();

			if (endFunc) endFunc();
		});
	},

	//Общие
	getExtraGeneral: function (value) {
		let me = this,
			tabValue = value.General;

		me.changeTab(me.getTab('General'), true);

		me.setLinkSelf(value.row.LINK_SELF);
		me.sksd('TYPE', value.row.TYPE);
		me.sksd('docVidItems', value.docVidItems);
		me.sksd('DOCUMENTS', value.row.DOCUMENTS);
		me.sksd('isRfnAp', tabValue.isRfnAp);
		me.sksd('restrictDeloByReviz', tabValue.RestrictDeloByReviz);
		me.sksd('warnBeforeChangePersonOtv', value.warnBeforeChangePersonOtv);		
		me.sksd('isFilterByDocType', value.isFilterByDocType);		
		me.sksd('docTypeFilter', value.docTypeFilter);		
		me.sksd('selfDocType', value.selfDocType);
		me.sksd('accessObject', tabValue.accessObject);
		me.sksd('filterRevizByDt', value.filterRevizByDt);
		// Ссылка на запись, на основе которого создана текущая копия
		me.sksd('linkSame', value.linkSame);
		
		// Информация по вкладкам
		me.sksd('tabInfo', value.tabInfo);
		me.sksd('tabFileData', value.Files);
		me.sksd('tabPropData', value.Prop);
		me.sksd('tabCorrData', value.Corr);

		me.sksd('SettingFileMask', value.SettingFileMask);
		me.sksd('EDS', value.row.EDS);
		me.sksd('EDSSaveDocBehavior', value.EDSSaveDocBehavior);
		
		me.fillRollBackData(value.rollBackData);

		me.setObjsValues(value.row, ['DT', 'RDT', 'DTENDUTV', 'DTUTV',
			'NUMBER', 'NUMBER2', 'RNUMBER_PREF', 'RNUMBER_ORD', 'RNUMBER_POST', 'VOL', 'HEADER', 'CONTENT', 'REMARK', 'RELATION_NEED']);
		me.setObjsValues(tabValue, ['S_DOCVID', 'S_PERSON_OTV', 'S_ORG_OTV', 'S_DELO', 'LINK_SELF', 'REVIZ']);
		// Видимость полей согласно прав и настройке "Не показывать для ввода"
		me.setControlVisibleByAccess();
	
		// Значение для инициализации дикедитора видов документа
		me.sksd('sDocVid', tabValue['S_DOCVID']);
		
		// Доступные виды документов с типами
		me.fillDocVidType(tabValue['S_DOCVID'][0].LINK, value.row.TYPE, false);
		// Доступность поля Мероприятия
		me.gksc('REVIZ').setDisabled(!value.row['RELATION_NEED']);

		if (value.printReport) {
			me.sksd('printReport', value.printReport);
		}
	},

	createTabGeneral: function () {
		let me = this;

		return Ext.create('Ext.panel.Panel', {
			title: 'Общие',
			layout: {type: 'vbox', align: 'stretch'},
			bodyPadding: 10,
			border: 0,
			flex: 1,
			items: [
				Ext.create('Ext.form.FieldContainer', {
					layout: {type: 'hbox', align: 'stretch'},
					items: [
						me.sksc('RNUMBER_PREF', Ext.create('Ext.form.field.Text', {
							labelWidth: me.labelWidth,
							maxLength: 50,
							enforceMaxLength: true,
							fieldLabel: 'Рег №',
							width: me.labelWidth + 150,
							padding: '0 15 0 0',
							sender: me,
							listeners: {
								render: function (e) {
									let me = this.sender;
									e.getEl().on('contextmenu', function (target) {
										let cm = new Ext.menu.Menu(
											{
												items: [
													{
														text: 'Заполнить',
														listeners: {
															'click': function () {
																const data = me.dataCollector();
																const rid = ajaxRequest({
																	url: 'SDfDocuments/CalculateFormulaRnPref_A',
																	params: {
																		gzipData: SignalR.pack(data)
																	},
																	success: function (result) {
																		if (!result) return;
																		me.gksc('RNUMBER_PREF').setValue(result);
																	},
																	callback: function(){
																		if (me) me.hideLoadMask();
																	}
																})
																if (me) {
																	me.showLoadMask({
																		msg: KS.L10n.updating_data,
																		rid: rid
																	});
																}
															}
														}
													}
												]
											}
										);
										target.stopEvent();
										cm.showAt(target.getXY());
									}, e);
								}
							}
						})),
						me.sksc('RNUMBER_ORD', Ext.create('Ext.form.field.Text', {
							labelWidth: me.labelWidth,
							maxLength: 50,
							enforceMaxLength: true,
							fieldLabel: 'Рег №',
							width: me.labelWidth + 150,
							sender: me,
							enableKeyEvents: true,							
							listeners: {
								keydown:
									// Контроль ввода только цифр и TAB 
									function (obj, e)
									{
										if (e.getKey() !== e.TAB && !me.isNumberKey(e))
										{
											if (Ext.browser.is.Firefox)
											{
												e.event.preventDefault();
											}
											else
											{
												e.event.returnValue = false;
											}
										}
									},
								blur: async function(obj, e) {
									// Изменить автонумерацию, если выполняется условие
									let ord = me.gksc('RNUMBER_ORD').getValue();
									if (me.gksd('rollBackData')
										&& me.gksd('rollBackData').RollbackNumLink !== 0 
										&& me.gksd('rollBackData').RollbackNumStr !== ord) {
										ajaxRequest({
											url: me.linkCode + '/CheckAutoNumerExt_A',
											params: { strNumber: ord, gzipData: SignalR.pack(me.gksd('rollBackData')) },
											success: function(newNum) {
												if (newNum !== -1 && ord === me.gksc('RNUMBER_ORD').getValue()) {
													selectDialogShow(KS.L10n.attention, 
														Ext.String.format(KS.L10n.DFDocumentsEditView_EbRNumberOrd_Leave_Заменить_текущий_номер_автонумерации_порядкового_номера_на__0__, ord), 
														function() {
															ajaxRequest({ 
																url: me.linkCode + '/SaveNewAutoNumberExt_A', 
																params: { strNumber: ord, newNumber: newNum, gzipData: SignalR.pack(me.gksd('rollBackData')) },
																success: function(res) {
																	me.fillRollBackData(res);
																}
															});
														}, 
														function() {
															me.sksd('IgnoreNewAutoNumber', true);
														});
												}
											}
										});
										
									}
								}
							}
						})),
						me.sksc('RNUMBER_POST', Ext.create('Ext.form.field.Text', {
							maxLength: 50,
							enforceMaxLength: true,
							padding: '0 0 0 15',
							width: 170
						})),						
						'->',
						me.sksc('NUMBER2', Ext.create('Ext.form.field.Text', {
							labelWidth: 80,
							maxLength: 50,
							enforceMaxLength: true,
							fieldLabel: '№ АС ДОУ',
							width: 230
						}))
					]
				}),
				me.sksc('RDT', Ext.create('Ext.form.field.Date', {
					labelWidth: me.labelWidth,
					format: 'd.m.Y',
					fieldLabel: 'Рег. дата',
					ksAllowEmpty: true,
					minValue: longPeriod.begin,
					maxValue: longPeriod.end,
					value: now,
					maxWidth: me.labelWidth + 110
				})),
				me.sksc('LINK_SELF', Ext.create('Keysystems.Controls.Dict.Edit', {
					labelWidth: me.labelWidth,
					fieldLabel: 'В ответ на',
					codeField: 'RNUMBER',
					code: dnl.DF_DOCUMENTS,
					handler: function () {
						dictFunc({
								accessReadOnly: true,
								parentView: objs.view,
								code: dnl.DF_DOCUMENTS,
								mode: 'SINGL',
								control: me.gksc('LINK_SELF'),
								contextSearch: me.gksc('LINK_SELF').contextSearch,
								selectLinks: me.gksc('LINK_SELF').getValue(),
								initWhereArgs: function () {
									let wa = {NotInLinks: {type: 'List_int', value: JSON.stringify([me.getLink()])}};
									// refs #458
									if (me.gksd('isFilterByDocType')){
										let docTypeFilterItems = me.gksd('docTypeFilter');
										let docType = me.gksd('TYPE');
										let sDocVid = me.gksc('S_DOCVID').getLink();
										// Если отобран вид документа - выставим условие фильтрации по типу документа для родительских записей
										if (sDocVid && docTypeFilterItems[docType]){
											wa["SType"] = {type: 'List_int', value: JSON.stringify(docTypeFilterItems[docType])};
										}	
									}
									return wa;
								}
							},
							{
								ok: function (value) {
									me.gksc('LINK_SELF').setValue(value);
									me.setLinkSelf(value.length ? value[0].LINK || value[0].data.LINK : null);
								}
							});
					},
					listeners: {
						change: async function (th, dictValue, newValue, oldValue) {
							if (me.isLoaded) return;
							let link = dictValue.length ? dictValue[0].LINK || dictValue[0].data.LINK : 0;
							// Тип родительского документа
							me.sksd('selfDocType', link ? dictValue[0].TYPE || dictValue[0].data.TYPE : 0);
							
							if (link > 0 && me.getTabVisibleFromTabInfo('CORR')) {
								let res = await selectDialogShowAsync(KS.L10n.attention, KS.L10n.DFDocumentsEditView_DictInReply_Changed_Заполнить_информацию_о_корреспонденте_из_указанного_документа_ + "?");
								if (res === "yes") {
									let store = me.gksc('gridCorr').store;
									let getCorRes = await ajaxRequestAsync({
										url: 'SDfDocuments/GetCorrBySelfDoc_A',
										params: {selfLink: link}
									});
									// Очистка текущих записей корреспондентов
									store.removeAll();

									if (getCorRes && getCorRes.selfCorr) {
										let newData = [];
										let dataItem = {};
										// Колонки которые не копируем
										let exludeColumns = ["LINK", "DF_DOCUMENTS"];
										getCorRes.selfCorr.forEach(r => {
											for (let col in r) {
												if (!Ext.Array.contains(exludeColumns, col.toUpperCase())) {
													dataItem[col] = r[col];
												}
											}
											newData.push(dataItem);
											dataItem = {};
										});
										if (newData.length) store.loadData(newData, true);
										if (store.data.length && !store.findRecord('MAIN', true)) {
											store.getAt(0).set('MAIN', true);
										}
									}
								}
							}
						}
					}
				})),
                me.createDictEdit({
					key: 'S_DOCVID',
					code: dnl.S_DOCVID,
					mode: 'SINGL',
					fieldLabel: 'Вид документа',
					ksAllowEmpty: true,
					initWhereArgs: function () {
						let wa = {
							InLinksOnly: {value: 'True', type: 'bool'}
						};
						let docVidItems = me.gksd('docVidItems');
						wa.InLinks = {type: 'List_int', value:  (docVidItems != null ? JSON.stringify(Ext.Object.getKeys(docVidItems)) : '[]') };

						// refs #458
						if (me.gksd('isFilterByDocType')){
							let docTypeFilterItems = me.gksd('docTypeFilter');
							let selfDocType = me.gksd('selfDocType');							
							// Если отобран родительский документ - берем его тип как основа для получения условия для фильтрации
							if (selfDocType && docTypeFilterItems[selfDocType]){
								wa["SType"] = {type: 'List_int', value: JSON.stringify(docTypeFilterItems[selfDocType])};	
							}		
						}
						return wa;
					},
					listeners: {
						change: async function (th, dictValue, newValue, oldValue) {
							if (me.isLoaded) return;
							const docVidNew = dictValue.length ? dictValue[0].LINK || dictValue[0].data.LINK : null;
							let docTypeOld = me.gksd('TYPE');
							let rollback = me.gksd('rollback');
							if (docVidNew && !rollback) {
								me.sksd('dictDocVidChanged', true);
								me.fillDocVidType(docVidNew, null, true);
								let docTypeNew = me.gksd('TYPE');
								let docVidOldArr = JSON.parse(oldValue);
								me.refreshTabVisible(docVidOldArr && docVidOldArr.length > 0 ? docVidOldArr[0] : 0, docTypeOld, docVidNew, docTypeNew, false, dictValue);
								me.sksd('dictDocVidChanged', false);	
							}
						}
					}
				}),
				me.sksc('TYPE', Ext.create('Ext.form.RadioGroup', {
					fieldLabel: 'Тип документа',
					labelWidth: me.labelWidth,
					layout: {type: 'hbox', align: 'stretch'},
					itemCls: 'rks-checkbox-group-item',
					items: [
						me.rbInternal = Ext.create('Ext.form.field.Radio', {
							boxLabel: 'Внутренний',
							name: 'doctype',
							checked: true,
							inputValue: '4',

						}),
						me.rbIn = Ext.create('Ext.form.field.Radio', {
							boxLabel: 'Входящий',
							name: 'doctype',
							inputValue: '1',
						}),
						me.rbOut = Ext.create('Ext.form.field.Radio', {
							boxLabel: 'Исходящий',
							flex: 1,
							name: 'doctype',
							inputValue: '2',
						})
					],
					listeners: {
						change: async function (th, newValue, oldValue) {
							if (me.isLoaded || !newValue.doctype) return;

							me.sksd('TYPE', newValue.doctype);
							// Режим изменения вида документа
							let dictDocVidChanged = me.gksd('dictDocVidChanged');
							let rollback = me.gksd('rollback');
							// Если изменяется тип документа не в разрезе изменении вида документа и отката
							if (!dictDocVidChanged && !rollback){
								let sDocVid = me.gksc('S_DOCVID').getLink();
								me.refreshTabVisible(sDocVid, oldValue.doctype, sDocVid, newValue.doctype, true);
							}							
						}
					}
				})),
				Ext.create('Ext.form.FieldContainer', {
					layout: {type: 'hbox', align: 'stretch'},
					items: [
						me.sksc('NUMBER', Ext.create('Ext.form.field.Text', {
							labelWidth: me.labelWidth,
							maxLength: 50,
							enforceMaxLength: true,
							fieldLabel: '№',
							padding: '0 15 0 0',
							width: me.labelWidth + 150
						})),
						me.sksc('DT', Ext.create('Ext.form.field.Date', {
							labelWidth: 35,
							format: 'd.m.Y',
							fieldLabel: 'от:',
							minValue: longPeriod.begin,
							maxValue: longPeriod.end,
							width: 145
						}))
					]
				}),
				me.createDictEdit({
					key: 'S_ORG_OTV',
					code: dnl.S_ORG,
					mode: 'SINGL',
					height: 30,
					fieldLabel: 'Ответственная организация',
					padding: '-4 0 0 0',
					whereArgs: {
						SType: {
							value: JSON.stringify([Ext.Object.getKey(miscTypes.TypeOrg, 'Проверяющая')]),
							type: 'List_int'
						},
						HasFilterOnLoad: {value: false, type: 'bool'}
					}
				}),
				me.createDictEdit({
					key: 'S_PERSON_OTV',
					code: dnl.S_PERSON,
					mode: 'SINGL',
					fieldLabel: 'Ответственный сотрудник',
					initWhereArgs: function () {
						let wa = {
							DH1: {value: longPeriod.begin, type: 'Date'},
							DH2: {value: longPeriod.end, type: 'Date'},
							HasFilterOnLoad: {value: false, type: 'bool'}
						};

						if (me.gksc('S_ORG_OTV').isEmpty()) {
							wa.InLinksOnly = {type: 'bool', value: 'True'};
							wa.InLinks = {type: 'List_int', value: '[]'};
						} else {
							wa.SOrgs = {type: 'List_int', value: me.gksc('S_ORG_OTV').getLinks(1)}
						}
						return wa;
					}
				}),

				Ext.create('Ext.form.FieldContainer', {
					layout: {type: 'hbox', align: 'stretch'},
					items: [
						me.createDictEdit({
							key: 'S_DELO',
							mode: 'SINGL',
							code: dnl.S_DELO,
							fieldLabel: 'Дело',
							padding: '0 15 0 0',
							flex: 1,
							initWhereArgs: function () {
								let wa = {
									Orgs: {
										value: (c = me.gksc('S_ORG_OTV')).isEmpty()
											? '[' + user.org.data.LINK + ']'
											: c.getLinks(1),
										type: 'List_int'
									}
								};

								if (me.gksd('restrictDeloByReviz')) {
									wa.Reviz = {value: me.data.data.REVIZ || 0, type: 'int'};
								}

								if (me.gksd('isRfnAp')) {
									wa.OnlyFree = {
										value: (c = me.gksc('S_DELO')).isEmpty()
											? '[' + user.org.data.LINK + ']'
											: c.getLinks(1),
										type: 'List_int'
									};
								}
								return wa;
							},
							listCfg: {
								edit: function (f, data, defCfg) {
									// //todo 
									// return this.callParent([f, data, Ext.apply(defCfg || {}, {
									// 	dataCollector: function() {
									// 		var result = this.callParent(arguments);
									// 		if (me.gksd('restrictDeloByReviz')) result.REVIZ = me.data.data.REVIZ;
									// 		return result;
									// 	}
									// })]);
								}
							}
						}),
						me.sksc('VOL', Ext.create('Ext.form.field.Number', {
							fieldLabel: 'Том',
							labelWidth: 35,
							minValue: 0,
							maxValue: 100,
							width: 100
						}))
					]
				}),

				me.sksc('HEADER', Ext.create('Ext.form.field.TextArea', {
					fieldLabel: 'Заголовок',
					labelWidth: me.labelWidth,
					fieldCls: 'rks-textarea',
					height: 50
				})),

				me.sksc('CONTENT', Ext.create('Ext.form.field.TextArea', {
					fieldLabel: 'Содержание',
					labelWidth: me.labelWidth,
					flex: 1,
					fieldCls: 'rks-textarea',
					minHeight: 70
				})),

				Ext.create('Ext.form.FieldContainer', {
					layout: 'hbox',
					items: [
						me.sksc('DTENDUTV', Ext.create('Ext.form.field.Date', {
							labelWidth: me.labelWidth,
							format: 'd.m.Y',
							fieldLabel: 'Срок исполнения',
							ksAllowEmpty: true,
							padding: '0 15 0 0',
							minalue: longPeriod.begin,
							maxValue: longPeriod.end,
							enforceMaxLength: true,
							width: me.labelWidth + 110
						})),
						me.sksc('DTUTV', Ext.create('Ext.form.field.Date', {
							fieldLabel: 'Дата исполнения',
							labelWidth: 130,
							format: 'd.m.Y',
							minValue: longPeriod.begin,
							maxValue: longPeriod.end,
							width: 240
						}))
					]
				}),

				me.sksc('RELATION_NEED', Ext.create('Ext.form.field.Checkbox', {
					fieldLabel: 'Добавить в мероприятие',
					labelWidth: me.labelWidth,
					listeners: {
						change: function (th1, newValue) {
							me.gksc('REVIZ').setDisabled(!newValue);
							if (!newValue){
								me.gksc('REVIZ').setValue(null);
							}							
						}
					}
				})),
				me.createDictEdit({
					key: 'REVIZ',
					code: dnl.REVIZ,
					mode: 'SINGL',
					codeField: 'NUMBER',
					fieldLabel: 'Мероприятие',
					initWhereArgs: function () {
						let dt = me.gksc('RDT').getValue() ?? new Date();
						if (dt <= longPeriod.begin){
							dt = new Date();
						}
						let filterRevizByDt = me.gksd('filterRevizByDt');
						return {
							DBegin: {value: new Date(filterRevizByDt ? dt.getFullYear() : 1900,0,1) , type: 'Date'},
							DEnd: {value: new Date(filterRevizByDt ? dt.getFullYear() : 2100,11,31), type: 'Date'}
						};
					},
					listeners: {
						change: async function (th, dictValue, newValue, oldValue) {
							if (me.isLoaded) return;
							const link = dictValue.length ? dictValue[0].LINK || dictValue[0].data.LINK : null;
							if (link > 0) {
								let warn = me.gksd('warnBeforeChangePersonOtv');
								// refs #454 - предупреждение по настройке
								if (warn){
									let res = await selectDialogShowAsync(KS.L10n.attention, KS.L10n.DFDocumentsEditView_DictReviz_Changed_Обновить_поле__Ответственный_сотрудник__);
									if (res !== "yes") return;									
								}

								res = await ajaxRequestAsync({
									url: 'SDfDocuments/GetRevizOtdelRuk_A',
									params: {reviz: link}
								});

								if (res && res.org) {
									me.gksc('S_ORG_OTV').setValue(res.org);
									if (res.persons && res.persons.length === 1) {
										me.gksc('S_PERSON_OTV').setValue(res.persons);
									} else {
										me.gksc('S_PERSON_OTV').setValue(null);
									}
								} else {
									me.gksc('S_PERSON_OTV').setValue(null);
								}
							}
						}
					}
				}),
                me.sksc('REMARK', Ext.create('Ext.form.field.TextArea', {
					fieldLabel: 'Замечания',
					labelWidth: me.labelWidth,
					height: 100,
					fieldCls: 'rks-textarea'
				})),
			]
		})
	},

	//#region Реквизиты
	getExtraProp: function () {
		var me = this,
			tabValue = me.gksd('tabPropData');
		let visible = me.getTabVisibleFromTabInfo('DOCPROP');

		me.changeTab(me.getTab('Prop'), true);
		if(tabValue) {
			me.getTab('Prop').loadData(tabValue);
		}
		
		me.setTabVisible('Prop', visible);
		if (visible && !me.isLoaded){
			me.setTabOrder(me.getTab('Prop'), 'Prop');
		}
	},

	createTabProp: function () {
		let me = this;

		return Ext.create('Keysystems.Panel.Prop', {
			parentView: me,
			readOnly: me.readOnly,
			decimalData: me.gksd('decimalData')
		});
	},

	//#endregion Реквизиты

	//#region Задачи

	createTabTask: function () {
		let me = this;
		let visible = me.getTabVisibleFromTabInfo('TASK');
		if (visible){
			if (!me.gksc('tabTask')){
				let	tab = me.sksc('tabTask', Ext.create('Ext.panel.Panel', {
					tabKey: 'TASK',
					title: 'Задачи',
					layout: {type: 'vbox', align: 'stretch'},
					border: 0,
					bodyBorder: false,
					items: []
				}));
				me.add(tab);				
			}			
		}		
		me.setTabVisible('Task', visible);
		if (visible && !me.isLoaded) {
			me.setTabOrder(me.getTab('Task'), 'Task');
		}
	},

	bindTask: function () {
		let me = this;
		if (me.gksc('formTask')) return;

		me.sksc('formTask', Ext.create('Keysystems.Base.List.Tree',
			{
				code: dnl.DF_TASK,
				GateCode: dnl.DF_TASK,
				title: 'Задачи',
				parentView: me.gksc('tabTask'),
				head: false,
				closable: false,
				tabMode: true,
				checkModel: false,
				handler: 'Keysystems.Base.List.Tree',
				editClass: 'Keysystems.DFTask.Edit',
				linkCode: 'SDfTask',
				deleteCode: 'DF_TASK',
				btnsHide: {search: true, relations: true, exit: true},
				hidePagging: true,
				pageSize: 100000,
				accessReadOnly: me.accessReadOnly || me.readOnly,
				getWhereArgs: function () {
					var me2 = this;
					return {
						Documents: {value: JSON.stringify([me.getLink()]), type: 'List_int'},
						SOrgOtv: {value: me.gksc('S_ORG_OTV').getLinks(1), type: 'List_int'},
						DtEndUtv: { value: me.gksc('DTENDUTV').getValue().toDateString(), type: 'Date' },
						PersonOtv: {value: me.gksc('S_PERSON_OTV').getLink(), type: 'int'}
					};
				},
				show: function () {
					this.callParent(arguments);
					me.oldData = JSON.stringify(me.dataCollector());
				},
				edit: function (f, data, defCfg) {
					defCfg = defCfg || {};
					defCfg.Document = me.getLink();
					defCfg.FillFromDFDocuments = this.gksd('FillFromDFDocuments');
					return this.callParent([f, data, defCfg]);
				},
				
				/** Task Revizor.DfDocuments.Task.New */
				newFromDfdoc: async function () {
					let me = this,
						rec = me.objs.Grid.getFrstSelect(),
						fillFromDFDoc = false;

					if (!rec) {
						const res = await selectDialogShowAsync(KS.L10n.attention, KS.L10n.DFDocumentsTasks_DfDocumentsDelDocRel_Создать_задачу_на_основе_информации_из_вкладки__Общие__);
						fillFromDFDoc = res === "yes";
					}

					me.sksd('FillFromDFDocuments', fillFromDFDoc)
					me.edit('new', null)
				},
				/** Task Revizor.DFTask.List.PrintReport
				 */
				dfTaskPrintReport: function(){
					let doc = me.getLink(),
						report = me.gksd('printReport'),
						paramsNastr = { "@_nDFDoc": {value: doc, type: 'int'} };

						func = function() {
							if (report.noNeedForm) {
								const loadMask = new Ext.LoadMask({
									msg: `${KS.L10n.report_generate}...`,
									target: me.objs.view,
									autoShow: true,
									rid: ajaxRequest({
										url: 'Report/CreateReportWeb_A',
										params: {
											code: report.objectCode,
											link_var: report.id,
											title: report.name,
											sysCode: report.code,
											mode: KsLib.getKeyByValue(miscTypes.ReportPrintMode, 'DFDocuments'),
											parentLink: 0,
											parametrs: '',
											paramsOtbor: '',
											paramsNastr: JSON.stringify(paramsNastr),
											noNeedForm: true
										},
										success: function(res) {
											if (!res.error.length) {
												getReportFile.call(me, res.guid, report.objectCode);
											}
										},
										callback: function() {
											loadMask.destroy();
										}
									})
								});
							} else {
								Ext.create('Revizor.ReportView', {
									parentView: me,
									tabMode: false,
									title: report.name,
									link_var: report.id,
									code: report.objectCode,
									id: 'SYS_' + report.CODE + '-' + Ext.id(),
									mode: KsLib.getKeyByValue(miscTypes.ReportPrintMode, 'DFDocuments'),
									parentData: {
										code: me.code,
										data: {
											LINK: doc
										},
										paramsOtbor: '',
										paramsNastr: paramsNastr
									}
								});
							}
						};

					func();
				}
			}));

	},

	//#endregion Задачи

	//#region Корреспондент
	createTabCorr: function () {
		let me = this,
			tab = me.sksc('tabCorr', Ext.create('Ext.panel.Panel', {
				tabKey: 'CORR',
				title: 'Корреспондент',
				layout: {type: 'vbox', align: 'stretch'},
				border: 0,
				bodyBorder: false,
				items: [
					me.sksc('gridCorr', Ext.create('Ext.grid.Panel', {
						flex: 1,
						border: 0,
						plugins: [
							Ext.create('Ext.grid.plugin.CellEditing', {
								clicksToEdit: 1
							}),
							'gridclipboard'
						],
						viewConfig: {
							getRowClass: function (rec) {
								return rec.data.MAIN ? 'ks-main' : '';
							}
						},
						tbar: [
							Ext.create('Ext.Button', {
								key: 'new',
								iconCls: 'x_btn_add_element',
								tooltip: KS.L10n.vibrat,
								tooltipType: 'title',
								handler: function () {
									let oldData = me.gksc('gridCorr').store.getDataExt();
									dictFunc({
											mode: 'MULTI',
											code: dnl.S_ORG,
											checkList: oldData.map(r => {
												return {LINK: r.S_ORG, NAME: r.TEMP_SORG_NAME, SNAME: r.TEMP_SORG_SNAME}
											}),
										},
										{
											ok: function (value) {
												let newData = (value.data || value).map(r => r.data || r),
													newLinks = newData.map(r => r.LINK),
													oldLinks = oldData.map(r => r.S_ORG),
													addData = newData.filter(r => oldLinks.indexOf(r.LINK) < 0),
													delLinks = oldLinks.filter(link => newLinks.indexOf(link) < 0)

												me.updateCorr(addData, delLinks);
											}
										});
								}
							}),
							Ext.create('Ext.Button', {
								key: 'delete',
								iconCls: 'x_btn_delete_element',
								tooltip: KS.L10n.udalit,
								tooltipType: 'title',
								handler: function () {
									const sel = me.gksc('gridCorr').getFrstSelect();
									if (!sel) return;

									selectDialogShow(KS.L10n.attention,
										"Удалить запись?",
										function () {
											me.updateCorr([], [sel.get('S_ORG')]);
										});
								}
							})
						],
						store: Ext.create('Ext.data.Store',
							{
								fields: [],
								data: [],
								proxy: 'memory',
								autoSort: false
							}),
						columns: [],
						columnLines: true,
						allowDeselect: false,
					}))
				]
			}));
		me.add(tab);
		return tab;
	},

	bindCorr: function () {
		let me = this;
		if (me.gksc('formCorr')) return;

		me.sksc('formCorr', Ext.create('Keysystems.Base.List',
			{
				code: dnl.DF_DOCCORR,
				GateCode: dnl.DF_DOCCORR,
				title: 'Корреспондент',
				parentView: me.gksc('tabCorr'),
				head: false,
				closable: false,
				tabMode: true,
				checkModel: false,
				handler: 'Keysystems.Base.List',
				editClass: 'Keysystems.DFDocCorr.Edit',
				linkCode: 'SDfDocCorr',
				deleteCode: 'DF_DOCCORR',
				btnsHide: {search: true, relations: true, exit: true},
				hidePagging: true,
				pageSize: 100000,
				accessReadOnly: me.accessReadOnly || me.readOnly,
				getWhereArgs: function () {
					return {DFDocument: {value: me.getLink(), type: 'int'}};
				},
				show: function () {
					this.callParent(arguments);
					me.oldData = JSON.stringify(me.dataCollector());
				},
				edit: function (f, data, defCfg) {
					if (!me.getLink()) {
						var dict = this,
							args = arguments;
						me.needSaveMsgShow({
							ok: function () {
								me.checkFilled(res => {
									if (!res) return;
									me.saveData(function () {
										if (me.getLink()) dict.edit.apply(dict, args);
									});
								});
							}
						});
						return _;
					}
					return this.callParent([f, data, defCfg]);
				}
			}));
	},

	updateCorr: function (addData, delLinks) {
		let me = this,
			store = me.gksc('gridCorr').store;

		delLinks.forEach(link => {
			const idx = store.find('S_ORG', link);
			if (idx >= 0) store.removeAt(idx);
		});

		let newData = [];
		addData.forEach(r => {
			newData.push({
				S_ORG: r.LINK,
				TEMP_SORG_NAME: r.NAME,
				TEMP_SORG_SNAME: r.SNAME
			})
		});
		if (newData.length) store.loadData(newData, true);
		if (store.data.length && !store.findRecord('MAIN', true)) {
			store.getAt(0).set('MAIN', true);
		}
	},
	getExtraCorr: function () {
		let me = this,
			tabCorr = me.gksd('tabCorrData'),
			tabReadOnly = me.readOnly || me.getTabReadOnly('CORR');

	
		let visible = me.getTabVisibleFromTabInfo('CORR');
		if (visible){
			me.changeTab(me.getTab('Corr'), true);	
		}
		me.setTabVisible('Corr', visible);
		if (!visible) return;

		if (visible && !me.isLoaded) {
			me.setTabOrder(me.getTab('Corr'), 'Corr');
		}

		const colMain = tabCorr.columns.filter(c => c.dataIndex.indexOf('MAIN') >= 0)[0];
		if (colMain) {
			colMain.readOnly = tabReadOnly;
			colMain.listeners = {
				'beforecheckchange': (_, __, checked) => {
					return checked || tabReadOnly;
				},
				'checkchange': function (_, __, checked, rec) {
					if (!checked) return;
					const prev = me.gksc('gridCorr').store.getDataExt().filter(r => r.MAIN && r.S_ORG !== rec.get('S_ORG'))[0];
					if (prev) {
						const prevNode = me.gksc('gridCorr').store.findRecord('S_ORG', prev.S_ORG);
						if (prevNode) prevNode.set('MAIN', false);
					}
				}
			}
		}

		if (!tabReadOnly) {
			tabCorr.columns.filter(c => c.dataIndex.indexOf('TEMP_S') >= 0).forEach(c => {
				c.width = 150;
				c.xtype = 'dictcolumn';
				c.cleaningKey = false;
				c.mode = 'SINGL';

				const match = c.dataIndex.match(/TEMP_S(.*)_S?NAME/);
				if (!match) {
					return;
				}
				const columnName = "S_" + match[1];

				c.code = dnl[columnName];
				c.ksGetValue = function (rec) {
					return [{LINK: rec.get(columnName)}];
				};
				c.defaultRenderer = function (v, m, r) {
					if (!v) {
						v = r ? (r.data || r)[c.dataIndex] : null;
					}
					if (+v === 0) v = null;
					return v;
				};
				c.ksSetValue = function (v, rec) {
					let d = v[0];
					d = d ? (d.data || d) : {LINK: null};
					// Если ничего не отобрали по организации - ничего не делаем
					if (columnName === "S_ORG" && !d.LINK) return;
					rec.beginEdit();
					rec.set(columnName, d.LINK);
					rec.set(c.dataIndex, d.NAME);
					rec.endEdit();

					switch (columnName) {
						case "S_ORG":
							rec.set("S_OTDEL", null);
							rec.set("TEMP_SOTDEL_NAME", null);
							rec.set("S_PERSON", null);
							rec.set("TEMP_SPERSON_NAME", null);
							break;
						case "S_OTDEL":
							rec.set("S_PERSON", null);
							rec.set("TEMP_SPERSON_NAME", null);
							break;							
					}
				}
				c.initWhereArgs = function (rec) {
					let whereArgs = {};
					switch (columnName) {
						case "S_ORG":
							const selOrgs = me.gksc('gridCorr').store.getDataExt().filter(r => r.S_ORG !== rec.get('S_ORG')).map(r => {return r.S_ORG});
							whereArgs = {
								NotInLinks: { value: JSON.stringify(selOrgs), type: 'List_int' }
							};
							break;
						case "S_OTDEL":
							whereArgs = {
								SOrgs: {value: JSON.stringify([rec.get('S_ORG')]), type: 'List_int'},
							};
							break;
						case "S_PERSON":
							if (rec.get('S_ORG')) {
								whereArgs = {
									SOrgs: {value: JSON.stringify([rec.get('S_ORG')]), type: 'List_int'},
									HasFilterOnLoad: {value: false, type: 'bool'}
								}
								if (rec.get('S_OTDEL')) {
									whereArgs.SOtdel = {value: JSON.stringify([rec.get('S_OTDEL')]), type: 'List_int'}
								}
							}
							break;
					}
					return whereArgs;
				}
			});
		}

		const gridCorr = me.gksc('gridCorr');
		gridCorr.setMetaDate(tabCorr, {
			profileCode: me.code,
			profileKey: 'gridCorr',
			gateCode: 'edit'
		});

		gridCorr.store.sort({property: 'MAIN', direction: 'DESC'});
		gridCorr.getSelectionModel().select(0);

		if (tabReadOnly) gridCorr.getToolbar().items.items.forEach(b => b.setDisabled(true));
	},

	dataCollectorCorr: function () {
		return this.getTabVisibleFromTabInfo('CORR') ? this.gksc('gridCorr').store.getDataExt(r => {
			if (+r.S_ORG === 0) r.S_ORG = null;
			if (+r.S_OTDEL === 0) r.S_OTDEL = null;
			if (+r.S_PERSON === 0) r.S_PERSON = null;
			return r;
		}) : _;
	},

	//#endregion Корреспондент

	//#region Файлы

	//#region редактирование файла

	fileEdit: function () {
		var me = this;

		me.sksc('fileView', Ext.create('Keysystems.File', {
			readOnly: me.readOnly || me.ksReadOnly || me.objs.btnFile.readOnly,
			iconCls: getExtStyle(me.getMainOrFirstFile()[me.fieldExt]),
			createFile: function (callback) {
				me.createFile(me.getLink(), callback);
			},
			updRecord: function (fileObj, isMain) {
				me.updFileRecord(fileObj, isMain);
			},
			getFileId: function () {
				var file = me.getFile();
				return file[me.fieldFile] || file.LINK;
			},
			downloadFile: function () {
				me.downloadFile();
			},
			fileExists: function (exist, noExist) {
				me.fileExists(exist, noExist);
			},
			clearFile: function () {
				me.clearFile();
			}
		}));
	},
	fileExists: function (exists, notExists) {
		var me = this;
		(me.getFile()[me.fieldExt] ? exists : notExists)();
	},
	createFile: function (link, callback) {
		if (this.readOnly) return;
		UploaderLib.newFile(this.code, link, 0, -1, 0, this.getLoadMaskTarget(), callback);
	},
	clearFile: function () {
		var me = this;
		if (me.readOnly) return;

		me.removeFile();

		var ext = me.getMainOrFirstFile()[me.fieldExt];
		me.gksc('btnFile').setIconCls(getExtStyle(ext));
	},
	removeFile: function (fileLink) {
		var me = this;
		var files = this.gksd('tabFileData');

		var res = fileLink
			? ArrayLib.filter(files, [this.fieldFile], fileLink)[0]
			: ArrayLib.filter(files, [this.fieldMain], 1)[0];

		if (res) {
			res[me.fieldFile] = '';
			res[me.fieldExt] = '';
		}

		me.getTab('Files').getExtra();
	},
	updFileRecord: function (fileObj, main) {
		var me = this;
		if (me.readOnly) return;

		var file = me.getFile(main ? _ : fileObj.id);
		var isEmpty = jQuery.isEmptyObject(file);
		file[me.fieldFile] = fileObj.id;
		file[me.fieldExt] = fileObj.ext;
		file[me.fieldMain] = main;
		file.NAME = fileObj.name || me.getFileName();
		file.DTCREATE = now;
		if (main || !me.gksc('btnFile').iconCls) me.gksc('btnFile').setIconCls(getExtStyle(fileObj.ext));
		if (isEmpty) {
			file.LINK = 0;
			this.gksd('tabFileData').push(file);
		}
		me.getTab('Files').getExtra();
	},

	getFileName: function () {
		var me = this,
			settingFileMask = me.gksd('SettingFileMask'),
			docVidName = me.gksd('S_DOCVID_NAME'),
			number = me.gksc('NUMBER').getValue(),
			dt = me.gksc('RDT').getValue(),
			fileName = settingFileMask || '{Документ.Вид.Имя}+" № "+ {Документ.Номер} + " от " + ДАТАПРОП({Документ.Дата},4)';

		fileName = fileName.replace('{Документ.Вид.Имя}', '"' + docVidName + '"');
		fileName = fileName.replace('{Документ.Номер}', '"' + number + '"');
		fileName = fileName.replace('ДАТАПРОП({Документ.Дата},4)', '"' + (Ext.isDate(dt) ? Ext.Date.format(dt, 'd.m.Y') : dt) + '"');

		return eval(fileName);
	},

	downloadFile: function () {
		var me = this,
			file = me.getFile();
		if (!file) return;
		UploaderLib.getFile(file[me.fieldFile] || file.LINK, file['NAME'] || me.getFileName() + '.' + file[me.fieldExt]);
	},

	getMainFile: function () {
		let me = this,
			files = this.gksd('tabFileData').filter(f => f[me.fieldFile]);
		return ArrayLib.filter(files, [this.fieldMain], 1)[0];
	},

	getMainOrFirstFile: function () {
		let me = this,
			res = this.getMainFile();
		if (res) return res;

		let files = this.gksd('tabFileData').filter(f => f[me.fieldFile]);
		res = files.sort((x, y) => x - y)[0];
		return res || {};
	},

	getFile: function (fileLink) {
		let files = this.gksd('tabFileData'),
			res = fileLink
				? ArrayLib.filter(files, ['LINK'], fileLink)[0]
				: this.getMainFile();
		return res || {}
	},

	//#endregion редактирование файла

	//конструктор таба
	createTabFiles: function () {
		let me = this,
			res = me.fileList = UploaderLib.showFileList({
				getFiles: function (callBack) {
					callBack(me.gksd('tabFileData'));
				},
				setFiles: Ext.emptyFn
			}, {
				readOnly: me.readOnly,
				isWindow: false,
				autoRender: false,
				EDSSaveDocBehavior: window.useEDS ? me.gksd('EDSSaveDocBehavior') : 0,
				createTBar: function () {
					var tbar = this.callParent(arguments);
					tbar.unshift(Ext.create('Ext.Button', {
						key: 'new',
						iconCls: 'x_btn_new',
						tooltip: KS.L10n.DocumentsEditView_InitializeComponent_Создать_по_шаблону,
						tooltipType: 'title',
						handler: function () {
							me.fileExists(function () {
									selectDialogShow(KS.L10n.attention,
										KS.L10n.rewrite_existing_file,
										function () {
											me.createFile(me.getLink(),
												function (fileLink, ext, name) {
													me.updFileRecord({id: fileLink, ext: ext, name: name}, 1);
												});
										});
								},
								function () {
									me.createFile(me.getLink(),
										function (fileLink, ext, name) {
											me.updFileRecord({id: fileLink, ext: ext, name: name}, 1);
										});
								});
						}
					}));
					return tbar;
				},
				downloadFile: function (link, name, rec) {
					return this.callParent([link || rec.get('LINK'), name, rec]);
				},
				afterAddFile: function (r) {
					let files = me.gksd('tabFileData');
					if (!files.length) {
						r.MAIN = 1;
						me.gksc('fileList').view.refresh();
					}
					files.push(r);
					if (!me.gksc('btnFile').iconCls) me.gksc('btnFile').setIconCls(getExtStyle(r[me.fieldExt]));
				},
				removeSelection: function () {
					var th = this;
					return th.callParent([
						function (rec) {
							th.editingPlugin.cancelEdit();
							me.removeFile(rec.get("FILES"));
							var ext = me.getMainOrFirstFile()[me.fieldExt];
							me.gksc('btnFile').setIconCls(getExtStyle(ext));
							return false;
						}
					]);
				},
				enableTools: function(sels) {
					this.callParent(arguments);
					const sel = sels?.length ? sels[0] : null;
					const mainSigned = me.gksd('EDSSaveDocBehavior') === 3 && sel?.get('MAIN') && sel?.get('TEMP_EDS_DATE');
					this.getToolbarItem('new')?.setDisabled(this.getReadOnly()  || mainSigned);
				},
				viewConfig: {
					getRowClass: function (rec) {
						if (!rec.get(me.fieldExt)) return 'ks-hidden';
						return rec.get(me.fieldMain) ? 'x-bold' : '';
					}
				},
				afterGetExtra: function() {
					this.callParent(arguments);
					let oldData = JSON.parse(me.oldData);
					oldData.tabFiles = JSON.stringify(me.dataCollectorFiles());
					me.oldData = JSON.stringify(oldData);
				},
				//Выполнить после подписи файла на вкладке Файлы
				afterSignCompleted: function (sel) {
					const data = sel.data ?? sel;
					if (!data.MAIN) return;

					//обновим доступность кнопки Файл окна редактирования документоа
					if (me.gksd('EDSSaveDocBehavior') >= 2) {
						me.objs.btnFile.setKsReadOnly(data.TEMP_EDS_DATE);
					}

					//подменим данные на акутальные
					const oldData = JSON.parse(me.oldData);
					const filesData = me.dataCollectorFiles();
					oldData.tabFiles = JSON.stringify(filesData);
					me.oldData = JSON.stringify(oldData);

					//обновим данные по ЭП файла в списке, откуда открыли окно редактирования
					me.updateRecord({
						LINK: data.LINK,
						IS_FILES: true,
						EDS_FILES: data.TEMP_EDS_DATE ? 1 : 0
					});
				}
			});
		res.setTitle('Файлы');
		res.header = {};
		res.setIconCls('');
		delete res.header;
		me.sksc('fileList', res);
		return res;
	},

	//загрузка данных во вкладку файлы 
	getExtraFiles: function () {
		var me = this;
		let visible = me.getTabVisibleFromTabInfo('FILES');
		me.setTabVisible('Files', visible);
		me.objs.btnFile && me.objs.btnFile.setVisible(visible);
		if (!visible) return;			
		
		let tabFiles = me.getTab('Files');
		
		if (visible && !me.isLoaded) {
			me.setTabOrder(tabFiles, 'Files');
		}
		let file = me.getMainOrFirstFile();
		me.gksc('btnFile').setIconCls(getExtStyle(file[me.fieldExt]));
		
		let filesReadOnly = me.getTabReadOnly('FILES');			
		me.objs.btnFile?.setKsReadOnly(filesReadOnly || (window.useEDS && file.MAIN && file.TEMP_EDS_DATE && me.gksd('EDSSaveDocBehavior') === 3));
		me.getTab('Files').setKsReadOnly(filesReadOnly);
		
		me.changeTab(tabFiles, true);
	},

	//Сборка данных
	dataCollectorFiles: function () {
		var me = this;
		return me.getTabVisibleFromTabInfo('FILES') ?
			me.getTab('Files').store.getDataExt(function (d) {
				if (!d.LINK) d.LINK = d.FILES;
				return d;
			}) :
			_;
	},

	//#endregion Файлы

	//Сборка данных

	isFilled: function() {
		let me = this,
			dt = me.gksc('RDT'),
			dtEndUtv = me.gksc('DTENDUTV'),
			sDocVid = me.gksc('S_DOCVID');
		
		let res = true;
		if (!dt.getValue() || !dt.isValid()) {
			me.addToInvalidControls(dt);
			res = false;
		}
		
		if (!sDocVid.getLink()) {
			me.addToInvalidControls(sDocVid);
			res = false;
		}

		if (!dtEndUtv.getValue() || !dtEndUtv.isValid()) {
			me.addToInvalidControls(dtEndUtv);
			res = false;
		}

		// refs #341 Если изменился вид документа/тип документа
		if (me.needToResetDocuments()) {
			me.warningMessages.push(KS.L10n.DFDocumentsEditView_CheckSave_Будет_удалена_связь_с_записью_раздела__Документы__);
		}
		return res;
	},

	dataCollector: function () {
		let me = this,
			res = {
				LINK: me.getLink(),
				LINK_SELF: me.getLinkSelf(),
				TYPE: me.gksd('TYPE'),
				DOCUMENTS: me.gksd('DOCUMENTS'),
				LINK_SAME: me.gksd('linkSame')
			};

		if (me.needToResetDocuments()) res.DOCUMENTS = null;

		let data = me.dataCollectorGeneral();
		if (data) res.tabGeneral = JSON.stringify(data);

		data = me.dataCollectorCorr();
		if (data) res.tabCorr = JSON.stringify(data);

		if (me.getTabVisibleFromTabInfo('DOCPROP'))
			res.tabProp = me.getTab('Prop').getData(1);

		data = me.dataCollectorFiles();
		if (data) res.tabFiles = JSON.stringify(data);

		return res;
	},

	dataCollectorGeneral: function () {
		let me = this;
		if (!me.getTabVisible('General')) return _;
		let res = {};
		Ext.each(['NUMBER', 'RNUMBER_PREF', 'RNUMBER_ORD', 'RNUMBER_POST', 'NUMBER2', 'VOL', 'HEADER', 'CONTENT', 'REMARK', 'RELATION_NEED'],
			(key) => res[key] = me.gksc(key).getValue());
		Ext.each(['RDT', 'DT', 'DTENDUTV', 'DTUTV'], key => res[key] = me.gksc(key).getValue()?.toDateString());
		Ext.each(['S_DOCVID','S_ORG_OTV', 'S_PERSON_OTV', 'S_DELO', 'REVIZ'], (key) => res[key] = me.gksc(key).getLink());
		return res;
	},

	/**
	 * Требуется ли занулять поле DOCUMENTS
	 * @returns {boolean}  Вернет true в случае, если запись была привязана к DOCUMENTS и были изм-ия в разрезе видов документов.
	 */
	needToResetDocuments: function(){
		const me = this;
		const docVid = me.gksc('S_DOCVID').getLink();
		const type = +me.gksd('TYPE');

		if (me.getLink() > 0 && docVid !== null && me.gksd('DOCUMENTS') &&
			(docVid !== me.data.data.S_DOCVID || type !== me.data.data.TYPE)) {
			return true;
		}
		return false;
	},

	//сообщение о необходимости сохранения
	needSaveMsgShow: function (cfg) {
		Ext.Msg.show({
			title: KS.L10n.attention,
			msg: wmc.get('NeedSaveDocument'),
			buttons: Ext.MessageBox.OKCANCEL,
			buttonText: {ok: 'Сохранить'},
			fn: function (buttonId) {
				var fn = cfg[buttonId] || cfg.default;
				if (fn) fn();
			},
			icon: Ext.MessageBox.INFO
		});
	},

	afterClose: function () {
		let me = this;
		let link = me.getLink();
		// Если при создании подобной записи, закрываем окно без сохранения
		// при этом присутсвуют файлы которые уже скопировались в БД, то их удаляем
		if (link === 0 && !me.saveChanges) {
			let fstore = me.gksd('tabFileData');
			let fileLinks = [];

			Ext.Array.each(fstore, function (value) {
				let link = Ext.Number.parseInt(value["LINK"]);
				if (link != null) {
					fileLinks.push(link);
				}
			});
			if (fileLinks.length > 0) {
				let res = ajaxRequest({
					url: 'SDfDocuments/DelFilesAfterCancell_A',
					params: {lstFiles: fileLinks}
				});
			}
		}
		me.callParent(arguments);
	},
	isNumberKey:  function (e) {
		var returnValue = false;
	
		if (e.keyCode >= 96 && e.keyCode <= 105)
		{
			returnValue = true;
		}
		else if (e.keyCode >= 48 && e.keyCode <= 57)
		{
			returnValue = true;
		}
		else if (e.keyCode == 8 || e.keyCode == 46)
		{
			returnValue = true;
		}
	
		return returnValue;
	},
	// Заполнить информацию по автонумераци в параметр rollBackData
	// так же вносим параметры для отката автонумерации при выполнении отмены изменений 
	fillRollBackData: function (rollBackData){
		let me = this;
		me.sksd('rollBackData', rollBackData);
		// Заполняем данные для отмены автонумерации BaseController.Cancel, rollbackNumLink и т.д.
		Object.keys(rollBackData).forEach(function (key) {
			me.sksd(key[0].toLowerCase()+key.substring(1), rollBackData[key]);
		});
	},
	// Заполнить поле Тип докмента
	fillDocVidType: function (sDocVid, type, selectDefType){
		let me = this;
		let rgroup = me.gksc('TYPE');
		// Доступные типы
		let lstDocTypes = me.gksd('docVidItems')[sDocVid];
		// Тип родительского документа
		let selfDocType = me.gksd('selfDocType');
		// Правила фильтрации по типам
		let docTypeFilterItems = me.gksd('docTypeFilter');
		
		if (lstDocTypes){
			Ext.Array.each(rgroup.items.items, (item) => {
				// refs #458
				// Если включена настройка "Ограничивать тип предыдущего документа" и есть отобранный родительский документ
				// тогда тип документа - настраиваем с учетом доступных типов для родительского документа
				if ((!me.gksd('isFilterByDocType') || !selfDocType || docTypeFilterItems[selfDocType] 
						&& Ext.Array.contains(docTypeFilterItems[selfDocType], Number(item.inputValue))) 
					&& Ext.Array.contains(lstDocTypes, Number(item.inputValue))){
					item.enable();
					//Если метод вызвался при изменении вида документа
					//устанавливаем значение по умолчанию
					if (selectDefType){
						rgroup.setValue({doctype: item.inputValue});
						selectDefType = false;
					}
				}
				else{
					item.disable();
				}
			});
			// Если метод вызвался при биндинге а не при изменении вида документа
			// устанавливаем тип документа
			if (!selectDefType && type != null){
				rgroup.setValue({doctype: type});
			}
		}
		else {
			Ext.Array.each(rgroup.items.items, (item) => { item.disable(); });
		}
	},
	// Обновить видимость и содержимое вкладок 
	refreshTabVisible : function(docVidOld, docTypeOld, docVidNew, docTypeNew, onlyCorr, dictDocVidNewValue = null){
		let me = this;
		const rid = ajaxRequest({
			url: 'SDfDocuments/GetTabInfo_A',
			params: {
					link: me.getLink(),
					docVidOld: docVidOld,
					docTypeOld: docTypeOld,
					docVidNew: docVidNew,
					docTypeNew: docTypeNew,
					onlyCorr: onlyCorr

				},
				success: async function (result) {
					if (!result) return;
					let warnMsgItems = [];
					let tabInfo = result['tabInfo'];
					let propInfo = result['propInfo'];
					let accessObject = result['accessObject'];
					if (!onlyCorr) {
						me.sksd('accessObject', accessObject);
					}
					tabInfo.forEach(r => {
						if (r.WarningMsg) {
							warnMsgItems.push(r.WarningMsg);
						}
					});
					let sDocVid = me.gksd('sDocVid');
					if (warnMsgItems.length > 0) {
						let res = await selectDialogShowAsync(KS.L10n.attention, warnMsgItems.join("\n"));
						if (res !== "yes") {
							// откат
							me.sksd('rollback', true);
							// Вид документа 
							if (docVidOld !== docVidNew){
								me.gksc('S_DOCVID').setValue(sDocVid);	
							}							
							// Тип документа
							me.fillDocVidType(docVidOld, docTypeOld, false);
							me.sksd('rollback', false);
							return;
						}						
					}					
					// Обновление данных для справочника видов документов, необходимых при откате
					if (sDocVid && dictDocVidNewValue){
						sDocVid[0].LINK = dictDocVidNewValue[0].LINK || dictDocVidNewValue[0].data.LINK;
						sDocVid[0].CODE = dictDocVidNewValue[0].CODE || dictDocVidNewValue[0].data.CODE;
						sDocVid[0].NAME = dictDocVidNewValue[0].NAME || dictDocVidNewValue[0].data.NAME;
					}					
					// Обновляем информацию о реквизитах, если она есть
					if (propInfo){
						me.sksd('tabPropData', propInfo);	
					}					
					// Обновляем информацию о вкладках
					if (onlyCorr){
						// Обновляем только информацию по вкладке корреспондентов
						let oldTabInfo = me.gksd('tabInfo');
						for(let i = 0; i < oldTabInfo.length; i++){
							if (oldTabInfo[i].Key === tabInfo[0].Key){
								oldTabInfo[i] = tabInfo[0];
								break;
							}
						}
					}
					else{
						// Обновляем всю информацию по вкладкам
						me.sksd('tabInfo', tabInfo);	
					}
					
					tabInfo.forEach(tab => {
						switch (tab.Key)
						{
							case "CORR":
								// Если было изменение видимости - ребинд данных, скрытие/раскрытие доступа к вкладке
								if (tab.Change)
								{
									me.getExtraCorr();
								}
								break;
							case "DOCPROP":
								// Если было изменение видимости - ребинд данных, скрытие/раскрытие доступа к вкладке
								if (tab.Change)
								{
									me.getExtraProp();
								}
								break;
							case "FILES":
								// Если было изменение видимости - ребинд данных, скрытие/раскрытие доступа к вкладке
								if (tab.Change)
								{
									me.getExtraFiles();
								}
								break;
							case "TASK":
								// Если было изменение видимости - ребинд данных, скрытие/раскрытие доступа к вкладке
								if (tab.Change)
								{
									me.createTabTask();
								}
								break;
						}
					});
					// Видимость полей согласно прав и настройке "Не показывать для ввода"
					if (!onlyCorr){
						me.setControlVisibleByAccess();
					}

				},
				callback: function () {
					if (me) me.hideLoadMask();
				}
			});
			if (me) {
				me.showLoadMask({
					msg: KS.L10n.updating_data,
					rid: rid
				});
			}	
	},
	// Получить видимость вкладки
	getTabVisibleFromTabInfo : function(tabKey){
		let me = this;
		let visible = false;
		let tabItemsInfo = me.gksd('tabInfo'); 
		if (tabItemsInfo && tabKey){
			for (let i = 0; i < tabItemsInfo.length; i++) {
				let t = tabItemsInfo[i];
				if (t.Key === tabKey){
					visible = t.Visible;
					break
				}
			}
		}
		return visible;
	},
	// Получить признак только для чтения у вкладки
	getTabReadOnly : function(tabKey){
		let me = this;
		let readonly = false;
		let tabItemsInfo = me.gksd('tabInfo');
		if (tabItemsInfo && tabKey){
			for (let i = 0; i < tabItemsInfo.length; i++) {
				let t = tabItemsInfo[i];
				if (t.Key === tabKey){
					readonly = (t.Access & ObjAccessMask.EDIT) === 0;
					break
				}
			}
		}
		return readonly;	
	},
	// Выставить порядок вкладок
	setTabOrder: function (tab, key) {
		var me = this;
		// порядок вкладок
		let tabOrder = ['General','Task','Corr','Prop','Files'];
		let tabIndex =  tabOrder.indexOf(key);
		if (tabIndex < 0) return;
		for(let i =  tabOrder.indexOf(key) - 1; i >= 0; i--){
			let prevTab = me.ksControls[me.getTabKey(tabOrder[i])];
			let prevTabIndex = prevTab ? me.ksControls.allTab.items.items.indexOf(prevTab) : -1; 
			if (prevTabIndex >= 0){
				me.remove(tab, false);
				me.insert(prevTabIndex + 1, tab);
				break;
			}
		}
	},
	// Установка видимости контролов по правам доступа с учетом настройки скрытия по виду документа
	setControlVisibleByAccess: function() {
		let me = this;
		let accessObject = me.gksd('accessObject'); 
		// Видимость полей согласно настройке "Не показывать для ввода"
		me.setFullObjsAccess(accessObject, ['RNUMBER_PREF', 'RNUMBER_POST', 'NUMBER2', 'NUMBER', 'DT', 'S_ORG_OTV', 'S_PERSON_OTV', 'S_DELO', 'VOL', 'HEADER', 'CONTENT', 'DTENDUTV', 'DTUTV', 'REMARK']);
		// Настраиваем видимость, размер полей, перед которыми могут скрываться поля
		// Порядковый номер
		me.gksc('RNUMBER_ORD').labelEl.setDisplayed(!accessObject.RNUMBER_PREF ? true : false);
		me.gksc('RNUMBER_ORD').setWidth(!accessObject.RNUMBER_PREF ? 280: 100);
		// от
		me.gksc('DT').labelEl.setWidth(!accessObject.NUMBER ? me.labelWidth + 5 : 35);
		me.gksc('DT').setWidth(!accessObject.NUMBER ? 280: 145);
		// Том
		me.gksc('VOL').labelEl.setWidth(!accessObject.S_DELO ? me.labelWidth + 5 : 35);
		me.gksc('VOL').setWidth(!accessObject.S_DELO ? 240: 100);
		// Дата исполнения
		me.gksc('DTUTV').labelEl.setWidth(!accessObject.DTENDUTV ? me.labelWidth + 5 : 130);
		me.gksc('DTUTV').setWidth(!accessObject.DTENDUTV ? 280 : 240);
	},

	setReadOnly: function(v, reason, fake) {
		const me = this;
		me.callParent(arguments);

		if (window.useEDS) {
			//не блокируем полностью кнопку Подписать
			me.btnSign?.setKsReadOnly(false);
			me.subBtnSign?.setDisabled(v);
			me.subBtnUnSign?.setDisabled(v);

			if (v) {
				//в случае, если причиной доступа только на чтение является ЭП, разрешаем подписывать и снимать подпись
				const readOnlyReasonExt = me.gksd('readOnlyReasonExt');
				if ((readOnlyReasonExt & +Ext.Object.getKey(miscTypes.ReadOnlyReasonEnum, 'EDS')) !== 0) {
					const otherReason = readOnlyReasonExt | ~+Ext.Object.getKey(miscTypes.ReadOnlyReasonEnum, 'EDS');
					if (otherReason <= 0) {
						me.subBtnSign?.setDisabled(false);
						me.subBtnUnSign?.setDisabled(false);
					}
				}
			}
		}
	},

	onSignCompleted: async function(response) {
		if (!response) return;

		const me = this;
		if (response.doc) {
			const rowDocUpd = response.doc.rows[0];
			//обновим данные записи окна редактирования
			me.sksd('EDS', rowDocUpd.EDS);
			me.sksd('STAMP', rowDocUpd.STAMP);

			//обновим данные по ЭП документа в списке, откуда открыли
			me.updateRecord({
				LINK: rowDocUpd.LINK,
				EDS_DATE: rowDocUpd.EDS_DATE,
				EDS_CNS: rowDocUpd.EDS_CNS,
				STAMP: rowDocUpd.STAMP
			});
		}
		if (response.files) {
			//обновим данные вкладки Файлы окна редактирования
			const files = me.getTab('Files').store.getDataExt();
			files.forEach(file => {
				const rowUpd = response.files.rows.filter(r => r.LINK === file.LINK)[0];
				if (rowUpd) {
					file.TEMP_EDS_DATE = rowUpd.EDS_DATE;
					file.TEMP_EDS_CNS = rowUpd.EDS_CNS;
				}
			});
			me.fileList?.onSignAllCompleted(response.files.rows);

			//обновим данные по ЭП файла в списке, откуда открыли
			response.files.rows.forEach(rowFilesUpd => {
				me.updateRecord({
					LINK: rowFilesUpd.LINK,
					IS_FILES: true,
					EDS_FILES: rowFilesUpd.EDS_DATE ? 1 : 0
				});
			})
		}

		me.oldData = JSON.stringify(me.dataCollector());

		const readOnlyResponse = await ajaxRequestAsync({
			url: me.linkCode + '/CanEditDFDoc_A',
			params: {link: me.getLink()}
		});

		if (!readOnlyResponse) return;
		me.sksd('readOnlyReasonExt', readOnlyResponse.readOnlyReasonExt);
		me.readOnly = readOnlyResponse.readOnly;
		me.setReadOnly(me.readOnly, readOnlyResponse.readOnlyReason);		
	},
});