Ext.define('Keysystems.DFDocCorr.Edit', {
	extend: 'Keysystems.Base.Edit',
	profileListeners: [{name: 'view', method: 'FormParam'}],
	title: 'Корреспонденты документооборота',
	viewMinSize: [720, 150],
	viewCfg: function () {
		let cfg = this.callParent(arguments);
		cfg.resizable = true;
		cfg.maximizable = true;
		return cfg;
	},
	createItems: function () {
		let me = this,
			items = [];

		Ext.each([
			{
				key: 'S_ORG',
				name: 'Организация',
				code: dnl.S_ORG,
				ksSetValue: function (v) {
					let prev = me.gksc('S_ORG').getLink();
					this.setValue(v);

					me.gksc('S_OTDEL').setDisabled(!this.value.length);
					if (me.gksc('S_ORG').getLink() !== prev) {
						me.gksc('S_OTDEL').setValue([]);
					}
				}
			},
			{
				key: 'S_OTDEL',
				name: 'Подразделение',
				code: dnl.S_OTDEL,
				disabled: true,
				initWhereArgs: function () {
					return {
						SOrgs: {value: me.gksc('S_ORG').getLinks(1), type: 'List_int'},
						HasFilterOnLoad: {value: 'False', type: 'bool'}
					};
				},
				getSOrg: function () {
					return me.gksc('S_ORG').getLink();
				}
			},
			{
				key: 'S_PERSON',
				name: 'Сотрудник',
				code: dnl.S_PERSON,
				initWhereArgs: function () {
					let wa = {
							DH1: {value: longPeriod.begin, type: 'Date'},
							DH2: {value: longPeriod.end, type: 'Date'}
						},
						orgCorr = me.gksc('S_ORG').getLinks(),
						otdelCorr = me.gksc('S_OTDEL').getLinks();

					if (orgCorr.length) {
						wa.SOrgs = {value: JSON.stringify(orgCorr), type: 'List_int'};
						wa.HasFilterOnLoad = {value: 'False', type: 'bool'};
					}

					if (otdelCorr.length) {
						wa.SOtdel = {value: JSON.stringify(otdelCorr), type: 'List_int'};
					}

					return wa;
				}
			}
		], function (el) {
			items.push(me.sksc(el.key, me.createDictEdit({
				key: el.key,
				fieldLabel: el.name,
				initWhereArgs: el.initWhereArgs,
				code: el.code,
				mode: 'SINGL',
				ksSetValue: el.ksSetValue,
				listCfg: {
					getSOrg: el.getSOrg
				}
			})));
		});

		return items;
	},

	getExtra: function (callBack, link) {
		var me = this;
		me.baseGetExtra({link: link}, function (value) {
			if (value.ErrorMsg) {
				showError(value.ErrorMsg);
				me.isExit = true;
				LoadMask.hide();
				return;
			}
			me.sksd('DFDocument', value.row.DF_DOCUMENTS);
			me.gksc('S_ORG').setValue(value.S_ORG);
			if (!me.gksc('S_ORG').getLink())
				me.gksc('S_OTDEL').setDisabled(true);
			me.gksc('S_OTDEL').setValue(value.S_OTDEL);
			me.gksc('S_PERSON').setValue(value.S_PERSON);
			if (callBack) callBack();
		});
	},

	dataCollector: function () {
		let me = this,
			res = me.callParent();

		res.DF_DOCUMENTS = me.gksd('DFDocument');
		res.S_ORG = me.gksc('S_ORG').getLink();
		res.S_OTDEL = me.gksc('S_OTDEL').getLink();
		res.S_PERSON = me.gksc('S_PERSON').getLink();
		return res;
	},
	isFilled: function () {
		let me = this;

		if (me.gksc('S_ORG').isEmpty() && me.gksc('S_OTDEL').isEmpty() && me.gksc('S_PERSON').isEmpty()) {
			me.errorMessages.push("Не заполнен корреспондент");
		}
		return true;
	},
});