﻿Ext.define('Keysystems.Contract.List', {
    extend: 'Keysystems.Base.List',
    deleteCode: 'DOCUMENT_CONTRACT',
    startYear: (new Date()).getFullYear(),
    bodyPadding: 10,
    labelWidth: 150,
    disableToolBar: true,

    profileListeners: [
        { name: 'holdingPeriod', method: 'KsPeriodChange' }
    ],

    constructor: function(cfg){
        Ext.apply(this, cfg);
        this.callParent(arguments);
    },

    setWhereArgs: function() {
        let me = this,
            objs = me.objs,
            dh = objs.holdingPeriod.getValue(),
            whereArgs = {
                ObjLinks: me.getWhereArgs().ObjLinks
            };
        
        if (!me.hideFilterPanel){
            whereArgs.DBegin = { value: dh.dh1, type: 'Date' };
            whereArgs.DEnd = { value: dh.dh2, type: 'Date' };
        }
        else {
            whereArgs.DBegin = {value: new Date(1900,0,1) , type: 'Date'};
            whereArgs.DEnd = {value: new Date(2100,11,31), type: 'Date'};
        }

        return Ext.apply(me.whereArgs, whereArgs);
    },
    createItems: function() {
        var me = this,
            objs = me.objs,
            items = me.callParent(arguments);

        items.unshift(objs.filterPanel = Ext.create('Ext.panel.Panel', {
            layout: { type: 'vbox', align: 'stretch' },
            collapsible: !me.hideBottomPanel,
            bodyPadding: !me.hideBottomPanel ? me.bodyPadding : ( me.bodyPadding + ' ' + me.bodyPadding + ' 0 ' + me.bodyPadding),
            border: 0,
            bodyBorder: 0,
            userCls: 'rks-filter-panel',
            header: {
                title: 'Фильтр по Контрактам',
                hidden: me.hideBottomPanel,
            },
            animCollapse: false,
            items: [
                Ext.create('Ext.form.FieldContainer',
                    {
                        layout: { type: 'hbox', align: 'stretch' },
                        items: [
                            objs.holdingPeriod = Ext.create('Keysystems.Controls.KsPeriod', {
                                startYear: me.startYear,
                                state: 4,
                                allStates: 13,
                                width: 400,
                                listeners: {
                                    ksChange: function () {
                                        if (me.isLoading) return;
                                        me.refreshData();
                                    }
                                }
                            })
                        ]
                    })
            ]
        }));
        objs.Year = objs.holdingPeriod.Quarter.holdingYear;
        objs.Quarter = objs.holdingPeriod.Quarter.holdingQuarter;

        if (me.hideFilterPanel)
            objs.filterPanel.hide();

        return items;
    },

    addRecord: function() {
        var me = this,
            rec = me.callParent(arguments);

        KsLib.tryRun(me.addRevizRecord, me, rec);
    },

    refreshData: function() {
        var me = this,
            objs = me.objs;

        me.setWhereArgs();
        me.refresh();
    },

    initializeFilter: function () {
        let me = this;
        if (!me.whereArgs) return;

        if (!me.hideFilterPanel)
            me.updateDateFromWhereArg(me.whereArgs.DBegin.value, me.whereArgs.DEnd.value, me.objs.holdingPeriod);
    },

    createTBar: function () {
        let me = this,
            objs = me.objs;

        me.callParent(arguments);

        if (me.visibleShowContract) {
            me.objs.tbarBtns.showContract = me.sksc('btnShow',
                Ext.create('Ext.Button',
                    {
                        iconCls: 'x_btn_contract_list',
                        tooltip: 'Контракты по объекту',
                        tooltipType: 'title',
                        hidden: !me.visibleShowContract,
                        handler: function () {
                            let whereArgsShow = me.getWhereArgs(),
                                cfg = {
                                    code: me.code,
                                    parentView: me.parentView,
                                    title: me.title,
                                    linkCode: me.linkCode,
                                    editClass: 'Keysystems.Contract.Edit',
                                    handler: 'Keysystems.Contract.List',
                                    iconCls: 'x_btn_contract_list',
                                    hideFilterPanel: true,
                                    hidePagging: true,
                                    checkModel: false,
                                    setRecord: function (row, cmp) {
                                        return me.setRecord(row, cmp);
                                    },
                                    addRecord: function (row) {
                                        var grid = me.objs.CONTRACT_LIST.objs.Grid,
                                            rec = grid.store.createModel(row);
                                        grid.loadData([rec], true);
                                        me.objs.CONTRACT_LIST.refresh(true, 1);
                                        me.addRecord(row);
                                        return rec;
                                    },
                                    whereArgs: {
                                        ObjLinks: whereArgsShow.ObjLinks
                                    },
                                }
                            me.objs.CONTRACT_LIST = Ext.create('Keysystems.Contract.List', cfg);
                        }
                    }));
            objs.tbar.unshift(objs.tbarBtns.showContract);
        }
        me.setReadOnly(me.accessTab === 1);
        return objs.tbar;
    },

    getGridCfg: function(){
        let res = this.callParent(arguments);
        res.userCls = 'rks-grid-with-filter-panel';
        return res;
    },

    setReadOnly: function(state) {
        var me = this,
            objs = me.objs,
            btns = objs.tbar;
        me.callParent(arguments);

        if (me.disableToolBar && objs.tbarBtns) {
            Ext.Array.each(btns,
                function (btn) {
                    if (Ext.isFunction(btn.setReadOnly)) {
                        btn.setReadOnly(state);
                    }
                });
            objs.tbarBtns.showContract && objs.tbarBtns.showContract.setReadOnly(false);
        }
    },

    columnsAdapted: function() {
        var me = this,
            columns = me.callParent(arguments);
        
        c = ArrayLib.find(columns, ['dataIndex'], 'URL');

        if (c !== -1) {
            columns[c].defaultRenderer = function(v) {
                if (!v || v.length === 0)
                    return '<div></div>';
                val = v.toString();
                if (val.indexOf('http') !== -1)
                    return '<a href="' + v.toString() + '" target="_blank">' + v.toString() +'</a>';
                else
                    return '<a href="https://' + v.toString() + '" target="_blank">' + v.toString() +'</a>';
            };
        }
        
        return columns;
    },

    /** Task Revizor.Contract.NewSame */
    newSameContract: function () {
        let me = this,
            rec = me.objs.Grid.getFrstSelect();

        me.edit('new', null, {ObjLink: rec.data.S_ORG, ObjCode: rec.data.S_ORG_CODE, ObjName: rec.data.S_ORG_NAME});
    }
});