Ext.define('Keysystems.Contract.Edit', {
    extend: 'Keysystems.Base.Edit',
    title: 'Контракты',
    f: 'new',
    viewMinSize: [690, 510],
    bodyPadding: 0,
    readOnlyList: [
        'S_ORG', 'DT', 'SUMMA', 'S_NACPROJ'
    ],
    ObjLink: 0,
    ObjCode: '',
    ObjName: '', 
    
    createItems: function () {
        var me = this;
        return me.objs.allTab = Ext.create('Ext.tab.Panel',
            {
                plain: true,
                border: 0,
                flex: 1,
                userCls: me.basePanelCls,
                bodyCls: me.basePanelBodyCls,
                items: me.getTab('General')
            });
    },
    createTabGeneral: function() {
        var me = this,
            objs = me.objs;

        objs.tabGeneral = Ext.create('Ext.panel.Panel',
            {
                title: 'Общие',
                layout: { type: 'vbox', align: 'stretch' },
                flex: 1,
                border: 0,
                bodyPadding: 10,
                items: [
                    Ext.create('Ext.form.FieldContainer',
                        {
                            layout: { type: 'vbox', align: 'stretch' },
                            padding: me.bodyPadding,
                            items: [
                                me.createDictEdit({
                                    key: 'S_ORG',
                                    mode: 'SINGL',
                                    ksAllowEmpty: true,
                                    code: dnl.S_ORG,
                                    fieldLabel: 'Организация',
                                    ksSetValue: function(v) {
                                        this.setValue(v);
                                    },
                                    initWhereArgs: function() {
                                        return {
                                            Regions: {value: JSON.stringify(me.gksd('Regions')), type: 'List_int'}
                                        };
                                    },
                                }),
                                Ext.create('Ext.form.FieldContainer', {
                                    layout: { type: 'hbox', align: 'stretch' },
                                    items: [
                                        me.sksc('NUMBER',
                                            objs.NUMBER = Ext.create('Ext.form.field.Text', {
                                                fieldLabel: '№',
                                                labelWidth: me.labelWidth,
                                                enforceMaxLength: true,
                                                maxLength: 100,
                                                ksAllowEmpty: true,
                                                width: 175 + me.labelWidth
                                            })),
                                        me.sksc('DT',
                                            objs.DT = Ext.create('Ext.form.field.Date', {
                                                fieldLabel: 'от',
                                                labelWidth: 30,
                                                padding: '0 0 0 20',
                                                flex: 1,
                                                maxWidth: 180,
                                                format: 'd.m.Y',
                                                hideTrigger: false,
                                                minValue: '01.01.1900',
                                                maxValue: '31.12.2100',
                                                ksAllowEmpty: true,
                                                listeners: {
                                                    blur: function() {
                                                        me.checkDT(true);
                                                    }
                                                }
                                            })),
                                        me.sksc('SMALL_PURCHASE',
                                            objs.SMALL_PURCHASE = Ext.create('Ext.form.Checkbox', {
                                                boxLabel: 'Малые закупки',
                                                padding: '0 0 0 20'
                                            }))
                                    ]
                                }),
                                me.sksc('REESTR_NUMBER',
                                    objs.REESTR_NUMBER = Ext.create('Keysystems.form.field.TextAreaComboBox', {
                                        labelWidth: me.labelWidth,
                                        fieldLabel: 'Реестровый номер',
                                        store: me.content || [],
                                        ksAllowEmpty: true,
                                        enforceMaxLength: true,
                                        maxLength: 19,
                                        listeners: {
                                            blur: function() {
                                                me.checkReestrNumUnique(Ext.emptyFn);
                                            }
                                        }
                                    })),
                                me.sksc('SUMMA',
                                    objs.SUMMA = Ext.create('Keysystems.Controls.CalcField',
                                        {
                                            labelWidth: me.labelWidth,
                                            fieldLabel: 'Сумма',
                                            minValue: 0,
                                            maxWidth: 300
                                        })),
                                me.sksc('SUBJECT',
                                    objs.SUBJECT = Ext.create('Keysystems.form.field.TextAreaComboBox', {
                                        labelWidth: me.labelWidth,
                                        fieldLabel: 'Предмет контракта',
                                        store: me.content || [],
                                        enforceMaxLength: true,
                                        maxLength: 2000
                                    })),
                                me.createDictEdit({
                                    key: 'S_NACPROJ',
                                    mode: 'SINGL',
                                    code: dnl.S_NACPROJ,
                                    fieldLabel: 'Нац. проект'
                                }),
                                me.sksc('URL',
                                    objs.URL = Ext.create('Keysystems.form.field.TextAreaComboBox', {
                                        labelWidth: me.labelWidth,
                                        fieldLabel: 'Ссылка на ЕИС',
                                        store: me.content || [],
                                        enforceMaxLength: true,
                                        maxLength: 1500
                                    })),
                            ]
                        })
                ]
            });
        return objs.tabGeneral;
    },
    afterGetExtra: function() {
        var me = this,
            objs = me.objs;

        me.sksd('ReestrNumberUnique', true);
        me.sksd('ReestrNumber', '');
        
        if (me.data && me.f === 'new') {
            var data = me.data.data;

            let dict = objs.S_ORG;
            dict.setValue({
                LINK: data.S_ORG,
                CODE: data.S_ORG_CODE,
                NAME: data.S_ORG_NAME
            });
        }

        if (!me.data && me.f === 'new') {
            let dict = objs.S_ORG;
            dict.setValue({
                LINK: me.ObjLink,
                CODE: me.ObjCode,
                NAME: me.ObjName
            });       
        }
                
        me.callParent(arguments);
    },
        
    getExtra: function(endFunc, link) {
        var me = this,
            orgLink = me.data && me.data.data.S_ORG || 0,
            objs = me.objs;

        me.baseGetExtra({
            link: link,
            orgLink: link > 0 ? 0 : orgLink
        }, function(val) {
            me.gksc('NUMBER').setValue(val.row.NUMBER);
            me.gksc('DT').setValue(val.row.DT);
            me.gksc('REESTR_NUMBER').setValue(val.row.REESTR_NUMBER);
            me.gksc('URL').setValue(val.row.URL);
            me.gksc('SUBJECT').setValue(val.row.SUBJECT);
            me.gksc('SUMMA').setValue(val.row.SUMMA);
            objs.S_ORG.setValue(val.S_ORG);
            objs.S_NACPROJ.setValue(val.S_NACPROJ);
            me.sksd('Regions', val.Regions);
            me.gksc('SMALL_PURCHASE').setValue(val.row.SMALL_PURCHASE);            
            
            if (me.readOnly || (me.data && me.data.data.readOnly)) me.setReadOnly(true);
            if (endFunc) endFunc();
        });
    },
    isFilled: function() {
        var me = this,
            objs = me.objs;

        let res = true;
        
        if (objs.S_ORG.isEmpty()) {
            me.addToInvalidControls(objs.S_ORG);
            res = false;
        }
        
        if (!objs.NUMBER.getValue()) {
            me.addToInvalidControls(objs.NUMBER);
            res = false;
        }

        if (!objs.SMALL_PURCHASE.getValue() && !objs.REESTR_NUMBER.getValue()) {
            me.addToInvalidControls(objs.REESTR_NUMBER);
            res = false;
        }

        if (objs.SMALL_PURCHASE.getValue() && objs.SUMMA.getNumValue() > 600000) {
            me.errorMessages.push(wmc.getString(KS.L10n.ContractEditView_CheckSave_Сумма_не_должна_превышать_600_тыс_руб_));
        }

        if (!objs.DT.getValue()) {
            me.addToInvalidControls(objs.DT);
            res = false;
        }

        if (!me.gksd('ReestrNumberUnique')) {
            me.errorMessages.push(wmc.getString(KS.L10n.ContractEditView_CheckSave_Контракт_с_реестровым_номером___0___уже_присутствует_, me.gksd('ReestrNumber')));
        }
        
        return res;
    },
    dataCollector: function() {
        var me = this,
            objs = me.objs;

        var data = me.callParent([false]);
        data.LINK = objs.link;
        data.S_ORG = objs.S_ORG.getLink();
        data.SUMMA = objs.SUMMA.getNumValue();
        data.S_NACPROJ = objs.S_NACPROJ.getLink();

        data.NUMBER = objs.NUMBER.getValue();
        data.REESTR_NUMBER = objs.REESTR_NUMBER.getValue();
        data.URL = objs.URL.getValue();
        data.SUBJECT = objs.SUBJECT.getValue();
        data.DT = objs.DT.getValue() !== null ? objs.DT.getValue().toDateString() : null;
        data.SMALL_PURCHASE = objs.SMALL_PURCHASE.getValue();
                
        return data;
    },
    successSaveFunc: function (result, endFunc, params) {
        var me = this;
        if (!result.result && result.limitLinks) {
            var link = me.data.get('LINK');
            // Сначала блокирующее сообщение про связанные записи Мероприятия
            if (result.limitLinks.DOCUMENT_REVIZ) {
                var links = { DOCUMENT_REVIZ: result.limitLinks.DOCUMENT_REVIZ };
                relationsMsg(me.code,
                    [{ name: "()", text: KS.L10n.ContractEditView_AfterFailedSaveCompleted_Сохранение_невозможно__Изменения_затрагивают_связанные_записи_, related: true, link: link }],
                    [link],
                    false,
                    me,
                    links);
            }
        }
        this.callParent(arguments);
    },

    //проверка на то существует ли контракт с таким же реестровым номером
    checkReestrNumUnique: function(callBack, key) {
        var me = this,
            ksData = me.ksData,
            key = key || 'REESTR_NUMBER',
            ksControls = me.ksControls,
            num = me.gksc(key).getValue(),
            dt = ksControls.DT.getValue();

        //Не проверяем уже сохраенное мероприятие
        if (ksData.link <= 0 || (JSON.parse(me.oldData))[key] !== num) {
            ajaxRequest({
                url: (me.linkCode + '/IsReestrNumberUnique_A'),
                ignoreError: true,
                params: {
                    link: ksData.link,
                    num: num
                },
                success: function(val) {
                    if (key === 'NUMBER' && val) {
                        info(wmc.get('RevizExist', num, dt.dh2.getFullYear()));
                    } else if (!val) {
                        info(wmc.getString(KS.L10n.ContractEditView_CheckSave_Контракт_с_реестровым_номером___0___уже_присутствует_, num));
                    }

                    me.sksd('ReestrNumberUnique', val);
                    me.sksd('ReestrNumber', num);
                    
                    callBack && callBack();
                }
            });
        } else {
            callBack();
        }
    },
    //
})