﻿Ext.define('Keysystems.Chart', {
	extend: 'Ext.chart.Chart',
	animate: true,
	shadow: true,

	fieldName: 'data1',
	fieldValue: 'data2',
	titleName: 'title1',
	titleValue: 'title2',
	positionName: 'bottom',
	positionValue: 'left',

	initComponent: function() {
		var me = this;

		me.axes = me.axes || me.getAxes();
		me.store = me.store || me.createStore();
		me.series = me.series || me.getSeries();

		return me.callParent(arguments);
	},

	createStoreCfg: function() {
		var me = this;
		return {
			fields: [me.fieldName, me.fieldValue],
			data: me.data || [],
			proxy: 'memory'
		};
	},
	createStore: function() { return Ext.create('Ext.data.Store', this.createStoreCfg()); },

	getAxes: function() {
		var me = this;
		return [
			{
				type: 'Category',
				position: me.positionName,
				fields: [me.fieldName],
				title: me.titleName,
				label: me.cfgNameLabel ? Function('return ' + me.cfgNameLabel)() : _
				/*label: {
					renderer: me.methodNameRenderer ? Function('return ' + me.methodNameRenderer)() : _,
					rotate: { degrees: 45 }
				},*/
				//label: { rotate: { degrees: 270 } }
			},
			{
				type: 'Numeric',
				position: me.positionValue,
				fields: [me.fieldValue],
				title: me.titleValue,
				label: me.cfgValueLabel ? Function('return ' + me.cfgValueLabel)() : _,
				grid: true,
				minorTickSteps: 1,
				minimum: me.minimum,
				maximum: me.maximum
			}
		];
	},

	getSeries: function(xField, yField, type) {
		var me = this;
		xField = xField || this.fieldName;
		yField = yField || this.fieldValue;
		return [
			{
				type: type || 'column',
				//gutter: 80,
				xField: xField,
				yField: yField,
				tips: {
					trackMouse: true,
					renderer: function(storeItem) {
						var t = storeItem.get(xField);
						this.setTitle(me.methodNameRenderer ? Function('return ' + me.methodNameRenderer)()(t) : t);
						var u = storeItem.get(yField);
						this.update(me.methodValueRenderer ? Function('return ' + me.methodValueRenderer)()(u) : u);
					}
				}
			}
		];
	},

	addSeries: function(xField, yField, type, fill) {
		this.series.addAll(this.getSeries(xField, yField, type, fill));
		this.redraw();
	},

	refreshData: function() {
		var me = this,
			wa = JSON.parse(me.whereArgs || '{}');
		wa.IgnoreHierarchy = { value: 'True', type: 'bool' };

		PageDataLib.get({
			whereArgs: JSON.stringify(wa),
			GateCode: 'WidgetChart',
			controlName: 'WidgetChart',
			page: 1,
			pageSize: 10000,
			filter: me.filter,
			linkCode: me.linkCode
		}, function(a) {
			var d = a.data;
			if (me.methodGetData) d = Function('return ' + me.methodGetData)()(d) || d;
			me.store.loadData(d, false);
		});
	}
});

Ext.define('Keysystems.Chart.Settings', {
	extend: 'Ext.window.Window',

	title: 'Настройка графика',
	iconCls: 'x_btn_settings_blue',
	layout: { type: 'vbox', align: 'stretch' },
	width: 400,
	resizable: false,
	labelWidth: 150,
	bodyPadding: 10,

	defaultGetData: function(data) { return data; },

	initComponent: function() {
		var me = this;

		me.items = me.createItems();
		me.fillItems();
		me.buttons = [
			Ext.create('Ext.Button', {
				text: 'Ок',
				handler: function() {
					me.callback && me.callback(me.getValue());
					me.close();
				}
			}),
			Ext.create('Ext.Button', { text: 'Отмена', handler: function() { me.close(); } }),
			Ext.create('Ext.Button', { text: 'Принять', handler: function() { me.callback && me.callback(me.getValue()); } })
		];

		return me.callParent(arguments);
	},

	getValue: function() {
		var me = this;
		return {
			title: me.fieldTitle.getValue(),
			fieldName: me.fieldName.getValue(),
			fieldValue: me.fieldValue.getValue(),
			titleName: me.fieldTitleName.getValue(),
			titleValue: me.fieldTitleValue.getValue(),

			methodGetData: me.fieldGetData.getValue(),
			cfgNameLabel: me.fieldNameLabel.getValue(),
			cfgValueLabel: me.fieldValueLabel.getValue(),

			linkCode: me.fieldLinkCode.getValue(),
			whereArgs: me.fieldWhereArgs.getValue(),
			filter: me.fieldFilter.getValue()
		};
	},

	parseColumns: function(cm) {
		var res = [];
		Ext.each(cm, function(c) { if (c.dataIndex !== 'tree') res.push({ title: c.text + ' [' + c.dataIndex + ']', text: c.text, dataIndex: c.dataIndex }); });
		return res;
	},

	getColumns: function(callback) {
		var me = this,
			cfg = me.widgetCfg || (me.widgetCfg = {});

		if (me.columns) return callback(me.columns);

		switch (cfg.type) {
		case 'dict':
			return callback(me.columns = me.parseColumns(cfg.dict.Grid.columnManager.columns));
		case 'chart':
			ajaxRequest({
				url: cfg.linkCode + '/GetShema_A',
				params: { gzipData: '{}' },
				success: function(result) { callback(me.columns = me.parseColumns(result.columns)); }
			});
			break;
		}

		return _;
	},

	fillItems: function() {
		var me = this,
			cfg = me.widgetCfg || (me.widgetCfg = {});

		me.fieldTitle.setValue(cfg.title || '');

		switch (cfg.type) {
		case 'dict':
			me.getColumns(function(cols) {
				me.fieldName.loadData(cols.concat());
				me.fieldName.setValueSelectOrFrst();
				me.fieldValue.loadData(cols.concat());
				me.fieldValue.setValueSelectOrFrst();
			});

			var dict = cfg.dict;
			me.fieldLinkCode.setValue(dict.linkCode);
			me.fieldWhereArgs.setValue(JSON.stringify(dict.initWhereArgs()));
			me.fieldFilter.setValue(dict.getFilter());

			break;
		case 'chart':
			me.getColumns(function(cols) {
				me.fieldName.loadData(cols.concat());
				me.fieldValue.loadData(cols.concat());
			});

			me.fieldName.setValue(cfg.fieldName);
			me.fieldValue.setValue(cfg.fieldValue);
			me.fieldTitleName.setValue(cfg.titleName);
			me.fieldTitleValue.setValue(cfg.titleValue);

			me.fieldGetData.setValue(cfg.methodGetData);
			me.fieldNameLabel.setValue(cfg.cfgNameLabel);
			me.fieldValueLabel.setValue(cfg.cfgValueLabel);

			me.fieldLinkCode.setValue(cfg.linkCode);
			me.fieldWhereArgs.setValue(cfg.whereArgs);
			me.fieldFilter.setValue(cfg.filter);

			break;
		}
	},

	createItems: function() {
		var me = this;
		return [
			me.fieldTitle = Ext.create('Ext.form.field.Text', {
				fieldLabel: 'Наименование',
				labelWidth: me.labelWidth
			}),
			me.fieldName = Ext.create('Ext.form.field.ComboBox', {
				fieldLabel: 'Поле наименования',
				labelWidth: me.labelWidth,
				queryMode: 'local',
				displayField: 'title',
				valueField: 'dataIndex',
				store: Ext.create('Ext.data.Store', { fields: ['dataIndex', 'text', 'title'], data: [], proxy: 'memory' }),
				listeners: {
					change: function(th, nv, ov) {
						var on,
							r = th.store.findRecord(th.valueField, nv),
							n = r ? r.data.text : nv,
							name = me.fieldTitleName.getValue();
						if (ov) {
							r = th.store.findRecord(th.valueField, ov);
							on = r ? r.data.text : ov;
						}
						if (!name || on === name) me.fieldTitleName.setValue(n);
					}
				}
			}),
			me.fieldValue = Ext.create('Ext.form.field.ComboBox', {
				fieldLabel: 'Поле значения',
				labelWidth: me.labelWidth,
				queryMode: 'local',
				displayField: 'title',
				valueField: 'dataIndex',
				store: Ext.create('Ext.data.Store', { fields: ['dataIndex', 'text', 'title'], data: [], proxy: 'memory' }),
				listeners: {
					change: function(th, nv, ov) {
						var on,
							r = th.store.findRecord(th.valueField, nv),
							n = r ? r.data.text : nv,
							name = me.fieldTitleValue.getValue();
						if (ov) {
							r = th.store.findRecord(th.valueField, ov);
							on = r ? r.data.text : ov;
						}
						if (!name || on === name) me.fieldTitleValue.setValue(n);
					}
				}
			}),
			me.fieldTitleName = Ext.create('Ext.form.field.Text', {
				fieldLabel: 'Подпись наименования',
				labelWidth: me.labelWidth
			}),
			me.fieldTitleValue = Ext.create('Ext.form.field.Text', {
				fieldLabel: 'Подпись значения',
				labelWidth: me.labelWidth
			}),
			Ext.create('Ext.form.FieldSet', {
				title: 'Методы',
				collapsible: true,
				labelWidth: me.labelWidth,
				layout: { type: 'vbox', align: 'stretch' },
				collapsed: true,
				items: [
					me.fieldGetData = Ext.create('Keysystems.form.field.Trigger.TextEditor', {
						height: 50,
						fieldLabel: 'Метод обработки данных',
						labelWidth: me.labelWidth,
						value: me.defaultGetData.toString()
					}),
					me.fieldNameLabel = Ext.create('Keysystems.form.field.Trigger.TextEditor', {
						height: 50,
						fieldLabel: 'Настройка подписи наименований',
						labelWidth: me.labelWidth,
						value: '{}'
					}),
					me.fieldValueLabel = Ext.create('Keysystems.form.field.Trigger.TextEditor', {
						height: 50,
						fieldLabel: 'Настройка подписи значений',
						labelWidth: me.labelWidth,
						value: '{}'
					})
				]
			}),
			Ext.create('Ext.form.FieldSet', {
				title: 'Дополнительно',
				collapsible: true,
				labelWidth: me.labelWidth,
				layout: { type: 'vbox', align: 'stretch' },
				collapsed: true,
				items: [
					me.fieldLinkCode = Ext.create('Ext.form.field.Text', {
						fieldLabel: 'LinkCode',
						labelWidth: me.labelWidth
					}),
					me.fieldWhereArgs = Ext.create('Keysystems.form.field.Trigger.TextEditor', {
						fieldLabel: 'WhereArgs',
						labelWidth: me.labelWidth,
						height: 50
					}),
					me.fieldFilter = Ext.create('Keysystems.form.field.Trigger.TextEditor', {
						fieldLabel: 'Filter',
						labelWidth: me.labelWidth,
						height: 50
					})
				]
			})
		];
	}
});