// title: rec.get('title'),
// text: rec.get('description'),
// author: rec.get('author'),
// icon: me.GetToastIcon(rec.get('type')),
// buttonText: rec.get("buttonText")
Ext.define('Keysystems.Bubble', {
	extend: 'Ext.window.Toast',
	xtype: 'bubble',
	alias: 'widget.bubble',
	header: false,
	align: 'br',
	width: 330,
	autoCloseDelay: 5000,
	autoClose: true,
	cls: 'ks-bubble',
	bodyCls: 'ks-bubble__body',
	title: '',
	text: '',
	author: '',
	cancelFn: null,
	isProcessStart: false,
	hideNotificationManagerBtn: false,
	layout: 'ksflex',
	paddingX: 10,
	paddingY: 10,
	spacing: 10,
	limitTextMaxLength: true,
	buttons: [],
	statics: {
		/**
		 * @param {Object} p
		 * @param {String} p.title
		 * @param {String} p.text
		 * @param {String} p.author
		 * @param {Function} p.cancelFn
		 * @param {Boolean} p.isProcessStart
		 * @param {String} p.icon
		 * @param {Boolean} p.hideNotificationManagerBtn
		 */

		showWithDelay(p) {
			const bubble = new Keysystems.Bubble(p),
				  delay = 1000;

			Ext.defer(() => {
				!bubble.destroyed && bubble.show();
			}, delay);

			return bubble;
		},

		Show() {
			Keysystems.Bubble.show.apply(this, arguments);
		},

		show(p) {
			const bubble = new Keysystems.Bubble(p);
			bubble.show();
			return bubble;
		},
		
		testBubble(){
			const p = {
				title: 'title',
				text: 'description',
				author: 'author',
				icon: 'x_btn_letter52',
				buttonText: 'buttonText'
			}
			Keysystems.Bubble.showWithDelay(p);
		}
	},

	controller: {
		onOpenNotificationManagerBtnClick: function () {
			window.NotificationManager.Show();
			this.onCloseBtnClick();
		},
		onCancelBtnClick: function () {
			// var cancelFn = this.view.cancelFn;
			//
			// cancelFn && cancelFn.call && cancelFn();
		},
		onCloseBtnClick: function () {
			this.view.close();
		}
	},

	initComponent: function () {
		let me = this,
			title = me.title,
			text = me.text,
			author = me.author,
			cancelFn = me.cancelFn,
			isProcessStart = me.isProcessStart,
			hideManagerBtn,
			iconCls = me.icon || 'x_btn_notificate52',
			items = [],
			bItems = [];
		
		KS.L10n.otkrittsentropoveshchenii = 'Открыть центр оповещений';
		KS.L10n.otmenit = 'Отменить';

		if (text && text.length > 70 && me.limitTextMaxLength) {
			text = text.substring(0, 70) + '...';
		}

		if (text && title && title.length > 30) {
			title = title.substring(0, 30) + '...';
		}

		if (cancelFn && cancelFn.call) {
			isProcessStart = true;
		}

		if (isProcessStart) {
			me.autoClose = false;
		}

		hideManagerBtn = isProcessStart || me.hideNotificationManagerBtn,

			items = [{
				xtype: 'component',
				itemId: 'ksToastIcon',
				cls: 'ks-bubble__icon ' + iconCls
			}, {
				xtype: 'container',
				autoEl: 'div',
				cls: 'ks-bubble__text-block',
				defaultType: 'component',
				items: [{
					xtype: 'container',
					autoEl: 'div',
					cls: 'ks-bubble__text-block-item ks-bubble__title-block',
					items: [{
						xtype: 'component',
						autoEl: {
							tag: 'div',
							cls: 'ks-bubble__title',
							html: title
						}
					}, {
						xtype: 'tool',
						cls: 'ks-bubble__close-btn',
						iconCls: 'x-window-header x-tool-close',
						handler: 'onCloseBtnClick'
					}]
				}, {
					autoEl: {
						tag: 'div',
						cls: 'ks-bubble__text-block-item ks-bubble__note',
						html: text
					}
				}, {
					autoEl: {
						tag: 'div',
						cls: 'ks-bubble__text-block-item ks-bubble__author',
						html: author
					}
				}]
			}];

		bItems = [{
			xtype: 'button',
			text: KS.L10n.otkrittsentropoveshchenii,
			handler: 'onOpenNotificationManagerBtnClick',
			hidden: hideManagerBtn
		}, {
			xtype: 'button',
			text: KS.L10n.otmenit,
			handler: 'onCancelBtnClick',
			hidden: !cancelFn
		}];

		me.callParent(arguments);
		me.add(items);
		me.getDockedItems('toolbar')[0].add(bItems);
	}	
});