﻿//Пакетная замена
Ext.define('Revizor.BatchChange', {
	extend: 'Ext.window.Window',
	mixins: ['Keysystems.Base.Abstract', 'Revizor.FilterView'],
	title: 'Пакетная замена',
	hideFeedPanel: true,
	height: 300,
	links: [],
	labelWidth: 200,
	isFillGroup: Ext.emptyFn,
	layout: 'anchor',

	constructor: function (cfg) {
		Ext.apply(this, cfg);
		this.callParent(arguments);
	},
	initComponent: function () {
		let me = this;
		me.beforeInitComponent();
		me.buttons = me.createButtons();
		me.items = [
			me.contentPanel = Ext.create('Ext.panel.Panel', {
				padding: '10 10 0 10',
				border: 0,
				anchor: '100% 100%',
				layout: {type: 'vbox', align: 'stretch'}
			})
		];
		me.on('afterrender', me.generateElements.bind(me));
		me.callParent(arguments);
	},

	createButtons: function () {
		var me = this;
		return [
			{text: 'OK', handler: me.submit, scope: this},
			{text: 'Отмена', handler: me.close, scope: this},
		];
	},

	submit: function () {
		let me = this,
			mode = me.modeBtn.getValue().mode,
			params;

		if (mode === "replace" || mode === "add") {
			let propName = me.cmbPropReplace.getValue(),
				prop = me.batchProps.filter(p => p.Name === propName)[0];
			if (!propName || !prop) {
				info(wmc.get('EmptyBatchProp'));
				return false;
			}

			let freeValueEl = me.gksc('FREE_VALUE_' + propName),
				freeValue = freeValueEl ? freeValueEl.getValue() : false,
				fromValueEl = me.gksc('FROM_VALUE_' + propName),
				fromValue = freeValue ? null : (fromValueEl ? fromValueEl.getValue() : null),
				condEl = fromValueEl ? fromValueEl.cbCondition : null,
				condition = condEl ? condEl.getValue() : null;

			if (!freeValue && condition < 0) {
				info(wmc.get('EmptyBatchCondition'));
				return false;
			}

			if (!freeValue && fromValue > 0) {
				info(wmc.get('EmptyBatchFromValue'));
				return false;
			}

			let emptyValueEl = me.gksc('TO_EMPTY_VALUE_' + propName),
				emptyValue = emptyValueEl ? emptyValueEl.getValue() : false,
				toValueEl = me.gksc('TO_VALUE_' + propName),
				toValue = emptyValue ? null : (toValueEl ? toValueEl.getValue() : null),
				byMaskEl = me.gksc('BY_MASK_' + propName),
				byMask = byMaskEl ? byMaskEl.getValue() : false,
				maskEl = me.gksc('MASK_' + propName),
				mask = byMask ? (maskEl ? maskEl.getValue() : "") : "";
			if (byMask) {
				if (!mask) {
					info(wmc.get('EmptyBatchMask'));
					return false;
				}
			} else if (!emptyValue && !toValue) {
				info(wmc.get('EmptyBatchToValue'));
				return false;
			}

			switch (miscTypes.ControlType[prop.ControlType]) {
				case 'Dictionary':
					if (!freeValue) fromValue = ArrayLib.getLinks(fromValue, _, 1);
					if (!emptyValue) toValue = ArrayLib.getLinks(toValue, _, 1);
					break;
				case 'DatePeriod':
				case 'ComboBox':
					if (!freeValue) fromValue = JSON.stringify(fromValue);
					if (!emptyValue) toValue = JSON.stringify(toValue);
					break;
			}

			params = {
				code: me.code,
				links: me.links,
				mode: me.modeBtn.getValue().mode,
				propName: JSON.stringify([propName]),
				freeValue,
				condition,
				fromValue,
				emptyValue,
				toValue,
				byMask,
				mask

			};
		} else {
			let props = me.cmbPropUnion.getValue();
			if (!props.length) {
				info(wmc.get('EmptyBatchProp'));
				return false;
			}
			params = {
				code: me.code,
				links: me.links,
				mode: me.modeBtn.getValue().mode,
				propName: JSON.stringify(props),
				preview: me.chbPreview.getValue(),
				fuzzyCompare: me.chbFuzzyCompare.getValue()
			};
			if (params.fuzzyCompare) {
				params.fuzzyCompareProps = JSON.stringify(me.cmbFuzzyCompare.getValue());
				params.percent = me.nbPercent.getValue();
				params.cntWords = me.nbCntWords.getValue();
				params.searchDirection = me.cmbSearchDirection.getValue();
			}
		}
		if (me.ok) me.ok(params);
		me.close();
	},

	generateElements: function () {
		let me = this;

		const loadMask = new Ext.LoadMask({
			msg: KS.L10n.loading_data,
			view: me,
			autoShow: true,
			rid: ajaxRequest({
				params: {
					code: me.code,
					links: JSON.stringify(me.links)
				},
				url: 'data/GetBatchChange_A',
				success: function (res) {
					me.batchProps = res;
					me.createItems(res);
					if (res.length) me.cmbPropReplace.setValue(res[0].Name);
				},
				failure: function () {
					showError(wmc.get('ErrorGetData'));
				},
				callback: function () {
					loadMask.destroy();
				}
			}),
			cancelFn: function () {
				me.close();
			}
		});
		
	},

	controlChange: function (control) {
		if (control.isEmpty()) {
			control.cbCondition.setValue(-1);
		} else {
			var cbValue = control.cbCondition.getValue();
			if (cbValue === -1) control.cbCondition.setValue(control.cbCondition.store.getAt(1));
		}
	},

	getPropsForReplace: function () {
		//все поля, кроме тех, которые только для объединения
		return this.batchProps.filter(prop => !prop.OnlyUnion);
	},
	getPropsForAdd: function () {
		//все справочные поля неосновных таблиц
		return this.batchProps.filter(prop => prop.DictCode && prop.MultiReplace);
	},
	getPropsForUnion: function () {
		//все поля основной таблицы + поля для объединения
		return this.batchProps.filter(prop => (!prop.MultiReplace && !prop.IsRekvProp) || prop.OnlyUnion);
	},
	createItems: function () {
		let me = this;
		me.contentPanel.add(
			me.modeBtn = Ext.create('Ext.form.RadioGroup', {
				fieldLabel: 'Режим',
				labelWidth: me.labelWidth,
				layout: {type: 'hbox', align: 'stretch'},
				itemCls: 'rks-checkbox-group-item',
				hidden: !this.isAllModeVisible(),
				items: [
					me.replaceBtn = Ext.create('Ext.form.field.Radio', {
						boxLabel: 'замена',
						name: 'mode',
						checked: true,
						inputValue: 'replace',

					}),
					me.unionBtn = Ext.create('Ext.form.field.Radio', {
						boxLabel: 'объединение',
						name: 'mode',
						inputValue: 'union',
						hidden: !this.isUnionModeVisible()
					}),
					me.addBtn = Ext.create('Ext.form.field.Radio', {
						boxLabel: 'добавление',
						flex: 1,
						name: 'mode',
						inputValue: 'add',
						hidden: !this.isAddModeVisible()
					})
				],
				listeners: {
					change: function (th, newVal) {
						let values = newVal.mode === "replace" ? me.getPropsForReplace() :
							(newVal.mode === "add" ? me.getPropsForAdd() : me.getPropsForUnion());

						if (newVal.mode === "union") {
							me.cmbPropReplace.setVisible(false);
							me.cmbPropUnion.loadData(values);
							me.cmbPropUnion.setVisible(true);
							me.showUnionOptions([]);

							let curValue = me.cmbPropUnion.getValue();
							if (curValue && !values.filter(value => value.Name === curValue).length)
								me.cmbPropUnion.setValue(null);
						} else {
							me.cmbPropReplace.loadData(values);
							me.cmbPropReplace.setVisible(true);
							me.cmbPropUnion.setVisible(false);
							me.showReplaceOptions();

							let curValue = me.cmbPropReplace.getValue();
							if (curValue && !values.filter(value => value.Name === curValue).length)
								me.cmbPropReplace.setValue(null);
						}
					}
				}
			}),
			me.cmbPropReplace = Ext.create('Keysystems.Controls.ComboBoxExtra', {
				maxWidth: 600,
				fieldLabel: 'Реквизит',
				labelWidth: me.labelWidth,
				valueField: 'Name',
				displayField: 'CaptionText',
				value: null,
				editable: false,
				store: Ext.create('Ext.data.Store', {
					fields: ['CaptionText'],
					data: me.getPropsForReplace(),
					proxy: 'memory'
				}),
				listeners: {
					change: function (th, newVal) {
						let prop = newVal ? me.batchProps.filter(prop => prop.Name === newVal)[0] : null;
						me.comboProp_onChange(prop ? [prop] : []);
					}
				}
			}),
			me.cmbPropUnion = Ext.create('Ext.form.field.Tag', {
				fieldLabel: 'Реквизит',
				labelWidth: me.labelWidth,
				valueField: 'Name',
				displayField: 'CaptionText',
				queryMode: 'local',
				value: null,
				editable: false,
				selectOnFocus: false,
				store: Ext.create('Ext.data.Store', {
					fields: ['CaptionText'],
					data: me.getPropsForUnion(),
					proxy: 'memory'
				}),
				hidden: true,
				listeners: {
					change: function (th, values) {
						let selectedProps = me.batchProps.filter(prop => values.indexOf(prop.Name) >= 0),
							hasStringProps = selectedProps.filter(prop => prop.DataType === "String").length;

						me.chbFuzzyCompare.setVisible(hasStringProps);
						me.fuzzyCompareOptions.setVisible(hasStringProps);
						if (hasStringProps && me.height < 326) me.setHeight(326);

						me.cmbFuzzyCompare.loadData(selectedProps);
						if (me.chbFuzzyCompare.getValue()) me.cmbFuzzyCompare.setValue(values);
					}
				}
			}),
			me.replaceOptions = Ext.create('Ext.panel.Panel', {
				padding: 0,
				border: 0,
				flex: 1,
			}),
		);
	},

	comboProp_onChange: function (props) {
		let me = this,
			mode = me.modeBtn.getValue().mode;

		if (mode === "replace" || mode === "add") {
			let prop = {};
			Object.assign(prop, props[0]);
			if (prop) {
				let items = me.replaceOptions.items.items.filter(item => item.key === "FROM_" + prop.Name || item.key === "TO_" + prop.Name);
				if (!items.length) {
					me.createTypedControls(prop);
				}
				if (mode === "add") {
					me.gksc('FREE_VALUE_' + prop.Name).setValue(true);
				}

				me.replaceOptions.items.items.forEach(item => {
					item.setVisible && item.setVisible((item.key === 'FROM_' + prop.Name) || (item.key === 'TO_' + prop.Name));
				});
			} else {
				me.replaceOptions.items.items.forEach(item => {
					item.setVisible && item.setVisible(false);
				});
			}
		}
	},
	createTypedControls: function (prop) {
		let me = this,
			createEl = (isToControl) => {
				if (prop.ControlType === 19) {
					prop.flex = false;
					prop.comboWidth = 400;
				}
				if (isToControl) {
					prop.mode = !prop.MultiReplace ? 'SINGL' : 'MULTI';
				}
				let valueEl = me.genControlByElement(prop);
				if (!valueEl) return null;

				if (prop.ReadOnly && valueEl.setReadOnly) valueEl.setReadOnly(true);
				valueEl.flex = 1;

				return valueEl;
			}

		let fromValueEl = me.sksc('FROM_VALUE_' + prop.Name, createEl());
		if (fromValueEl == null) return;

		fromValueEl.cbCondition = me.genComboCondition(prop, prop.CaptionText, me.labelWidth);
		me.appendControlListeners(prop, fromValueEl);

		me.replaceOptions.add(Ext.create('Ext.form.FieldSet', {
			key: 'FROM_' + prop.Name,
			title: 'Найти:',
			hidden: true,
			cbList: [],
			layout: {type: 'vbox', align: 'stretch'},
			items: [
				Ext.create('Ext.form.FieldContainer', {
					layout: {type: 'hbox', align: 'stretch'},
					items: [
						me.sksc('FROM_EMPTY_VALUE_' + prop.Name, Ext.create('Ext.form.field.Checkbox', {
							propName: prop.Name,
							boxLabel: 'Пустое значение',
							padding: '0 20 0 0',
							hidden: !prop.AllowEmptyStartValue,
							handler: function (th, check) {		
								let freeValueEl = me.gksc('FREE_VALUE_' + th.propName),
									fromValueEl = me.gksc('FROM_VALUE_' + th.propName);
									
								if (freeValueEl) {
									freeValueEl.setDisabled(check);
								}

								if (fromValueEl) {
									if (check) {
										fromValueEl.setValue();
									}
									fromValueEl.setDisabled(check);
								}
							}
						})),
						me.sksc('FREE_VALUE_' + prop.Name, Ext.create('Ext.form.field.Checkbox', {
							propName: prop.Name,
							boxLabel: 'Произвольное значение',
							handler: function (th, check) {
								let fromValueEl = me.gksc('FROM_VALUE_' + th.propName),
									fromEmptyEl = me.gksc('FROM_EMPTY_VALUE_' + th.propName);
								
								if (fromValueEl) {
									fromValueEl.cbCondition && fromValueEl.cbCondition.setDisabled(check);
									
									if (me.isPlatform) {
										if (check) {
											fromValueEl.setValue();
										}
										fromValueEl.setDisabled(check);
									} else {
										fromValueEl.setVisible(!check);
									}
								}
			
								if (fromEmptyEl) {
									fromEmptyEl.setDisabled(check);
								}
							}
						}))
				]}),
				Ext.create('Ext.form.FieldContainer', {
					layout: {type: 'hbox', align: 'stretch'},
					items: [fromValueEl.cbCondition, fromValueEl]
				})
			]
		}));

		let toValueEl = me.sksc('TO_VALUE_' + prop.Name, createEl(true));
		me.replaceOptions.add(Ext.create('Ext.form.FieldSet', {
			key: 'TO_' + prop.Name,
			title: 'Заменить на:',
			hidden: true,
			cbList: [],
			layout: {type: 'vbox', align: 'stretch'},
			items: [
				me.sksc('TO_EMPTY_VALUE_' + prop.Name, Ext.create('Ext.form.field.Checkbox', {
					propName: prop.Name,
					boxLabel: 'Пустое значение',
					hidden: !prop.AllowDBNull,
					handler: function (th, check) {
						let fromValueEl = me.gksc('TO_VALUE_' + th.propName);
						if (fromValueEl) {
							fromValueEl.elCondition && fromValueEl.cbCondition.setVisible(!check);
							if (me.isPlatform) {
								if (check) {
									fromValueEl.setValue();
								}
								fromValueEl.setDisabled(check);
							} else {
								fromValueEl.setVisible(!check);
							}
						}
						let byMaskEl = me.gksc('BY_MASK_' + th.propName);
						if (prop.AllowChangeByMask && byMaskEl) {
							byMaskEl.setVisible(!check);
						}
					}
				})),
				Ext.create('Ext.form.FieldContainer', {
					layout: {type: 'hbox', align: 'stretch'},
					items: [
						toValueEl,
						me.sksc('MASK_' + prop.Name, Ext.create('Keysystems.Controls.Formula.Edit', {
							flex: 1,
							hidden: true
						})),
						me.sksc('BY_MASK_' + prop.Name, Ext.create('Ext.form.field.Checkbox', {
							propName: prop.Name,
							boxLabel: 'По маске',
							padding: '0 0 0 5',
							hidden: !prop.AllowChangeByMask,
							handler: function (th, checked) {
								me.gksc('TO_VALUE_' + th.propName).setVisible(!checked);
								me.gksc('MASK_' + th.propName).setVisible(checked);
							}
						}))
					]
				})
			]
		}));
	},

	showReplaceOptions: function () {
		let me = this;
		if (me.unionOptions) me.unionOptions.setVisible(false);
		me.replaceOptions.setVisible(true);
	},

	showUnionOptions: function (batchProps) {
		let me = this;
		me.replaceOptions.setVisible(false);

		if (me.unionOptions) {
			me.unionOptions.setVisible(true);
			return;
		}
		me.contentPanel.add(
			me.unionOptions = Ext.create('Ext.panel.Panel', {
				padding: 0,
				border: 0,
				flex: 1,
				layout: {type: 'vbox', align: 'stretch'},
				items: [
					me.chbPreview = Ext.create('Ext.form.field.Checkbox', {
						boxLabel: 'Предварительный просмотр'
					}),
					me.chbFuzzyCompare = Ext.create('Ext.form.field.Checkbox', {
						boxLabel: 'Нечеткое сравнение',
						hidden: true,
						handler: function (th, check) {
							me.fuzzyCompareOptions.setDisabled(!check);
							if (check) {
								me.cmbFuzzyCompare.setValue(me.cmbPropUnion.getValue());
							}
						}
					}),
					me.fuzzyCompareOptions = Ext.create('Ext.form.FieldSet', {
						title: 'Параметры поиска совпадений:',
						hidden: true,
						cbList: [],
						layout: {type: 'vbox', align: 'stretch'},
						disabled: true,
						items: [
							me.cmbFuzzyCompare = Ext.create('Ext.form.field.Tag', {
								fieldLabel: 'Реквизит',
								labelWidth: me.labelWidth,
								valueField: 'Name',
								displayField: 'CaptionText',
								queryMode: 'local',
								value: null,
								editable: false,
								selectOnFocus: false,
								store: Ext.create('Ext.data.Store', {
									fields: ['CaptionText'],
									data: batchProps,
									proxy: 'memory'
								}),
								listeners: {
									change: function (th, newVal) {

									}
								}
							}),
							Ext.create('Ext.form.FieldContainer', {
								layout: {type: 'hbox', align: 'stretch'},
								items: [
									me.cmbPercentType = Ext.create('Ext.form.field.ComboBox', {
										fieldLabel: 'Процент схожести',
										labelWidth: me.labelWidth,
										editable: false,
										value: 0,
										queryMode: 'local',
										displayField: CBDataLib.displayField,
										valueField: CBDataLib.valueField,
										store: Ext.create('Ext.data.Store', {
											fields: CBDataLib.getFields(),
											data: [{index: 0, value: '%'}, {index: 1, value: 'шт'}],
											proxy: 'memory'
										}),
										width: me.labelWidth + 60
									}),
									me.nbPercent = Ext.create('Keysystems.Controls.CalcField',
										{
											fieldLabel: null,
											minValue: 0,
											value: 90,
											width: 80,
											padding: '0 0 0 5'
										})
								]
							}),
							me.nbCntWords = Ext.create('Ext.form.field.Number', {
								fieldLabel: 'Количество слов',
								labelWidth: me.labelWidth,
								minValue: 0,
								maxWidth: me.labelWidth + 80
							}),
							me.cmbSearchDirection = Ext.create('Ext.form.field.ComboBox', {
								fieldLabel: 'Направление поиска',
								labelWidth: me.labelWidth,
								editable: false,
								value: 0,
								queryMode: 'local',
								displayField: CBDataLib.displayField,
								valueField: CBDataLib.valueField,
								store: Ext.create('Ext.data.Store', {
									fields: CBDataLib.getFields(),
									data: CBDataLib.get('SearchDirection'),
									proxy: 'memory'
								}),
								maxWidth: me.labelWidth + 150
							})
						]
					})
				]
			}));
	},

	//#region Видимость режимов 

	isAllModeVisible() {
		let me = this;
		return me.code.indexOf('DICTIONARY_') >= 0;
	},
	isUnionModeVisible() {
		let me = this;
		return me.code !== "DICTIONARY_IFC_ACTION";
	},
	isAddModeVisible() {
		let me = this;
		return me.code.indexOf('DICTIONARY_') >= 0
			&& me.batchProps.filter(prop => prop.DictCode && prop.MultiReplace).length;
	},

	//#endregion Видимость режимов 
})