﻿Ext.define('Keysystems.AppealsOrders.List', {
	extend: 'Keysystems.Base.List',
	startYear: (new Date()).getFullYear(),
	bodyPadding: 10,
	labelWidth: 150,
	profileListeners: [
		{ name: 'DT', method: 'KsPeriodChange' },
		{ name: 'subGrid', method: 'resizeH_expandCollapse' },
	],

	viewCfg: function() {
		var cfg = this.callParent(arguments);
		cfg.minHeight = 350;
		return cfg;
	},

	baseGetData: function (endFunc, params) {
		var me = this;
		params.code = me.code;
		me.callParent([
			function (data) {
				me.sksd('SlaveOrgs', data.SlaveOrgs);
				me.sksd('appealsAudit', data.appealsAudit);
				me.sksd('rosnovAppeals', data.rosnovAppeals);
				if (endFunc) endFunc(data);
			}, params
		]);
	},

	setWhereArgs: function() {
		let me = this,
			dt = me.gksc('DT').getValue(),
			dh1 = dt.dh1 || longPeriod.begin,
			dh2 = dt.dh2 || longPeriod.end,
			whereArgs = {
				DBegin: { value: dh1.toDateString(), type: 'Date' },
				DEnd: { value: dh2.toDateString(), type: 'Date' }
			};
		
		me.afterSetWhereArgs && me.afterSetWhereArgs(whereArgs);

		return Ext.apply(me.whereArgs, whereArgs);
	},

	createItems: function() {
		var me = this,
			objs = me.objs,
			items = me.callParent(arguments);

		me.isCreate = true;

		items.unshift(Ext.create('Ext.panel.Panel', {
			border: 0,
			bodyBorder: 0,
			layout: { type: 'hbox' },
			userCls: 'rks-filter-panel',
			header: {
				title: 'Фильтр по ' + me.title + 'м',
				hidden: me.hideBottomPanel,
			},
			animCollapse: false,
			collapsible: !me.hideBottomPanel,
			bodyPadding: !me.hideBottomPanel ? me.bodyPadding : ( me.bodyPadding + ' ' + me.bodyPadding + ' 0 ' + me.bodyPadding),
			items: [
				me.sksc('DT', objs.DT = Ext.create('Keysystems.Controls.KsPeriod', {
					startYear: me.startYear,
					fieldLabel: 'Период',
					state: 8,
					allStates: 8,
					width: 400,
					listeners: {
						ksChange: function(dh1, dh2) {
							if (me.isLoading) return;
							me.setWhereArgs();
							me.refresh();
						}
					}
				}))
			]
		}));
		items.push({ xtype: 'splitter' },
			me.sksc('subGrid', Ext.create('Ext.panel.Panel', {
				minHeight: 100,
				minWidth: 100,
				collapsed: true,
				collapsible: true,
				bodyPadding: me.bodyPadding,
				collapseDirection: 'bottom',
				userCls: 'rks-filter-panel',
				//region: 'south',
				layout: 'fit',
				title: 'Суть ' + me.title.toLowerCase(),
				items: [
					objs.NOTE = Ext.create('Ext.form.field.TextArea', {
						fieldLabel: 'Суть ' + me.title.toLowerCase(),
						//layout: { type: 'vbox', align: 'stretch' },
						labelWidth: me.labelWidth,
						flex: 1,
						readOnly: true
					})
				]
			})));

		objs.Grid.on('selectionchange', function(th, sels) {
			if (me.hideTBar) return;
			
			if (sels.length) {
				var rec = sels[0];
				objs.NOTE.setValue(rec.data.NOTE);

				if (me.code === dnl.APPEALS) {
					var planreviz = rec.data.PLANREVIZ_APPEAL,
						slaveOrgs = me.gksd('SlaveOrgs') || [],
						appealsAudit = me.gksd('appealsAudit') ? me.gksd('appealsAudit')[rec.data.LINK].filter(function (i) {
							return i === window.user.org.data.LINK;
						}):[];

					const canCreate = appealsAudit.length > 0;
					objs.tbarBtns.add_reviz_from_appeals.setDisabled(!(parseInt(rec.data.RECOMMENDATION) === 2 && canCreate));										
					objs.tbarBtns.add_plan_from_appeals.setDisabled(!(parseInt(rec.data.RECOMMENDATION) === 1 && canCreate));

					const bindEnabled = canCreate && !rec.get('REVIZ_APPEAL') && +rec.get('RECOMMENDATION') === 2;
					objs.tbarBtns.bind_reviz.setDisabled(!bindEnabled);
					
					//todo проверить на новом функционале
					if (slaveOrgs.indexOf(rec.data.S_ORGP) === -1) {
						me._arrAddTBarBtns = [];
						me._arrEditTBarBtns = ['edit'];
						me.setAccess(true);
					}
				} else {
					var order = rec.data.REVIZ_ORDER;

					objs.tbarBtns.add_reviz_from_orders.setDisabled(!(parseInt(rec.data.RECOMMENDATION)=== 2 && !order));
					order = rec.data.PLANREVIZ_ORDER;

					objs.tbarBtns.add_plan_from_orders.setDisabled(!(parseInt(rec.data.RECOMMENDATION) === 1 && !order));
				}
			}
		});
		//objs.DT.setValue(d1, d2);

		me.isCreate = false;

		return items;
	},

	getGridCfg: function(){
		let res = this.callParent(arguments);
		res.userCls = 'rks-grid-with-filter-panel';
		return res;
	},
	
	/**Tasks Revizor.Orders.AddPlanReviz	 
	 */
	ordersAddPlanReviz: function() {
		let me = this,
			rec = me.objs.Grid.getFrstSelect();
		if (!rec) return;
		me.newPlanReviz(rec);
	},

	/**Tasks Revizor.Orders.AddReviz
	 */
	ordersAddReviz: function() {
		let me = this,
			rec = me.objs.Grid.getFrstSelect();
		if (!rec) return;
		me.newReviz(rec);
	},
	newReviz: function(rec) {
		var me = this,
			cfg = {
				f: 'new',
				code: dnl.REVIZ,
				refreshFunc: function() { me.refresh(); },
				parentView: me.objs.view,
				addRecord: function(row) { return {data: row}}
			};
		cfg[me.code === dnl.ORDERS ? "OrderLink" : "AppealLink"] = rec.data.LINK;
		Ext.apply(cfg, dictListController.DOCUMENT_REVIZ);

		Ext.create(cfg.editClass, cfg);
	},

	/**Tasks Revizor.Orders.BindReviz
	 */
	ordersBindReviz: function() {
		const me = this;
		const rec = me.objs.Grid.getFrstSelect();
		if (!rec) return;

		const dt = rec.get('DT') ? new Date(rec.get('DT')) : new Date();
		const revizObject = {link: +rec.get('S_ORG'), objType: 1};
		dictFunc({
				parentView: tabView,
				mode: 'SINGL',
				code: dnl.REVIZ,
				ksReadOnly: true,
				initWhereArgs: function () {
					return {
						Rosnov: {value: JSON.stringify(me.gksd('rosnovAppeals')), type: 'List_int'},
						DBegin: {value: PeriodLib.getYearFirstDay(dt).toDateString(), type: 'Date'},
						DEnd: {value: PeriodLib.getYearLastDay(dt).toDateString(), type: 'Date'},
						DTOverriden: {value: true, type: 'boolean'},
						DBeginAfter: {value: PeriodLib.addDays(dt, 1).toDateString(), type: 'Date'},
						Objects: {value: JSON.stringify([revizObject]), type: 'Reviz_Objects'}
					};
				}
			},
			{
				ok: function (value) {
					if (!value.length) return;

					me.showLoadMask({
						msg: KS.L10n.AppealsListPresenter_BindReviz_Привязка_мероприятия,
						rid: ajaxRequest({
							url: 'SAppeals/BindReviz_A',
							params: {
								appeals: +rec.get('LINK'),
								reviz: value[0].data.LINK
							},
							success: function (response) {
								const htmlCfg = {
									text: response.htmlProtocol,
									title: "Протокол",
									hasIgnoreButton: false,
									noPreStyle: true,
									width: 800,
									height: 600
								};
								ChooseBox.ShowHTMLLog(htmlCfg);
							},
							callback: function () {
								me.hideLoadMask();
							}
						})
					});
				}
			});	
	},
	
	columnsAdapted: function() {
		var cols = this.callParent(arguments),
			pos = ArrayLib.find(cols, ['dataIndex'], 'RECOMMENDATION');

		if (pos !== -1)
			cols[pos] = {
				xtype: 'misccolumn',
				typeName: 'RecommendationTypes',
				text: cols[pos].text,
				dataIndex: cols[pos].dataIndex
			};

		return cols;
	},

	fieldsAdapted: function() {
		var fields = this.callParent(arguments),
			pos = ArrayLib.find(fields, ['name'], 'RECOMMENDATION');

		if (pos !== -1) fields[pos].type = 'string';

		return fields;
	},

	newPlanReviz: function (rec) {
		var me = this,
			dt = rec.data.CONSIDERED_AT,
			year = dt ? dt.getFullYear() : new Date().getFullYear();
		
		ajaxRequest({
			url: 'SAppeals/NewPlan_A',
			params: {
				year: year,
				isAppeals: me.code === dnl.APPEALS,
				link: rec.data.LINK
			},
			success: function (res) {
				if (res.errMsg) {
					showError(res.errMsg);
				} 
				else {
					if (res.warningMsg.length) {
						selectDialogShow(wmc.get('Attention'),
							res.warningMsg + ' Продолжить?',
							function () { me.createPlanReviz(rec, res);});
					} else {
						me.createPlanReviz(rec, res);
					}
					
				}
			}
		});

	},

	createPlanReviz: function (rec, param) {
		var me = this,
			cfg = {
				f: 'new',
				modification: param.modification,
				updRecord: function() { me.refresh(); },
				whereArgs: {
					DT1: { value: new Date(param.DT1).toDateString(), type: 'Date' },
					DT2: { value: new Date(param.DT2).toDateString(), type: 'Date' }
				}
			};
		 
		if (param.modification) cfg["modType"] = 'add';
		cfg[me.code === dnl.ORDERS ? "OrderLink" : "AppealLink"] = rec.data.LINK;
		var planEditForm = Ext.create('Keysystems.Plan.Edit', cfg);
		planEditForm.objs.view.on('close',
			function () {
				// удаляем проект без пунктов плана
				var projLink = arguments[0].items.items[0].gksc('S_PLANPROJ').getLink();
				ajaxRequest({
					url: 'SPlanMod/CheckForDel_A',
					params: {
						projLink: projLink
					}
				});
			});
	}
});