﻿Ext.define('Keysystems.Appeals.Edit', {
	extend: 'Keysystems.Base.Edit',
	title: 'Обращения',
	linkCode: 'SAppeals',
	f: 'new',
	labelWidth: 100,
	arrType: ['ФЛ', 'ЮЛ', 'ИП'],
	isFileBtn: true,
	fieldName: 'NUMBER',
	bodyPadding: 0,
	viewMinSize: [630, 400],
	createItems: function() {
		let me = this;
		return me.objs.allTab = Ext.create('Ext.tab.Panel', {
			plain: true,
			border: 0,
			flex: 1,
			userCls: me.basePanelCls,
			bodyCls: me.basePanelBodyCls,
			items: me.objs.items = [me.getTab('General')]
		});		
	},

	// Конструктор таба Общие
	createTabGeneral: function() {
			var me = this,
				objs = me.objs,
				rot = window.miscTypes.RevizObjType;

			me.dataType = {};
			for (var t in rot) {
				if (me.arrType.indexOf(rot[t]) !== -1) {
					me.dataType[t] = rot[t];
				}
			};

			return objs.tabGeneral = Ext.create('Ext.panel.Panel',
				{
					title: 'Общие',
					layout: { type: 'vbox', align: 'stretch' },
					bodyPadding: 10,
					flex: 1,
					border: 0,
					items: [
						me.createDictEdit({
							key: 'S_ORGP',
							mode: 'SINGL',
							code: dnl.S_ORG,
							fieldLabel: 'Организация',
							readOnly: true
						}),
						me.objs.S_OTDEL = Ext.create('Keysystems.Controls.Dict.Edit', {
							labelWidth: me.labelWidth,
							padding: '-2 0 7 0',
							handler: function() {
								dictFunc({
									mode: 'SINGL',
									title: me.titleSOtdel,
									readOnly: me.objs.S_OTDEL.readOnly,
									initWhereArgs: function() {
										var isOnlyParent = me.gksd('NastrOnlyParentOtdel') === '1';
										return {
											SOrgs: {
												value: JSON.stringify(objs.S_ORGP.getLinks()),
												type: 'List_int'
											},
											OnlyParent: { value: isOnlyParent ? 'True' : 'False', type: 'bool' }
										}
									},
									selectLinks: me.objs.S_OTDEL.getValue(),
									code: dnl.S_OTDEL,
									control: me.objs.S_OTDEL,
									contextSearch: me.objs.S_OTDEL.contextSearch,
									getSOrg: function() {
										return me.objs.S_ORGP.getLink();
									},
								},
								{
									ok: function(value) {
										me.objs.S_OTDEL.setValue(value);
									}
								});
							}
						}),
						{ xtype: 'menuseparator' },
						Ext.create('Ext.form.FieldContainer',
							{
								labelWidth: me.labelWidth,
								layout: { type: 'hbox', align: 'stretch' },
								items: [
									objs.NUMBER = Ext.create('Ext.form.field.Text',
										{
											labelWidth: me.labelWidth,
											ksAllowEmpty: true,
											allowBlank: false,
											maxLength: 15,
											enforceMaxLength: true,
											fieldLabel: '№'
										}),
									objs.DT = Ext.create('Ext.form.field.Date',
										{
											labelWidth: 50,
											ksAllowEmpty: true,
											allowBlank: false,
											padding: '0 0 0 20',
											emptyText: '',
											fieldLabel: 'От'
										})
								]
							}),
						Ext.create('Ext.form.FieldContainer',
							{
								labelWidth: me.labelWidth,
								fieldLabel: 'Обращение от',
								layout: { type: 'hbox', align: 'stretch' },
								items: [
									objs.TYPE_FROM = Ext.create('Keysystems.Controls.ComboBoxExtra',
										{
											editable: false,
											value: 0,
											padding: '0 5 0 0',
											store: Ext.create('Ext.data.Store',
												{
													fields: CBDataLib.getFields(),
													data: CBDataLib.get(_, _, me.dataType),
													proxy: 'memory'
												}),
											listeners: {
												change: function(th) {
													var fl = th.getRawValue() === 'ФЛ';
													objs.S_ORG_FROM.setVisible(!fl);
													objs.S_PERSON_FROM.setVisible(fl);
												}
											},
											displayField: CBDataLib.displayField,
											valueField: CBDataLib.valueField,
											width: 58
										}),
									objs.S_ORG_FROM = Ext.create('Keysystems.Controls.Dict.Edit',
										{
											flex: 1,
											handler: function() {
												dictFunc({
														mode: 'SINGL',
														parentView: objs.view,
														selectLinks: objs.S_ORG_FROM.getValue(),
														whereArgs: me.initWhereArgs(objs.TYPE_FROM.getRawValue() == 'ИП'
															? {
																SType: {
																	value: JSON.stringify(objs.ip),
																	type: 'List_int'
																}
															}
															: _),
														code: dnl.S_ORG,
														readOnly: objs.S_ORG_FROM.readOnly,
														control: me.objs.S_ORG_FROM,
														contextSearch: me.objs.S_ORG_FROM.contextSearch
													},
													{ ok: function(v) { objs.S_ORG_FROM.setValue(v); } });
											}
										}),
									me.createDictEdit({
										key: 'S_PERSON_FROM',
										mode: 'SINGL',
										code: dnl.S_PERSON,
										initWhereArgs: function() {
											return me.initWhereArgs();
										}
									})
								]
							}),
						Ext.create('Ext.form.FieldContainer',
							{
								labelWidth: me.labelWidth,
								fieldLabel: 'Объект',
								ksAllowEmpty: true,
								layout: { type: 'hbox', align: 'stretch' },
								items: [
									objs.TYPE = Ext.create('Keysystems.Controls.ComboBoxExtra',
										{
											editable: false,
											hidden: true,
											value: 0,
											padding: '0 5 0 0',
											store: Ext.create('Ext.data.Store',
												{
													fields: CBDataLib.getFields(),
													data: CBDataLib.get(_, _, me.dataType),
													proxy: 'memory'
												}),
											listeners: {
												change: function(th) {
													var fl = th.getRawValue() === 'ФЛ';
													objs.S_ORG.setVisible(!fl);
													objs.S_PERSON.setVisible(fl);
												}
											},
											displayField: CBDataLib.displayField,
											valueField: CBDataLib.valueField,
											width: 58
										}),
									objs.S_ORG = Ext.create('Keysystems.Controls.Dict.Edit',
										{
											flex: 1,
											ksAllowEmpty: true,
											handler: function() {
												dictFunc({
														mode: 'SINGL',
														parentView: objs.view,
														selectLinks: objs.S_ORG.getValue(),
														whereArgs: me.initWhereArgs(objs.TYPE.getRawValue() == 'ИП'
															? {
																SType: {
																	value: JSON.stringify(objs.ip),
																	type: 'List_int'
																}
															}
															: _),
														code: dnl.S_ORG,
														readOnly: objs.S_ORG.readOnly,
														control: objs.S_ORG,
														contextSearch: objs.S_ORG.contextSearch
													},
													{ ok: function(v) { objs.S_ORG.setValue(v); } });
											}
										}),
									me.createDictEdit({
										key: 'S_PERSON',
										mode: 'SINGL',
										code: dnl.S_PERSON,
										initWhereArgs: function() {
											return me.initWhereArgs();
										}
									})
								]
							}),
						Ext.create('Ext.form.FieldSet',
							{
								title: 'Суть обращения',
								layout: { type: 'vbox', align: 'stretch' },
								flex: 1,
								items: [objs.NOTE = Ext.create('Ext.form.field.TextArea', { flex: 1 })]
							}),
						objs.FS_COMMENT = Ext.create('Ext.form.FieldSet',
							{
								title: 'Примечание',
								layout: { type: 'vbox', align: 'stretch' },
								flex: 1,
								items: [objs.COMMENT = Ext.create('Ext.form.field.TextArea', { flex: 1 })]
							}),
						Ext.create('Ext.form.FieldContainer',
							{
								labelWidth: me.labelWidth,
								layout: { type: 'hbox', align: 'stretch' },
								items: [
									objs.CONSIDERED_AT = Ext.create('Ext.form.field.Date',
										{
											labelWidth: me.labelWidth + 50,
											padding: '0 10 0 0',
											width: me.labelWidth + 200,
											emptyText: '',
											fieldLabel: 'Срок рассмотрения'
										}),
									objs.RECOMMENDATION = Ext.create('Keysystems.Controls.ComboBoxExtra',
										{
											labelWidth: me.labelWidth + 50,
											fieldLabel: 'Рекомендовать для',
											editable: false,
											value: 0,
											store: Ext.create('Ext.data.Store',
												{
													fields: CBDataLib.getFields(),
													data: CBDataLib.get('RecommendationTypes'),
													proxy: 'memory'
												}),
											displayField: CBDataLib.displayField,
											valueField: CBDataLib.valueField,
											maxWidth: me.labelWidth + 200
										})
							]}),
						me.createDictEdit({
							key: 'ORGP',
							mode: 'MULTI',
							code: dnl.S_ORG,
							fieldLabel: 'Проверяющие организации',
							padding: '-3 0 0 0',
							initWhereArgs: function () {
								return {
									SType: {
										value: JSON.stringify([Ext.Object.getKey(miscTypes.TypeOrg, 'Проверяющая')]),
										type: 'List_int'
									}
								};
							}
						}),
						objs.RevizIKM = Ext.create('Keysystems.Controls.DictName.Edit', {
							labelWidth: me.labelWidth,
							fieldLabel: 'КМ',
							width: me.width,
							mode: 'MULTI',
							readOnly: true,
							padding: '8 0 0 0',
							code: dnl.REVIZ,
							cleaningKey: false,
							handler: function() {
								dictFunc({
									checkModel: false,
									fieldLabel: 'Мероприятия',
									accessReadOnly: true,
									parentView: objs.view,
									code: dnl.REVIZ,
									btnsHide: {
										add_reviz_from_plan: true,
										add_slave: true,
										childplan: true,
										add_obsl: true
									},
									initWhereArgs: function () {
										return {
											InLinksOnly: {value: 'True', type: 'bool'},
											InLinks: {
												value: JSON.stringify(objs.linksReviz),
												type: 'List_int'
											},
											DBegin: {
												value: longPeriod.begin,
												type: 'Date'
											},
											DEnd: {
												value: longPeriod.end,
												type: 'Date'
											}
										};
									}
								});
							}
						}),
						objs.fieldSetRedirect = Ext.create('Ext.form.FieldSet',
							{
								title: 'Перенаправлено',
								layout: { type: 'vbox', align: 'stretch' },
								items: [
									Ext.create('Ext.form.FieldContainer',
										{
											labelWidth: me.labelWidth,
											layout: { type: 'hbox', align: 'stretch' },
											items: [
												objs.NUMBER_REDIRECT = Ext.create('Ext.form.field.Text',
													{
														labelWidth: me.labelWidth + 50,
														maxLength: 20,
														enforceMaxLength: true,
														fieldLabel: '№'
													}),
												objs.DT_REDIRECT = Ext.create('Ext.form.field.Date',
													{
														labelWidth: 50,
														padding: '0 0 0 10',
														emptyText: '',
														fieldLabel: 'От'
													})
											]
										}),
									me.createDictEdit({
										key: 'S_ORG_REDIRECT',
										mode: 'SINGL',
										code: dnl.S_ORG,
										fieldLabel: 'Перенаправлено от',
										labelWidth: me.labelWidth + 50,
										initWhereArgs: function() {
											return {
												NotSTypeOrgs: { value: JSON.stringify(objs.ip), type: 'List_int' }
											};
										}
									}),
								]
							}),
					]
				});
		},

	// Загрузка данных таба Ответы на обращение
	getExtraAnswers: function(value) {
		var me = this,
			ksControls = me.ksControls,
			tabAnswers = value.tabAnswers;
		
		if (tabAnswers) {
			Ext.each(value.tabAnswers.fields, function (field) {
				if (field.name === 'FILES') {
					field.type = 'string';
					return false;
				}
				return true;
			});

			const pos = ArrayLib.find(value.tabAnswers.columns, ['dataIndex'], 'FILES');
			const fileColumn = {
				xtype: 'actioncolumn',
				dataIndex: 'FILES',
				text: 'Файл',
				width: 40,
				align: 'center',
				items: [
					{
						getClass: function (v, meta, rec) { return getExtStyle(rec.get(me.fieldExt)); },
						handler: function (grid, rowIndex) { me.fileGridEdit(grid.getStore().getAt(rowIndex)); }
					}
				]
			};

			if (pos === -1) {
				value.tabAnswers.columns.push(fileColumn);
			} else {
				value.tabAnswers.columns[pos] = fileColumn;
			}
			
			ksControls.tabAnswers.setMetaDate(value.tabAnswers, {
				profileCode: me.code,
				profileKey: 'tabAnswers',
				gateCode: me.keyEdit
			});
			
		}
	},
	
	fileGridEdit: function (rec) {
		var me = this;
		Ext.create('Keysystems.File', {
			readOnly: me.objs.tabAnswers.ksReadOnly,
			iconCls: getExtStyle(rec.get(me.fieldExt)),
			createFile: function () { me.createGridFile(rec.get(fieldLink)); },
			updRecord: function (fileObj) { me.updGridFileRecord(fileObj, rec); },
			getFileId: function () { return rec.get(me.fieldFile); },
			downloadFile: function () { me.downloadGridFile(rec); },
			clearFile: function () { me.clearGridFile(rec); }
		});
	},

	// Конструктор таба Ответы на обращение
	createTabAnswers: function() {
		var me = this,
			objs = me.objs,
			ksControls = me.ksControls;

		var tA = objs.tabAnswers = me.sksc('tabAnswers', Ext.create('Ext.grid.Panel',
			{
				title: 'Ответы на обращение',
				flex: 1,
				tbar: [
					ksControls.btnNew = Ext.create('Ext.Button',
						{
							key: 'new',
							iconCls: 'x_btn_new',
							tooltip: 'Создать',
							tooltipType: 'title',
							handler: function () { me.editAnswer(); }
						}),
					ksControls.btnEdit = Ext.create('Ext.Button',
						{
							key: 'edit',
							iconCls: 'x_btn_edit',
							tooltip: 'Редактировать',
							tooltipType: 'title',
							disabled: true,
							handler: function () {
								if (me.gksc('tabAnswers').getFrstSelect())
									me.editAnswer(me.gksc('tabAnswers').getFrstSelect());
							}
						}),
					ksControls.btnDel = Ext.create('Ext.Button',
						{
							key: 'delete',
							iconCls: 'x_btn_delete',
							tooltip: 'Удалить',
							tooltipType: 'title',
							disabled: true,							
							handler: function () { me.gksc('tabAnswers').removeSelection(); }
						})
				],
				features: [
					{
						ftype: 'summary',
						showSummaryRow: false
					}
				],
				store: ksControls.storeAnswers = Ext.create('Ext.data.Store', {
					fields: [],
					data: [],
					proxy: 'memory'
				}),
				columns: [],
				columnLines: true,
				listeners: { 
					itemdblclick: function (th, rec) { if (!th.ksReadOnly) me.editAnswer(rec); },
					selectionchange: (_, sels) => me.enableToolsGrid(objs.tabAnswers, sels)
				},
				plugins: ['gridclipboard']
			}));

		return tA;
	},

	editAnswer: function(rec) {
		var me = this;
		Ext.create('Keysystems.Appeals.Edit.Answers', {
			f: rec ? 'edit' : 'new',
			data: rec ?? me.gksc('tabAnswers').store.createModel({}),
			parentView: me,
			getExtra: function (callback) { KsLib.tryRun(callback); },
			baseSaveData: function (params, callBack) {
				this.oldData = JSON.stringify(params);

				if (rec)
					rec.set(params);
				else {
					rec = me.gksc('tabAnswers').store.add(params)[0];
				}

				this.f = 'edit';
				
				QuickMsgs.save();
				if (callBack) callBack();
			}
		});
	},

	dictData: function (data) { return { data: data, total: data.length }; },

	initWhereArgs: function(cfg) {
		var d = { value: this.objs.DT.getValue() || new Date(), type: 'Date' };
		return Ext.apply({
			DH1: d,
			DH2: d,			
			MarkBusy: { value: 'True', type: 'bool' }
		}, cfg);
	},

	//конфигурация основого окна
	viewCfg: function() {
		var result = this.callParent(arguments);
		result.resizable = true;
		result.maximizable = true;
		return result;
	},

	getExtra: function(callBack, link) {
		var me = this,
			objs = me.objs;

		me.baseGetExtra({ link: link }, function(value) {
			var row = value.row;

			me.readOnly = value.readOnly;

			if (value.isType) objs.TYPE.show();

			objs.TYPE.setValue(row.TYPE || 1);
			objs.TYPE_FROM.setValue(row.TYPE_FROM || 1);

			objs.NUMBER.setValue(row.NUMBER);
			objs.DT.setValue(me.getDateOrToday(row.DT));
			objs.S_PERSON_FROM.setValue(value.S_PERSON_FROM);
			objs.S_PERSON.setValue(value.S_PERSON);
			objs.S_ORG_FROM.setValue(value.S_ORG_FROM);			
			objs.ip = value.ip;
			objs.S_ORG.setValue(value.S_ORG);
			objs.S_ORGP.setValue(value.S_ORGP || window.user.org);
			objs.NOTE.setValue(row.NOTE);
			objs.RECOMMENDATION.setValue(row.RECOMMENDATION);
			objs.CONSIDERED_AT.setValue(row.CONSIDERED_AT);
			me.data.data.FILES = row.FILES;
			me.data.data.TEMP_EXT = value.tempExt;
			objs.btnFile.setIconCls(getExtStyle(value.tempExt));

			me.setFullObjsAccess(value.isAccess, ['S_OTDEL', 'COMMENT', 'CONSIDERED_AT']);
			if (!me.objs.S_OTDEL.isHidden()) {
				me.objs.S_OTDEL.setValue(value.S_OTDEL);
				me.objs.S_OTDEL.setFieldLabel(me.titleSOtdel = value.SOtdelLabel);
			}
			if (!objs.COMMENT.isHidden()) {
				objs.COMMENT.setValue(row.COMMENT);
			}
			else{
				objs.FS_COMMENT.setVisible(false);
			}

			me.sksd('NastrOnlyParentOtdel', value.NastrOnlyParentOtdel);
			
			if (value.TabAnswersAccess) {
				me.objs.allTab.changeTab(me.getTab('Answers'), true);
				me.getExtraAnswers(value);
				objs.tabAnswers.setKsReadOnly(value.TabAnswersAccess === ObjAccessMask.READ);
			}

			objs.ORGP.setValue(value.ORGP);
			objs.RevizIKM.setValue(value.reviz);

			objs.NUMBER_REDIRECT.setValue(row.NUMBER_REDIRECT);
			if (row.DT_REDIRECT) objs.DT_REDIRECT.setValue(new Date(row.DT_REDIRECT));
			objs.S_ORG_REDIRECT.setValue(value.S_ORG_REDIRECT);
			if (!(+value.isAccess.REDIRECT & ObjAccessMask.READ)){
				objs.fieldSetRedirect.setHidden(true);
			}
			
			objs.Unplanned = value.Unplanned;
			objs.linksReviz = objs.RevizIKM.getLinks();
			if (callBack) callBack();
		});
	},

	updRecord: function (row) {
		var me = this;

		if (me.dictList) {
			me.dictList.ksData.appealsAudit[row.LINK] = me.objs.ORGP.getLinks();
		}
		me.callParent(arguments);
	},

	dataCollector: function() {
		var me = this,
			objs = me.objs,
			data = me.callParent([false]);

		data.NUMBER = objs.NUMBER.getValue();
		data.DT = me.getDateOrToday(objs.DT.getValue())?.toDateString();
		data.S_ORG_FROM = objs.S_ORG_FROM.getLink();
		data.S_PERSON_FROM = objs.S_PERSON_FROM.getLink();
		data.TYPE_FROM = objs.TYPE_FROM.getValue();
		data.S_ORGP = objs.S_ORGP.getLink();
		data.S_ORG = objs.S_ORG.getLink();
		data.S_PERSON = objs.S_PERSON.getLink();
		data.TYPE = objs.TYPE.getValue();
		data.NOTE = objs.NOTE.getValue();
		data.RECOMMENDATION = objs.RECOMMENDATION.getValue();
		data.FILES = me.data.data.FILES;
		data.ORGP = objs.ORGP.getLinks();
		if (!objs.S_OTDEL.isHidden()) data.S_OTDEL = objs.S_OTDEL.getLink();
		if (!objs.CONSIDERED_AT.isHidden()) data.CONSIDERED_AT = objs.CONSIDERED_AT.getValue();
		if (!objs.COMMENT.isHidden()) data.COMMENT = objs.COMMENT.getValue();

		if (!objs.fieldSetRedirect.isHidden()) {
			data.NUMBER_REDIRECT = objs.NUMBER_REDIRECT.getValue();
			data.DT_REDIRECT = me.getDateOrToday(objs.DT_REDIRECT.getValue())?.toDateString() ?? '';
			data.S_ORG_REDIRECT = objs.S_ORG_REDIRECT.getLink();
		}
		
		if (me.ksControls.tabAnswers) {
			data.tabAnswers = JSON.stringify(me.ksControls.storeAnswers.getDataExt());
		}
		return data;
	},
	isFilled: function() {
		const me = this;
		const objs = me.objs;

		let res = true;
		if (!objs.NUMBER.getValue()) {
			me.addToInvalidControls(objs.NUMBER);
			res = false;
		}

		const d = objs.DT.getValue();
		if (!Ext.isDate(d)) {
			me.addToInvalidControls(objs.DT);
			res = false;
		}

		const obj = objs[objs.S_ORG.isVisible() ? 'S_ORG' : 'S_PERSON'];
		if (obj.isEmpty()) {
			me.addToInvalidControls(obj, {title: 'Объект'});
			res = false;
		}

		if (objs.RECOMMENDATION.getValue() === objs.Unplanned && !objs.ORGP.getValue().length) {
			me.addToInvalidControls(objs.ORGP);
			res = false;
		}

		return res;
	},

	loadNewData: function() { this.data = { data: { FILES: 0 }, raw: { FILES: 0 } }; }
});