﻿Ext.define('Keysystems.Appeals.Edit.Answers', {
	extend: 'Keysystems.Base.Edit',
	title: 'Обращения',
	isFileBtn: true,
	fieldFile: 'FILES',
	newLink: -1,
	createItems: function () {
		var me = this,
			objs = me.objs,
			items = [
				Ext.create('Ext.form.FieldContainer', {
					layout: 'hbox',
					items: [
						me.sksc('NUMBER', objs.NUMBER = Ext.create('Ext.form.field.Text', {
							labelWidth: me.labelWidth,
							fieldLabel: '№'
						})),
						me.sksc('DT', objs.DT = Ext.create('Ext.form.field.Date', {
							labelWidth: 20,
							padding: '0 0 0 10',
							fieldLabel: 'от',
							ksAllowEmpty: true,
							minValue: '01.01.1900',
							maxValue: '31.12.2100',
							width: 130
						}))
					]
				}),
				me.sksc('FINAL', objs.FINAL = Ext.create('Ext.form.field.Checkbox', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Итог',
					checked: false
				}))
			];
		return objs.items = items;
	},
	dataCollector: function () {
		var me = this,
			objs = me.objs,
			data = me.callParent(arguments);

		data.DT = objs.DT.getValue();
		data.NUMBER = objs.NUMBER.getValue();
		data.FINAL = objs.FINAL.getValue();
		data.FILES = objs.fileData.FILES;
		data.TEMP_EXT = objs.fileData.TEMP_EXT;
		return data;
	},

	loadNewData: function () {
		var me = this;
		me.objs.fileData = { LINK: 0, FILES: 0, TEMP_EXT: '' };
		me.objs.LINK = me.newLink--;
		me.callParent(arguments);
	},

	clearFile: function () {
		var me = this,
			d = me.objs.fileData;

		d[me.fieldFile] = 0;
		me.objs.btnFile.setIconCls(getExtStyle(d[me.fieldExt] = ''));
	},
	updFileRecord: function (fileObj) {
		var me = this,
			d = me.objs.fileData;

		d[me.fieldFile] = fileObj.id;
		me.objs.btnFile.setIconCls(getExtStyle(d[me.fieldExt] = fileObj.ext));
	},

	isFilled: function () {
		const {objs} = this;
		let res = true;
		if (!objs.DT.getValue()) {
			this.addToInvalidControls(objs.DT);
			res = false;
		}
		return res;
	},

	loadCopyEditData: function () {
		var me = this,
			objs = me.objs,
			data = me.data.data;

		objs.LINK = data.LINK;
		objs.DT.setValue(data.DT);
		objs.NUMBER.setValue(data.NUMBER);
		objs.FINAL.setValue(data.FINAL);
		objs.fileData = {
			LINK: 0,
			FILES: data.FILES,
			TEMP_EXT: data.TEMP_EXT
		};
		objs.btnFile.setIconCls(getExtStyle(data.TEMP_EXT));

		if (me.readOnly) me.setReadOnly(true);
		me.callParent(arguments);
	}
});