﻿Ext.define('Keysystems.Admprocs.List',
	{
		extend: 'Keysystems.Base.List',
		startYear: (new Date()).getFullYear(),
		bodyPadding: 10,
		labelWidth: 150,

		profileListeners: [
			{ name: 'holdingPeriod', method: 'KsPeriodChange' }
		],

		columnsAdapted: function() {
			var cols = this.callParent(arguments),
				statusImageCol = ArrayLib.filter(cols, ['dataIndex'], 'TEMP_STATUS_IMAGE');

			if (statusImageCol && statusImageCol[0]) {
				statusImageCol[0].header = '';
				statusImageCol[0].sortable = false;
				statusImageCol[0].renderer = function (val, metaData, rec, rowIndex, colIndex, store, view) {
					var icon = '';
					switch (rec.data.SD_STATUS_NAME) {
						case "Проект":
							icon = 'status_blue';
							break;
						case "На расследовании":
							icon = 'status_yellow';
							break;
						case "Прекращено":
							icon = 'status_gray';
							break;
						case "Направлен на рассмотрение":
							icon = 'status_pink';
							break;
						case "На рассмотрении в ином органе":
							icon = 'status_lilac';
							break;
						case "Исполнение АН":
							icon = 'status_light_blue';
							break;
						case "АН исполнено":
							icon = 'status_green';
							break;
						case "На доработку":
							icon = 'status_red';
							break;
						case "Возвращено без рассмотрения (иной орган)":
							icon = 'status_orange';
							break;
						case "Рассмотрение отложено":
							icon = 'status_brown';
							break;
						case "На рассмотрении":
							icon = 'status_toxic';
							break;
						case "Приостановлено АН":
							icon = 'status_dark_green';
							break;
						default:
							icon = '';
							break;
					}
					return '<img class="ks-column-header-icon x_btn_' + icon + '"/>';
				}
			}
			return cols;
		},
		createItems: function() {
			var me = this,
				objs = me.objs,
				items = me.callParent(arguments);

			me.isCreate = true;
			items.unshift(Ext.create('Ext.panel.Panel',
				{
					border: 0,
					collapsible: true,
					title: 'Фильтр по Мероприятиям',
					layout: { type: 'vbox', align: 'stretch' },
					bodyPadding: me.bodyPadding + ' ' + me.bodyPadding + ' 0 ' + me.bodyPadding,
					userCls: 'rks-filter-panel',
					animCollapse: false,
					items: [
						Ext.create('Ext.form.FieldContainer',
							{
								layout: { type: 'hbox', align: 'stretch' },
								items: [
									objs.holdingPeriod = Ext.create('Keysystems.Controls.KsPeriod',
										{
											startYear: me.startYear,
											state: 4,
											allStates: 12,
											width: 400,
											listeners: {
												ksChange: function() {
													if (me.isLoading) return;
													me.setDate();
												}
											}
										})
								]
							})
					]
				}));


			objs.Year = objs.holdingPeriod.Quarter.holdingYear;
			objs.Quarter = objs.holdingPeriod.Quarter.holdingQuarter;
			
			me.isCreate = false;

			return items;
		},
		createGridListeners: function() {
			var me = this,
				objs = me.objs;

			me.callParent(arguments);
			if (me.isItemDblClick) {
				objs.gridListeners.itemdblclick = function (th1, record) {
					me.editReviz(record);
				};
			}
		},
		createTBar: function() {
			var me = this,
				objs = me.objs;

			me.callParent(arguments);
			if (objs.tbarBtns) {
				objs.tbarBtns.change_status = me.sksc('btnStatus',
					Ext.create('Ext.Button',
						{
							iconCls: 'x_btn_bpmn_doc_route',
							tooltip: 'Изменить статус',
							tooltipType: 'title',
							menu: Ext.create('Ext.menu.Menu',
								{
									items: []
								}),
							hidden: me.btnsHide.status,
							handler: function() {}
						}));
				ArrayLib.insert(objs.tbar, 0, objs.tbarBtns.change_status);
			}
		},
		/** Task Revizor.Reviz.AlienCreate		 
		 */
		createReviz: function() {
			var me = this,
				cfg = {
					f: 'new',
					code: dnl.REVIZ,
					refreshFunc: function() { me.refresh(); },
					parentView: me.objs.view,
					addRecord: function(row) { return me.addRecord(row); }
				};
			Ext.apply(cfg, dictListController.DOCUMENT_REVIZ);
			Ext.create(cfg.editClass, cfg);
		},
		/** Task Revizor.Reviz.AlienEdit
		 */
		doEditReviz: function(){
			this.editReviz();
		},
		editReviz: function(rec) {
			let me = this;
			if (!rec) {
				rec = me.objs.Grid.getFrstSelect();
				if (!rec) return;
			}
			let cfg = {
				f: 'edit',
				data: {data: {LINK: rec.data.REVIZ}},
				code: dnl.REVIZ,
				refreshFunc: function () {
					me.refresh();
				},
				tabMode: !me.isModalEdit(),
				parentView: me.isModalEdit() ? me.objs.view : me.parentView,				
				activetab: 'tabAp'
			};
			Ext.apply(cfg, dictListController.DOCUMENT_REVIZ);
			
			ajaxRequest({
				url: dictListController.DOCUMENT_REVIZ.linkCode + '/CheckBusy_A',
				params: {link: rec.data.REVIZ},
				success: function(res) {
					if (res) {
						info(KS.L10n.rowIsBusy);
						return;
					} else {
						Ext.create(cfg.editClass, cfg);
					}
				}
			});			
		},
		setWhereArgs: function () {
			let me = this,
				objs = me.objs,
				dh = objs.holdingPeriod.getValue(),
				whereArgs = {
					DRBegin: {value: dh.dh1, type: 'Date'},
					DREnd: {value: dh.dh2, type: 'Date'}
				};

			me.afterSetWhereArgs && me.afterSetWhereArgs(whereArgs);
			
			return Ext.apply(me.whereArgs, whereArgs);
		},
		setDate: function () {
			var me = this;
			me.setWhereArgs();
			me.refresh();
		},
		baseGetData: function (endFunc, params) {
			var me = this;
			params.code = me.code;
			me.callParent(arguments);
		},
		beforeSetData: function(data, params) {
			let me = this;
			
			data.fields
				.filter(f => ['R_NUMBER', 'SD_CODE'].indexOf(f.name) >= 0)
				.forEach(f => f.sortType = 'asNatural');
			
			me.callParent(arguments);

			Ext.each(data.data.data, function (d) {
				d.R_S_PERSON_CLOSED = !!d.R_S_PERSON_CLOSED;
			});

			if (data) {
				if (data.subStatuses && Object.keys(data.subStatuses).length) {
					for (var key in data.subStatuses) {
						me.objs.tbarBtns.change_status.menu.add({
							text: key,
							statuses: data.subStatuses[key],
							handler: function () {
								me.batchChangeStatus(this.statuses);
							}
						});
					}
				} else {
					me.objs.tbarBtns.change_status.setVisible(false);
				}
			}

		},
		batchChangeStatus: function (statuses) {
			var me = this,
				sels = [];
			Ext.each(me.objs.Grid.store.data.items,
				function (i) {
					if (i.data.M) sels.push(i);
				});
			if (sels.length) {
				var links = [],
					rows = [],
					stat = statuses.split(',');
				Ext.each(sels, function(sel) {
					links.push(sel.data.SD_LINK);
					rows.push(sel.data);
				});

				me.showLoadMask({
					msg: wmc.getMask('StatusBatchChange'),
					rid: ajaxRequest({
						url: 'SAdmprocs/StatusBatchChange_A',
						params: {
							statuses: JSON.stringify(stat),
							links: JSON.stringify(links),
							rows: JSON.stringify(rows)
						},
						success: function (res) {
							me.hideLoadMask();
							if (res) {
								if (res.error) {
									showError(res.error);
								} else {
									me.refresh(true, 1);
									ChooseBox.ShowHTML({
										text: res.text,
										hasIgnoreButton: false,
										info: true
									});
								}
							}
						},
						failure: function() {
							me.hideLoadMask();
							showError("Ошибка при изменении статуса.");
						}
					})
				});
			}
			else
				warning(wmc.get('SelectDeloAP'));
		},
		getGridCfg: function(){
			let res = this.callParent(arguments);
			res.userCls = 'rks-grid-with-filter-panel';
			return res;
		},
	});