﻿Ext.define('AboutView', {
	extend: 'Ext.window.Window',
	modal: true,
	width: 415,
	height: 360,
	resizable: false,
	title: 'О программе',
	layout: 'border',
	iconCls: 'x_btn_keysystems',
	//**********************************
	//---Метод initComponent 
	//--инициализация компонентов
	//**********************************
	initComponent: function() {
		var me = this;
		//Кнопка "Закрыть"
		me.buttons = [
			Ext.create('Ext.Button', {
				text: 'Закрыть',
				handler: function() {
					me.close();
				}
			})
		];

		me.items = [
			me.panelTop = Ext.create('Ext.panel.Panel', {
				region: 'north',
				height: 65,				
				bodyCls: 'x_login_head',
				bodyStyle: {
					'background-repeat': 'no-repeat'
				}
			}),
			me.panelCenter = Ext.create('Ext.panel.Panel', {
				region: 'center'
			}),
			me.panelBottom = Ext.create('Ext.panel.Panel', {
				region: 'south',
				height: 85,
				bodyStyle: 'background:transparent'
			})
		];

		me.on('afterrender',() => {
			//Вызов Инициализация данными
			me.getData(
				//****************************************************
				//--Callback отработает по завершению всех процессов в getData()
				//****************************************************
				function (result) {
					//инициализация данных
					me.Data = result;

					//формирование текста html для панели
					var htmlText_panelTop = '<span style="font-size: 24px">' + result.programName + '</span>';

					var htmlText_panelCenter =
						'<div class = "About", style="padding:5px">' + "\n";
					htmlText_panelCenter += result.programName + '<br>' + "\n";
					htmlText_panelCenter += 'Версия ' + result.versionClient + '<br>' + "\n";
					htmlText_panelCenter += '<span style = "color: gray">' + result.copyRights + '</br></span>' + "\n";
					htmlText_panelCenter += '</br>' + "\n";
					htmlText_panelCenter += result.server + '</br>' + "\n";
					htmlText_panelCenter += result.database + '</br>' + "\n";
					htmlText_panelCenter += 'Версия <span>' + result.versionDB + '</span>' + (result.config || '') + '</br>' + "\n";
					//htmlText_panelCenter += '<span style = "color: gray">Регистрация: 900 пользователей; действует по 4 апреля 2022 г.</span></br>' + "\n";
					htmlText_panelCenter += '</div>';

					var htmlText_panelBottom = '<div class = "About", style="padding:5px">' + "\n";
					htmlText_panelBottom += '© OOO "Кейсистемс"' + '</br>' + "\n";
					htmlText_panelBottom += result.phone + '</br>' + "\n";
					htmlText_panelBottom += 'Web: <a target="_blank" href="http://' + result.web + '/">' + result.web + '</a></br>' + "\n";
					htmlText_panelBottom += "Email: <a href=\"mailto:" + result.email + '">' + result.email + '</a>' + "\n";
					htmlText_panelBottom += '</div>';

					if (me.panelCenter.body) {
						//body есть только  когда панель создана
						me.panelCenter.body.update(htmlText_panelCenter);
					} else {
						//до создания панели инициазация html
						me.panelCenter.html = htmlText_panelCenter;
					}

					if (me.panelBottom.body) {
						//body есть только  когда панель создана
						me.panelBottom.body.update(htmlText_panelBottom);
					} else {
						//до создания панели инициазация html
						me.panelBottom.html = htmlText_panelBottom;
					}
				}
			);
		});

		//Обязательно в конце вызов родительского метода для рисования (window)
		me.callParent(arguments);

	}, //end initComponent


	//********************************************************
	//--Метод getData
	//--Метод для получения данных для заполнения формы
	//********************************************************
	getData: function(callBack) {
		var me = this;

		//Если данные есть (не первое в сеансе открытие окна), данные заново не запрашиваем
		if (window.cacheEngine.has('dataAbout')) {
			//обрабатываем резульат
			callBack(window.cacheEngine.get('dataAbout'));
			return;
		}
		
		const loadMask = new Ext.LoadMask({
			msg: KS.L10n.loading_data,
			view: me,
			autoShow: true
		});
		//Если данных нет, запрос для получения данных с севрера
		ajaxRequest({
			url: 'Data/GetAbout_A',
			success: function(result) {
				loadMask.hide();
				//сохранить результат в кэш
				window.cacheEngine.set('dataAbout', result);
				//обрабатываем результат
				callBack(result);
			},
			failure: function() {
				loadMask.hide();
				showError(wmc.get('ErrorGetData'));
				callBack("");
			}
		});
	}
});