﻿//only html5
Ext.define('Keysystems.Uploader', {
	extend: 'Ext.Component',
	dataUploader: Ext.create('Keysystems.Uploader.DataUploader', { parseUrl: function(url) { return urlPrefix + parsUrl(url); } }),
	portionSize: 1048576, //1mb

	initComponent: function() {
		var me = this;
		if (!window.FileReader) {
			showError(wmc.get('NotSupporting'));
			return;
		}
		if (!me.fileReader) me.fileReader = new FileReader();
		me.callParent(arguments);
	},

	runNext: function(i, metod, callBack) {
		var me = this;
		if (me.isAbort) return;
		setTimeout(function() {
			metod.call(me, i, function(next) {
				me.onUploadProgress(i / me.portionCount);
				if (next === false) {
					callBack();
				} else {
					me.runNext(i + 1, metod, callBack);
				}
			});
		}, 20);
	},

	uploadPortion: function(i, callBack) {
		var me = this;
		if (i < me.portionCount && me.onBeforeUploadProgress(i, me.fileId) !== false) {
			var blob = me.file.slice(i * me.portionSize, (i + 1) * me.portionSize);
			me.fileReader.readAsArrayBuffer(blob);

			me.fileReader.onload = function(el) {
				if (el.target.readyState === FileReader.DONE) {
					me.dataUploader.onLoadEnd = callBack;
					me.dataUploader.uploadItem({
						id: me.fileId,
						type: me.fileType,
						portion: i,
						portionCount: me.portionCount,
						data: el.target.result,
						isMain: me.isMain
					});
				} else {
					throw ('Load error ' + el.target.readyState);
				}
			};
		} else {
			callBack(false);
		}
	},

	uploadFile: function(id, file, callBack, isMain) {
		var me = this, parts;

		delete me.isAbort;

		me.onUploadStart(file, callBack);

		me.fileId = id;
		me.file = file;
		me.fileType = (parts = file.name.split('.')).length > 1 ? parts.pop() : '';
		me.portionCount = Math.ceil(file.size / me.portionSize);
		me.isMain = isMain;

		me.runNext(0, me.uploadPortion, function() {
			var type = me.fileType;
			delete me.fileId;
			delete me.file;
			delete me.fileType;
			delete me.portionCount;

			me.onUploadEnd(file, callBack);
			callBack(id, type, file);
		});
	},

	newFile: function(code, link, propLink, id, reportDescrLink, reportLink, ownerCt, callback) { this.dataUploader.newFile(code, link, propLink, id, reportDescrLink, reportLink, ownerCt, callback); },

	getFile: function(id, name) { this.dataUploader.getFile(id, name); },

	getFileAndFree: function(id, name, reportLink, reportCode) { this.dataUploader.getFileAndFree(id, name, reportLink, reportCode); },

	getFileForEditor: function(code, link, id, name, nextID, doubleSave) { this.dataUploader.getFileForEditor(code, link, id, name, nextID, doubleSave); },

	saveFile: function(code, link, fileLink, callback) { this.dataUploader.saveFile(code, link, fileLink, callback); },

	abortUpload: function() {
		var me = this;
		me.isAbort = true;
		me.dataUploader.abortXhr();
		ajaxRequest({
			url: 'Uploader/RemoveFile_A',
			params: { id: me.fileId }
		});
	},

	onUploadStart: Ext.emptyFn,
	onUploadEnd: Ext.emptyFn,
	onBeforeUploadProgress: Ext.emptyFn,
	onUploadProgress: Ext.emptyFn
});