﻿//only html5
Ext.define('Keysystems.Uploader.View', {
	extend: 'Ext.window.Window',
	portionSize: 1048576, //1mb
	msgCls: 'x-mask-msg-text',
	closable: false,
	bodyPadding: 5,
	resizable: false,
	header: false,
	border: false,
	modal: true,
	width: 300,
	layout: { type: 'hbox', align: 'stretch' },
	initComponent: function() {
		var me = this;
		if (!window.FileReader) {
			showError(wmc.get('NotSupporting'));
			return;
		}
		me.items = [
			//Ext.create('Ext.form.Label', { text: 'Загрузка файла...' }),
			me.progressBar = Ext.create('Ext.ProgressBar', { flex: 1 }),
			Ext.create('Ext.form.FieldContainer', { width: 5 }),
			me.cancelBtn = Ext.create('Ext.Button', {
				handler: me.m_cancelFn,
				scope: me,
				text: 'Отмена'
			})
		];
		if (!me.uploader)
			me.uploader = Ext.create('Keysystems.Uploader', {
				portionSize: me.portionSize,
				onUploadProgress: function(i, id) { me.updateProgress(i, id); }
			});
		me.callParent(arguments);
	},
	uploadFile: function(id, file, callBack, isMain) {
		var me = this;
		me.show();
		me.updateProgress(0);
		delete me.uploader.onBeforeUploadProgress;
		me.uploader.uploadFile(id, file, function(i, ext) {
			me.hide();
			if (Ext.isFunction(callBack)) callBack(id, ext, file);
		}, isMain);
	},
	newFile: function(code, link, propLink, id, reportDescrLink, reportLink, ownerCt, callback) { this.uploader.newFile(code, link, propLink, id, reportDescrLink, reportLink, ownerCt, callback); },
	getFile: function(id, name) { this.uploader.getFile(id, name); },
	getFileAndFree: function(id, name, reportLink, reportCode) { this.uploader.getFileAndFree(id, name, reportLink, reportCode); },
	getFileForEditor: function(code, link, id, name, nextID, doubleSave) { this.uploader.getFileForEditor(code, link, id, name, nextID, doubleSave); },
	saveFile: function(code, link, fileLink, callback) { this.uploader.saveFile(code, link, fileLink, callback); },
	m_cancelFn: function() {
		var me = this;
		me.uploader.abortUpload();
		me.hide();
		me.onCancel();
	},
	updateProgress: function(i) { this.progressBar.updateProgress(i, 'Отправка файла: ' + (Math.round(i * 10000) / 100) + '%', true); },
	onCancel: Ext.emptyFn
});