﻿window.UploaderLib = {
	prefixKey: 'tmpFiles',
	getView: function() { return this.view || (this.view = Ext.create('Keysystems.Uploader.View')); },
	getNextId: function() { return this.prefixKey + window.link++; },
	uploadFile: function(file, callBack, onCancel, isMain) {
		var me = this,
			link = me.getNextId(),
			view = me.getView();

		view.onCancel = function() { if (Ext.isFunction(onCancel)) onCancel(); };
		view.uploadFile(link, file, function(id, ext, f) { if (Ext.isFunction(callBack)) callBack(id, ext, f); }, isMain);
	},
	uploadFiles: function(files, callBack, metod, i, isMain) {
		i = i || 0;
		isMain = isMain || 0;
		callBack = callBack || Ext.emptyFn;
		var me = this,
			file = files[i];
		if (!(file && file.size)) {
			callBack();
			return;
		}
		i++;
		me.uploadFile(file, function(link, ext, f) {
			if (Ext.isFunction(metod)) {
				metod(link, ext, function() { me.uploadFiles(files, callBack, metod, i, isMain); }, f);
			} else {
				me.uploadFiles(files, callBack, metod, i, isMain);
			}
		}, callBack, isMain);
	},
	newFile: function(code, link, propLink, reportDescrLink, reportLink, ownerCt, callback) {
		var me = this,
			id = me.getNextId();
		me.getView().newFile(code, link, propLink, id, reportDescrLink, reportLink, ownerCt, callback);
		return id;
	},
	getFile: function(id, name) { this.getView().getFile(id, name); },
	getFileAndFree: function(id, name, reportLink, reportCode) { this.getView().getFileAndFree(id, name, reportLink, reportCode); },
	getFileForEditor: function(code, link, id, name, doubleSave) {
		//проверка на префикс кей -- зачем?!
		//getFileForEditor: function (code, link, id, name, nextID, doubleSave) {
		var me = this;
		window.top.document.customButtonClick = false;
		window.top.document.documentChanged = false;
		me.FileEditorWindow = Ext.create('Keysystems.FileEditorWindow', {
			code: code,
			link: link,
			id: id,
			name: name,
			nextID: this.getNextId(), //nextID,
			doubleSave: doubleSave
		});
		//},
		//this.getView().getFileForEditor(code, link, id, name, this.getNextId(), doubleSave);

	},
	saveFile: function(code, link, fileLink, callback) { this.getView().saveFile(code, link, fileLink, callback); },
	overCls: 'ks-dragover',
	addOverCls: function(dom) {
		if (!dom.classList.contains(this.overCls)) dom.classList.add(this.overCls);
	},
	remOverCls: function(dom) {
		if (dom.classList.contains(this.overCls)) dom.classList.remove(this.overCls);
	},
	bind: function(dom, metod, multi) {
		var me = this;
		dom.ondragover = function(e) {
			me.addOverCls(dom);
			return false;
		};
		dom.ondragleave = function(e) {
			me.remOverCls(dom);
			return false;
		};
		dom.ondrop = function(e) {
			me.remOverCls(dom);
			var files = e.dataTransfer.files;
			if (files.length) me.uploadFiles(multi ? files : [files[0]], _, metod);
			e.preventDefault();
			e.stopPropagation();
			return false;
		};
	},
	getGridItem: function(e, v, columnId) {
		var getTarget = Ext.EventObjectImpl.prototype.getTarget,
			itemSelector = v.dataRowSelector || v.itemSelector,
			item = getTarget.call(e, itemSelector);
		if (item) item = item.getElementsByClassName(columnId)[0];
		return item;
	},
	bindGrid: function(dom, view, columnId, metod, multi) {
		var me = this;
		dom.ondragover = function(e) {
			var item = me.getGridItem(e, view, columnId);
			if (item) me.addOverCls(item);
			return false;
		};
		dom.ondragleave = function(e) {
			var item = me.getGridItem(e, view, columnId);
			if (item) me.remOverCls(item);
			return false;
		};
		dom.ondrop = function(e) {
			var item = me.getGridItem(e, view, columnId);
			if (item) me.remOverCls(item);
			var files = e.dataTransfer.files;
			if (files.length)
				me.uploadFiles(multi ? files : [files[0]], _, function(link, ext, callback) {
					if (Ext.isFunction(metod)) metod(link, ext, view.getRecord(item.parentNode), callback);
				});
			e.preventDefault();
			e.stopPropagation();
			return false;
		};
	},
	showFileList: function (cfg, defCfg) {
		var c = {
			readOnly: cfg.readOnly,
			baseGetExtra: function(p, callBack) { cfg.getFiles(callBack); },
			baseSaveData: function(params, callBack) {
				if (cfg.setFiles(params) === false) {
					QuickMsgs.notSave();
				} else {
					QuickMsgs.save();
					this.oldData = JSON.stringify(this.dataCollector());
				}
				LoadMask.hide();
				if (callBack) callBack();
			}
		};
		Ext.apply(c, defCfg);
		return Ext.create('Keysystems.File.List', c);
	}
};