﻿Ext.define('Keysystems.Uploader.DataUploader', {
	extend: 'Ext.Component',
	timeout: 60000,
	contentType: 'application/octet-stream',
	contentTypeHeader: 'Content-Type',
	fileidHeader: 'X-File-Id',
	sizeHeader: 'X-File-Size',
	typeHeader: 'X-File-Type',
	portionHeader: 'X-File-Portion',
	portionCountHeader: 'X-File-Portion-Count',
	isMainHeader: 'X-File-Is-Main',
	method: 'POST',
	url: 'Uploader/UploadItem',

	parseUrl: function(url) {
		return url;
	},

	initConnection: function() {
		var me = this;
		if (me.params) me.url = Ext.urlAppend(me.url, Ext.urlEncode(me.params));

		var xhr = new XMLHttpRequest(),
			method = me.method,
			url = me.url;

		xhr.open(method, me.parseUrl(url), true);

		me.abortXhr = function() {
			this.suspendEvents();
			xhr.abort();
			this.resumeEvents();
			me.onAbort.apply(me, arguments);
		};

		return xhr;
	},

	setRequestHeader: function(xhr, item) {
		var me = this;

		xhr.setRequestHeader(me.contentTypeHeader, me.contentType);
		xhr.setRequestHeader(me.fileidHeader, item.id);
		xhr.setRequestHeader(me.sizeHeader, item.data.byteLength);
		xhr.setRequestHeader(me.typeHeader, item.type);
		xhr.setRequestHeader(me.portionHeader, item.portion);
		xhr.setRequestHeader(me.portionCountHeader, item.portionCount);
		xhr.setRequestHeader(me.isMainHeader, item.isMain);
	},

	setEvents: function(xhr, item) {
		var me = this;

		xhr.addEventListener('loadend', function() {
			if (me.xhrHttpTimeout) clearTimeout(me.xhrHttpTimeout);
			if (this.status !== 200)
				me.uploadItem(item);
			else
				me.onLoadEnd.apply(me, Array.prototype.slice.call(arguments, 0).concat([item]));
		}, true);
		xhr.upload.addEventListener('progress', Ext.Function.bind(me.onUploadProgress, me, [item], true), true);

		if (me.timeout) me.xhrHttpTimeout = setTimeout(function() {
			me.abortXhr(item);
		}, me.timeout);
	},

	uploadItem: function(item) {
		var me = this,
			xhr = me.initConnection();

		me.setRequestHeader(xhr, item);
		me.setEvents(xhr, item);

		var sendFn = xhr.sendAsBinary || xhr.send;
		if (sendFn) {
			sendFn.call(xhr, item.data, item.isMain);
		} else {
			throw 'Binary send not supported!';
		}
	},

	onAbort: Ext.emptyFn,
	onLoadEnd: Ext.emptyFn,
	onLoadError: Ext.emptyFn,
	onUploadProgress: Ext.emptyFn,

	getForm: function() {
		return this.form || (this.form = Ext.create('Ext.form.Panel', { items: [Ext.create('Ext.form.field.File')] }).getForm());
	},

	getFile: function(id, name) {
		var me = this;
		me.getForm().submit({
			method: 'POST',
			url: me.parseUrl('Uploader/GetFile'),
			params: { id: id, name: name }
		});
	},

	getFileForEditor: function(code, link, id, name, nextID, doubleSave) {
		var me = this;
		window.top.document.customButtonClick = false;
		window.top.document.documentChanged = false;
		me.FileEditorWindow = Ext.create('Keysystems.FileEditorWindow', {
			code: code,
			link: link,
			id: id,
			name: name,
			nextID: nextID,
			doubleSave: doubleSave
		});
	},

	getFileAndFree: function(id, name, reportLink, reportCode) {
		var me = this;
		me.getForm().submit({
			method: 'POST',
			url: me.parseUrl('Uploader/GetFileAndFree'),
			params: { id: id, name: name, reportLink: reportLink || 0, reportCode: reportCode || '' }
		});
	},

	newFile: function(code, link, propLink, id, reportDescrLink, reportLink, ownerCt, callback) {
		const me = this;
		const params = {code: code, link: link, propLink: propLink, id: id, reportDescrLink: reportDescrLink};
		const loadMask = ownerCt != null ? new Ext.LoadMask({
			msg: `${KS.L10n.file_create}...`,
			target: ownerCt,
			autoShow: true,
			cancelFn: function () {
				if (xhr) xhr.abort();
			}
		}) : null;

		//в случае использования XMLHttpRequest есть возможность отмены загрузки файла
		let xhr = new XMLHttpRequest();
		xhr.open('POST', me.parseUrl('Uploader/CreateFile_A'));
		xhr.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
		xhr.onreadystatechange = function () {
			if (xhr.readyState !== 4) return;
			if (xhr.status === 200) {
				if (loadMask) loadMask.destroy();

				//обработка ответа с FileContentResult. имя файла, задаваемое в FileDownloadName, попадает в заголовок content-disposition.
				// const fileName = me.getFileName(xhr.getResponseHeader("content-disposition"));
				// const fileId = xhr.getResponseHeader("file-id");
				// const fileExt = xhr.getResponseHeader("file-ext");
				// callback(fileId, fileExt, me.getFileNameWithoutExtention(fileName));
				// const blob = new Blob([xhr.response], {type: 'text/plain;charset=utf-8'});
				// window.saveAs(blob, fileName);
				
				const response = Ext.JSON.decode(xhr.response, true);
				if (!response) {
					showError('Ошибка при созданиии файла, ' + xhr.response);
					return;
				}
				const fileName = me.getFileNameWithoutExtention(response.fileName);
				callback(response.fileId, response.fileExt, fileName);
				if (reportDescrLink < 0) {
					UploaderLib.getFile(response.fileId, fileName);
				} else {
					UploaderLib.getFileAndFree(response.fileId, fileName, reportLink, code);
				}
			}
			else{
				console.error(`Ошибка при созданиии файла, responseStatus = ${xhr.status}, responseText = ${xhr.response}`);
				if (loadMask) loadMask.destroy();
			}
		}
		let encodedData = [];
		for (const key in params) {
			encodedData.push(`${encodeURIComponent(key)}=${encodeURIComponent(params[key])}`);
		}
		xhr.send(encodedData.join('&'));

		// me.getForm().submit({
		// 	method: 'POST',
		// 	url: me.parseUrl('Uploader/NewFile_A'),
		// 	params: cfg.params
		// });
	},

	saveFile: function(code, link, fileLink, callback) {
		ajaxRequest({
			url: 'Uploader/SaveFile_A',
			params: { code: code, link: link, fileLink: fileLink },
			success: callback
		});
	},

	getFileFromSnapshot: function(code, link) {
		let me = this;
		me.getForm().submit({
			method: 'POST',
			url: me.parseUrl('Uploader/GetFileFromSnapshot'),
			params: { code: code, link: link }
		});
	},

	getFileFromHTML: function(html, name) {
		let me = this,
			params = {html: html, name: name},
			gzipData = SignalR.pack(params);
		me.getForm().submit({
			method: 'POST',
			url: me.parseUrl('Uploader/GetFileFromHTML'),
			params: { gzipData }
		});
	},

	/*Получить имя файла из header "content-disposition"*/
	getFileName: function(disposition) {
		const utf8FilenameRegex = /filename\*=UTF-8''([\w%\-\.]+)(?:; ?|$)/i;
		const asciiFilenameRegex = /filename=(["']?)(.*?[^\\])\1(?:; ?|$)/i;

		let fileName = '';
		if (utf8FilenameRegex.test(disposition)) {
			fileName = decodeURIComponent(utf8FilenameRegex.exec(disposition)[1]);
		} else {
			const matches = asciiFilenameRegex.exec(disposition);
			if (matches != null && matches[2]) {
				fileName = matches[2];
			}
		}
		return fileName;
	},
	getFileNameWithoutExtention: function(fileName) {
		return fileName.replace(/\.[^/.]+$/, "");
	}
});