﻿let connection = new signalR.HubConnectionBuilder()
	.withUrl("./signalr")
	.configureLogging(signalR.LogLevel.Information)
	.build();

signalR.connection = connection;

var SignalR = {
	id: 1,
	x: 125,
	d: 1,
	levelPack: 4,
	connect: false,
	connection: connection,
	callBackStorage: {},
	hub: signalR,
	getRID: function () {
		return this.id++;
    },
	decodeRID: function (rid) {
		return rid;
    },
	addCallBack: function (id, cfg) {
		var me = this;
		me.callBackStorage[id] = {
			url: cfg.url,
			success: cfg.success,
			failure: cfg.failure,
			callback: cfg.callback,
			timeout: cfg.timeout,
			progress: cfg.progress
		};

		if (cfg.timeout) {
			me.callBackStorage[id].timeoutId = setTimeout(function() {
				Log.sendLog(wmc.get('timeoutByUrl', 0, me.callBackStorage[id].url, id));
				if (cfg.failure) {
					cfg.failure();
				}
				if (cfg.callback) {
					cfg.callback();
				}
				me.delCallBack(id);
			}, cfg.timeout);
		}
	},
	delCallBack: function(id) {
		if (this.callBackStorage[id]) {
			delete this.callBackStorage[id];
		}
	},
	bind: function(sessionId) {
		if (sessionId === '') {
			QuickTip.show({
				title: wmc.get('NoSessionId'),
				width: 300,
				iconCls: 'x_btn_ok'
			});
		}
		if (!sessionId) {
			sessionId = SignalR.sessionId;
		} else {
			if (sessionId !== SignalR.sessionId) {
				SignalR.sessionId = sessionId;
			}
		}
		if (SignalR.connect) {
            SignalR.connection.invoke("bind", sessionId);
        } else {
			setTimeout(function () {
				SignalR.bind(sessionId);
			}, 250);
		}
	},
	start: function (callBack) {
        connection.start(function() {
            SignalR.connect = false;
		}).then(function() {
                Log.sendLog(wmc.get('signalRConnect'));
                SignalR.connect = true;
                channelStop = true;
                if (connection.connectionState === 'disconnected') {
                    SignalR.start(callBack);
                    return;
                }
                if (callBack) callBack();
            }
		).catch(function () {});;
    },
	reRID: function (rid) {
		SignalR.connection.invoke("reRID", JSON.stringify(rid));
	},
	m_unpack: function (gzipped) {
		if (!gzipped) return null;
		//Log.sendLog(' Base64Binary.decode');
		var aArr = Ext.isString(gzipped) ? Base64Binary.decode(gzipped) : gzipped;
		//Log.sendLog('unzip');
		var result = null;
		try {
			result = pako.ungzip(aArr, { to: 'string' });
		} catch (ex) {
			showError(ex);
		}

		/*//Log.sendLog(' UTF8BytesToString to start');
		var result = utf8.UTF8BytesToString(unpackArr);
		//Log.sendLog(' ok');*/
		return result;
	},
	m_pack: function(json) {
		if (!json) return null;
		var packArr = pako.gzip(json, { level: SignalR.levelPack }),
			result = Base64Binary.encode(packArr);
		return result;
	},
	unpack: function(zip, isJson) {
		//Log.sendLog('Получены данные, начало распаковки');
		var result = SignalR.m_unpack(zip);
		//Log.sendLog('Получены данные, распаковано уход на ->JSON PARSE');
		if (isJson || isJson === undefined) result = JSON.parse(result);
		//Log.sendLog('Получены данные, JSON PARSE complited');
		return result;
	},
	pack: function(data, isJson) {
		var result = data;
		if (isJson || isJson === undefined) result = JSON.stringify(result);
		return SignalR.m_pack(result);
	}
};

SignalR.connection.onclose(function () {
	Log.sendLog(wmc.get('signalRDisconnect'));
	if (objs.checkSignal) objs.checkSignal.setStatus('None');
	QuickTip.show({
		title: wmc.get('LostLongConnect'),
		width: 350,
		iconCls: 'x_btn_errorX'
	});
	SignalR.connect = false;
	channelStart();
	var startFn = function() {
		if (SignalR.connect) return;
		SignalR.start(function() {
			if (objs.checkSignal) objs.checkSignal.checkSignal();
			SignalR.bind();
			Log.sendLog(wmc.get('signalRConnect'));
			QuickTip.show({
				title: wmc.get('LongReconnect'),
				width: 350,
				iconCls: 'x_btn_ok'
			});
		});
		setTimeout(startFn, 5000);
	};
	setTimeout(startFn, 5000);
});

ajaxCallBack = function (id, rid, data) {
    if (id) SignalR.reRID([id]);
    var cb = SignalR.callBackStorage[rid];
    if (cb) {
        //console.log(cb.url + ", rid = " + rid);
        var result = SignalR.unpack(data);
        Log.sendLog(wmc.get('backByUrl', cb.url, rid));
        if (cb.timeoutId) clearTimeout(cb.timeoutId);

        if (cb.success) {
		        cb.success(result);
	        }
        if (cb.callback) {
            cb.callback(result);
        }
        SignalR.delCallBack(rid);
    }
};

SignalR.connection.on("AjaxCallBack", ajaxCallBack);

SignalR.connection.on("SignalRCallBacks", function(data) {
	var callBacks = SignalR.unpack(data),
		rids = [];
	for (var key in callBacks) {
		rids.push(key);
		SignalR.client && SignalR.client[callBacks[key].name].apply(SignalR.client, [0].concat(callBacks[key].arguments));
	}
	SignalR.reRID(rids);
});

SignalR.connection.on("ChooseBoxShowHTML", function(id, data) {
	if (id) SignalR.reRID([id]);
	var cfg = SignalR.unpack(data);

	ChooseBox.ShowHTML(cfg);
});

SignalR.connection.on("ReportProgress", function(id, rid, data) {
	console.log('reportProgress');
	if (id) SignalR.reRID([id]);

	var cb = SignalR.callBackStorage[rid];
	if (cb && cb.progress) {
		cb.progress(data);
	}

});

SignalR.connection.on("UserListLeave", function(srid) {
	if (UserList.show) {
		var pos = UserList.store.find('srid', srid);
		if (pos !== -1) {
			window.UserList.store.remove(UserList.store.getAt(pos));
		}
	}
});

SignalR.connection.on("UserListJoin", function(rec) {
	if (window.UserList.show) {
		var pos = window.UserList.store.find('srid', rec.srid);
		if (pos === -1) {
			window.UserList.store.loadData([rec], true);
		} else {
			var row = window.UserList.store.getAt(pos);
			row.set('login', rec.login);
			row.set('fio', rec.fio);
			row.set('srip', rec.srip);
			row.set('ping', rec.ping);
		}
	}
});

SignalR.connection.on("Say", function(text) {
	alert(text);
});

SignalR.connection.on("Reload", function() {
	$(window).on('beforeunload', null);
	window.beforeunload = null;
	window.location.reload();
});

window.SignalR = SignalR;