/**
 * Перегрузка Ext.LoadMask. Добавляется кнопка Отмена.
 */
Ext.define('Keysystems.overrides.LoadMask', {
	override: 'Ext.LoadMask',
	cancelBtnText: KS.L10n.otmena,

	style: {
		borderWidth: 0,
		borderColor: '#FFFFFF!important'
	},

	config: {
		closable: false,
		rid: null,
		cancelFn: null,
		changeIcon: false
	},
	// renderData: {
	// 	spinnerSvg: Keysystems.Svg.getSvgHtml({ icon: 'loading_spinner' })
	// },
	messageTpl: new Ext.XTemplate(`
        <div id="{id}-msgWrapEl" data-ref="msgWrapEl" class="ks-load-mask">
            <div id="{id}-msgEl" data-ref="msgEl" class="ks-load-mask__b-wrapper">
                <div id="{id}-spinnerEl" class="ks-load-mask-spinner ks-load-mask-spinner-image">
                </div>
                <div id="{id}-msgTextEl" data-ref="msgTextEl" class="ks-load-mask__msg">{msg}</div>
                <div class="ks-load-mask__b-cancel-button">
                    {%
                        var me=values.$comp, cancelBtn=me.cancelBtn;
                        cancelBtn.ownerLayout = me.componentLayout;
                        cancelBtn.ownerCt= me;
                        Ext.DomHelper.generateMarkup(cancelBtn.getRenderTree(), out);
                    %}
                </div>
            </div>
        </div>
    `),

	renderTpl: `
        {%
            values.$comp.renderMask(out, values);
        %}
    `,

	privates: {
		finishRenderChildren() {
			this.callParent(arguments);

			const { cancelBtn } = this;

			if (cancelBtn) {
				cancelBtn.finishRender();
			}
		}
	},

	constructor(cfg = {}) {
		const { autoShow, opaque, view } = cfg;

		this.initCancelBtn();
		if (view) cfg.target = view;
		if (opaque) {
			if (!cfg.style) cfg.style = {};
			cfg.style.backgroundColor = 'rgba(255, 255, 255, 1)';
		}
		this.callParent(arguments);

		if (this.iconCt) {
			this.iconCls = this.iconCt.iconCls;
			this.setChangeIcon(this.iconCls);
		}
		
		if (autoShow) {
			this.show();
		}
	},

	initCancelBtn() {
		const { cancelBtnText, onCancelBtnClick } = this;

		this.cancelBtn = new Ext.button.Button({
			hidden: true,
			cls: 'x-btn-enter ks-load-mask__cancel-button',
			scale: 'small',
			text: cancelBtnText,
			handler: onCancelBtnClick,
			scope: this
		});
	},

	onCancelBtnClick() {
		const { cancelFn, rid } = this;

		this.fireEvent('cancelbtnclick', this);

		if (this.rendered && !this.destroyed) {
			this.hide();
		}

		if (cancelFn && cancelFn.call) {
			cancelFn();
		}
		if (rid) SignalR.delCallBack(rid);
	},

	syncMaskState() {
		const { cancelBtn, closable, rid, cancelFn } = this;

		if (cancelBtn) {
			const canClose = closable || rid || cancelFn;
			cancelBtn.setHidden(!canClose);
		}

		this.callParent(arguments);
	},

	renderMask(out, values) {
		const { messageTpl } = this;
		messageTpl.applyOut(values, out);
	},

	setMsg: function(text){
		this.msg = text;
		if (!this.msgTextEl) return;
		this.msgTextEl.dom.innerHTML = text;
	},

	/**
	 * Отобразить ошибку загрузки
	 * @param msg текст ошибки
	 */
	setErrorState: function(msg){
		const me = this,
			  spinnerEl = Ext.get(this.id + '-spinnerEl');
		if (!spinnerEl) return;
		spinnerEl.el.removeCls('ks-load-mask-spinner-image');
		spinnerEl.el.addCls('x_btn_warning');
		
		let msgText = KS.L10n.error_get_data || "Во время загрузки произошла ошибка.";
		if (msg) msgText += `<div style="padding-top: 5px">${msg}</div>`;
		me.setMsg(msgText);
		if (me.changeIcon) me.iconCt.setIconCls('x_btn_warning');
	},

	show: function() {
		let me = this;
		if (me.changeIcon) this.iconCt.setIconCls('rks-tab-load-mask');
		me.callParent(arguments);
	},
	
	onDestroy: function(){
		let me = this;
		if (me.changeIcon) this.iconCt.setIconCls(me.iconCls);
		me.callParent(arguments);
	}
});