﻿// Lossless LZW compression/decompression implemented in JavaScript for strings/JSON/JS objects
// предположительно взято отсюда - https://github.com/floydpink/lzwCompress.js

var lzw = {
	xmlsafe: false,
	compress: function(str) {
		var dico = Object.create(null),
			i;
		for (i = 0; i < 256; i++) {
			dico[String.fromCharCode(i)] = i;
		}
		if (lzw.xmlsafe) {
			dico['<'] = 256;
			dico['>'] = 257;
			dico['&'] = 258;
			dico['\"'] = 259;
			dico["'"] = 260;
		}
		for (var j = 1040 /*'А'*/; j <= 1103 /*'я'*/; j++) {
			dico[String.fromCharCode(j)] = i++;
		}
		var res = '',
			splitStr = str.split(''),
			len = splitStr.length,
			nbChar = i,
			buffer = '';
		for (i = 0; i <= len; i++) {
			var current = splitStr[i];
			if (dico[buffer + current] !== undefined) {
				buffer += current;
			} else {
				res += String.fromCharCode(dico[buffer]);
				dico[buffer + current] = nbChar;
				nbChar++;
				buffer = current;
			}
		}
		return res;
	},
	decompress: function(str) {
		var dico = [],
			i;
		for (i = 0; i < 256; i++) {
			dico[i] = String.fromCharCode(i);
		}
		if (lzw.xmlsafe) {
			dico[256] = '<';
			dico[257] = '>';
			dico[258] = '&';
			dico[259] = '\"';
			dico[260] = "'";
		}
		for (var j = 1040 /*'А'*/; j <= 1103 /*'я'*/; j++) {
			dico[i++] = String.fromCharCode(j);
		}
		var splitStr = str.split(''),
			len = splitStr.length,
			nbChar = i,
			dicoLen = nbChar,
			buffer = '',
			chaine,
			result = '';
		for (i = 0; i < len; i++) {
			var code = str.charCodeAt(i),
				current = dico[code];
			if (buffer === '') {
				buffer = current;
				result += current;
			} else {
				if (code < dicoLen) {
					result += current;
					chaine = buffer + current;
					dico[nbChar] = chaine;
					nbChar++;
					buffer = current;
				} else {
					chaine = dico[code];
					if (!chaine) chaine = buffer + buffer.slice(0, 1);
					result += chaine;
					dico[nbChar] = buffer + chaine.slice(0, 1);
					nbChar++;
					buffer = chaine;
				}
			}
		}
		return result;
	}
};