Ext.define('Keysystems.ToolbarBuilder', {
	extend: 'Ext.Component',

	config: {
		toolbarModel: null,
		tbar: [],
		tbarBtns: [],
		toolbar: null,
		sender: null
	},

	/**
	 * Заполнить структуру тулбара
	 */
	buildTBar: function () {
		let me = this;

		me.createTBarBtns();

		let tbar = [];
		for (let key in me.objs.tbarBtns) {
			tbar.push(me.objs.tbarBtns[key]);
		}
		me.objs.tbar = tbar;
	},

	/**
	 * Построить тулбар
	 */
	createToolbar: function () {
		let me = this;
		me.buildTBar();
		me.toolbar = Ext.create('Ext.toolbar.Toolbar', {items: me.objs.tbar});
		me.addDocked(me.toolbar);
	},

	createTBarBtns: function () {
		let me = this,
			tbarBtns = {};
		if (me.toolbarModel) {
			//console.log(me.toolbarModel);
			
			me.toolbarModel.forEach(item => {
				let btn = me.createToolButton(item);
				if (btn) tbarBtns[btn.code] = btn;
			});
		} else {
			//формируем массив создаваемых кнопок на основе конфига btnsHide и btnsShow (при отсутствии bntsHide)
			let functions = me.functions,
				hiddenBtns = Object.keys(me.btnsHide),
				visibleBtns = hiddenBtns.length
					? this.allBtns.filter(btn => hiddenBtns.indexOf(btn) === -1)
					: Object.keys(me.btnsShow);
			visibleBtns.forEach(key => {
				let btn;
				switch (key) {
					case 'new':
						btn = Ext.create('Ext.Button',
							{
								iconCls: 'x_btn_new',
								tooltip: 'Создать',
								tooltipType: 'title',
								hidden: me.btnsHide.new || (!(functions.edit || me.editClass)),
								handler: () => me.new()
							});
						break;
					case 'same':
						btn = Ext.create('Ext.Button',
							{
								iconCls: 'x_btn_copy',
								tooltip: 'Создать подобную',
								tooltipType: 'title',
								hidden: me.btnsHide.copy || (!(functions.edit || me.editClass)),
								handler: () => me.newSame()
							});
						break;
					case 'edit':
						btn = Ext.create('Ext.Button',
							{
								iconCls: 'x_btn_edit',
								tooltip: 'Редактировать',
								tooltipType: 'title',
								hidden: me.btnsHide.edit || (!(functions.edit || me.editClass)),
								handler: () => me.doEdit()
							});
						break;
					case 'delete':
						btn = Ext.create('Ext.Button',
							{
								iconCls: 'x_btn_delete',
								tooltip: 'Удалить',
								tooltipType: 'title',
								hidden: me.btnsHide.delete || (!(functions['delete'] || me.deleteCode)),
								handler: () => me.delete()
							});
						break;
					case 'refresh':
						btn = Ext.create('Ext.Button',
							{
								iconCls: 'x_btn_refresh',
								tooltip: 'Обновить',
								tooltipType: 'title',
								hidden: me.btnsHide.refresh || (!me.refreshBtn),
								handler: function () {
									me.refresh();
								}
							})
						break;
					case 'print':
						btn = Ext.create('Ext.Button',
							{
								iconCls: 'x_btn_print',
								tooltip: 'Печать',
								tooltipType: 'title',
								hidden: me.btnsHide.print,
								scope: me,
								handler: me.Print
							});
						break;
					case 'galka':
						btn = Ext.create('Ext.button.Split',
							{
								hidden: me.btnsHide.galka || !me.checkModel || me.mode !== 'MULTI' || me.readOnly,
								iconCls: 'x_btn_galka',
								tooltip: 'Инверсия',
								tooltipType: 'title',
								menu: [
									{
										text: 'Инверсия',
										iconCls: 'x_btn_galka',
										handler: function () {
											me.checkInversion();
										}
									}, {
										text: 'Отметить все',
										handler: function () {
											me.checkAll();
										}
									}, {
										text: 'С начала до текущей',
										handler: function () {
											me.checkFstToSel();
										}
									}, {
										text: 'С текущей до конца',
										handler: function () {
											me.checkSelToLst();
										}
									}, {
										text: 'Между отмеченными',
										handler: function () {
											me.checkCheckToCheck();
										}
									}, {
										text: 'Отметить выделенные',
										handler: function () {
											me.checkSelection();
										}
									}
								],
								handler: function () {
									me.checkInversion();
								}
							});
						break;
					case 'unmark':
						btn = Ext.create('Ext.Button',
							{
								hidden: me.btnsHide.unmark || !me.checkModel || me.mode !== 'MULTI' || me.readOnly,
								iconCls: 'x_btn_unmark',
								tooltip: 'Разметить',
								tooltipType: 'title',
								handler: function () {
									me.uncheckAll();
								},
								//если разметить страницу где-то понадобиться локально, раскоментить и переделать 
								// menu: [
								// 	{
								// 		text: 'Разметить страницу',
								// 		iconCls: 'x_btn_mark_on_delete',
								// 		handler: function () {
								// 			me.uncheckAllFromPage();
								// 		}
								// 	},
								// 	{
								// 		text: 'Разметить все',
								// 		handler: function () {
								// 			me.uncheckAll();
								// 		}
								// 	}
								// ]
							});
						break;
					case 'search':
						btn = Ext.create('Ext.Button',
							{
								hidden: me.btnsHide.search,
								iconCls: 'x_btn_search',
								tooltip: 'Поиск',
								tooltipType: 'title',
								handler: function () {
									me.search();
								}
							});
						break;
					case 'reset':
						btn = Ext.create('Ext.Button',
							{
								hidden: me.btnsHide.search || me.btnsHide.undo,
								iconCls: 'x_btn_undo',
								tooltip: 'Сброс',
								tooltipType: 'title',
								handler: function () {
									me.undo();
								}
							});
						break;
					case 'settings':
						btn = Ext.create('Ext.Button',
							{
								iconCls: 'x_btn_settings',
								tooltip: 'Настроить список',
								tooltipType: 'title',
								hidden: me.btnsHide.settings,
								handler: () => me.showColumnManager()
							});
						break;
					case 'exit':
						btn = Ext.create('Ext.Button',
							{
								iconCls: 'x_btn_exit',
								tooltip: 'Выход',
								tooltipType: 'title',
								hidden: me.btnsHide.exit || !me.closable,
								handler: () => me.doClose()
							});
						break;
					case 'show_actual':
						btn = Ext.create('Ext.Button',
							{
								iconCls: 'x_btn_empty_calendar',
								tooltip: 'Показать актуальные',
								tooltipType: 'title',
								hidden: me.btnsHide.show_actual,
								enableToggle: true,
								handler: function () {
									me.doShowActual(this);
								}
							});
						break;
					case 'autofilter':
						btn = Ext.create('Ext.Button',
							{
								iconCls: 'x_btn_filter',
								tooltip: 'Автофильтр',
								tooltipType: 'title',
								hidden: me.btnsHide.setAutoFilter,
								handler: () => me.doAutoFilter()
							});
						break;
					case 'relations':
						btn = Ext.create('Ext.Button',
							{
								iconCls: 'x_btn_methods',
								tooltip: 'Связи документа',
								tooltipType: 'title',
								hidden: me.btnsHide.relations,
								handler: () => me.showRelations()
							});
						break;
					case 'wrap':
						btn = Ext.create('Ext.Button',
							{
								iconCls: 'x_btn_wrap',
								tooltip: wmc.get('Wrap'),
								tooltipType: 'title',
								enableToggle: true,
								hidden: me.btnsHide.warp,
								handler: function () {
									me.enableWrap(this);
								}
							});
						break;
					case 'showBatchChange':
						btn = Ext.create('Ext.Button',
							{
								iconCls: 'x_btn_form_doc',
								tooltip: 'Пакетная замена',
								tooltipType: 'title',
								hidden: true, //me.btnsHide.showBatchChange,
								handler: function () {
									me.doBatchChange();
								}
							});
						break;
					case 'journal':
						btn = Ext.create('Ext.button.Split',
							{
								iconCls: 'x_btn_journal',
								tooltip: 'Журнал событий',
								tooltipType: 'title',
								hidden: me.btnsHide.journal,
								menu: [
									{
										text: 'По записи',
										handler: function () {
											me.showEventLogByLink();
										}
									},
									{
										text: 'Все',
										handler: function () {
											me.showEventLogList();
										}
									}
								],
								handler: function () {
									me.showEventLogList();
								}
							});
						break;
				}
				if (btn) tbarBtns[key] = btn;
			});
		}

		me.objs.tbarBtns = tbarBtns;
	},

	createToolButton: function (item, typeName) {
		let me = this,
			functions = me.functions,
			funcName = item.pluginNameWeb.funcName
				? window.tasks[item.pluginNameWeb.funcName]
				: window.tasks[item.pluginNameWeb],
			value = null,
			btn;
		
		//если в плагине объявлены параметры, они будут переданы в функцию последним параметром value - массив ключ-значение
		if (item.pluginNameWeb.params) {
			value = item.pluginNameWeb.params;
		}
		let code = item.code.toLowerCase();
		if (item.code.indexOf('/') < 0) {
			code = code.replace('button_', '');
		} else {
			let subCode = item.code.toLowerCase().split('/')[1];
			code = subCode.replace('subbutton_', '');
		}
		
		let hidden = !funcName || !me[funcName] || me.btnsHide[code] || item.mask === 1;
		if (!hidden) {
			switch (code) {
				case "delete":
					hidden = (!(functions['delete'] || me.deleteCode));
					break;
				case 'refresh':
					hidden = (!me.refreshBtn);
					break;
				case 'galka':
				case 'galka~~2':
				case 'mrk_all':
				case 'mrk_top':
				case 'mrk_rest':
				case 'mrk_between':
				case 'mrk_selected':
					hidden = !me.checkModel || me.mode !== 'MULTI' || me.btnsHide.galka || me.readOnly;
					break;
				case 'unmark':
				case 'unmark~~2':
					hidden = !me.checkModel || me.mode !== 'MULTI' || me.readOnly;
					break;
				case "unmark_page":
					hidden = !me.checkModel || me.mode !== 'MULTI' || me.readOnly || !me.pageSize || me.pageSize >= me.maxPageSize;
					break;
				case "journal_one":
				case "journal_all":
					hidden = me.btnsHide.journal;
					break;
				case 'reset':
					hidden = me.btnsHide.search;
					break;
				case 'exit':
					hidden = !me.closable;
					break;
			}
		}

		//сепаратор видим всегда, если пришел с сервера
		if (item.nodeStyle === 3) hidden = false;
		
		//console.log('code = ' + code + ', hidden = ' + hidden);

		let createSimpleBtn = function () {
			return typeName === 'Ext.menu.Item'
				?
				item.nodeStyle === 3
					? { xtype: 'menuseparator', hidden: hidden ? true : false }
					: {
						text: item.name,
						hidden: hidden ? true : false,
						code: code,
						disabled: item.disabled,
						iconCls: item.image ? 'x_btn_' + item.image.toLowerCase() : '',
						handler: () => KsLib.tryRun(me[funcName], me, value)
					}
				:
				item.nodeStyle === 3
					? { xtype: 'tbseparator', hidden: hidden ? true : false }
					: Ext.create('Ext.Button', {
						iconCls: item.image ? 'x_btn_' + item.image.toLowerCase() : '',
						tooltip: item.name,
						tooltipType: 'title',
						hidden: hidden ? true : false,
						code: code,
						disabled: item.disabled,
						handler: () => KsLib.tryRun(me[funcName], me, value)
					});
		}
		//UINodeStyle
		switch (item.nodeStyle) {
			case 0:  //BUTTONTOOL
			case 3:  //SEPARATOR
			case 10: //BUTTONTOOL_WITH_TEXT
				btn = createSimpleBtn();
				break;
			case 1:	  //CHECK
			case 12:  //CHECK_WITH_TEXT
			case 101: //CHECK2
				btn = Ext.create('Ext.Button',
					{
						iconCls: item.image ? 'x_btn_' + item.image.toLowerCase() : '',
						tooltip: item.name,
						tooltipType: 'title',
						hidden: hidden,
						code: code,
						enableToggle: true,
						handler: (button) => {
							KsLib.tryRun(me[funcName], me, button, value)
						}
					});
				break;			
				
			case 5:   //POPUP
			case 11:  //POPUP_WITH_TEXT
			case 13:  //POPUP2
			case 15:  //POPUP_FORCE
			case 102: //POPUP_WITHOUT_ICON
				let subBtns = [];
				item.children.forEach(itemChild => {
					let subButton = me.createToolButton(itemChild, 'Ext.menu.Item')
					if (subButton) subBtns.push(subButton);
				});
				if (hidden && subBtns.filter(itemChild => !itemChild.hidden).length) hidden = false;
				if (subBtns.filter(subBtn => !subBtn.hidden).length) {
					btn = Ext.create('Ext.button.Split',
						{
							iconCls: item.image ? 'x_btn_' + item.image.toLowerCase() : '',
							tooltip: item.name,
							tooltipType: 'title',
							code: code,
							hidden: hidden,
							menu: subBtns,
							handler: function (e) {
								if (funcName && item.nodeStyle !== 15)
									KsLib.tryRun(me[funcName], me, value);
								else
									this.maybeShowMenu(e);
							}
						});
				} else {
					btn = createSimpleBtn();
				}
				break;
		}
		return btn;
	},

	getButtons: function (btns) {
		let me = this;
		return me.toolbar.items.items.filter(item => btns.indexOf(item.code) >= 0);
	},
	disableButtons: function (btns, disable) {
		let me = this;
		if (!me.toolbar) return;
		let childs = this.getButtons(btns);
		childs.forEach(function (button) {
			disable ? button.disable() : button.enable();
		});
	},

	/**
	 * Получить структуру контекстного меню по тулбару me.objs.tbar
	 * @returns [{Ext.menu.Menu}]
	 */	
	buildTContextMenu: function (){
		const me = this;
		return me.objs.tbar ? me.buildContextMenuByToolbar(me.objs.tbar) : [];
	},

	/**
	 * Получить структуру контекстного меню по тулбару
	 * Для отображения кнопки тулбара в меню обязательно должно быть заполнено одно из св-в кнопки тулбара tooltip | text | title
	 * Желательно также заполнить code|key (сейчас пока также построит и по iconCls, если св-ва code|key не заполнены)
	 * @returns [{Ext.menu.Menu}]
	 */
	buildContextMenuByToolbar: function (toolbarItems) {
		if (!toolbarItems || !Ext.isArray(toolbarItems)) return [];

		const me = this;
		const cmItems = [];

		toolbarItems.forEach(item => {
			if (!item.tooltip && !item.text && !item.title) return;
			
			let code = item.code ?? item.key;
			if (!code && item.xtype !== 'tbseparator') code = item.iconCls;
			if (!code) return;
			
			cmItems.push(me.createContextMenuItem(item));
		});

		return cmItems;
	},

	createContextMenuItem: function(toolbarItem){
		const me = this;
		const btnCfg = {
			text: toolbarItem.tooltip || toolbarItem.text || toolbarItem.title,
			iconCls: toolbarItem.iconCls,
			hidden: toolbarItem.hidden,
			handler: toolbarItem.handler,
			code: toolbarItem.code || toolbarItem.key || toolbarItem.iconCls,
			disabled: toolbarItem.disabled
		};

		if (toolbarItem instanceof Ext.button.Split){
			btnCfg.menu = [];
			toolbarItem.menu.items.items.forEach(subToolbarItem => {
				btnCfg.menu.push(me.createContextMenuItem(subToolbarItem));
			})
			return Ext.create('Ext.Action',btnCfg);
		}
		else if (toolbarItem.xtype === "tbseparator") {
			return '-';
		}
		else{
			return btnCfg;
		}
	},
})