﻿const dnl = {
	S_PODRAZDEL: 'DICTIONARY_SPODRAZDEL',
	S_MINVO: 'DICTIONARY_SMINVO',
	S_CST: 'DICTIONARY_SCST',
	S_ST: 'DICTIONARY_SST',
	S_RASH: 'DICTIONARY_SRASH',
	S_VBUDJ: 'DICTIONARY_SVBUDJ',
	S_ADDBK: 'DICTIONARY_SADDBK',
	S_NACPROJ: 'DICTIONARY_SNACPROJ',
	S_DOCVID: 'DICTIONARY_SDOCVID',
	S_PROP: 'DICTIONARY_SPROP',
	S_PERSON: 'DICTIONARY_SPERSON',
	S_OTDEL: 'DICTIONARY_SOTDEL',
	S_DOLG: 'DICTIONARY_SDOLG',
	S_RANG: 'DICTIONARY_SRANG',
	S_REASON: 'DICTIONARY_SREASON',
	S_ORG: 'DICTIONARY_SORG',
	S_TYPEORG: 'DICTIONARY_STYPEORG',
	S_ADR: 'DICTIONARY_SADR',
	S_BUDGET: 'DICTIONARY_SBUDGET',
	S_RESPONS: 'DICTIONARY_SRESPONS',
	S_RDOC: 'DICTIONARY_SRDOC',
	S_WORK: 'DICTIONARY_SWORK',
	S_WORK_ESGFK: 'DICTIONARY_SWORK_ESGFK',
	S_ROSNOV_ESGFK: 'DICTIONARY_SROSNOV_ESGFK',
	S_RESPONS_ESGFK: 'DICTIONARY_SRESPONS_ESGFK',
	S_TAKENMEASURE_ESGFK: 'DICTIONARY_STAKENMEASURE_ESGFK',
	S_BUDGMEASURE_ESGFK: 'DICTIONARY_SBUDGMEASURE_ESGFK',
	S_BUDGNARKIND_ESGFK: 'DICTIONARY_SBUDGNARKIND_ESGFK',
	S_CASECONRES_ESGFK: 'DICTIONARY_SCASECONRES_ESGFK',
	S_NPA_ESGFK: 'DICTIONARY_SNPA_ESGFK',
	S_ARTICLE_ESGFK: 'DICTIONARY_SARTICLE_ESGFK',
	S_NAR_ESGFK: 'DICTIONARY_SNAR_ESGFK',
	S_RPROG: 'DICTIONARY_SRPROG',
	S_NAR: 'DICTIONARY_SNAR',
	S_NPA: 'DICTIONARY_SNPA',
	S_RNORM: 'DICTIONARY_SRNORM',
	S_ROSNOV: 'DICTIONARY_SROSNOV',
	S_PLAN: 'DICTIONARY_SPLAN',
	S_RTEMA: 'DICTIONARY_SRTEMA',
	S_RTEMA_VFA: 'DICTIONARY_SRTEMA_VFA',
	S_CALC: 'DICTIONARY_SCALC',
	S_CHECK: 'DICTIONARY_SCHECK',
	S_KLADR_REGION: 'DICTIONARY_SKLADR_REGION',
	S_KLADR_RAYON: 'DICTIONARY_SKLADR_RAYON',
	S_KLADR_CITY: 'DICTIONARY_SKLADR_CITY',
	S_KLADR_NPUNKT: 'DICTIONARY_SKLADR_NPUNKT',
	S_KLADR_STREET: 'DICTIONARY_SKLADR_STREET',
	S_KLADR_INDEX: 'DICTIONARY_SKLADR_INDEX',
	S_OKVED: 'DICTIONARY_SOKVED',
	S_OKOPF: 'DICTIONARY_SOKOPF',
	S_OKFS: 'DICTIONARY_SOKFS',
	S_OKSM: 'DICTIONARY_SOKSM',
	S_VAL: 'DICTIONARY_SVAL',
	EDS_LEVEL: 'DICTIONARY_SEDS_LEVEL',
	S_RACCOUNT: 'DICTIONARY_SRACCOUNT',
	S_TASK: 'DICTIONARY_STASK',
	S_REGION: 'DICTIONARY_SREGION',
	S_INFO: 'DICTIONARY_SINFO',
	S_ACCOUNTTYPE: 'DICTIONARY_SACCOUNTTYPE',
	S_LOGIN: 'DICTIONARY_USER_GROUP',
	S_TABLELIST: 'DICTIONARY_STABLELIST',
	S_ARTICLE: 'DICTIONARY_SARTICLE',
	S_STATUS_OBJECT: 'DICTIONARY_SSTATUS_OBJECT',
	S_STATUS: 'DICTIONARY_SSTATUS',
	S_DELO: 'DICTIONARY_SDELO',
	S_TASKDOC: 'DICTIONARY_TASKDOC',
	S_TN_VED: 'DICTIONARY_STN_VED',
	S_GROUP_EI: 'DICTIONARY_SGROUP_EI',
	S_OKEI: 'DICTIONARY_SOKEI',
	S_TRANSPORT: 'DICTIONARY_STRANSPORT',
	S_TYPECARGO: 'DICTIONARY_STYPECARGO',
	REPORT_LIST: 'DICTIONARY_REPORT_LIST',
	S_PLANPROJ: 'DICTIONARY_SPLANPROJ',
	S_VARPARAM: 'DICTIONARY_SVARPARAM',
	S_RTYPE: 'DICTIONARY_SRTYPE',
	S_LUTIL: 'DICTIONARY_SLUTIL',
	S_LKATEG: 'DICTIONARY_SLKATEG',
	S_KVARTAL: 'DICTIONARY_SKVARTAL',
	S_LAND: 'DICTIONARY_SLAND',
	PLANREVIZORG: 'DICTIONARY_PLANREVIZORG',
	OUTERREVIZ: 'DOCUMENT_OUTER_REVIZ',
	DOCREQUEST: 'DOCUMENT_DOCREQUEST',
	DOCREQUEST_VFA: 'DOCUMENT_DOCREQUEST_VFA',
	ORDERS: 'DOCUMENT_ORDERS',
	APPEALS: 'DOCUMENT_APPEALS',
	REVIZ: 'DOCUMENT_REVIZ',
	DOCREVIZ: 'DOCUMENT_DOCREVIZ',
	DOCREVIZ_REPORT: 'DOCUMENT_DOCREVIZ_REPORT',
	DOCREVIZ_VFA: 'DOCUMENT_DOCREVIZ_VFA',
	DOCREVIZ_REPORT_VFA: 'DOCUMENT_DOCREVIZ_REPORT_VFA',
	FACTNAR: 'DOCUMENT_FACTNAR',
	FACTNAR_DIS: 'DOCUMENT_FACTNAR_DIS',
	DOCUMENTS: 'DOCUMENTS',
	FINANC: 'DOCUMENT_FINANC',
	KURS: 'DOCUMENT_KURS',
	IFC_RECORD: 'DOCUMENT_IFC_RECORD',
	IFC_RECORD_MOD: 'DOCUMENT_IFC_RECORD_MOD',
	IFC_REGISTER: 'DOCUMENT_IFC_REGISTER',
	IFC_ACTION: 'DICTIONARY_IFC_ACTION',
	IFC_S_ACTION: 'DICTIONARY_IFC_S_ACTION',
	IFC_R_A_INSP: 'DICTIONARY_IFC_R_A_INSP',
	IFC_R_A_RESP_PERS: 'DICTIONARY_IFC_R_A_RESP_PERS',
	IFC_S_PROB_RISK: 'DICTIONARY_IFC_S_PROB_RISK',
	IFC_S_IMPL_RISK: 'DICTIONARY_IFC_S_IMPL_RISK',
	IFC_S_PROB_RISK_L: 'DICTIONARY_IFC_S_PROB_RISK_L',
	IFC_S_IMPL_RISK_L: 'DICTIONARY_IFC_S_IMPL_RISK_L',
	IFC_S_RISK_L: 'DICTIONARY_IFC_S_RISK_L',
	IFC_S_PROCEDURE: 'DICTIONARY_IFC_S_PROCEDURE',
	IFC_RISK_L_VALUE: 'DICTIONARY_IFC_RISK_L_VALUE',
	IFC_S_PROCESS: 'DICTIONARY_IFC_S_PROCESS',
	OBJECTIONACT: 'DOCUMENT_OBJECTIONACT',
	OBJECTIONACT_VFA: 'DOCUMENT_OBJECTIONACT_VFA',
	IFC_S_CMETHOD: 'DICTIONARY_IFC_S_CMETHOD',
	IFC_S_CTYPE: 'DICTIONARY_IFC_S_CTYPE',
	IFC_S_CMODE: 'DICTIONARY_IFC_S_CMODE',
	IFC_S_CACTION: 'DICTIONARY_IFC_S_CACTION',
	S_MOSNOV: 'DICTIONARY_SMOSNOV',
	S_FIASREGION: 'DICTIONARY_SFIASREGION',
	S_FIASAREA: 'DICTIONARY_SFIASAREA',
	S_FIASCITY: 'DICTIONARY_SFIASCITY',
	S_FIASPLACE: 'DICTIONARY_SFIASPLACE',
	S_FIASSTREET: 'DICTIONARY_SFIASSTREET',
	S_FIASHOUSE: 'DICTIONARY_SFIASHOUSE',
	S_FIASROOM: 'DICTIONARY_SFIASROOM',
	S_AUTHORITY: 'DICTIONARY_SAUTHORITY',
	S_MEASURE: 'DICTIONARY_SMEASURE',
	S_ACTIVITY_INDEX: 'DICTIONARY_SACTIVITY_INDEX',
	OBJECTACTIVITY: 'DOCUMENT_OBJECTACTIVITY',
	PLANREVIZ: 'DOCUMENT_PLANREVIZ',
	PLANREVIZ_VFA: 'DOCUMENT_PLANREVIZ_VFA',
	PLANREVIZ_MOD: 'DOCUMENT_PLANREVIZ_MOD',
	DF_S_TASK: 'DICTIONARY_DF_S_TASK',
	DF_DOCUMENTS: 'DOCUMENT_DF_DOCUMENTS',
	DF_TASK: 'DOCUMENT_DF_TASK',
	DF_DOCCORR: 'DOCUMENT_DF_DOCCORR',
	ORG_ACTIVITY: 'DOCUMENT_ORG_ACTIVITY',
	USERS_ADM: 'DICTIONARY_USERS_ADM',
	GROUPS_ADM: 'DICTIONARY_GROUPS_ADM',
	BPMS_DIVISION: 'DICTIONARY_BPMS_DIVISION',
	EDS_LVL: 'DICTIONARY_EDS_LEVEL',
	ARM: 'DICTIONARY_ARM',
	USERS_TEMPLATE_ADM: 'DICTIONARY_USERS_TEMPLATE_ADM',
	CONTRACT: 'DOCUMENT_CONTRACT',
	REPORT_EDS_LIST: 'REPORT_EDS_LIST',
	DOCUMENTS_EDS_LIST: 'DOCUMENTS_EDS_LIST',
	DF_DOCUMENTS_EDS_LIST: 'DF_DOCUMENTS_EDS_LIST',
	FILES_EDS_LIST: 'FILES_EDS_LIST',
	DOC_REPORT_EDS: 'DOC_REPORT_EDS',
};

const dictListController = {
	DICTIONARY_SPODRAZDEL: {
		title: 'Подразделы',
		editClass: 'Keysystems.Bk.Edit',
		linkCode: 'SPodrazdel',
		deleteCode: 'S_PODRAZDEL',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_SMINVO: {
		title: 'Главы',
		editClass: 'Keysystems.Bk.Edit',
		linkCode: 'SMinvo',
		deleteCode: 'S_MINVO',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_SCST: {
		title: 'Целевые статьи',
		editClass: 'Keysystems.Bk.Edit',
		linkCode: 'SCst',
		deleteCode: 'S_CST',
		handler: 'Keysystems.Base.List.Tree'
	},
	DICTIONARY_SST: {
		title: 'Экономические статьи',
		editClass: 'Keysystems.Bk.Edit',
		linkCode: 'SSt',
		deleteCode: 'S_ST',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_SRASH: {
		title: 'Виды расходов',
		editClass: 'Keysystems.Bk.Edit',
		linkCode: 'SRash',
		deleteCode: 'S_RASH',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_SVBUDJ: {
		title: 'Виды средств',
		editClass: 'Keysystems.Bk.Edit',
		linkCode: 'SVbudj',
		deleteCode: 'S_VBUDJ',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_SADDBK: {
		title: 'Дополнительная классификация',
		editClass: 'Keysystems.Bk.Edit',
		linkCode: 'SAddbk',
		deleteCode: 'S_ADDBK',
		handler: 'Keysystems.Base.List.Tree'
	},
	DICTIONARY_SNACPROJ: {
		title: 'Национальные проекты',
		editClass: 'Keysystems.Bk.Edit',
		linkCode: 'SNacproj',
		deleteCode: 'S_NACPROJ',
		handler: 'Keysystems.Base.List.Tree'
	},
	DICTIONARY_SDOCVID: {
		title: 'Виды документов',
		editClass: 'Keysystems.Edits.DocVid',
		linkCode: 'SDocVid',
		deleteCode: 'S_DOCVID',
		fileColumn: true,
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_SPROP: {
		title: 'Реквизиты',
		editClass: 'Keysystems.SProp.Edit',
		linkCode: 'SProp',
		deleteCode: 'S_PROP',
		handler: 'Keysystems.Base.List.Tree'
	},
	DICTIONARY_SPERSON: {
		title: 'Сотрудники',
		editClass: 'Keysystems.Edits.Person',
		linkCode: 'SPerson',
		deleteCode: 'S_PERSON',
		handler: 'Keysystems.Base.List',
		getName: function (row) {
			var result = '';
			row = row.data || row;
			if (row) {
				result += row.LASTNAME + ' ' + row.FIRSTNAME + ' ' + row.PATRONYMIC;
			}
			return result;
		},
		getVisibleFields: function() {
			return 'LASTNAME,FIRSTNAME,PATRONYMIC';
		},
		getRowClass: function(r) {
			let me = this,
				wa = me.getWhereArgs(),
				orgVal = wa.SOrgs ? JSON.parse(wa.SOrgs.value) : '',
				org = orgVal.length ? orgVal[0] : 0, 
				data = r.data || r;

			return org !== 0 
				? data.ORGS.trim().length
					? data.IS_RUK ? 'x-bold' : ''
					: 'ks-textgray'
				: '';
		}
	},
	DICTIONARY_SOTDEL: {
		title: 'Подразделения',
		editClass: 'Keysystems.SOtdel.Edit',
		/*editClass: 'Keysystems.Base.Edit',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 10, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 200, enforceMaxLength: true },
		isSNameEdit: true,
		snameEditCfg: { maxLength: 60, enforceMaxLength: true },
		isDHEdit: true,
		isParentEdit: true,
		getExtraNew: function(callBack) { if (callBack) callBack(); },
		getExtra: function(callBack) { this.getLinkSelfExtra(callBack); },*/
		getSOrg: function () {
			throw new Error(wmc.get('NeedOverride'));
		},
		edit: function (f, data, defCfg) {
			defCfg = defCfg || {};
			defCfg.S_ORG = this.getSOrg();
			return this.callParent([f, data, defCfg]);
		},
		linkCode: 'SOtdel',
		deleteCode: 'S_OTDEL',
		handler: 'Keysystems.Base.List.Tree'
	},
	DICTIONARY_SDOLG: {
		title: 'Должности',
		editClass: 'Keysystems.Base.Edit',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 10, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 100, enforceMaxLength: true },
		isDHEdit: true,
		linkCode: 'SDolg',
		deleteCode: 'S_DOLG',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_SRANG: {
		title: 'Классные чины',
		editClass: 'Keysystems.Base.Edit',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 10, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 100, enforceMaxLength: true },
		isDHEdit: true,
		linkCode: 'SRang',
		deleteCode: 'S_RANG',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_SREASON: {
		title: 'Причины отсутствия',
		editClass: 'Keysystems.Base.Edit',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 20, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 500, enforceMaxLength: true },
		linkCode: 'SReason',
		deleteCode: 'S_REASON',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_SORG: {
		title: 'Организации',
		editClass: 'Keysystems.SOrg.Edit',
		linkCode: 'SOrg',
		deleteCode: 'S_ORG',
		handler: 'Keysystems.Base.List.Tree'
	},
	DICTIONARY_STYPEORG: {
		title: 'Типы организаций',
		editClass: 'Keysystems.Base.Edit',
		linkCode: 'STypeOrg',
		deleteCode: 'S_TYPEORG',
		handler: 'Keysystems.STypeOrg.List',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 3, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 550, enforceMaxLength: true },
		isDHEdit: true,
		dictArr: [
			{
				key: 'S_DOLG',
				fieldLabel: 'Должности',
				code: dnl.S_DOLG,
				mode: 'Multi',
				tableName: 'T_STYPEORG_SDOLG',
				whereField: 'S_TYPEORG'
			}
		]
	},
	DICTIONARY_SADR: {
		title: 'Адреса',
		editClass: 'Keysystems.SAdr.Edit',
		linkCode: 'SAdr',
		deleteCode: 'S_ADR',
		handler: 'Keysystems.SAdr.List'
	},
	DICTIONARY_SBUDGET: {
		title: 'Бюджеты',
		editClass: 'Keysystems.Base.Edit',
		linkCode: 'SBudget',
		deleteCode: 'S_BUDGET',
		handler: 'Keysystems.Base.List.Tree',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 20, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 1000, enforceMaxLength: true },
		dictArr: [
			{
				key: 'S_VBUDJ',
				fieldLabel: 'Уровень',
				code: dnl.S_VBUDJ,
				mode: 'Single'
			},
			{
				key: 'S_ORG',
				fieldLabel: 'Организация',
				code: dnl.S_ORG,
				mode: 'Multi',
				tableName: 'T_SBUDGET_SORG',
				whereField: 'S_BUDGET'
			}
		]
	},
	DICTIONARY_SRESPONS: {
		title: 'Виды ответственности',
		editClass: 'Keysystems.SRespons.Edit',
		linkCode: 'SRespons',
		deleteCode: 'S_RESPONS',
		handler: 'Keysystems.Base.List.Tree',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 10, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 500, enforceMaxLength: true },
		isDHEdit: true,
		dictArr: [
			{
				key: 'S_NAR',
				fieldLabel: 'Виды нарушений',
				code: dnl.S_NAR,
				mode: 'Multi',
				tableName: 'TEMP_T_SNAR_SRESPONS',
				whereField: 'S_RESPONS'
			}
		]
	},
	DICTIONARY_SRDOC: {
		title: 'Виды проверяемых документов',
		editClass: 'Keysystems.SRDoc.Edit',
		linkCode: 'SRdoc',
		fileColumn: true,
		deleteCode: 'S_RDOC',
		handler: 'Keysystems.Base.List.Tree'
	},
	DICTIONARY_SWORK: {
		title: 'Виды работ',
		editClass: 'Keysystems.Base.Edit',
		linkCode: 'SWork',
		deleteCode: 'S_WORK',
		handler: 'Keysystems.Base.List',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 3, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 250, enforceMaxLength: true },
		isDHEdit: true,
		dictArr: [
			{
				key: 'S_NAR',
				fieldLabel: 'Виды нарушений',
				code: dnl.S_NAR,
				mode: 'Multi',
				tableName: 'T_SWORK_SNAR',
				whereField: 'S_WORK'
			},
			{
				key: 'S_CALC',
				fieldLabel: 'Показатели',
				code: dnl.S_CALC,
				mode: 'Multi',
				tableName: 'T_SWORK_SCALC',
				whereField: 'S_WORK'
			}
		]
	},
	DICTIONARY_SWORK_ESGFK: {
		title: 'Виды работ (ГИС ЕСГФК)',
        linkCode: 'SWorkEsgfk',
		deleteCode: 'S_WORK_ESGFK',
		handler: 'Keysystems.SyncDictionary.List',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 3, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 250, enforceMaxLength: true },
	},
	DICTIONARY_SROSNOV_ESGFK: {
		title: 'Основания (ГИС ЕСГФК)',
		linkCode: 'SROsnovEsgfk',
		deleteCode: 'S_ROSNOV_ESGFK',
		handler: 'Keysystems.SyncDictionary.List',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 3, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 250, enforceMaxLength: true },
	},
	DICTIONARY_SRESPONS_ESGFK: {
		title: 'Виды ответственностей (ГИС ЕСГФК)',
		linkCode: 'SResponsEsgfk',
		deleteCode: 'S_RESPONS_ESGFK',
		handler: 'Keysystems.SyncDictionary.List',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 3, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 250, enforceMaxLength: true },
	},
	DICTIONARY_STAKENMEASURE_ESGFK: {
		title: 'Типы мер (ГИС ЕСГФК)',
		linkCode: 'STakenMeasureEsgfk',
		deleteCode: 'S_TAKENMEASURE_ESGFK',
		handler: 'Keysystems.Base.List',
		syncColumn: false,
		isCodeEdit: true,
		codeEditCfg: { maxLength: 3, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 250, enforceMaxLength: true },
	},
	DICTIONARY_SCESSREASONS_ESGFK: {
		title: 'Основания прекращения дела об АП (ГИС ЕСГФК)',
		linkCode: 'SCessReasonsEsgfk',
		deleteCode: 'S_CESSREASONS_ESGFK',
		handler: 'Keysystems.Base.List',
		syncColumn: false,
		isCodeEdit: true,
		codeEditCfg: { maxLength: 3, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 250, enforceMaxLength: true }
	},
	DICTIONARY_SBUDGMEASURE_ESGFK: {
		title: 'Бюджетные меры принуждения (ГИС ЕСГФК)',
		linkCode: 'SBudgMeasureEsgfk',
		deleteCode: 'S_BUDGMEASURE_ESGFK',
		handler: 'Keysystems.Base.List',
		syncColumn: false,
		isCodeEdit: true,
		codeEditCfg: { maxLength: 3, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 250, enforceMaxLength: true },
	},
	DICTIONARY_SBUDGNARKIND_ESGFK: {
		title: 'Виды бюджетных нарушений (ГИС ЕСГФК)',
		linkCode: 'SBudgNarKindEsgfk',
		deleteCode: 'S_BUDGNARKIND_ESGFK',
		handler: 'Keysystems.Base.List',
		syncColumn: false,
		isCodeEdit: true,
		codeEditCfg: { maxLength: 3, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 250, enforceMaxLength: true },
	},
	DICTIONARY_SCASECONRES_ESGFK: {
		title: 'Результаты дел об АП (ГИС ЕСГФК)',
		linkCode: 'SCaseConResEsgfk',
		deleteCode: 'S_CASECONRES_ESGFK',
		handler: 'Keysystems.Base.List',
		syncColumn: false,
		isCodeEdit: true,
		codeEditCfg: { maxLength: 3, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 250, enforceMaxLength: true },
	},
	DICTIONARY_SNPA_ESGFK: {
		title: 'Нормативно-правовые акты (ГИС ЕСГФК)',
		linkCode: 'SNpaEsgfk',
		deleteCode: 'S_NPA_ESGFK',
		handler: 'Keysystems.SyncDictionary.List',
		multiChoise: false,
		isCodeEdit: true,
		codeEditCfg: { maxLength: 3, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 250, enforceMaxLength: true },
	},
	DICTIONARY_SARTICLE_ESGFK: {
		title: 'Статьи (ГИС ЕСГФК)',
		linkCode: 'SArticleEsgfk',
		deleteCode: 'S_ARTICLE_ESGFK',
		handler: 'Keysystems.SyncDictionary.List',
		multiChoise: false,
		isCodeEdit: true,
		codeEditCfg: { maxLength: 3, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 250, enforceMaxLength: true },
	},
	DICTIONARY_SNAR_ESGFK: {
		title: 'Классификатор нарушений (ГИС ЕСГФК)',
		linkCode: 'SNarEsgfk',
		deleteCode: 'S_NAR_ESGFK',
		handler: 'Keysystems.SyncDictionary.List',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 3, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 250, enforceMaxLength: true },
	},
	DICTIONARY_SRPROG: {
		title: 'Вопросы программы',
		editClass: 'Keysystems.SRProg.Edit',
		linkCode: 'SRprog',
		deleteCode: 'S_RPROG',
		handler: 'Keysystems.Base.List.Tree'
	},
	DICTIONARY_SNAR: {
		title: 'Классификатор нарушений',
		editClass: 'Keysystems.SNar.Edit',
		linkCode: 'SNar',
		deleteCode: 'S_NAR',
		handler: 'Keysystems.Base.List.Tree'
	},
	DICTIONARY_SNPA: {
		title: 'Нормативно-правовые акты',
		editClass: 'Keysystems.SNpa.Edit',
		linkCode: 'SNpa',
		deleteCode: 'S_NPA',
		fileColumn: true,
		handler: 'Keysystems.SNpa.List'
	},
	DICTIONARY_SRNORM: {
		title: 'Нормативы',
		editClass: 'Keysystems.SRNorm.Edit',
		linkCode: 'SRnorm',
		deleteCode: 'S_RNORM',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_SROSNOV: {
		title: 'Основания',
		editClass: 'Keysystems.SRosnov.Edit',
		linkCode: 'SRosnov',
		deleteCode: 'S_ROSNOV',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_SPLAN: {
		title: 'Разделы плана',
		editClass: 'Keysystems.SPlan.Edit',
		linkCode: 'SPlan',
		deleteCode: 'S_PLAN',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_SRTEMA: {
		title: 'Темы',
		editClass: 'Keysystems.SRTema.Edit',
		linkCode: 'SRtema',
		deleteCode: 'S_RTEMA',
		handler: 'Keysystems.Base.List.Tree'
	},
	DICTIONARY_SRTEMA_VFA: {
		title: 'Темы ВФА',
		$parentCode: 'DICTIONARY_SRTEMA',
		profileCode: 'DICTIONARY_SRTEMA_VFA',
		linkCode: 'SRtema',
		isVfa: true,
		baseGetData: function (endFunc, params) {
			var me = this;

			params.code = 'DICTIONARY_SRTEMA_VFA';
			me.whereArgs = params.whereArgs = params.whereArgs || {};
			params.whereArgs.isVfa = { value: (params.isVfa = me.isVfa) ? 'True' : 'False', type: 'bool' };

			return me.callParent(arguments);
		},
		baseRefresh: function (endFunc, params) {
			params.code = 'DICTIONARY_SRTEMA_VFA';
			return this.callParent(arguments);
		}
		//beforeCreate: function(setts, callback) {
		//	Settings.getVfaSWork(setts, callback);
		//}
	},
	DICTIONARY_SCALC: {
		title: 'Показатели',
		editClass: 'Keysystems.SCalc.Edit',
		linkCode: 'SCalc',
		deleteCode: 'S_CALC',
		handler: 'Keysystems.SCalc.List'
	},
	DICTIONARY_SCHECK: {
		title: 'Формулы контроля',
		editClass: 'Keysystems.SCheck.Edit',
		linkCode: 'SCheck',
		deleteCode: 'S_CHECK',
		handler: 'Keysystems.Base.List',
		getVisibleFields: function() {
			return 'FORMULA';
		}		
	},
	DICTIONARY_SMEASURE: {
		title: 'Типы мер',
		editClass: 'Keysystems.Base.Edit',
		linkCode: 'SMeasure',
		deleteCode: 'S_MEASURE',
		handler: 'Keysystems.Base.List.Tree',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 20, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 1000, enforceMaxLength: true },
		isDHEdit: true,
	},
	DICTIONARY_SKLADR_REGION: {
		title: 'Регионы',
		editClass: 'Keysystems.SKladr.Edit',
		linkCode: 'SKladrRegion',
		deleteCode: 'S_KLADR_REGION',
		handler: 'Keysystems.Base.List',
		columnsAdapted: function () {
			var cols = this.callParent(arguments),
				i = ArrayLib.find(cols, ['dataIndex'], 'TEMP_USER');
			if (i !== -1) cols.splice(i, 1);
			return cols;
		},
		getVisibleFields: function() {
			return 'NAME SOCR';
		}
	},
	DICTIONARY_SKLADR_RAYON: {
		title: 'Районы',
		editClass: 'Keysystems.SKladr.Edit',
		linkCode: 'SKladrRayon',
		deleteCode: 'S_KLADR_RAYON',
		columnsAdapted: function () {
			var cols = this.callParent(arguments),
				i = ArrayLib.find(cols, ['dataIndex'], 'TEMP_USER');
			if (i !== -1) cols.splice(i, 1);
			return cols;
		},
		handler: 'Keysystems.Base.List',
		getVisibleFields: function() {
			return 'NAME SOCR';
		}
	},
	DICTIONARY_SKLADR_CITY: {
		title: 'Города',
		editClass: 'Keysystems.SKladr.Edit',
		linkCode: 'SKladrCity',
		deleteCode: 'S_KLADR_CITY',
		columnsAdapted: function () {
			var cols = this.callParent(arguments),
				i = ArrayLib.find(cols, ['dataIndex'], 'TEMP_USER');
			if (i !== -1) cols.splice(i, 1);
			return cols;
		},
		handler: 'Keysystems.Base.List',
		getVisibleFields: function() {
			return 'SOCR. NAME';
		}
	},
	DICTIONARY_SKLADR_NPUNKT: {
		title: 'Населенные пункты',
		editClass: 'Keysystems.SKladr.Edit',
		linkCode: 'SKladrNPunkt',
		deleteCode: 'S_KLADR_NPUNKT',
		columnsAdapted: function () {
			var cols = this.callParent(arguments),
				i = ArrayLib.find(cols, ['dataIndex'], 'TEMP_USER');
			if (i !== -1) cols.splice(i, 1);
			return cols;
		},
		handler: 'Keysystems.Base.List',
		getVisibleFields: function() {
			return 'SOCR. NAME';
		}
	},
	DICTIONARY_SKLADR_STREET: {
		title: 'Улицы',
		editClass: 'Keysystems.SKladr.Edit',
		linkCode: 'SKladrStreet',
		deleteCode: 'S_KLADR_STREET',
		handler: 'Keysystems.Base.List',
		getVisibleFields: function() {
			return 'SOCR. NAME';
		}
	},
	DICTIONARY_SKLADR_INDEX: {
		title: 'Дома',
		editClass: 'Keysystems.SKladr.Edit',
		linkCode: 'SKladrIndex',
		deleteCode: 'S_KLADR_INDEX',
		handler: 'Keysystems.Base.List',
		getVisibleFields: function() {
			return 'SOCR. NAME';
		}
	},
	DICTIONARY_SOKVED: {
		title: 'ОКВЭД',
		editClass: 'Keysystems.Base.Edit',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 10, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 500, enforceMaxLength: true },
		isDHEdit: true,
		linkCode: 'SOkved',
		deleteCode: 'S_OKVED',
		handler: 'Keysystems.Base.List.Tree'
	},
	DICTIONARY_SOKOPF: {
		title: 'ОКОПФ',
		editClass: 'Keysystems.Base.Edit',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 10, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 100, enforceMaxLength: true },
		isDHEdit: true,
		linkCode: 'SOkopf',
		deleteCode: 'S_OKOPF',
		handler: 'Keysystems.Base.List.Tree'
	},
	DICTIONARY_SOKFS: {
		title: 'ОКФС',
		editClass: 'Keysystems.Base.Edit',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 5, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 100, enforceMaxLength: true },
		isDHEdit: true,
		linkCode: 'SOkfs',
		deleteCode: 'S_OKFS',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_SOKSM: {
		title: 'ОКСМ',
		editClass: 'Keysystems.Base.Edit',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 4, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 254, enforceMaxLength: true },
		isSNameEdit: true,
		snameEditCfg: { maxLength: 100, enforceMaxLength: true },
		linkCode: 'SOksm',
		deleteCode: 'S_OKSM',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_SVAL: {
		title: 'Виды валют',
		editClass: 'Keysystems.Base.Edit',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 3, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 250, enforceMaxLength: true },
		isSNameEdit: true,
		snameEditCfg: { maxLength: 3, enforceMaxLength: true },
		linkCode: 'SVal',
		deleteCode: 'S_VAL',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_SEDS_LEVEL: {
		title: 'Уровни ЭЦП',
		editClass: 'Keysystems.SEdsLevel.Edit',
		linkCode: 'SEdsLevel',
		deleteCode: 'DICTIONARY_SEDS_LEVEL',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_SRACCOUNT: {
		title: 'Счета',
		editClass: 'Keysystems.Base.Edit',
		linkCode: 'SAccount',
		deleteCode: 'S_RACCOUNT',
		handler: 'Keysystems.Base.List',
		codeEditCfg: { fieldLabel: 'Сч №', maxLength: 20, enforceMaxLength: true },
		isCodeEdit: true,
		isNameEdit: true,
		nameEditCfg: { maxLength: 250, enforceMaxLength: true, ksAllowEmpty: false, allowBlank: true },
		isSNameEdit: true,
		isDHEdit: true,
		dictArr: [
			{
				key: 'S_ACCOUNTTYPE',
				fieldLabel: 'Тип счета',
				code: dnl.S_ACCOUNTTYPE,
				ksAllowEmpty: true,
				mode: 'Single'
			},
			{
				key: 'S_ORGP',
				fieldLabel: 'Банк',
				code: dnl.S_ORG,
				ksAllowEmpty: true,
				whereArgs: { SType: { value: JSON.stringify([KsLib.getKeyByValue(miscTypes.TypeOrg, 'Банк')]), type: 'List_int' } },
				mode: 'Single'
			},
			{
				key: 'S_ORGC',
				fieldLabel: 'Организация',
				code: dnl.S_ORG,
				mode: 'Single'
			}
		]
	},
	DICTIONARY_STASK: {
		title: 'Регламенты',
		editClass: 'Keysystems.STask.Edit',
		linkCode: 'STask',
		deleteCode: 'S_TASK',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_SREGION: {
		title: 'Территории',
		editClass: 'Keysystems.SRegion.Edit',
		linkCode: 'SRegion',
		deleteCode: 'S_REGION',
		handler: 'Keysystems.Base.List.Tree'
	},
	DICTIONARY_SINFO: {
		title: 'Виды информации о нарушениях',
		editClass: 'Keysystems.SInfo.Edit',
		linkCode: 'SInfo',
		deleteCode: 'S_INFO',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_SACCOUNTTYPE: {
		title: 'Типы счетов',
		editClass: 'Keysystems.Base.Edit',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 6, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 250, enforceMaxLength: true },
		linkCode: 'SAccountType',
		deleteCode: 'S_ACCOUNTTYPE',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_USER_GROUP: {
		title: 'Пользователи и группы',
		linkCode: 'SUserGroup',
		handler: 'Keysystems.Login'
	},
	DICTIONARY_SARTICLE: {
		title: 'Статьи',
		editClass: 'Keysystems.SArticle.Edit',
		linkCode: 'SArticle',
		deleteCode: 'S_ARTICLE',
		codeEditCfg: {
			maxLength: 500,
			enforceMaxLength: true,
			fieldLabel: 'Статья',
			blankText: KS.L10n.pole_obyazatelno_dlya_zapolneniya,
		},
		isCodeEdit: true,
		isDHEdit: true,
		isNameEdit: true,
		nameEditCfg: {
			fieldLabel: 'Содержание',
			maxLength: 8000,
			enforceMaxLength: true,
			height: 100,
			ksAllowEmpty: false,
			allowBlank: true,
			className: 'Ext.form.field.TextArea'
		},
		handler: 'Keysystems.Base.List',
		dictArr: [
			{
				key: 'S_NPA',
				fieldLabel: 'НПА',
				code: dnl.S_NPA,
				ksAllowEmpty: true,
				mode: 'Single'
			}
		]
	},
	DICTIONARY_SSTATUS_OBJECT: {
		title: 'Статусы',
		editClass: 'Keysystems.SStatus.Object.Edit',
		linkCode: 'SStatusObject',
		deleteCode: 'S_STATUS_OBJECT',
		handler: 'Keysystems.Base.List',
		btnsHide: {
			same: true
		}
	},
	DICTIONARY_SSTATUS: {
		title: 'Статусы',
		editClass: 'Keysystems.Base.Edit',
		isCodeEdit: true,
		isNameEdit: true,
		codeEditCfg: { maxLength: 10, enforceMaxLength: true, className: 'Ext.form.field.Number' },
		linkCode: 'SStatus',
		deleteCode: 'S_STATUS',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_STABLELIST: {
		title: 'Список таблиц',
		linkCode: 'STabletList',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_SDELO: {
		title: 'Номенклатура дел',
		editClass: 'Keysystems.Base.Edit',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 30, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 250, enforceMaxLength: true },
		isDHEdit: true,
		linkCode: 'SDelo',
		deleteCode: 'S_DELO',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_TASKDOC: {
		title: 'Виды документов регламентов',
		//editClass: 'Keysystems.STask.Edit.Doc',
		linkCode: 'STaskDoc',
		//deleteCode: 'S_TASKDOC',
		handler: 'Keysystems.STask.Gantt'
	},
	DICTIONARY_STN_VED: {
		title: 'ТН ВЭД',
		editClass: 'Keysystems.Base.Edit',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 50, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 1000, enforceMaxLength: true },
		isDHEdit: true,
		linkCode: 'STnved',
		deleteCode: 'S_TN_VED',
		handler: 'Keysystems.Base.List.Tree'
	},
	DICTIONARY_SGROUP_EI: {
		title: 'Группы единиц измерений',
		editClass: 'Keysystems.Base.Edit',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 20, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 500, enforceMaxLength: true },
		linkCode: 'SOkeiGroup',
		deleteCode: 'S_GROUP_EI',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_SOKEI: {
		title: 'ОКЕИ',
		editClass: 'Keysystems.SOkei.Edit',
		linkCode: 'SOkei',
		deleteCode: 'S_OKEI',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_STRANSPORT: {
		title: 'Виды транспорта',
		editClass: 'Keysystems.Base.Edit',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 20, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 500, enforceMaxLength: true },
		linkCode: 'STransport',
		deleteCode: 'S_TRANSPORT',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_STYPECARGO: {
		title: 'Типы грузов',
		editClass: 'Keysystems.Base.Edit',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 20, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 500, enforceMaxLength: true },
		linkCode: 'STypeCargo',
		deleteCode: 'S_TYPECARGO',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_SKVARTAL: {
		title: 'Кадастровые кварталы',
		editClass: 'Keysystems.SKvartal.Edit',
		linkCode: 'SKvartal',
		deleteCode: 'S_KVARTAL',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_SLAND: {
		title: 'Земельные участки',
		editClass: 'Keysystems.SLand.Edit',
		linkCode: 'SLand',
		deleteCode: 'S_LAND',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_SLKATEG: {
		title: 'Категории земельных участков',
		editClass: 'Keysystems.Base.Edit',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 20, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 500, enforceMaxLength: true },
		linkCode: 'SLkateg',
		deleteCode: 'S_LKATEG',
		handler: 'Keysystems.Base.List.Tree'
	},
	DICTIONARY_SLUTIL: {
		title: 'Виды разрешенного использования',
		editClass: 'Keysystems.Base.Edit',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 20, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 500, enforceMaxLength: true },
		linkCode: 'SLutil',
		deleteCode: 'S_LUTIL',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_SRTYPE: {
		title: 'Виды прав',
		editClass: 'Keysystems.Base.Edit',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 20, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 500, enforceMaxLength: true },
		linkCode: 'SRType',
		deleteCode: 'S_RTYPE',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_REPORT_LIST: {
		title: 'Список отчетов',
		linkCode: 'SReportShowList',
		handler: 'Keysystems.Base.List',
		getVisibleFields: function() {
			return 'NAME';
		}
	},
	DICTIONARY_SPLANPROJ: {
		title: 'Проекты плана',
		editClass: 'Keysystems.PlanProj.Edit',
		linkCode: 'SPlanproj',
		deleteCode: 'S_PLANPROJ',
		handler: 'Keysystems.PlanProj.List',
		checkUserError: true,
		btnsHide: {
			show_actual: true
		}
	},
	DICTIONARY_SPLANPROJ_VFA: {
		$parentCode: 'DICTIONARY_SPLANPROJ',
		profileCode: 'DICTIONARY_SPLANPROJ_VFA',
		linkCode: 'SPlanproj',
		isVfa: true,
		baseGetData: function (endFunc, params) {
			var me = this;

			params.code = 'DICTIONARY_SPLANPROJ_VFA';
			me.whereArgs = params.whereArgs = params.whereArgs || {};
			params.whereArgs.isVfa = { value: (params.isVfa = me.isVfa) ? 'True' : 'False', type: 'bool' };

			return me.callParent(arguments);
		},
		baseRefresh: function (endFunc, params) {
			params.code = 'DICTIONARY_SPLANPROJ_VFA';
			return this.callParent(arguments);
		},
		beforeCreate: function (setts, callback) {
			Settings.getVfaSWork(setts, callback);
		},
		btnsHide: {
			show_actual: true
		}
	},
	DICTIONARY_SVARPARAM: {
		title: 'Варианты',
		editClass: 'Keysystems.SVarParam.Edit',
		linkCode: 'SVarparam',
		deleteCode: 'S_VARPARAM',
		handler: 'Keysystems.SVarParam.List'
	},
	DICTIONARY_SOKP: {
		title: 'ОКП',
		editClass: 'Keysystems.Base.Edit',
		linkCode: 'SOkp',
		deleteCode: 'DICTIONARY_SOKP',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 50, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 1000, enforceMaxLength: true },
		isDHEdit: true,
		handler: 'Keysystems.Base.List.Tree',
		dictArr: [
			{
				key: 'S_OKEI',
				fieldLabel: 'Единица измерения',
				code: dnl.S_OKEI,
				mode: 'Single'
			}
		]
	},
	DOCUMENT_REVIZ: {
		title: 'Мероприятия',
		iconCls: 'x_btn_reviz',
		editClass: 'Keysystems.Reviz.Edit',
		linkCode: 'SReviz',
		//deleteCode: 'REVIZ',
		handler: 'Keysystems.Reviz.List',
		btnsHide: {
			make_child: true,
			make_parent: true
		},
		checkUserError: true, //выводить сообщение, что у пользователь не привязан к кому-то, либо может бан есть
		getVisibleFields: function() {
			return window.isRfn ? 'NUMBERIKM' : '№ NUMBER от DT';
		}
	},
	DOCUMENT_REVIZ_VFA: {
		$parentCode: 'DOCUMENT_REVIZ',
		profileCode: 'DOCUMENT_REVIZ_VFA',
		linkCode: 'SReviz',
		isVfa: true,
		baseGetData: function (endFunc, params) {
			var me = this;

			params.code = 'DOCUMENT_REVIZ_VFA';
			me.whereArgs = params.whereArgs = params.whereArgs || {};
			params.whereArgs.isVfa = { value: (params.isVfa = me.isVfa) ? 'True' : 'False', type: 'bool' };

			return me.callParent(arguments);
		},
		baseRefresh: function (endFunc, params) {
			params.code = 'DOCUMENT_REVIZ_VFA';
			return this.callParent(arguments);
		},
		beforeCreate: function (setts, callback) {
			Settings.getVfaSWork(setts, callback);
		}
	},
	DOCUMENT_REVIZ_BR: {
		$parentCode: 'DOCUMENT_REVIZ',
		profileCode: 'DOCUMENT_REVIZ_BR',
		linkCode: 'SReviz',		
		baseGetData: function (endFunc, params) {
			const me = this;
			params.code = 'DOCUMENT_REVIZ_BR';
			return me.callParent(arguments);
		},
		baseRefresh: function (endFunc, params) {
			params.code = 'DOCUMENT_REVIZ_BR';
			return this.callParent(arguments);
		}		
	},
	DOCUMENT_REVIZ_IC: {
		$parentCode: 'DOCUMENT_REVIZ',
		profileCode: 'DOCUMENT_REVIZ_IC',
		linkCode: 'SReviz',
		baseGetData: function (endFunc, params) {
			const me = this;
			params.code = 'DOCUMENT_REVIZ_IC';
			return me.callParent(arguments);
		},
		baseRefresh: function (endFunc, params) {
			params.code = 'DOCUMENT_REVIZ_IC';
			return this.callParent(arguments);
		}
	},
	DOCUMENT_REVIZ_DC_FZ_44: {
		$parentCode: 'DOCUMENT_REVIZ',
		profileCode: 'DOCUMENT_REVIZ_DC_FZ_44',
		linkCode: 'SReviz',
		baseGetData: function (endFunc, params) {
			const me = this;
			params.code = 'DOCUMENT_REVIZ_DC_FZ_44';
			return me.callParent(arguments);
		},
		baseRefresh: function (endFunc, params) {
			params.code = 'DOCUMENT_REVIZ_DC_FZ_44';
			return this.callParent(arguments);
		}
	},
	DOCUMENT_REVIZ_DC_FZ_223: {
		$parentCode: 'DOCUMENT_REVIZ',
		profileCode: 'DOCUMENT_REVIZ_DC_FZ_223',
		linkCode: 'SReviz',
		baseGetData: function (endFunc, params) {
			const me = this;
			params.code = 'DOCUMENT_REVIZ_DC_FZ_223';
			return me.callParent(arguments);
		},
		baseRefresh: function (endFunc, params) {
			params.code = 'DOCUMENT_REVIZ_DC_FZ_223';
			return this.callParent(arguments);
		}
	},
	DOCUMENT_FACTNAR: {
		title: 'Нарушения',
		editClass: 'Keysystems.FactNar.Edit',
		linkCode: 'SFactNar',
		handler: 'Keysystems.FactNar.List.Tree',
		btnsHide: { make_child: true, make_parent: true, add_slave: true, delete: true },
		deleteCode: 'DOCUMENT_FACTNAR',
		checkUserError: true,
		getVisibleFields: function() {
			return 'DTNAR';
		}
	},
	DOCUMENT_FACTNAR_DIS: {
		$parentCode: 'DOCUMENT_FACTNAR',
		profileCode: 'DOCUMENT_FACTNAR_DIS',
		linkCode: 'SFactNar',
		title: 'Недостатки',
		isDis: true,
		baseGetData: function (endFunc, params) {
			params.code = 'DOCUMENT_FACTNAR_DIS';
			return this.callParent(arguments);
		},
		baseRefresh: function (endFunc, params) {
			params.code = 'DOCUMENT_FACTNAR_DIS';
			return this.callParent(arguments);
		},
		getVisibleFields: function() {
			return 'DTNAR';
		}
	},
	DOCUMENT_FACTNAR_VFA: {
		$parentCode: 'DOCUMENT_FACTNAR',
		profileCode: 'DOCUMENT_FACTNAR_VFA',
		linkCode: 'SFactNar',
		isVfa: true,
		baseGetData: function (endFunc, params) {
			var me = this;

			params.code = 'DOCUMENT_FACTNAR_VFA';
			me.whereArgs = params.whereArgs = params.whereArgs || {};
			params.whereArgs.isVfa = { value: (params.isVfa = me.isVfa) ? 'True' : 'False', type: 'bool' };

			return me.callParent(arguments);
		},
		baseRefresh: function (endFunc, params) {
			params.code = 'DOCUMENT_FACTNAR_VFA';
			return this.callParent(arguments);
		},
		beforeCreate: function (setts, callback) {
			Settings.getVfaSWork(setts, callback);
		}
	},
	DOCUMENT_FACTNAR_BR: {
		$parentCode: 'DOCUMENT_FACTNAR',
		profileCode: 'DOCUMENT_FACTNAR_BR',
		linkCode: 'SFactNar',
		baseGetData: function (endFunc, params) {
			const me = this;
			params.code = 'DOCUMENT_FACTNAR_BR';
			return me.callParent(arguments);
		},
		baseRefresh: function (endFunc, params) {
			params.code = 'DOCUMENT_FACTNAR_BR';
			return this.callParent(arguments);
		}		
	},
	DOCUMENT_FACTNAR_IC: {
		$parentCode: 'DOCUMENT_FACTNAR',
		profileCode: 'DOCUMENT_FACTNAR_IC',
		linkCode: 'SFactNar',
		baseGetData: function (endFunc, params) {
			const me = this;
			params.code = 'DOCUMENT_FACTNAR_IC';
			return me.callParent(arguments);
		},
		baseRefresh: function (endFunc, params) {
			params.code = 'DOCUMENT_FACTNAR_IC';
			return this.callParent(arguments);
		}
	},
	DOCUMENT_FACTNAR_DC_FZ_44: {
		$parentCode: 'DOCUMENT_FACTNAR',
		profileCode: 'DOCUMENT_FACTNAR_DC_FZ_44',
		linkCode: 'SFactNar',
		baseGetData: function (endFunc, params) {
			const me = this;
			params.code = 'DOCUMENT_FACTNAR_DC_FZ_44';
			return me.callParent(arguments);
		},
		baseRefresh: function (endFunc, params) {
			params.code = 'DOCUMENT_FACTNAR_DC_FZ_44';
			return this.callParent(arguments);
		}
	},
	DOCUMENT_FACTNAR_DC_FZ_223: {
		$parentCode: 'DOCUMENT_FACTNAR',
		profileCode: 'DOCUMENT_FACTNAR_DC_FZ_223',
		linkCode: 'SFactNar',
		baseGetData: function (endFunc, params) {
			const me = this;
			params.code = 'DOCUMENT_FACTNAR_DC_FZ_223';
			return me.callParent(arguments);
		},
		baseRefresh: function (endFunc, params) {
			params.code = 'DOCUMENT_FACTNAR_DC_FZ_223';
			return this.callParent(arguments);
		}
	},
	DICTIONARY_PLANREVIZORG: {
		title: 'Запланированные мероприятия',
		linkCode: 'PlanRevizOrg',
		handler: 'Keysystems.Base.List',
		checkUserError: true,
		viewCfg: function () {
			var me = this,
				parentMetod = me.callParent(arguments),
				res = parentMetod.apply(me);

			if (me.Grid) {
				me.Grid.view.getRowClass = function (record) {
					return record.data.TEMP_HASREVIZ ? '' : 'x-bold';
				};
			}
			return res;
		},
		getVisibleFields: function() {
			return 'PPLAN';
		}
	},
	DOCUMENT_PLANREVIZ: { 
		handler: 'Keysystems.Plan.List.Simple',
		editClass: 'Keysystems.Plan.Edit',
		linkCode: 'SPlanSimple',
		checkUserError: true,
		getVisibleFields: function() {
			return 'DT1,DT2';
		}
	},
	DOCUMENT_PLANREVIZ_SIMPLE: { 
		handler: 'Keysystems.Plan.List.Simple',
		editClass: 'Keysystems.Plan.Edit',
		linkCode: 'SPlanSimple'
	},
	DOCUMENT_PLANREVIZ_MOD: { 
		handler: 'Keysystems.Plan.List.Mod',
		editClass: 'Keysystems.Plan.Edit',
		linkCode: 'SPlanMod',
		checkUserError: true,
		getVisibleFields: function() {
			return 'DT1,DT2';
		}
	},
	DOCUMENT_PLANREVIZ_VFA: {
		$parentCode: 'DOCUMENT_PLANREVIZ_SIMPLE',
		profileCode: 'DOCUMENT_PLANREVIZ_VFA',
		linkCode: 'SPlanSimple',
		isVfa: true,
		baseGetData: function (endFunc, params) {
			var me = this;

			params.code = 'DOCUMENT_PLANREVIZ_VFA';
			me.whereArgs = params.whereArgs = params.whereArgs || {};
			params.whereArgs.isVfa = { value: (params.isVfa = me.isVfa) ? 'True' : 'False', type: 'bool' };

			return me.callParent(arguments);
		},
		baseRefresh: function (endFunc, params) {
			params.code = 'DOCUMENT_PLANREVIZ_VFA';
			return this.callParent(arguments);
		},
		beforeCreate: function (setts, callback) {
			Settings.getVfaSWork(setts, callback);
		},
		getVisibleFields: function() {
			return 'DT1,DT2';
		}
	},
	DOCUMENT_PLANREVIZ_IC: {
		$parentCode: 'DOCUMENT_PLANREVIZ_SIMPLE',
		profileCode: 'DOCUMENT_PLANREVIZ_IC',
		linkCode: 'SPlanSimple',
		baseGetData: function (endFunc, params) {
			const me = this;
			params.code = 'DOCUMENT_PLANREVIZ_IC';
			return me.callParent(arguments);
		},
		baseRefresh: function (endFunc, params) {
			params.code = 'DOCUMENT_PLANREVIZ_IC';
			return this.callParent(arguments);
		},		
		getVisibleFields: function() {
			return 'DT1,DT2';
		}
	},
	DOCUMENT_PLANREVIZ_DC_FZ_44: {
		$parentCode: 'DOCUMENT_PLANREVIZ_SIMPLE',
		profileCode: 'DOCUMENT_PLANREVIZ_DC_FZ_44',
		linkCode: 'SPlanSimple',
		baseGetData: function (endFunc, params) {
			const me = this;
			params.code = 'DOCUMENT_PLANREVIZ_DC_FZ_44';
			return me.callParent(arguments);
		},
		baseRefresh: function (endFunc, params) {
			params.code = 'DOCUMENT_PLANREVIZ_DC_FZ_44';
			return this.callParent(arguments);
		},
		getVisibleFields: function() {
			return 'DT1,DT2';
		}
	},
	DOCUMENT_PLANREVIZ_DC_FZ_223: {
		$parentCode: 'DOCUMENT_PLANREVIZ_SIMPLE',
		profileCode: 'DOCUMENT_PLANREVIZ_DC_FZ_223',
		linkCode: 'SPlanSimple',
		baseGetData: function (endFunc, params) {
			const me = this;
			params.code = 'DOCUMENT_PLANREVIZ_DC_FZ_223';
			return me.callParent(arguments);
		},
		baseRefresh: function (endFunc, params) {
			params.code = 'DOCUMENT_PLANREVIZ_DC_FZ_223';
			return this.callParent(arguments);
		},
		getVisibleFields: function() {
			return 'DT1,DT2';
		}
	},
	DOCUMENTS: { 
		handler: 'Keysystems.Documents.List',
		editClass: 'Keysystems.Documents.Edit',
		linkCode: 'SDocuments',
		checkUserError: true, //выводить сообщение, что у пользователь не привязан к комуто, либо может бан есть
		getVisibleFields: function() {
			return '№ NUMBER от DT';
		}
	},
	DOCUMENTS_VFA: {
		$parentCode: 'DOCUMENTS',
		profileCode: 'DOCUMENTS_VFA',
		linkCode: 'SDocuments',
		isVfa: true,
		baseGetData: function (endFunc, params) {
			var me = this;

			params.code = 'DOCUMENTS_VFA';
			me.whereArgs = params.whereArgs = params.whereArgs || {};
			params.whereArgs.isVfa = { value: (params.isVfa = me.isVfa) ? 'True' : 'False', type: 'bool' };

			return me.callParent(arguments);
		},
		baseRefresh: function (endFunc, params) {
			params.code = 'DOCUMENTS_VFA';
			return this.callParent(arguments);
		},
		beforeCreate: function (setts, callback) {
			Settings.getVfaSWork(setts, callback);
		},
		getVisibleFields: function() {
			return '№ NUMBER от DT';
		}
	},
	DOCUMENTS_BR: {
		$parentCode: 'DOCUMENTS',
		profileCode: 'DOCUMENTS_BR',
		linkCode: 'SDocuments',
		baseGetData: function (endFunc, params) {
			const me = this;
			params.code = 'DOCUMENTS_BR';
			return me.callParent(arguments);
		},
		baseRefresh: function (endFunc, params) {
			params.code = 'DOCUMENTS_BR';
			return this.callParent(arguments);
		},	
		getVisibleFields: function() {
			return '№ NUMBER от DT';
		}
	},
	DOCUMENTS_IC: {
		$parentCode: 'DOCUMENTS',
		profileCode: 'DOCUMENTS_IC',
		linkCode: 'SDocuments',
		baseGetData: function (endFunc, params) {
			const me = this;
			params.code = 'DOCUMENTS_IC';
			return me.callParent(arguments);
		},
		baseRefresh: function (endFunc, params) {
			params.code = 'DOCUMENTS_IC';
			return this.callParent(arguments);
		},
		getVisibleFields: function() {
			return '№ NUMBER от DT';
		}
	},
	DOCUMENTS_DC_FZ_44: {
		$parentCode: 'DOCUMENTS',
		profileCode: 'DOCUMENTS_DC_FZ_44',
		linkCode: 'SDocuments',
		baseGetData: function (endFunc, params) {
			const me = this;
			params.code = 'DOCUMENTS_DC_FZ_44';
			return me.callParent(arguments);
		},
		baseRefresh: function (endFunc, params) {
			params.code = 'DOCUMENTS_DC_FZ_44';
			return this.callParent(arguments);
		},
		getVisibleFields: function() {
			return '№ NUMBER от DT';
		}
	},
	DOCUMENTS_DC_FZ_223: {
		$parentCode: 'DOCUMENTS',
		profileCode: 'DOCUMENTS_DC_FZ_223',
		linkCode: 'SDocuments',
		baseGetData: function (endFunc, params) {
			const me = this;
			params.code = 'DOCUMENTS_DC_FZ_223';
			return me.callParent(arguments);
		},
		baseRefresh: function (endFunc, params) {
			params.code = 'DOCUMENTS_DC_FZ_223';
			return this.callParent(arguments);
		},
		getVisibleFields: function() {
			return '№ NUMBER от DT';
		}
	},
	DOCUMENT_FINANC: {
		title: 'Финансирование',
		iconCls: 'x_btn_currency',
		linkCode: 'SFinanc',
		editClass: 'Keysystems.Financ.Edit',
		handler: 'Keysystems.Financ.List',
		checkUserError: true,
		getVisibleFields: function() {
			return 'DT1,DT2,SUMMA';
		}
	},
	DOCUMENT_CONTRACT: {
		title: 'Контракты',
		iconCls: 'x_btn_contract_list',
		linkCode: 'SContract',
		editClass: 'Keysystems.Contract.Edit',
		handler: 'Keysystems.Contract.List'
	},
	DOCUMENT_REVIZOR_MAP: { handler: 'Keysystems.Map.List' },
	DOCUMENT_KURS: { 
		handler: 'Keysystems.Kurs.List',
		linkCode: 'SKurs'
	},
	DOCUMENT_INFO: {
		title: 'Информация о нарушениях',
		iconCls: 'x_btn_docinfo',
		linkCode: 'SDocInfo',
		editClass: 'Keysystems.Info.Edit',
		handler: 'Keysystems.Info.List',
		checkUserError: true,
		getVisibleFields: function() {
			return 'DT';
		}
	},

	DOCUMENT_OUTER_REVIZ: {
		//Внешние проверки
		title: 'Проверки внешних КНО',
		iconCls: 'x_btn_vreviz',
		editClass: 'Keysystems.OuterReviz.Edit',
		linkCode: 'SOuterReviz',
		deleteCode: 'DOCUMENT_OUTER_REVIZ',
		handler: 'Keysystems.OuterReviz.List'
	},
	DICTIONARY_IFC_ACTION: {
		title: 'Операции (действия)',
		linkCode: 'SAction',
		editClass: 'Keysystems.Action.Edit',
		deleteCode: 'IFC_ACTION',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_IFC_S_ACTION: {
		title: 'Операции',
		linkCode: 'SOperation',
		editClass: 'Keysystems.Operation.Edit',
		deleteCode: 'IFC_S_ACTION',
		handler: 'Keysystems.Base.List.Tree'
	},
	DICTIONARY_IFC_R_A_INSP: {
		title: 'Контролирующие',
		linkCode: 'SInspectors',
		deleteCode: 'IFC_R_A_INSP',
		handler: 'Keysystems.Base.List',
		getVisibleFields: function() {
			return 'INSPECTOR_NAME';
		}
	},
	DICTIONARY_IFC_R_A_RESP_PERS: {
		title: 'Ответственное лицо',
		linkCode: 'SResponsiblePerson',
		deleteCode: 'IFC_R_A_RESP_PERS',
		handler: 'Keysystems.Base.List.Tree',
		getVisibleFields: function() {
			return 'RESPONSIBLE_PERSON_NAME';
		}
	},
	DICTIONARY_IFC_S_PROB_RISK: {
		title: 'Риски по критерию "Вероятность"',
		linkCode: 'SProbabilityRisk',
		editClass: 'Keysystems.Base.Edit',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 10, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 1000, enforceMaxLength: true },
		isDHEdit: true,
		deleteCode: 'IFC_S_PROB_RISK',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_IFC_S_IMPL_RISK: {
		title: 'Риски по критерию "Последствия"',
		linkCode: 'SImplicationRisk',
		editClass: 'Keysystems.Base.Edit',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 10, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 1000, enforceMaxLength: true },
		isDHEdit: true,
		deleteCode: 'IFC_S_IMPL_RISK',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_IFC_S_PROB_RISK_L: {
		title: 'Уровни рисков по критерию "Вероятность"',
		linkCode: 'SProbabilityRiskLevel',
		editClass: 'Keysystems.RiskLevel.Edit',
		isProbability: true,
		deleteCode: 'IFC_S_PROB_RISK_L',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_IFC_S_IMPL_RISK_L: {
		title: 'Уровни рисков по критерию "Последствия"',
		linkCode: 'SImplicationRiskLevel',
		editClass: 'Keysystems.RiskLevel.Edit',
		isProbability: false,
		deleteCode: 'IFC_S_IMPL_RISK_L',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_IFC_S_RISK_L: {
		title: 'Уровни рисков',
		linkCode: 'SRiskLevel',
		editClass: 'Keysystems.SRiskLevel.Edit',
		deleteCode: 'IFC_S_RISK_L',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_IFC_RISK_L_VALUE: {
		title: 'Матрица бюджетных рисков',
		linkCode: 'SRiskLevelValue',
		editClass: 'Keysystems.RiskLevelValue.Edit',
		deleteCode: 'IFC_RISK_L_VALUE',
		handler: 'Keysystems.Base.List'
	},
	DOCUMENT_DOCREQUEST: {
		title: 'Запросы документов',
		editClass: 'Keysystems.Documents.Edit.Request',
		linkCode: 'SDocumentRequest',
		iconCls: 'x_btn_docrequest',
		btnsHide: { new: true, same: true, search: true, delete: true },
		//deleteCode: 'DOCREQUEST',
		handler: 'Keysystems.Base.List',
		getGridCfg: function () {
			var me = this,
				res = me.callParent(arguments);
			res.viewConfig = { getRowClass: function (r) { return r.get('ReadOnly') === false ? 'ks-editable' : ''; } };
			return res;
		}
	},
	DOCUMENT_DOCREQUEST_VFA: {
		$parentCode: 'DOCUMENT_DOCREQUEST',
		profileCode: 'DOCUMENT_DOCREQUEST',
		linkCode: 'SDocumentRequest',
		isVfa: true,
		baseGetData: function (endFunc, params) {
			var me = this;

			me.whereArgs = params.whereArgs = params.whereArgs || {};
			params.whereArgs.isVfa = { value: (params.isVfa = me.isVfa) ? 'True' : 'False', type: 'bool' };

			return me.callParent(arguments);
		},
		beforeCreate: function (setts, callback) {
			Settings.getVfaSWork(setts, callback);
		}
	},
	DOCUMENT_ORDERS: {
		title: 'Поручения',
		editClass: 'Keysystems.Orders.Edit',
		linkCode: 'SOrders',
		iconCls: 'x_btn_orders',
		deleteCode: 'ORDERS',
		handler: 'Keysystems.AppealsOrders.List',
		checkUserError: true,
		getVisibleFields: function() {
			return '№ NUMBER от DT';
		}
	},
	DOCUMENT_APPEALS: {
		title: 'Обращения',
		editClass: 'Keysystems.Appeals.Edit',
		linkCode: 'SAppeals',
		iconCls: 'x_btn_appeals',
		deleteCode: 'APPEALS',
		handler: 'Keysystems.AppealsOrders.List',
		checkUserError: true,
		getVisibleFields: function() {
			return '№ NUMBER от DT';
		}
	},
	DOCUMENT_DOCREVIZ: {
		title: 'Планы устранения нарушений',
		editClass: 'Keysystems.Documents.Edit.Reviz',
		linkCode: 'SDocumentReviz',
		iconCls: 'x_btn_document',
		btnsHide: { new: true, same: true, search: true, delete: true },
		//deleteCode: 'DOCREVIZ',
		fileColumn: true,
		handler: 'Keysystems.Base.List',
		checkUserError: true,
		getGridCfg: function () {
			var me = this,
				res = me.callParent(arguments);
			res.viewConfig = { getRowClass: function (r) { return r.get('ReadOnly') === false ? 'ks-editable' : ''; } };
			return res;
		},
		fileEdit: function (rec) {
			if (Keysystems.Base.List.prototype.isPrototypeOf(this) || rec.get('ReadOnly')) {
				if (rec.get('FILES')) this.downloadFile(rec);
			} else {
				this.callParent(arguments);
			}
		},
		getFileName: function (rec) {
			if (!rec) rec = this.data;
			var d = rec.get('DT');
			return Ext.String.format('{0} № {1} от {2}', rec.get('NAME'), rec.get('NUMBER'), Ext.isDate(d) ? Ext.Date.format(d, 'd_m_Y') : d);
		}
	},
	DOCUMENT_DOCREVIZ_VFA: {
		$parentCode: 'DOCUMENT_DOCREVIZ',
		profileCode: 'DOCUMENT_DOCREVIZ',
		linkCode: 'SDocumentReviz',
		isVfa: true,
		baseGetData: function (endFunc, params) {
			var me = this;

			me.whereArgs = params.whereArgs = params.whereArgs || {};
			params.whereArgs.isVfa = { value: (params.isVfa = me.isVfa) ? 'True' : 'False', type: 'bool' };

			return me.callParent(arguments);
		},
		beforeCreate: function (setts, callback) {
			Settings.getVfaSWork(setts, callback);
		}
	},
	DOCUMENT_DOCREVIZ_REPORT: {
		profileCode: 'DOCUMENT_DOCREVIZ',
		title: 'Отчет о выполнении плана',
		editClass: 'Keysystems.Documents.Edit.Reviz',
		linkCode: 'SDocumentReviz',
		iconCls: 'x_btn_document',
		readOnly: true,
		btnsHide: { new: true, same: true, search: true, journal: true, delete: true },
		fileColumn: true,
		checkUserError: true,
		whereArgs: { HideEmptyReviz: { value: 'True', type: 'bool' } },
		handler: 'Keysystems.Documents.Reviz.Report.List'
	},
	DOCUMENT_DOCREVIZ_REPORT_VFA: {
		$parentCode: 'DOCUMENT_DOCREVIZ_REPORT',
		profileCode: 'DOCUMENT_DOCREVIZ',
		linkCode: 'SDocumentReviz',
		isVfa: true,
		beforeCreate: function (setts, callback) {
			Settings.getVfaSWork(setts, callback);
		}
	},
	DOCUMENT_IFC_RECORD: {
		title: 'Карты ВФК',
		editClass: 'Keysystems.Record.Edit',
		linkCode: 'SRecord',
		iconCls: 'x_btn_document',
		deleteCode: 'IFC_RECORD',
		btnsHide: {
			show_actual: true,
			relations: true
		},
		handler: 'Keysystems.Record.List',
		checkUserError: true,
		getVisibleFields: function() {
			return '№ NUMBER от DATE_AT';
		}
	},
	DOCUMENT_IFC_RECORD_MOD: {
		title: 'Изменения в Карты ВФК',
		editClass: 'Keysystems.Record.Edit',
		linkCode: 'SRecordMod',
		iconCls: 'x_btn_document',
		deleteCode: 'IFC_RECORD_MOD',
		btnsHide: {
			show_actual: true,
			relations: true
		},
		handler: 'Keysystems.Record.List.Mod',
		checkUserError: true,
		getVisibleFields: function() {
			return '№ NUMBER от DATE_AT';
		}
	},
	DOCUMENT_IFC_REGISTER: {
		title: 'Регистры (журналы) ВФК',
		editClass: 'Keysystems.Register.Edit',
		linkCode: 'SRegister',
		iconCls: 'x_btn_document',
		deleteCode: 'IFC_REGISTER',
		handler: 'Keysystems.Register.List',
		getVisibleFields: function() {
			return '№ CODE от INSPECTION_ACTION_AT';
		}
	},
	DICTIONARY_IFC_S_PROCEDURE: {
		title: 'Бюджетные процедуры',
		editClass: 'Keysystems.Procedure.Edit',
		linkCode: 'SProcedure',
		deleteCode: 'IFC_S_PROCEDURE',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_IFC_S_PROCESS: {
		title: 'Процессы',
		editClass: 'Keysystems.Procedure.Edit.Processes',
		deleteCode: 'IFC_S_PROCESS',
		linkCode: 'SProcess',
		handler: 'Keysystems.Base.List'
	},
	DOCUMENT_OBJECTIONACT: {
		title: 'Результаты проверки',
		iconCls: 'x_btn_document',
		linkCode: 'SObjectionAct',
		editClass: 'Keysystems.ObjectionAct.Edit',
		btnsHide: { new: true, same: true, search: true },
		getRowClass: function (r) { return r.get('NextStatus') ? 'ks-editable' : ''; },
		columnsAdapted: function () {
			var cols = this.callParent(arguments),
				c = ArrayLib.filter(cols, ['dataIndex'], 'OBJECTIONT')[0];
			if (c) {
				c.align = 'center';
				c.renderer = Ext.grid.column.Check.prototype.renderer;
			}
			c = ArrayLib.filter(cols, ['dataIndex'], 'Акт')[0];
			if (c) {
				c = ArrayLib.filter(c.columns, ['dataIndex'], 'ACT_FILE')[0];
				if (c) {
					c.xtype = 'actioncolumn';
					c.align = 'center';
					c.items = [
						{
							getClass: function (v, m, r) { return getExtStyle(r.get('ACT_TEMP_EXT')); },
							handler: function (grid, rowIndex) {
								var file = grid.getStore().getAt(rowIndex).get('ACT_FILE');
								if (file) UploaderLib.getFile(file, 'Акт');
							}
						}
					];
				}
			}
			return cols;
		},
		handler: 'Keysystems.Base.List'
	},
	DOCUMENT_OBJECTIONACT_VFA: {
		$parentCode: 'DOCUMENT_OBJECTIONACT',
		profileCode: 'DOCUMENT_OBJECTIONACT',
		linkCode: 'SObjectionAct',
		isVfa: true,
		baseGetData: function (endFunc, params) {
			var me = this;

			me.whereArgs = params.whereArgs = params.whereArgs || {};
			params.whereArgs.isVfa = { value: (params.isVfa = me.isVfa) ? 'True' : 'False', type: 'bool' };

			return me.callParent(arguments);
		},
		beforeCreate: function (setts, callback) {
			Settings.getVfaSWork(setts, callback);
		}
	},
	DICTIONARY_IFC_S_CMETHOD: {
		title: 'Методы контроля',
		editClass: 'Keysystems.Base.Edit',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 20, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 500, enforceMaxLength: true },
		linkCode: 'SCMethod',
		deleteCode: 'IFC_S_CMETHOD',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_IFC_S_CTYPE: {
		title: 'Виды контроля',
		editClass: 'Keysystems.Base.Edit',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 20, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 500, enforceMaxLength: true },
		linkCode: 'SCType',
		deleteCode: 'IFC_S_CTYPE',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_IFC_S_CMODE: {
		title: 'Способы контроля',
		editClass: 'Keysystems.Base.Edit',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 20, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 500, enforceMaxLength: true },
		linkCode: 'SCMode',
		deleteCode: 'IFC_S_CMODE',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_IFC_S_CACTION: {
		title: 'Контрольные действия',
		editClass: 'Keysystems.Base.Edit',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 20, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 500, enforceMaxLength: true },
		linkCode: 'SCAction',
		deleteCode: 'IFC_S_CACTION',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_SMOSNOV: {
		title: 'Основания изменений',
		editClass: 'Keysystems.SMosnov.Edit',
		linkCode: 'SMOsnov',
		deleteCode: 'S_MOSNOV',
		handler: 'Keysystems.Base.List'
	},
	DOCUMENT_REVIZTASK: {
		editClass: 'Keysystems.RevizTask.Edit',
		linkCode: 'SRevizTask',
		iconCls: '',
		deleteCode: 'DOCUMENT_REVIZTASK',
		handler: 'Keysystems.RevizTask.List'
	},

	DICTIONARY_SAUTHORITY: {
		title: 'Полномочия',
		editClass: 'Keysystems.SAuthority.Edit',
		linkCode: 'SAuthority',
		deleteCode: 'S_AUTHORITY',
		handler: 'Keysystems.Base.List.Tree'
	},
	DOCUMENT_ADMPROCS: {
		title: 'Административное производство',
		iconCls: 'x_btn_document',
		editClass: 'Keysystems.Reviz.Edit',
		linkCode: 'SAdmprocs',
		handler: 'Keysystems.Admprocs.List'
	},
	DICTIONARY_SACTIVITY_INDEX: {
		title: 'Показатели деятельности объектов контроля',
		editClass: 'Keysystems.SActivityIndex.Edit',
		linkCode: 'SActivityIndex',
		deleteCode: 'DICTIONARY_SACTIVITY_INDEX',
		handler: 'Keysystems.Base.List.Tree',
		columnsAdapted: function () {
			let me = this,
				cols = this.callParent(arguments);
			if (me.mColumn) {
				me.mColumn.on('beforecheckchange', function (th, inx, check, rec) {
					return rec.data.TYPE != null && rec.data.TYPE !== 5;
				})
			}
			return cols;
		},
		checkRenderer: function (val, meta, rec) {
			if (rec.data.TYPE == null || rec.data.TYPE === 5)
				meta.tdCls += ' ' + this.disabledCls;
		}
	},
	DOCUMENT_ORG_ACTIVITY:{
		linkCode: 'SOrgActivity',
		editClass: 'Keysystems.OrgActivity.Edit',
		getViewTitle: function() {
			var me = this;

			return me.group + ' - ' + ((me.readOnly || me.f === 'readOnly') ? 'только просмотр' : (me.f === 'edit' ? 'редактирование' : 'создание'));
		}
	},
	DOCUMENT_OBJECTACTIVITY: {
		title: 'Показатели деятельности объектов контроля',
		editClass: 'Keysystems.OrgActivity.Edit',
		iconCls: 'x_btn_revizobjectinfo',
		linkCode: 'SOrgActivity',
		handler: 'Keysystems.OrgActivity.List'
	},
	DOCUMENT_RISKINFO: {
		title: 'Оценка рисков',
		iconCls: 'x_btn_risk_assessment',
		linkCode: 'SRiskInfo',
		handler: 'Keysystems.RiskInfo.List'
	},
	DICTIONARY_SKLON: {
		title: 'Справочник склонений',
		iconCls: 'x_btn_edit',
		linkCode: 'SSklon',
		handler: 'Keysystems.Sklon.List',
		isFake: true
	},
	DICTIONARY_SFIASREGION: {
		handler: 'Keysystems.Base.List',
		title: 'Субъекты РФ',
		linkCode: 'SFiasRegion',
		deleteCode: 'S_FIASREGION'
	},
	DICTIONARY_SFIASAREA: {
		title: 'Районы',
		handler: 'Keysystems.Base.List',
		linkCode: 'SFiasArea',
		deleteCode: 'S_FIASAREA'
	},
	DICTIONARY_SFIASCITY: {
		title: 'Города',
		handler: 'Keysystems.Base.List',
		linkCode: 'SFiasCity',
		deleteCode: 'S_FIASCITY'
	},
	DICTIONARY_SFIASPLACE: {
		title: 'Населенные пункты',
		handler: 'Keysystems.Base.List',
		linkCode: 'SFiasPlace',
		deleteCode: 'S_FIASPLACE'
	},
	DICTIONARY_SFIASSTREET: {
		title: 'Улицы',
		handler: 'Keysystems.Base.List',
		linkCode: 'SFiasStreet',
		deleteCode: 'S_FIASSTREET'
	},
	DICTIONARY_SFIASHOUSE: {
		title: 'Дома',
		handler: 'Keysystems.Base.List',
		linkCode: 'SFiasHouse',
		deleteCode: 'S_FIASHOUSE'
	},
	DICTIONARY_SFIASROOM: {
		title: 'Помещения',
		handler: 'Keysystems.Base.List',
		linkCode: 'SFiasRoom',
		deleteCode: 'S_FIASROOM'

	},
	DICTIONARY_NARREMOVE: {
		title: 'Требования по устранению',
		iconCls: 'x_btn_edit',
		linkCode: 'SNarremove',
		handler: 'Keysystems.Base.List'
	},
	DICTIONARY_EOD_PREVIEW_LIST: {
		title: 'Предварительный просмотр',
		iconCls: 'x_btn_edit',
		linkCode: 'SEodPreview',
		handler: 'Keysystems.Base.List.Tree'
	},
	DICTIONARY_DF_S_TASK: {
		title: 'Виды задач',
		editClass: 'Keysystems.DFSTask.Edit',
		isCodeEdit: true,
		codeEditCfg: { maxLength: 50, enforceMaxLength: true },
		isNameEdit: true,
		nameEditCfg: { maxLength: 800, enforceMaxLength: true },
		linkCode: 'SDfSTask',
		deleteCode: 'DF_S_TASK',
		handler: 'Keysystems.Base.List',
		fileColumn: true,
	},
	DOCUMENT_DF_DOCUMENTS: {
		title: 'Регистрация документов',
		iconCls: 'x_btn_message_new',
		linkCode: 'SDfDocuments',
		handler: 'Keysystems.DFDocuments.List',
		editClass: 'Keysystems.DFDocuments.Edit',
		checkUserError: true,
		getVisibleFields: function() {
			return '№ RNUMBER от RDT';
		}
	},
	DOCUMENT_DF_DOCCORR: {
		title: 'Корреспонденты документооборота',
		linkCode: 'SDfDocCorr',
		handler: 'Keysystems.Base.List',
		editClass: 'Keysystems.DFDocCorr.Edit',
	},
	DOCUMENT_DF_TASK: {
		title: 'Задачи документооборота',
		linkCode: 'SDfTask',
		handler: 'Keysystems.DFTask.List',
		editClass: 'Keysystems.DFTask.Edit',
	},
	DICTIONARY_USERS_ADM: {
		title: 'Пользователи',
		iconCls: 'x_btn_copy',
		linkCode: 'SUsersAdm',
		editClass: 'Keysystems.UsersAdm.Edit',
		handler: 'Keysystems.UsersAdm.List',
		isFake: true
	},
	DICTIONARY_GROUPS_ADM: {
		title: 'Группы пользователей',
		iconCls: 'x_btn_copy',
		linkCode: 'SGroupsAdm',
		editClass: 'Keysystems.GroupsAdm.Edit',
		handler: 'Keysystems.GroupsAdm.List',
		isFake: true
	},
	DICTIONARY_BPMS_DIVISION: {
		title: 'Подразделения',
		linkCode: 'SBPMSDivision',
		handler: 'Keysystems.BPMSDivision.List',
		isFake: true
	},
	DICTIONARY_EDS_LEVEL: {
		title: 'Уровни ЭЦП',
		linkCode: 'SEDSLvl',
		handler: 'Keysystems.EDSLvl.List',
		isFake: true
	},
	DICTIONARY_ARM: {
		title: 'АРМ',
		iconCls: 'x_btn_copy',
		linkCode: 'SArm',
		handler: 'Keysystems.Arm.List',
		isFake: true
	},
	DICTIONARY_USERS_TEMPLATE_ADM: {
		title: 'Шаблоны создания пользователей',
		iconCls: 'x_btn_copy',
		linkCode: 'SUsersTemplate',
		handler: 'Keysystems.UsersTemplate.List',
		isFake: true
	},
	DICTIONARY_COMPLEX_LIST: {
		title: 'Список комплексов',
		iconCls: 'x_btn_copy',
		linkCode: 'SComplexList',
		handler: 'Keysystems.ComplexList.List',
		isFake: true
	},
	DICTIONARY_OBJECT_FIELDS: {
		title: 'Поля документа',
		handler: 'Keysystems.Base.List',
		isFake: true
	},

	REPORT_EDS_LIST: {
		linkCode: 'SReportEds',
		title: 'Список ЭП отчетов',
		handler: 'Keysystems.Base.List',
		
	},
	DOCUMENTS_EDS_LIST: {
		linkCode: 'SDocumentsEds',
		title: 'Список ЭП документов',
		handler: 'Keysystems.Base.List',
	},
	DF_DOCUMENTS_EDS_LIST: {
		linkCode: 'SDfDocumentsEds',
		title: 'Список ЭП регистрации документов',
		handler: 'Keysystems.Base.List',
	},
	FILES_EDS_LIST: {
		linkCode: 'SFilesEds',
		title: 'Список ЭП документов файлов',
		handler: 'Keysystems.Base.List',
	},
	DOC_REPORT_EDS: {
		linkCode: 'SReportSign',
		title: 'Сохраненные отчеты',
		deleteCode: 'DOC_REPORT_EDS',
		handler: 'Keysystems.Reports.Sign.List',
		editClass: 'Keysystems.Reports.Sign.Edit'	
	}
};

const EODListController = {
	EOD_OUT_BASE: {
		text: 'Передача',
		handler: function () {
		}
	},
	EOD_IN_SPODRAZDEL: {
		text: 'Подразделы',
		handler: function () {
		}
	},
	EOD_IN_SMINVO: {
		text: 'Главы',
		handler: function () {
		}
	},
	EOD_IN_SCST: {
		text: 'Целевые статьи',
		handler: function () {
		}
	},
	EOD_IN_SST: {
		text: 'Экономические статьи',
		handler: function () {
		}
	},
	EOD_IN_SRASH: {
		text: 'Виды расходов',
		handler: function () {
		}
	},
	EOD_IN_SADDBK: {
		text: 'Доп. классификация',
		handler: function () {
		}
	},
	EOD_IN_SKLADR: {
		text: 'Классификатор адресов',
		handler: function () {
		}
	},
	EOD_IN_CONVERTER: {
		text: 'Конвертер',
		handler: function () {
		}
	},
	EOD_IN_REESTR: {
		text: 'Организации',
		handler: function () {
		}
	},
	EOD_IN_BASE: {
		text: 'Прием',
		handler: function () {
		}
	},
	EOD_IN_FINANC: {
		text: 'Финансирование',
		handler: function () {
		}
	}
};

window.tasks = {
	'Revizor.List.New': 'new',
	'Revizor.List.NewSelf': 'newSelf',
	'Revizor.List.NewSame': 'newSame',
	'Revizor.List.Edit': 'doEdit',
	'Revizor.List.Delete': 'delete',
	'Revizor.List.Refresh': 'doRefresh',
	'Revizor.List.Print': 'Print',
	'Revizor.List.SearchList': 'search',
	'Revizor.List.ClearFilter': 'undo',
	'Revizor.List.SetAutoFilter': 'doAutoFilter',
	'Revizor.List.ShowRelations': 'showRelations',
	'Revizor.List.ShowActual': 'doShowActual',
	'Revizor.List.BatchChange' : 'doBatchChange',
	'Revizor.Events.List': 'showEventLogList',
	'Revizor.Events.ListByObject': 'showEventLogList',
	'Revizor.Events.ListByLink': 'showEventLogByLink',

	'Revizor.List.SelectInverse': 'checkInversion',
	'Revizor.List.SelectAll': 'checkAll',
	'Revizor.List.CheckFromStartTillCurrent': 'checkFstToSel',
	'Revizor.List.CheckFromCurrentTillEnd': 'checkSelToLst',
	'Revizor.List.CheckBeetwenSelected': 'checkCheckToCheck',
	'Revizor.List.CheckSelected': 'checkSelection',
	'Revizor.List.UnSelectPage': 'uncheckAllFromPage',
	'Revizor.List.UnSelectAll': 'uncheckAll',
	'Revizor.List.ShowColumnChooser': 'showColumnManager',
	'Revizor.List.Wrap': 'enableWrap',
	'Revizor.List.ExpandAll': 'expandAll',
	'Revizor.List.CollapseAll': 'collapseAll',
	'Revizor.List.RowLevelDown': 'treechangeHandler',
	'Revizor.List.RowLevelUp': 'makeParent',
	'Revizor.List.Top': 'moveTop',
	'Revizor.List.Up': 'moveUp',
	'Revizor.List.Down': 'moveDown',
	'Revizor.List.Bottom': 'moveBottom',
	'Revizor.List.Sign': 'sign',	
	'Revizor.List.UnSign': 'unSign',
	'Revizor.List.SignList': 'signList',
	'Revizor.List.SignInfo': 'signInfo',
	'Revizor.List.ExtSignInfo': 'extSignInfo',
	'Revizor.Documents.List.Sign': 'sign',
	'Revizor.Documents.List.UnSign': 'unSign',
	'Revizor.Show.InList': 'showInList',
	'Revizor.Edit': 'editWithoutList',

	'Revizor.Reviz.AlienCreate': 'createReviz',
	'Revizor.Reviz.AlienEdit': 'doEditReviz',
	'Revizor.Reviz.AddPlan': 'revizAddFromPlan',
	'Revizor.Reviz.AddRepair': 'revizAddRepair',
	'Revizor.Reviz.AddRepairPlan': 'revizAddRepairPlan',
	'Revizor.Reviz.AddFromRevizTask': 'revizAddFromTask',
	'Revizor.Reviz.Edit': 'doEdit',
	'Revizor.Reviz.Recalc': 'recalcMsg',
	'Revizor.Reviz.AddFromInfo': 'revizAddFromInfo',
	'Revizor.Reviz.EditFromInfo': 'revizEditFromInfo',
	'Revizor.Reviz.DeleteFromInfo': 'revizDeleteFromInfo',
	
	'Revizor.Documents.Edit': 'doEdit',

	'Revizor.Factnar.Edit': 'doEdit',

	'Revizor.PlanProj.Info': 'planProjInfo',
	'Revizor.Plan.List.PrintReport': 'planPrintReport',	
	'Revizor.PlanMod.TreeAdd': 'modTreeAdd',
	'Revizor.PlanMod.TreeEdit': 'modTreeEdit',
	'Revizor.PlanMod.TreeDel': 'modTreeDelete',
	'Revizor.PlanCentral.ChangeStatus': 'batchChangeStatus',

	'Revizor.Orders.AddPlanReviz': 'ordersAddPlanReviz',
	'Revizor.Orders.AddReviz': 'ordersAddReviz',

	'Revizor.Appeals.AddPlanReviz': 'ordersAddPlanReviz',
	'Revizor.Appeals.AddReviz': 'ordersAddReviz',
	'Revizor.Appeals.BindReviz': 'ordersBindReviz',
	
	'Revizor.Record.TreeEdit': 'modTreeEdit',

	'Revizor.Info.Add': 'new',
	'Revizor.Info.Edit': 'doEdit',
	'Revizor.Info.Same': 'newSame',
	
	'Revizor.ObjectActivity.ShowActual': 'showActual',
	'Revizor.List.Rang': 'showRangForm',
	'Revizor.List.RecalcRang': 'recalc',
	'Revizor.List.Rang.ShowActual': 'showActual',
	
	'Revizor.RevizTask.New': 'new',
	'Revizor.RevizTask.Edit': 'doEdit',

	'Revizor.List.Close': 'doClose',
	'Revizor.List.OutEod': 'send',
	'Revizor.ExportFromProtocol': 'sendEsgfk',//пока под кнопкой передачи нет ничего кроме выгрузки в ГИС ЕСГФК, ставим на нее функционал выгрузки в ГИС ЕСГФК и переименовываем в "выгрузку в гис есгфк"
	//'Revizor.Integration.SendGis': 'sendEsgfk', //это непоср. кнопка выгрузки в гис есгфк, но пока ее уберем, т.к. мы накинули выгрузку в гис есгфк на главную кнопку
	'Revizor.Integration.SendGisHistory': 'showEsgfkEventLog',

	'Revizor.Integration.SyncDict': 'syncDictEsgfk',
	'Revizor.Integration.SaveSyncDict': 'saveSyncData',
	'Revizor.Integration.AutoSyncDict': 'autoSyncDict',

	'Revizor.DfDocuments.New': 'new',
	'Revizor.DfDocuments.NewSelf': 'newSelf',
	'Revizor.DfDocuments.RegisterDoc': 'registerDoc',
	'Revizor.DfDocuments.OpenDoc': 'doEditDoc',
	'Revizor.DfDocuments.DelDocRel': 'deleteDocRelation',
	'Revizor.DfDocuments.Task.New': 'newFromDfdoc',

	'Revizor.DFTask.List.PrintReport': 'dfTaskPrintReport',

	'Revizor.Contract.NewSame': 'newSameContract',
	
	'Revizor.Reports.Sign.New': 'new',
	'Revizor.Reports.Sign.ShowNote': 'showNote',
	'Revizor.Reports.Sign.EditNote': 'editNote',
	'Revizor.Reports.Sign.Open': 'open',
	'Revizor.Reports.Sign.Edit': 'doEdit',
	'Revizor.Reports.Sign.SaveAs': 'saveAs',

	'MailNew': 'mailNewTask',
	'MailRead': 'mailReadTask',
	'MailRefresh': 'mailRefreshTask',
	'MailReply': 'mailReplyTask',
	'MailReplyAll': 'mailReplyAllTask',
	'MailForward': 'mailForwardTask',
	'MailDelete': 'mailDeleteTask',
	'MailCompactView': 'mailCompactViewTask',
	'MailFullView': 'mailFullViewTask',
	'MailSwitchReadArea': 'mailSwitchReadAreaTask',

	'Meta.Document.New': 'new',
	'Meta.Users.Batch': 'batchCreation',
	'Meta.Document.EditUser': 'doEdit',
	'Meta.Users.Restore': 'restoreUser',
	'Budget.Document.BatchReplacement': 'batchReplacement',
	'Meta.Document.Copy': 'newSame',
	'Meta.Document.Delete': 'delete',
	'Meta.Users.Lock': 'lockUser',
	'Meta.Users.Unlock': 'unlockUser',
	'Meta.Users.LockLogin': 'lockLogin',
	'Meta.Users.UnlockLogin': 'unlockLogin',
	'Core.Grid.SelectInverse': 'checkInversion',
	'Core.Grid.SelectAll': 'checkAll',
	'Core.Grid.CheckFromStartTillCurrent': 'checkFstToSel',
	'Core.Grid.CheckFromCurrenttTillEnd': 'checkSelToLst',
	'Core.Grid.CheckBeetwenSelected': 'checkCheckToCheck',
	'Core.Grid.UnSelectAll': 'uncheckAll',
	'Meta.Print.List': 'Print',
	'Meta.Users.Print': 'printUsers',
	'Meta.Users.Export': 'exportUsers',
	'Meta.Users.EventsLog': 'showEventLogList',
	'Meta.Users.Access': 'userAccess',
	'Meta.Users.Arm': 'userArm',
	'Meta.Document.UpdateList': 'doRefresh',
	
	'Meta.Document.Edit': 'doEdit',
}

window.dnl = dnl;

window.dictListController = dictListController;

window.EODListController = EODListController;


export {
	dictListController,
	dnl,
	EODListController
}

export default dnl;