﻿Ext.define('Keysystems.QuickTip', {
	extend: 'Ext.tip.ToolTip',
	focusOnToFront: true,
	formBind: true,
	iconCls: 'x_btn_errorX',
	quickCls: 'x-keysystems-quickTip',
	autoHide: false,
	closable: true,
	width: 200,
	titleAlign: 'left',	
	height: 30,
	hideDelay1: 5000,
	closeAction: 'hide',
	defaultAlign: 'br',
	shadow: window.Theme !== 'crisp',
	userCls: 'ks-quicktip',
	anchor: window.app,
	onMouseMove: function (e) {
		var me = this;
		if (me.el && !me.hidden) {
			me.targetXY = e.getXY();
			var box = me.el.getBox();

			if (box.left <= me.targetXY[0] && box.right >= me.targetXY[0] && box.top <= me.targetXY[1] && box.bottom >= me.targetXY[1]) {
				me.clearTimer('hide');
				return;
			}
		}
		me.delayHide1();
	},
	delayHide1: function () {
		var me = this;
		if (!me.hidden && !me.hideTimer) {
			me.hideTimer = setTimeout(function () {
				delete me.hideTimer;
				me.hide();
			}, me.hideDelay1);
		}
	},
	setIconCls: function (iconCls) {
		this.callParent([this.quickCls + ' ' + iconCls]);
	},

	//по умолчанию в ext71 тултип прилипает к краям области anchor, в ext4 был отступ, зададим и в 71 
	getBox: function(contentBox, local) {
		var box = this.callParent([contentBox, local]);
		if (this.defaultAlign === 'br') {
			if (box.left) box.left -= 10;
			if (box.top) box.top -= 10;
		}
		return box;
	},
	showBy: function (cfg) {
		var me = this;	
		if (cfg) {
			if (cfg.title) {
				me.setTitle(cfg.title);
			}
			if (cfg.iconCls) {
				me.setIconCls(cfg.iconCls);
			}
			if (cfg.hideDelay) {
				me.hideDelay1 = cfg.hideDelay;
			}
			if (cfg.height) {
				me.setHeight(cfg.height);
			}
			if (cfg.width) {
				me.setWidth(cfg.width);
			}
			if (cfg.hideDelay) {
				me.hideDelay1 = cfg.hideDelay;
			}
			if (cfg.position) {
				me.defaultAlign = cfg.position;
			}
		}

		me.callParent([cfg.component || window.app, cfg.position || 'br']);
		me.delayHide1();
	}
});

window.QuickTip = {
	tip: Ext.create('Keysystems.QuickTip'),
	show: function(cfg) {
		if (QuickTip.lastCfg &&
			QuickTip.lastCfg.title === cfg.title &&
			performance.now() - QuickTip.callTime < 2000.00) {
			//В случае если пользователь слишком часто (3 сек) получает сообщение выводим информационное окно
			info(cfg.title);
		} else {
			//При первом показе фиксируем время отрисовки
			QuickTip.lastCfg = cfg;
			QuickTip.callTime = performance.now();
		}

		QuickTip.tip.showBy(cfg);
	},
	hide: function() { QuickTip.tip.hide(); },
	delayHide: function() { QuickTip.tip.delayHide1(); }
};

window.QuickMsgs = {
	save: function() { QuickTip.show({ title: 'Сохранено', hideDelay: 2000, iconCls: 'x_btn_ok' }); },
	notSave: function () { QuickTip.show({ title: 'Не сохранено', hideDelay: 2000, iconCls: 'x_btn_errorX' }); },
	ReportDeleted: function () { QuickTip.show({ title: 'Задача снята', hideDelay: 2000, iconCls: 'x_btn_ok' }); },
	showSuccess: function(text) { QuickTip.show({ title: text, hideDelay: 2000, iconCls: 'x_btn_ok' }); },
};