﻿import {dnl} from './TableListController';

var NavigatorLib = {

	fireCloseNext: function (th, c) {
		let me = this;
		if (c.nextItemClose) {
			th.tabPanel.setActiveTab(c.nextItemClose.tab);
			c.nextItemClose.close();
		}
		else if (c.isCurr)
			NavigatorLib.cleanData();
	},

	cleanData: function () {
		ajaxRequest({
			url: 'Data/CleanData_A',
			success: function() {
				let me = this;
				info(wmc.get('SuccessCleanData'));
				try
				{
					window.tabView.tabBar.un('remove', NavigatorLib.fireCloseNext);
				}
				catch{}
			}
		});
	},
	
	cleanDataHandler: function() {
		const me = this;
		let tabsForClose = window.tabView.items.items.find(
			function (item) {
				return (item.code && window.dictListController[item.code]
					&& (!item.tabID || (!item.tabID.includes('ACCESS_') && !item.tabID.includes('SETTINGS_'))));
			}
		)
		let msg = '';
		if (tabsForClose)
			msg = wmc.getQuestion('QCloseTabsCleanData')
		else
			msg = wmc.getQuestion('QCleanData')
		
		selectDialogShow(wmc.get('CleanData'),
			msg,
			function() {
				me.cleanLocalData();
				
				let items = window.tabView.items.items;
				let tBar = window.tabView.tabBar;
				if (items.length > 0){
					let prev = null;
					let curr = null;
					let last = null;
					let tmp = null;
					for (let i = items.length - 1; i >= 0; i--) {
						if (items[i].code && window.dictListController[items[i].code] && (!items[i].tabID
							|| ['ACCESS_', 'SETTINGS_', 'PLT_'].every(v => items[i].tabID.indexOf(v) !== -1)))
						{
							if (!last)
								last = items[i];
							tmp = prev;
							prev = curr;
							curr = items[i];
							if (curr && prev) {
								prev.tab.nextItemClose = curr;
							}
						}
					}
					if (curr) {
						curr.tab.isCurr = true;
						tBar.on('remove', NavigatorLib.fireCloseNext);
					}
					if (last){
						last.close();
					}
					else {
						NavigatorLib.cleanData();
					}
				}
				else {
					NavigatorLib.cleanData();
				}
			});
	},
	/**
	 * Почистить клиентский кэш
	 */
	cleanLocalData: function(){
		cacheEngine.clear();
		LocalStorage.clear();
		Settings.settingsTable = {};
		PageDataLib.clear();
		Keysystems.Revizor.Mail.resetData();
	},
	contextMenuGen: function() {
		var me = this,
			objs = {},
			seps = {},
			createRenameFolder = function(cfg) {
				Ext.create('Keysystems.Comment',
					{
						title: wmc.get('RevizorSmart'),
						labelText: cfg.labelText ?? wmc.get('LabelCreateFolder'),
						initText: cfg.initText ?? 'Новый каталог',
						minHeight: 128,
						minWidth: 420,
						textAreaHeight: 50,
						textAreaWidth: 408,
						okFn: function () {
							const name = this.textArea.getValue();
							const mask = new Ext.LoadMask({
								msg: cfg.msg ?? wmc.get('CreateFolder'),
								target: window.objs.navigator,
								autoShow: true,
								rid: ajaxRequest({
									url: cfg.url ?? 'SNavigator/CreateFolder_A',
									params: {
										link: cfg.link,
										name: name,
										mode: cfg.mode,
										isOuter: window.isOuter
									},
									success: function(res) {
										if (Object.keys(res).length) {
											NavigatorLib.expanded(res.children);
											me.btns = res;

											window.objs.subNavigator.getStore().setRootNode({
												expanded: true,
												children: me.createTreeItems(res)
											});
										} else {
											Ext.MessageBox.alert("Error", cfg.errText ?? wmc.get('ErrorCreateFolder'));
										}
									},
									failure: function() {
										Ext.MessageBox.alert("Error", cfg.errText ?? wmc.get('ErrorCreateFolder'));
									},
									callback: function() {
										mask.destroy();
									}
								})
							});
						}
					}).show();
			},
			moveNode = function(link, linkW) {
				const mask = new Ext.LoadMask({
					msg: wmc.get('ShiftNode'),
					view: window.objs.navigator,
					autoShow: true,
					rid: ajaxRequest({
						url: 'SNavigator/ShiftNode_A',
						params: {
							link,
							linkW,
							isOuter: window.isOuter
						},
						success: function(res) {
							if (!res.error.length) {
								NavigatorLib.expanded(res.navigator.children);
								me.btns = res.navigator;

								window.objs.subNavigator.getStore().setRootNode({
									expanded: true,
									children: me.createTreeItems(res.navigator)
								});
							} else {
								Ext.MessageBox.alert("Error", wmc.get('ErrorShiftNode'));
								console.error(res.error);
							}
						},
						failure: function() {
							Ext.MessageBox.alert("Error", wmc.get('ErrorShiftNode'));
						},
						callback: function() {
							mask.destroy();
						}
					})
				});
			},
			contextMenu = Ext.create('Ext.menu.Menu',
				{
					showNodes: function(codes) {
						for(var obj in objs) {
							objs[obj].setHidden(codes.indexOf(obj) === -1);
							if (seps.hasOwnProperty(obj)) {
								seps[obj].setHidden(codes.indexOf(obj) === -1);
							}
						}

						// дизейблим кнопки Вверх и Вниз
						var rec = window.objs.subNavigator.getSelectionModel().getSelection()[0],
							type = rec.data.item.NodeType.split('_').slice(0, 2).join('_'),
							allNodes = [];
						
						Ext.each(rec.parentNode.childNodes, function(node) {
							if (node.data.item.NodeType.indexOf(type) !== -1) {
								allNodes.push(node);
							}
						});
						
						var index = allNodes.indexOf(rec);
						objs.BUTTON_NTP_UP.setDisabled(index - 1 < 0);
						objs.BUTTON_NTP_DOWN.setDisabled(index + 1 > allNodes.length - 1);
					},
					items: [
						objs.BUTTON_NTP_FOLDER_ADD = new Ext.Action({
							iconCls: 'x_btn_folder_add',
							text: 'Создать личный каталог',
							hidden: true,
							handler: function() {
								createRenameFolder({
									link : '',
									mode: 'create_folder'
								});
							}
						}),
						objs.BUTTON_NTP_SUBFOLDER_ADD = new Ext.Action({
							text: 'Создать подкаталог',
							hidden: true,
							handler: function() {
								var rec = window.objs.subNavigator.getSelectionModel().getSelection()[0];
								createRenameFolder({
									link : rec.data.link,
									mode: ''
								});
							}
						}),
						seps.BUTTON_NTP_SUBFOLDER_ADD = new Ext.menu.Separator({ hidden: true }),
						objs.BUTTON_NTP_OPEN = new Ext.Action({
							text: 'Открыть',
							iconCls: 'x_btn_folder_open',
							hidden: true,
							handler: function() {
								var rec = window.objs.subNavigator.getSelectionModel().getSelection()[0];
								if (rec && rec.raw && rec.raw.handler) rec.raw.handler();
							}
						}),
						objs.BUTTON_NTP_DELETE = new Ext.Action({
							text: 'Удалить',
							iconCls: 'x_btn_delete',
							hidden: true,
							handler: function() {
								var rec = window.objs.subNavigator.getSelectionModel().getSelection()[0];
								Ext.Msg.show({
									title: 'Ревизор-СМАРТ',
									msg:  wmc.get('DeleteNodeQuestion', rec.data.text),
									buttons: Ext.MessageBox.OKCANCEL,
									buttonText: { ok: 'Да', cancel: 'Нет' },
									fn: function(buttonId) {
										if (buttonId === 'ok') {
											const mask = new Ext.LoadMask({
												msg: wmc.get('DeleteNode'),
												view: window.objs.navigator,
												autoShow: true,
												rid: ajaxRequest({
													url: 'SNavigator/DeleteNode_A',
													params: {
														link: rec.data.link,
														isOuter: window.isOuter
													},
													success: function(res) {
														if (Object.keys(res).length) {
															NavigatorLib.expanded(res.children);
															me.btns = res;

															window.objs.subNavigator.getStore().setRootNode({
																expanded: true,
																children: me.createTreeItems(res)
															});
														} else {
															Ext.MessageBox.alert("Error", wmc.get('ErrorDeleteNode'));
														}
													},
													failure: function() {
														Ext.MessageBox.alert("Error", wmc.get('ErrorDeleteNode'));
													},
													callback: function() {
														mask.destroy();
													}
												})
											});
										}
									},
									icon: Ext.MessageBox.QUESTION
								});
							}
						}),
						objs.BUTTON_NTP_RENAME = new Ext.Action({
							text: 'Переименовать',
							iconCls: 'x_btn_rename',
							hidden: true,
							handler: function() {
								var rec = window.objs.subNavigator.getSelectionModel().getSelection()[0];
								createRenameFolder({
									labelText: wmc.get('LabelRenameFolder'),
									initText: rec.data.text,
									msg: wmc.get('RenameNode'),
									url: 'SNavigator/RenameNode_A',
									link: rec.data.link,
									mode: '',
									errText: wmc.get('ErrorRenameNode')
								});
							}
						}),
						seps.BUTTON_NTP_RENAME = new Ext.menu.Separator({ hidden: true }),
						objs.BUTTON_NTP_UP = new Ext.Action({
							text: 'Вверх',
							iconCls: 'x_btn_up',
							hidden: true,
							handler: function() {
								var rec = window.objs.subNavigator.getSelectionModel().getSelection()[0],
									index = rec.parentNode.childNodes.indexOf(rec),
									prevRec = rec.parentNode.childNodes[index - 1];
								moveNode(rec.data.item.NodeId, prevRec.data.item.NodeId);
							}
						}),
						objs.BUTTON_NTP_DOWN = new Ext.Action({
							text: 'Вниз',
							iconCls: 'x_btn_down',
							hidden: true,
							handler: function() {
								var rec = window.objs.subNavigator.getSelectionModel().getSelection()[0],
									index = rec.parentNode.childNodes.indexOf(rec),
									nextRec = rec.parentNode.childNodes[index + 1];
								moveNode(rec.data.item.NodeId, nextRec.data.item.NodeId);
							}
						}),
						objs.desktopAddBtn = Ext.create('Ext.Action',
							{
								hidden: true,
								iconCls: 'x_btn_desktop',
								text: 'Добавить на рабочий стол',
								handler: function() {
									var rec = window.objs.subNavigator.getSelectionModel().getSelection()[0];
									if (rec && rec.raw && Desktop.UI.items.length)
										Desktop.UI.items[0].addWidget(rec.raw.item);
								}
							}),
						seps.BUTTON_NTP_NASTR = new Ext.menu.Separator({ hidden: true }),
						objs.BUTTON_NTP_NASTR = Ext.create('Ext.Action',
							{
								hidden: true,
								iconCls: 'x_btn_settings',
								text: 'Настройка',
								handler: function() {
									var rec = window.objs.subNavigator.getSelectionModel().getSelection()[0];
									if (rec) Settings.show(rec.raw.code, rec.raw.text);
								}
							}),
						objs.BUTTON_NTP_ACCESS = new Ext.Action({
							iconCls: 'x_btn_key',
							text: 'Права доступа',
							hidden: true,
							handler: function() {
								let rec = window.objs.subNavigator.getSelectionModel().getSelection()[0];
								if (rec) ObjAccess.show(rec.raw.code, rec.raw.text);
							}
						}),
						seps.BUTTON_VARIANT_PROFILE_ADD = new Ext.menu.Separator({ hidden: true }),
						objs.BUTTON_VARIANT_PROFILE_ADD = new Ext.Action({
							iconCls: 'x_btn_squery_filter',
							text: 'Добавить вариант',
							hidden: true,
							handler: function() {
								var rec = window.objs.subNavigator.getSelectionModel().getSelection()[0];
								
								Ext.create('Keysystems.Comment',
									{
										title: wmc.get('RevizorSmart'),
										labelText: wmc.get('LabelAddVariant'),
										initText: rec.data.text,
										minHeight: 140,
										minWidth: 420,
										okFn: function () {
											let name = this.textArea.getValue();
											if (['DOCUMENT_OBJECTIONACT', 'DOCUMENT_DOCREVIZ'].indexOf(rec.data.code) !== -1)
											{
												Ext.MessageBox.alert("Error", wmc.get('ErrorExceptAddVariant', name));
												return;
											}
											
											if (name === rec.data.text) {
												Ext.MessageBox.alert("Error", wmc.get('ErrorDifAddVariant', name));
												return;
											}

											if (name.length > 254)
											{
												name = name.slice(0, 254);
											}

											const mask = new Ext.LoadMask({
												msg: wmc.get('AddVariant'),
												view: window.objs.navigator,
												autoShow: true,
												rid: ajaxRequest({
													url: 'SNavigator/AddVariant_A',
													params: {
														link: rec.data.link,
														linkParent: rec.parentNode.data.link,
														name,
														code: rec.data.code,
														isOuter: window.isOuter
													},
													success: function(res) {
														// обновленные данные навигатора
														if (Object.keys(res.navigator).length) {
															NavigatorLib.expanded(res.navigator.children);

															me.btns = res.navigator;

															window.objs.subNavigator.getStore().setRootNode({
																expanded: true,
																children: me.createTreeItems(res.navigator)
															});
														}
														
														if (!res.showWindow) return;
														// Форма фильтрации
														Ext.create('Revizor.FilterView',
														{
															title: rec.data.text + ' - Фильтр',
															filter: res.filter,
															closeAction: 'hide',
															ok: function() {
																let parsVariant = this.filter.slice();
																Ext.each(parsVariant, pv => {
																	// свойство мешает для сериализации
																	delete pv.fieldCondition;
																	
																	if (miscTypes.ControlType[pv.ControlType] === 'Dictionary') {
																		pv.Value = Ext.isArray(pv.Value) 
																			? JSON.stringify(pv.Value.map(v=>(v.data ?? v).LINK))
																			: "[]";
																	}
																});

																const maskSave = new Ext.LoadMask({
																	msg: wmc.get('SaveFilterVariant'),
																	view: window.objs.navigator,
																	autoShow: true,
																	rid: ajaxRequest({
																		url: 'SNavigator/SaveFilterVariant_A',
																		params: {
																			code: rec.data.code,
																			variantID: res.variantID,
																			filter: JSON.stringify(parsVariant)
																		},
																		success: function (res) {
																			if (res.error.length) {
																				Ext.MessageBox.alert("Error", wmc.get('ErrorSaveFilterVariant'));
																			}
																		},
																		failure: function () {
																			Ext.MessageBox.alert("Error", wmc.get('ErrorSaveFilterVariant'));
																		},
																		callback: function() {
																			maskSave.destroy();
																		}
																	})
																});
															}
														}).show();
													},
													failure: function() {
														Ext.MessageBox.alert("Error", wmc.get('ErrorAddVariant'));
													},
													callback: function() {
														mask.hide();
													}
												})
											});
										}
									}).show();
							}
						}),
						seps.BUTTON_CLEAR_PROFILE = new Ext.menu.Separator({ hidden: true }),
						objs.BUTTON_CLEAR_PROFILE = new Ext.Action({
							iconCls: 'x_btn_clean',
							text: 'Очистить профиль',
							hidden: true,
							handler: function(widget, event) {
								var rec = window['objs']['subNavigator'].getSelectionModel().getSelection()[0];
								if (rec) {
									selectDialogShow(wmc.get('CleanProfileTitle'),
										wmc.get('CleanProfile', rec.raw.text),
										function() {
											var code = rec.raw.code,
												dict = getDictParent(dictListController[code]);
											code = dict.profileCode || dict.$parentCode || code;
											ajaxRequest({
												url: 'data/CleanProfile_A',
												params: {
													title: rec.raw.text,
													code: code || '',
													gateCode: rec.raw.GateCode || ''
												},
												success: function(result) {
													if (result) {
														if (result.profile) localStorage.removeItem(result.profile);
														Keysystems.Controls.Grid.ColumnManager.prototype.cleanProfileByCode(rec.raw.code, rec.raw.GateCode);
														cacheEngine.removeByCode(rec.raw.code);
														info(wmc.get('ClearedProfil', result.title));
													}
												}
											});
										});
								}
							}
						}),
						seps.BUTTON_NTP_COPY_NAME = new Ext.menu.Separator({ hidden: true }),				
						objs.BUTTON_NTP_COPY_NAME = new Ext.Action({
							iconCls: 'x_btn_copy_name',
							text: 'Копировать наименование',
							hidden: true,
							handler: function() {
								let names = [],
									rec = window.objs.subNavigator.getSelectionModel().getSelection()[0];
								
								while (rec.hasOwnProperty('parentNode'))
								{
									names.push(rec.data.text);
									rec = rec.parentNode;
									if (rec.isRoot()) {
										break;
									}
								}
								
								navigator.clipboard.writeText('Навигатор: ' + names.reverse().join(' \\ '));
							}
						})
					]
				});

		return contextMenu;
	},
	expanded: function(nodes) {
		if (profile.tree && nodes) {
			Ext.each(nodes,
				function(node) {
					node.expanded = profile.tree.indexOf(node.link) !== -1;
					if (node.children) NavigatorLib.expanded(node.children);
				});
		}
	},

	ignoreArr: [
		'NODE_REVIZOR_MAP', 'NODE_REVIZOR_TASK', 'NODE_REVIZOR_ROBJECTINFO',
		'NODE_REVIZOR_PLAN_INFO'
	], // RWEB-121 Скрытие неиспользуемого функционала;
	checkModelList: [
		'DOCUMENT_PLANREVIZ', 'DOCUMENT_PLANREVIZ_VFA', 'DOCUMENT_PLANREVIZ_MOD', 'DOCUMENT_REVIZ', 
		'DOCUMENT_REVIZ_VFA', 'DOCUMENT_ADMPROCS'
	],

	//#region whiteList RWEB-1676

	whiteList: [
		dnl.OUTERREVIZ, dnl.DOCREQUEST, dnl.OBJECTIONACT, dnl.DOCREVIZ, dnl.DOCREVIZ_REPORT, 'DOCUMENT_PASSPORTORG',
		dnl.DOCREQUEST_VFA, dnl.OBJECTIONACT_VFA, dnl.DOCREVIZ_VFA, dnl.DOCREVIZ_REPORT_VFA
	],
	useWhiteList: window.NavigatorUseWhiteList && !window.isDebug,
	hideEmptyFolder: false,
	
	//#endregion whiteList RWEB-1676

	//[GateCode, key]
	addCountArr: [
		[dnl.DOCREQUEST, 'docRequestCount'],
		[dnl.DOCREVIZ, 'docRevizCount'],
		[dnl.DOCREVIZ_REPORT, 'docRevizReportCount'],
		[dnl.DOCREQUEST_VFA, 'vfaDocRequestCount'],
		[dnl.DOCREVIZ_VFA, 'vfaDocRevizCount'],
		[dnl.DOCREVIZ_REPORT_VFA, 'vfaDocRevizReportCount']
	],

	//#region Методы
	searchHandler: function() {
		var me = this;
		if (me.searchPanel.isVisible()) {
			me.searchPanel.hide();
		} else {
			me.searchPanel.show();
			me.searchTextField.focus();
		}
	},
	isEmpty: function(subNavigator){
		return subNavigator.store.data.items.length === 0;
	},
	navigatorUpdate: function(subNavigator) {
		var me = this,
			isNavigator = subNavigator.title === 'Навигатор',
			store = subNavigator.getStore(),
			expandedLinks = [];

		if (isNavigator) {
			store.each(function(rec) { if (rec.get('expanded')) expandedLinks.push(rec.get('link')); });
			LocalStorage.set(window.user.login + window.user.DataBase + 'WEB_NAVIGATOR_TREE', expandedLinks);
		}
		
		const loadMask = new Ext.LoadMask({
			target: subNavigator, 
			msg: me.isEmpty(subNavigator) ? KS.L10n.loading_data : KS.L10n.updating_data, 
			autoShow: true,
			rid: ajaxRequest({
				url: 'Data/GetNavigator_A',
				params: {  what: isNavigator ? "navigator" : "sOrgpTree", isOuter: window.isOuter,  },
				success: function(result) {
					if (isNavigator) {
						NavigatorLib.expanded(result.children);
						me.btns = result;
					}
					me.btns = navigator;

					store.setRootNode({
						expanded: true,
						children: me.createTreeItems(result)
					});
				},
				callback: function() {
					loadMask.destroy();
				}
			})
		});
	},
	getSearchIndex: function() {
		var me = window.objs.subNavigator;
		if (!me.searchNodes || !me.searchNodes.length) return -1;

		var sel = me.getSelectionModel().getSelection(),
			iPos;

		if (sel.length) {
			sel = sel[0];
			iPos = Ext.Array.indexOf(me.searchNodes, sel);
			if (iPos === -1) {
				var lstPos = -1;
				me.store.each(function(record) {
					if (record === sel) {
						return false;
					}
					iPos = Ext.Array.indexOf(me.searchNodes, record);
					if (iPos !== -1) lstPos = iPos;
					return true;
				});
				return lstPos + 0.5;
			} else {
				return iPos;
			}
		}

		return 0;
	},
	expandParentFn: function(node, callBack) {
		var me = this;
		if (node.parentNode) {
			if (node.parentNode.isExpanded()) {
				me.expandParentFn(node.parentNode, callBack);
			} else {
				node.parentNode.expand(false, function() { me.expandParentFn(node.parentNode, callBack); });
			}
		} else {
			if (callBack) callBack();
		}
	},
	createTreeItems: function(list) {
		if (!(list.children && list.children.length)) return false;

		var me = this,
			result = [];

		Ext.each(list.children,
			function(item) {
				if (NavigatorLib.useWhiteList &&
					!item.isFolder &&
					NavigatorLib.whiteList.indexOf(item.code) === -1) return;

				if (NavigatorLib.ignoreArr.findIndex(elem => item.NodeType?.includes(elem)) > -1 || item.GateCode?.startsWith('EOD_')) return;

				var sett = {
					text: item.text,
					_text: item.text,
					expanded: item.expanded,
					link: item.link,
					link_var: item.link_var,
					code: item.code,
					GateCode: item.GateCode,
					iconCls: item.iconCls,
					isRepAll: item.isRepAll,
					SORGPNodeId: item.SORGPNodeId,
					SORGPNodeType: item.SORGPNodeType,
					SORGPData: item.SORGPData,
					item: item
				};

				if (window.isOuter) {
					Ext.each(NavigatorLib.addCountArr,
						function (arr) {
							if (arr[0] === sett.GateCode) {
								var count = me.btns[arr[1]];
								count && (sett.text += ' (' + count + ')');
							}
						});
				}

				var children = me.createTreeItems.call(me, item);
				if (children) {
					sett.children = children;
					sett.leaf = false;
				} else {
					sett.leaf = true;
				}
				if (item.isFolder) {
					if (NavigatorLib.hideEmptyFolder && !children.length) return;
					sett.isFolder = true;
					sett.leaf = false;
					if (!item.isUserFolder) delete sett.iconCls;
					if (!sett.iconCls) sett.iconCls = 'x_btn_folder';
				} else {
					if (item.isDict) {
						sett.handler = function() {
							var index = window.tabView.items.findIndex('GateCode', this.GateCode);

							if (index != -1) { // add new form
								window.tabView.setActiveTab(window.tabView.items.items[index].id);
								window.tabView.items.items[index].getEl().frame("#0000b9", 1, { duration: 1000 });
							} else {
								dictFunc({
									checkModel: false,
									title: this._text,
									tabMode: true,
									parentView: window.tabView,
									GateCode: this.GateCode,
									code: this.code
								});
							}
						};
					} else {
						if (item.isEodOut || item.isEodIn) {
							var inArray = $.inArray(item.code, EODListController);
							sett.handler = inArray !== -1 ? EODListController[item.code].handler : _;
						} else {
								if (item.isRepAll) {
									sett.handler =
										function() {
											try {
												let tabs = window.tabView.items.items.filter(i => { return i.dict?.code === this.code; });

												if (tabs.length) {
													window.tabView.setActiveTab(tabs[0].id);
													tabs[0].getEl().frame("#0000b9",
														1,
														{
															duration: 1000
														});

												} else {
													// add new form
													var ReportView = Ext.create('Revizor.ReportView',
														{
															title: this._text,
															link_var: this.link_var,
															code: this.code,
															id: this.code + '-' + Ext.id(),
															tabMode: true,
															parentView: window.tabView
														});
												}

											} catch (exception) {
												alert(exception);
											};
										};
								} else {
									if (item.PASSPORTORG) {
										//sett.handler = function () { Ext.create('Keysystems.Edits.Pasport.Org'); };
										sett.handler = function() {
											Ext.create('Keysystems.SOrg.Edit',
												{
													f: 'edit',
													isPasport: true,
													linkCode: 'SOrg',
													title: 'Организация',
													editIcon: 'x_btn_organisation',
													iconCls: 'x_btn_organisation',
													data: user.org
												});
										};
									} else {
										sett.handler = function(node) {
											var additionalTitle = '',
												gateCode = this.GateCode;

											if (this.SORGPData) {
												additionalTitle = ' - ' + this.SORGPData.NAME;
												gateCode = this.code + this.SORGPData.CODE;
											}

											var cfg = {
												checkModel: NavigatorLib.checkModelList &&
													NavigatorLib.checkModelList.indexOf(this.code) !== -1,
												title: this._text + additionalTitle,
												tabMode: true,
												parentView: window.tabView,
												SORGPNodeType: this.SORGPNodeType,
												SORGPNodeId: this.SORGPNodeId,
												SORGPData: this.SORGPData,
												GateCode: gateCode,
												code: this.code,
											};

											if (this.SORGPNodeId && this.SORGPNodeType) {
												cfg.beforeSetWhereArgs = function() {
													var me = this;

													if (me.ksControls.S_ORG) {
														me.gksc('S_ORG').setValue(this.SORGPData);
													}
												};

												cfg.afterSetWhereArgs = function(whereArgs) {
													whereArgs.OrgP = {
														value: this.SORGPNodeId,
														type: 'int'
													};

													whereArgs.SlaveOrgPInclude = {
														value: 1,
														type: 'int'
													};

												}
											}
											
											for (var i = 0, items = window.tabView.items.items, len = items.length; i < len; i++) {
												if ((items[i].code === cfg.code) && (items[i].GateCode === cfg.GateCode)) {
													cfg.sameHandler = items[i].dict.handler;
													cfg.pagingOn = items[i].dict.pagingOn;
													if (cfg.code === 'DOCUMENT_FACTNAR_DIS') {
														cfg.disLinks = items[i].dict.disLinks;
														cfg.disVal = items[i].dict.disVal;
													}
												}
											}
											if (node) {
												cfg.beforeInitListData = () => node.set('loading', true);
												cfg.afterInitListData = () => node.set('loading', false);
											}
											window.openList(cfg);
										};
									}
								}
						}
					}
				}
				result.push(sett);
			});

		return result;
	},
	onSearchFieldChange: function(th, searchValue) {
		var me = this,
			count = 0;

		me.searchNodes = [];
		me.currentNode = null;

		me.view.refresh();

		if (searchValue) {
			try {
				me.searchRegExp = new RegExp(searchValue, 'g' + (me.caseSensitive ? '' : 'i'));
			} catch (e) {
				searchValue = searchValue.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
				me.searchRegExp = new RegExp(searchValue, 'g' + (me.caseSensitive ? '' : 'i'));
			}

			me.store.each(function(record) {
					var text = record.get('text');
					if (me.searchRegExp.test(text)) {
						count++;

						if (Ext.Array.indexOf(me.searchNodes, record) === -1) {
							me.searchNodes.push(record);
						}
						if (me.currentNode === null) {
							me.currentNode = record;
						}

						var el = Ext.fly(me.view.getNode(record));
						if (el) {
							var td = el.down('td'),
								cell,
								matches,
								cellHTML;
							if (td) {
								cell = td.down('.x-tree-node-text');
								matches = cell.dom.innerHTML.match(me.tagsRe);
								cellHTML = cell.dom.innerHTML.replace(me.tagsRe, me.tagsProtect);
								cellHTML = cellHTML.replace(me.searchRegExp,
									function(m) {
										return '<span class="' + me.matchCls + '">' + m + '</span>';
									});

								Ext.each(matches,
									function(match) {
										cellHTML = cellHTML.replace(me.tagsProtect, match);
									});

								cell.dom.innerHTML = cellHTML;
							}
						}
					}
				},
				me);
		}

		if (me.searchNodes.length > 1) {
			me.SearchNext.setDisabled(false);
			me.SearchPrev.setDisabled(false);
		} else {
			me.SearchNext.setDisabled(true);
			me.SearchPrev.setDisabled(true);
		}

		if (me.currentNode === null) {
			me.getSelectionModel().deselectAll();
		} else {
			NavigatorLib.expandParentFn(me.currentNode, function() { me.getSelectionModel().select(me.currentNode); });
		}

		me.searchTextField.focus();
	},
	onSearchNext: function() {
		var me = this,
			iPos = NavigatorLib.getSearchIndex();

		if (iPos === -1) return;

		iPos = ((iPos | 0) + 1) % me.searchNodes.length;

		me.currentNode = me.searchNodes[iPos];
		NavigatorLib.expandParentFn(me.currentNode, function() { me.getSelectionModel().select(me.currentNode); });
	},
	onSearchPrev: function() {
		var me = this,
			iPos = NavigatorLib.getSearchIndex();

		if (iPos === -1) return;

		iPos = (Math.round(iPos) - 1);

		if (iPos === -1) iPos = me.searchNodes.length - 1;

		me.currentNode = me.searchNodes[iPos];
		NavigatorLib.expandParentFn(me.currentNode, function() { me.getSelectionModel().select(me.currentNode); });
	},

	execute: function(cfg, navigatorContainer, subNavigatorName) {
		var me = this;

		navigatorContainer.setBorderRegion('west');
		navigatorContainer.setWidth(300);

		NavigatorLib.expanded(cfg.children);

		switch (subNavigatorName) {
		case 'sORGPTree':
			cfg.title = 'Дерево проверяющих';
			cfg.iconCls = 'x_btn_tree24';
			break;
		default:
			me.btns = cfg;
			cfg.title = 'Навигатор';
			cfg.iconCls = 'x_btn_folder24';
		}

		navigatorContainer.add(objs[subNavigatorName] = me.createSubNavigator(cfg, subNavigatorName));
	},

	//#endregion Методы

	//#region Конструкторы

	createSearchPanel: function(subNavigator) {
		var me = this;

		return Ext.create('Ext.panel.Panel',
			{
				flex: 1,
				border: 0,
				bodyStyle: 'background-color: transparent',
				layout: 'hbox',
				hidden: true,
				padding: '0 0 5px 7px',
				listeners: {
					hide: function() {
						subNavigator.searchTextField.setValue('');
						subNavigator.view.refresh();
					}
				},
				items: [
					Ext.create('Ext.Button',
						{
							iconCls: 'x_btn_delete',
							cls: 'ks-button-image',
							tooltip: 'Закрыть',
							tooltipType: 'title',
							handler: function() { subNavigator.searchPanel.hide(); }
						}),
					subNavigator.searchTextField = Ext.create('Ext.form.field.Text',
						{
							padding: '0 5 0 5',
							listeners: {
								change: { fn: me.onSearchFieldChange.bind(subNavigator), buffer: 500 },
								specialkey: function(field, e) {
									if (e.getKey() === e.TAB) {
										me.onSearchNext.call(subNavigator);
										e.stopEvent();
										this.focus();
									}
									if (e.getKey() === e.ENTER) {
										var rec = subNavigator.selModel.getSelection();
										if (!rec.length) return;
										rec = rec[0];
										if (rec.raw.isFolder) {
											rec[rec.isExpanded() ? 'collapse' : 'expand']();
										}
										if (rec.raw.handler) {
											rec.raw.handler();
										}
									}
								},
								afterrender: function(view) {
									if (!objs.tip) {
										objs.tip = Ext.create('Ext.tip.ToolTip',
											{
												target: view.el,
												anchor: 't',
												trackMouse: true,
												html: wmc.get('NextSearch'),
												listeners: {
													beforeshow: function() {
														var foc = $("input[type='text']:focus")[0],
															inputEl = this.target.down('input');
														return !!(foc && inputEl && foc === inputEl.dom);
													}
												}
											});
									}
								}
							}
						}),
					subNavigator.SearchNext = Ext.create('Ext.Button',
						{
							iconCls: 'x_btn_down',
							cls: 'ks-button-image',
							tooltip: 'Найти следующее',
							tooltipType: 'title',
							disabled: true,
							handler: function() { me.onSearchNext.call(subNavigator); }
						}),
					subNavigator.SearchPrev = Ext.create('Ext.Button',
						{
							iconCls: 'x_btn_up',
							cls: 'ks-button-image',
							tooltip: 'Найти предыдущее',
							tooltipType: 'title',
							disabled: true,
							handler: function() { me.onSearchPrev.call(subNavigator); }
						})
				]
			});
	},
	createSubNavigator: function(cfg, subNavigatorName) {
		var me = this,
			needFireEvent = true,
			contextMenu = NavigatorLib.contextMenuGen(),
			children = cfg.children ? me.createTreeItems(cfg) : [],
			saveExpandedStateToProfile = function(node, isExpanded) {
				var link = node.get('link'),
					currentNodes = LocalStorage.get(window.user.login + window.user.DataBase + 'WEB_NAVIGATOR_TREE') || [],
					ind = currentNodes.indexOf(link);

				if (ind !== -1) {
					if (!isExpanded) {
						currentNodes.splice(ind, 1);
					}
				} else {
					currentNodes.push(link);
				}

				LocalStorage.set(window.user.login + window.user.DataBase + 'WEB_NAVIGATOR_TREE', currentNodes);
			},
			subNavigator = Ext.create('Ext.tree.Panel',
				{
					//hidden: true,
					anchor: '100% 100%',
					hideHeaders: true,
					cls: Ext.baseCSSPrefix + 'autowidth-table',
					caseSensitive: false,
					columns: [
						{
							xtype: 'treecolumn',
							text: 'Name',
							minWidth: Ext.getViewportWidth() * 0.15,
							dataIndex: 'text',
							flex: 1,
							renderer: function(val, meta, rec) {
								var me = objs[subNavigatorName];
								if (me.searchNodes && Ext.Array.indexOf(me.searchNodes, rec) !== -1) {
									return val.replace(me.searchRegExp,
										function(m) {
											return '<span class="' + me.matchCls + '">' + m + '</span>';
										});
								}
								meta.tdCls += rec.get('loading') ? ' treelist-item-loading' : '';
								return val;
							}
						}
					],

					title: cfg.title,
					iconCls: cfg.iconCls,
					viewConfig: {
						plugins: {
							ptype: 'gridviewdragdrop',
							containerScroll: true,
							onViewRender: function(view) {
								const th = this;
								var scrollEl;

								if (th.enableDrag) {
									if (th.containerScroll) {
										scrollEl = view.getEl();
									}

									th.dragZone = new Ext.view.DragZone({
										view: view,
										ddGroup: th.dragGroup || th.ddGroup,
										dragText: th.dragText,
										containerScroll: th.containerScroll,
										scrollEl: scrollEl,
										isPreventDrag: function(e, record) {
											return record.get('SORGPData');
										}
									});
								}

								if (th.enableDrop) {
									th.dropZone = new Ext.grid.ViewDropZone({
										view: view,
										ddGroup: th.dropGroup || th.ddGroup,
										positionIndicator: function(node, data, e) {
											let th = this,
												view = th.view,
												pos = th.getPosition(e, node),
												targetRecord = view.getRecord(node),
												draggingRecords = data.records,
												indicatorY;
																						
											let isTargetUserFolder = targetRecord.data.item.hasOwnProperty('isUserFolder') 
												&& targetRecord.data.item.isUserFolder,
												isTargetParentUserFolder = !targetRecord.parentNode.isRoot() 
													&& targetRecord.parentNode.data.item.isUserFolder,
												rec = targetRecord,
												isChild = false,
												// в вине нельзя сверху папок поместить
												isOverUserFolder = isTargetUserFolder && pos === 'before';

											// нельзя переносить узлы в свои дочерние узлы
											while (rec.hasOwnProperty('parentNode'))
											{
												rec = rec.parentNode;
												if (rec.isRoot()) {
													break;
												}
												if (draggingRecords[0] === rec) {
													isChild = true;
													break;
												}
											}
											
											if (!isChild && !isOverUserFolder && (isTargetUserFolder || isTargetParentUserFolder)) {
												th.valid = true;

												if (th.targetRecord != targetRecord || th.currentPosition != pos) {
													indicatorY = Ext.fly(node).getY() - view.el.getY() - 1;
													if (pos == 'after') {
														indicatorY += Ext.fly(node).getHeight();
													}
													th.getIndicator().setWidth(Ext.fly(view.el).getWidth())
														.showAt(0, indicatorY);

													th.targetRecord = targetRecord;
													th.currentPosition = pos;
												}
											} else {
												th.invalidateDrop();
											}
										}
									});
								}
							}
						},
						listeners: {
							beforedrop: function(node, data, overModel, dropPosition, dropHandlers, e) {
								let th = this,
									targetRec = th.getRecord(node),
									draggedRec = data.records[0],
									parentIsUserFolder = draggedRec.parentNode.isRoot()
										? draggedRec.data.item.isUserFolder
										: draggedRec.parentNode.data.item.isUserFolder,
									targetIsNode = !targetRec.data.item.hasOwnProperty('isUserFolder'),
									targetIsUserFolder = !targetIsNode && targetRec.data.item.isUserFolder,
									draggedId = draggedRec.data.item.NodeId,
									targetId = targetRec.data.item.NodeId,
									linkSelf = draggedRec.parentNode.isRoot() ? '' : draggedRec.parentNode.data.item.link;
								
								// если из "не пользовательского" узла/папки под "пользовательскую" папку
								if (!parentIsUserFolder && targetIsUserFolder) {
									const mask = new Ext.LoadMask({
										msg: wmc.get('PasteNode'),
										view: window.objs.navigator,
										autoShow: true,
										rid: ajaxRequest({
											url: 'SNavigator/PasteNode_A',
											params: {
												draggedItem: JSON.stringify({
													Code: draggedRec.data.item.code,
													Link: draggedRec.data.item.link,
													Name: draggedRec.data.item.text,
													NodeSType: draggedRec.data.item.NodeType,
													SelfLink: linkSelf
												}),
												targetItem: JSON.stringify({
													targetLink: targetRec.data.item.link,
													RelID: targetRec.data.item.NodeId
												}),
												isOuter: window.isOuter
											},
											success: function (res) {
												if (!res.error.length) {
													NavigatorLib.expanded(res.navigator.children);
													me.btns = res.navigator;

													window.objs.subNavigator.getStore().setRootNode({
														expanded: true,
														children: me.createTreeItems(res.navigator)
													});
												} else {
													Ext.MessageBox.alert("Error", cfg.errText ?? wmc.get('ErrorPasteNode'));
												}
											},
											failure: function () {
												Ext.MessageBox.alert("Error", cfg.errText ?? wmc.get('ErrorPasteNode'));
											},
											callback: function () {
												mask.destroy();
											}
										})
									});	
								} else if (parentIsUserFolder && targetIsUserFolder){
									// если из "пользовательского" узла/папки под "пользовательскую" папку
									const mask = new Ext.LoadMask({
										msg: wmc.get('MoveNode'),
										view: window.objs.navigator,
										autoShow: true,
										rid: ajaxRequest({
											url: 'SNavigator/MoveNode_A',
											params: {
												draggedId: draggedId,
												targetId: targetId,
												isOuter: window.isOuter
											},
											success: function (res) {
												if (!res.error.length) {
													NavigatorLib.expanded(res.navigator.children);
													me.btns = res.navigator;

													window.objs.subNavigator.getStore().setRootNode({
														expanded: true,
														children: me.createTreeItems(res.navigator)
													});
												} else {
													Ext.MessageBox.alert("Error", cfg.errText ?? wmc.get('ErrorMoveNode'));
												}
											},
											failure: function () {
												Ext.MessageBox.alert("Error", cfg.errText ?? wmc.get('ErrorMoveNode'));
											},
											callback: function () {
												mask.destroy();
											}
										})
									});
								}								
								else if (targetIsNode) {
									// если из любого узла под/над "пользовательским" узлом
									const mask = new Ext.LoadMask({
										msg: wmc.get('MoveNode'),
										view: window.objs.navigator,
										autoShow: true,
										rid: ajaxRequest({
											url: 'SNavigator/Move_A',
											params: {
												draggedId: draggedId,
												targetId: targetId,
												above: dropPosition === 'before',
												makeCopy: !parentIsUserFolder,
												isOuter: window.isOuter
											},
											success: function (res) {
												if (!res.error.length) {
													NavigatorLib.expanded(res.navigator.children);
													me.btns = res.navigator;

													window.objs.subNavigator.getStore().setRootNode({
														expanded: true,
														children: me.createTreeItems(res.navigator)
													});
												} else {
													Ext.MessageBox.alert("Error", cfg.errText ?? wmc.get('ErrorMoveNode'));
												}
											},
											failure: function () {
												Ext.MessageBox.alert("Error", cfg.errText ?? wmc.get('ErrorMoveNode'));
											},
											callback: function () {
												mask.destroy();
											}
										})
									});
								}
							}
						}
					},

					//обнаружение html тегов
					tagsRe: /<[^>]*>/gm,

					// DEL ASCII code
					tagsProtect: '\x0f',

					//css стиль соответсвующего поиску текста
					matchCls: 'x-search-match',

					tbar: [						
						Ext.create('Ext.Button',
							{
								iconCls: 'x_btn_treeexpand',
								tooltip: 'Развернуть все узлы',
								tooltipType: 'title',
								handler: function() {
									needFireEvent = false;
									subNavigator.expandAll();
									setTimeout(function() {
										needFireEvent = true;
									}, 1500);
								}
							}),
						Ext.create('Ext.Button',
							{
								iconCls: 'x_btn_treecollapse',
								tooltip: 'Свернуть все узлы',
								tooltipType: 'title',
								handler: function() {
									needFireEvent = false;
									subNavigator.collapseAll();
									setTimeout(function() {
										needFireEvent = true;
									}, 1500);
								}
							}),
						'-',
						Ext.create('Ext.Button',
							{
								iconCls: 'x_btn_search',
								tooltip: 'Найти',
								tooltipType: 'title',
								handler: function() { NavigatorLib.searchHandler.call(subNavigator); }
							}),
						'-',
						Ext.create('Ext.Button',
							{
								iconCls: 'x_btn_clean',
								tooltip: 'Очистить оперативные данные',
								tooltipType: 'title',
								handler: function() { NavigatorLib.cleanDataHandler(); }
							}),
						'-',
						NavigatorLib.settingsBtns = Ext.create('Ext.Button',
							{
								iconCls: 'x_btn_settings',
								tooltip: 'Настройки',
								tooltipType: 'title',
								handler: function() { Settings.show(); }
							}),
						NavigatorLib.objAccess = Ext.create('Ext.Button',
							{
								iconCls: 'x_btn_key',
								tooltip: 'Права доступа',
								hidden: !window.user.isAdmin,
								tooltipType: 'title',
								handler: function() {  ObjAccess.show(); }
							}),
						Ext.create('Ext.Button',
							{
								iconCls: 'x_btn_about',
								hidden: true,
								tooltip: 'О программе',
								tooltipType: 'title',
								handler: function() { Ext.create('AboutView').show(); }
							}),
						Ext.create('Ext.Button',
							{
								iconCls: 'x_btn_keysystems',
								tooltip: 'Debug',
								// ReSharper disable UseOfImplicitGlobalInFunctionScope
								hidden: !(window.isDebug && window.debugBtnHandler),
								// ReSharper restore UseOfImplicitGlobalInFunctionScope
								tooltipType: 'title',
								handler: function() { debugBtnHandler(); }
							})
					],
					border: 0,
					autoScroll: true,
					store: Ext.create('Ext.data.TreeStore',
						{
							fields: ['link', 'text', '_text'],
							root: { expanded: true, children: children }
						}),
					rootVisible: false,
					listeners: {
						itemdblclick: function(th, rec) {
							rec.raw.handler && rec.raw.handler(rec);
						},
						afteritemexpand: function(node, index, item, eOpts) {
							needFireEvent && saveExpandedStateToProfile(node, true);
						},
						afteritemcollapse: function(node, index, item, eOpts) {
							needFireEvent && saveExpandedStateToProfile(node, false);
						},
						itemcontextmenu: function(view, rec, node, index, e) {
							objs[subNavigatorName].getSelectionModel().select(rec);
							if (rec.data.SORGPNodeId) {
								if (rec.data.SORGPNodeType && rec.data.code.indexOf('Folder') === -1) {
									contextMenu.showNodes(['BUTTON_NTP_OPEN']);
									contextMenu.showAt(e.getXY());
								}
							} else {
								ajaxRequest({
									url: 'SNavigator/GetNavigatorContextMenu_A',
									params: {
										code: rec.data.code,
										nodeType: rec.data.item.NodeType,
										nodeId: rec.data.item.NodeId
									},
									success: function(res) {
										contextMenu.showNodes(res);
										contextMenu.showAt(e.getXY());
									},
									failure: function(response) {
										Ext.MessageBox.alert("Error", wmc.get('ErrorGetNavigatorContextMenu'));
									}
								});
							}

							e.stopEvent();
							return false;
						},
						itemkeydown: function(th, rec, item, index, e) {
							if (e.getKey() == e.ENTER) {
								e.stopEvent();
								if (rec.raw.handler) {
									rec.raw.handler();
								}
							}
						},
						ksRefresh: function () {
							NavigatorLib.navigatorUpdate(subNavigator);
						},
						ksTabActivate: function () {
							//если данные не подгружались ранее - загрузим
							if (me.isEmpty(subNavigator))
								NavigatorLib.navigatorUpdate(subNavigator, true);
						}
					}
				});

		subNavigator.addDocked([subNavigator.searchPanel = me.createSearchPanel(subNavigator)]);

		return subNavigator;
	}

	//#endregion Конструкторы

};

export default NavigatorLib;