﻿var LocalStorage = ( function( window, undefined ) {
	// singleton pattern
	var store = null;

	function get(key, packed) {
		try {
			var res = LocalStorage.getStore().get ? LocalStorage.getStore().get(key) : LocalStorage.getStore().getItem(key);
			if (res && !packed) res = jQuery.parseJSON(lzw.decompress(res));
			return res;
		} catch (e) {
			Log.sendLog('Ошибка при распаковке по ключу ' + key);
			return {};
		}
	}

	
	function set (key, data, packed) {
		if (data && !packed) data = lzw.compress(JSON.stringify(data));
		if (LocalStorage.getStore().set) {
			LocalStorage.getStore().set(key, data);
		} else {
			LocalStorage.getStore().setItem(key, data);
		}
	};

	function remove(key) {
	 	if (LocalStorage.getStore().remove) {
	 		LocalStorage.getStore().remove(key);
		} else {
	 		LocalStorage.getStore().removeItem(key);
		}
	}
	function clear() {
		LocalStorage.getStore().clear();
	};

	function list() {
		var res = [],
			m_store = LocalStorage.getStore().cache || LocalStorage.getStore();
		for (var key in m_store) res.push(key);
		return res;
	};

	// handles the prevention of additional instantiations
	function getStore() {
		if( ! store ) {
			store = window.localStorage || Ext.create('Keysystems.ux.CacheEngine');
		}
		return store;
	}

	return {
		getStore : getStore,
		get: get,
		set: set,
		remove: remove,
		clear: clear,
		list: list
};

})( window );

window.LocalStorage = LocalStorage;

export default LocalStorage;