﻿/**
 *@ deprecated. Используем {@link Ext#LoadMask}. 
  */
Ext.define('Keysystems.LoadMask', {
	extend: 'Ext.window.Window',
	msgCls: 'x-mask-msg-text',
	closable: false,
	bodyPadding: 6,
	resizable: false,
	header: false,
	border: false,
	modal: true,
	cls: 'ks-loadMask',
	layout: { type: 'vbox', align: 'center' },
	initComponent: function() {
		var me = this;
		me.items = [
			me.iconDraw = Ext.create('Ext.draw.Component', {
				autoRender: true,
				width: 30,
				height: 25,
				border: 0,
				sprites: [
					 {
						type: 'path',
						fill: 'green',
						//group: 'green',
						path: 'M 4,0 18,0 9.8,7 2.6,7 4,0'
					 },
					 {
						type: 'path',
						fill: 'green',
						//group: 'green',
						path: 'M 2.4,8 8.5,8 5,11 7.5,14 1.4,14 2.4,8'
					},
					{
						type: 'path',
						fill: 'green',
						//group: 'green',
						path: 'M 1.2,15 8.3,15 14,22 0,22 1.2,15'
					},
					{
						type: 'path',
						fill: 'blue',
						group: 'blue',
						path: 'M 20,0 27,0 25.8,7 11.8,7 20,0'
					},
					{
						type: 'path',
						fill: 'blue',
						//group: 'blue',
						path: 'M 10.5,8 16.5,8 13,11 15.5,14 9.5,14 7,11 10.5,8'
					},
					{
						type: 'path',
						fill: 'blue',
						//group: 'blue',
						path: 'M 10.3,15 24.3,15 23,22 16,22 10.3,15'
					}
				]
			}),
			me.msgLabel = Ext.create('Ext.form.Label', {
				text: me.msg,
				padding: '2px 0 2px 0'
			}),
			me.cancelBtn = Ext.create('Ext.Button', {
				disabled: !me.rid && !me.cancelFn,
				handler: me.m_cancelFn,
				scope: me,
				text: 'Отмена'
			})
		];
		me.callParent(arguments);
		me.on('show', function() {
			delete me.stopAnim;
			me.m_animate();

			Ext.WindowManager._showModalMask.call(me.maskGhost, me);
		});
		me.on('hide', function() { me.m_stopAnimate(); });
		//Ext.EventManager.onWindowResize(function() { me.center(); });
		Ext.on('resize', function() { me.center(); });
		
	},
	maskGhost: { getMaskBox: Ext.ZIndexManager.prototype.getMaskBox },
	zIndexManager: {
		getActive: function() { return Ext.WindowManager.getActive(); },
		bringToFront: () => true,
		onComponentUpdate: function (){return false;},
		suspendReflow: function(){return false;},
		resumeReflow:function(){return false;}
	},
	registerWithOwnerCt: function() { this.setZIndex(2147483646); },
	
	m_animate: function (i) {
		var me = this,
			time = 500,
			greenItems = me.iconDraw.getSurface().getItems().filter(item => item.fill === 'green'),
			blueItems = me.iconDraw.getSurface().getItems().filter(item => item.fill === 'blue'),
			len = greenItems.length;

		if (me.stopAnim) return;
		if (!i || i >= len) i = 0;

		//не нашла delay и callback у анимации в новом Ext, animationend не отрабатывает
		//реализовала через таймауты (delay) + промисы (callback)
		//таймаут в промисе меньше основго таймаута для того, чтобы сектор мог вернуться прежде, чем следующий сектор будет перемещен
		let promise = new Promise((resolve) => {
			setTimeout(function () {
				let greenItem = greenItems[i],
					greenPath = greenItem.path,
					blueItem = blueItems[len - 1 - i],
					bluePath = blueItem.path;

				greenItem.setAnimation({
					duration: time,
					easing: 'easeOut',
				});
				greenItem.setAttributes({
					path: blueItem.path,
					fill: 'green'
				});

				blueItem.setAnimation({
					duration: time,
					easing: 'easeOut',
				});
				blueItem.setAttributes({
					path: greenPath,
					fill: 'blue'
				});
				me.iconDraw.renderFrame();

				resolve({
					greenItem: greenItem,
					greenPath: greenPath,
					blueItem: blueItem,
					bluePath: bluePath,
					greenIndex: i,
					blueIndex: (len - 1 - i)
				});
				i++;
				me.m_animate(i);
			}, time * 2);
		});
		promise
			.then(
				result => {
					setTimeout(() => {
						result.greenItem.setAttributes({
							path: result.greenPath,
							fill: 'green'
						});
						result.blueItem.setAttributes({
							path: result.bluePath,
							fill: 'blue'
						});
						me.iconDraw.renderFrame();
					}, time);
				}
			);
	},
	m_stopAnimate: function() {
		this.stopAnim = true;
		if (this.maskGhost.mask.isVisible()) {
			this.maskGhost.mask.maskTarget = undefined;
			this.maskGhost.mask.hide();
		}
		//Ext.WindowManager._hideModalMask.call(this.maskGhost);
	},

	m_cancelFn: function() {
		var me = this;
		me.cancelBtn.setDisabled(true);
		if (me.cancelFn) me.cancelFn();
		if (me.rid) SignalR.delCallBack(me.rid);
		LoadMask.hide();
	},
	setMsg: function(text) {
		this.msgLabel.setText(text);
	},
	setRid: function(rid) {
		var me = this;
		me.rid = rid;
		me.cancelBtn.setDisabled(!me.rid && !me.cancelFn);
	},
	setCancelFn: function(cancelFn) {
		var me = this;
		me.cancelFn = cancelFn;
		me.cancelBtn.setDisabled(!me.rid && !me.cancelFn);
	}
});

window.LoadMask = {
	i: 0,
	mask: Ext.create('Keysystems.LoadMask'),
	show: function(cfg, notI) {
		if (!cfg || (cfg.view && cfg.view.dontWaitMsg)) return;
		if (cfg.msg) {
			LoadMask.mask.setMsg(cfg.msg);
		}
		LoadMask.mask.setRid(cfg.rid);
		LoadMask.mask.setCancelFn(cfg.cancelFn);
		LoadMask.mask.show();
		//LoadMask.mask.setZIndex(2147483646); //MaxInt -1
		if (!notI) LoadMask.i++;
	},
	hide: function() {
		LoadMask.i--;
		if (LoadMask.i < 1) {
			LoadMask.i = 0;
			LoadMask.mask.hide();
		}
	}
};

export default LoadMask;