﻿import {dictListController} from '../Other/TableListController';

window.dictFunc = function (setts, funcs, afterCreate) {    
    if (!setts.code) return;
    let dict = dictListController[setts.code];
    if (!dict) return;
    if (!setts.GateCode) setts.GateCode = setts.code;
    
    let func = ()=> {
        dict = getDictParent(dict);

        if (setts.selectLinks) {
            setts.selectLinks = setts.selectLinks.slice();
        }
        setts = concatDictionary(dict, setts);
        setts.functions = concatDictionary(setts.functions || {}, funcs);

        // если есть уже открытое окно, то подбираем его линейность
        if (setts.hasOwnProperty('sameHandler')) {
            setts.handler = setts.sameHandler;
        }

        if (setts.beforeCreate) {
            setts.beforeCreate(setts,
                function (s) {
                    _createDict(s, afterCreate);
                });
        } else {
            _createDict(setts, afterCreate);
        }
    }

    let whereArgs = setts.whereArgs || setts.initWhereArgs && setts.initWhereArgs() || {},
        checkModel = setts.checkModel !== _ ? setts.checkModel : true,
        checkLinks = checkModel && setts.selectLinks ? ArrayLib.getLinks(ArrayLib.copy(setts.selectLinks)) : [],
        isFake = setts.isFake || dict.isFake,
        params = {
            code: setts.code,
            gateCode: setts.GateCode,
            contextSearch: setts.contextSearch || '',
            whereArgs: JSON.stringify(whereArgs),
            needToolBar: !setts.hideTBar,
            controlName: setts.controlName || '',
            checkModel: checkModel,
            checkLinks: JSON.stringify(checkLinks),
            checkUserError: !!dict.checkUserError,
            profileCode: dict.profileCode,
            codeParent: setts.codeParent,
            linkParent: setts.linkParent,
            tempNewCheckedLinks: setts.tempNewCheckedLinks,
            tempUncheckedLinks: setts.tempUncheckedLinks,
			disallowedToCheckLinks: setts.disallowedToCheckLinks ? JSON.stringify(setts.disallowedToCheckLinks) : null,			
        };
    
    if (isFake) {
        if (setts.beforeInitListData){
            setts.beforeInitListData();
            delete setts.beforeInitListData
        }
        func(setts);
        if (setts.afterInitListData) {
            setts.afterInitListData();
            delete setts.afterInitListData
        }
    } else {
        let rid = ajaxRequest({
            url: dict.linkCode + '/GetExtListData_A',
            params: {gzipData: SignalR.pack(params)},
            success: function (result) {
                for (let key in result) {
                    setts[key] = result[key];
                }
                setts.pageSize = result.pageSize;
                setts.pagingOn = result.pagingOn;
                setts.showActual = result.showActual;
                setts.filter = result.filter;
                setts.extraProfile = result.extraProfile;
				if (result.disallowedToCheckLinks) setts.disallowedToCheckLinks = result.disallowedToCheckLinks;
                // Если нет лицензии на документ
                if (result.noLicense) {
                    Ext.Msg.show({
                        title: '',
                        buttons: Ext.MessageBox.OK,
                        msg: result.noLicense,
                        icon: Ext.MessageBox.WARNING,
                    });   
                }
                else if (result.commonData) {
                    let rowsByContext = result.commonData.data.data,
                        control = setts.control,
                        field = control.fieldCode || control.fieldName || control,
                        oldValue = control.fieldCode || control.fieldName
                            ? control.getOldContextValue(control.fieldCode ? control.codeField : control.nameField)
                            : control.originalValue;

                    if (!rowsByContext.length) {
                        // Работаем по стандартному механизму
                        field.setValue(oldValue);
                        Ext.Msg.show({
                            title: wmc.get('Search'),
                            buttons: Ext.MessageBox.YES,
                            msg: wmc.get('RecordNotFound'),
                            icon: Ext.MessageBox.INFO,
                            fn: function (buttonId) {
                                func(setts);
                            }
                        });
                    } else if (rowsByContext.length === 1) {
                        // Сажаем найденную запись в DictEditor без открывания листовой формы
                        if (funcs.ok) {
                            funcs.ok(rowsByContext)
                        } else if (control._setValue) {
                            control._setValue(rowsByContext);
                        } else {
                            control.setValue(rowsByContext);
                        }
                    } else {
                        // Сажаем найденные данные в листовую форму
                        field.setValue(oldValue);
                        let parentGetData = funcs && funcs.getData ? funcs.getData : _;
                        if (!funcs) funcs = {};
                        funcs.getData = function (endFunc, params) {
                            parentGetData ? parentGetData(endFunc, result.commonData) : endFunc(result.commonData);
                        };
                        func(setts);
                    }
                } else {
                    func(setts);
                }
            },
            callback: function () {
                if (setts.afterInitListData) {
                    setts.afterInitListData();
                    delete setts.afterInitListData
                } else
                    LoadMask.hide();
            }
        });
    }

    if (!isFake && setts.beforeInitListData){
        setts.beforeInitListData();
        delete setts.beforeInitListData
    }
    // else
    //     LoadMask.show({ msg: wmc.getMask('GetDataList'), view: window.tabView, rid: rid }); 
};

/**
 * Открыть список с параметрами фильтрации.
 * @param cfg {object} конфиг списка
 * */
window.openList = function(cfg) {
    if (cfg.tabMode && cfg.parentView && cfg.code) {
        let tab = cfg.parentView.items.items.filter(tab => tab.code === cfg.code && tab.GateCode === cfg.GateCode)[0];
        if (tab) {
            selectDialogShow(
                KS.L10n.attention,
                Ext.String.format(KS.L10n.already_open, cfg.title),
                () => dictFunc(cfg),
                () => tab.show()
            );
        } else
            dictFunc(cfg);
    } else
        dictFunc(cfg);
}

window._createDict = function (setts, afterCreate) {
    if (!Ext.isFunction(afterCreate)) afterCreate = Ext.emptyFn;
    try {
        afterCreate(Ext.create(setts.handler, setts));
    } catch (ex) {
        console.error(ex);
        window.failureShow({statusText: ex.stack}, "Внимание");
        Log.sendLog(ex);
        afterCreate();
    }
};

//#region наследование по $parentCode

window.getDictParent = function (dict) {
    var parentCode = dict.$parentCode,
        i = 0;
    while (parentCode && i < 500) {
        var pDict = dictListController[parentCode];
        if (pDict) {
            parentCode = pDict.$parentCode;
            dict = concatDictionary(pDict, dict);
        } else {
            parentCode = '';
        }
        i++;
    }

    return dict;
};

//#endregion наследование по $parentCode

window.getDictRowName = function (row, code) {
    if (row) {
        row = row.data || row;
        var d = dictListController[code];
        if (d && d.getName) return d.getName(row);
        return row.NAME;
    }
    return '';
};

window.showError = function (text, fn) {
    Ext.MessageBox.show({
        title: KS.L10n.attention,
        msg: text,
        fn: fn,
        buttons: Ext.MessageBox.OK,
        icon: Ext.MessageBox.ERROR
    });
};

window.warning = function (text, fn) {
    Ext.MessageBox.show({
        title: KS.L10n.attention,
        msg: text,
        fn: fn,
        buttons: Ext.MessageBox.OK,
        icon: Ext.MessageBox.INFO
    });
};

/**
 * Отобразить html-лог по детализации журнала событийй
 * @param html {string} html-текст
 * @param modal {boolean} отобразить в модальном окне или во вкладке (для вкладки вызывать через .call(me,))
 * @param title {string} заголовок окна
 */
window.showDetailEventsLog = function(cfg) {
    let html = cfg.html,
        title = cfg.title,
        fullTitle = cfg.fullTitle;
    
    if (!html) return;
    if (html.result === false) {
        showError(html.ErrorMsg);
        return;
    }
    const tbar = [
        {
            iconCls: 'x_btn_save',
            tooltip: 'Сохранить',
            tooltipType: 'title',
            handler: function () {
                let uploader = Ext.create('Keysystems.Uploader.DataUploader', {
                    parseUrl: function (url) {
                        return urlPrefix + parsUrl(url);
                    }
                });
                uploader.getFileFromHTML(html, cfg.title);
            }
        },
        Ext.create('Ext.Button', {
            iconCls: 'x_btn_print',
            tooltip: 'Печать',
            tooltipType: 'title',
            handler: function () {
                let win = window.open('', 'snapshot');
                win.document.open();
                win.document.write(html);
                win.document.close();
                win.print();
            }
        })
    ];
    
    let me = this,
        afterRender = function () {
            //копия HtmlProtocolMaker.DEFJSCRIPT. требуется для корректного сворачивания/разворачивания лога, extjs игнорит встраиваемый в html-текст окна скрипт 
            let o=document.currentScript&&document.currentScript.parentElement||document,
                e=function(e){let r=e.cls,c=e.btnSelector;Array.prototype.slice.call(o.querySelectorAll(".".concat(r))).forEach((function(o){var e=o.querySelector(c);e&&e.addEventListener("click",(function(){return function(o,e){var r=!!~Array.prototype.slice.call(o.classList).indexOf(e);o.classList[r?"remove":"add"](e)}(o,"".concat(r,"--expanded"))}))}))};
            e({cls:"protocol-file",btnSelector:".protocol-file-header > .protocol-file-header__toggle-btn"}),e({cls:"protocol-card",btnSelector:".protocol-card-header > .protocol-card-header__toggle-btn"}),e({cls:"protocol-grid",btnSelector:".protocol-grid-header > .protocol-grid-header__toggle-btn"}),e({cls:"protocol-accordion",btnSelector:".protocol-accordion-header > .protocol-accordion-header__toggle-btn"});
        };  
   
    //уберем PRE-WRAP, каким-то образом из-за него протокол смещается вниз окна
    html = html.replace('WHITE-SPACE: PRE-WRAP;', '');
    if (cfg.modal) {
        let wndw = Ext.create('Ext.window.Window',
            {
                title: fullTitle ? fullTitle : title + ' - Детализация',
                userCls: 'ks-body',
                iconCls: 'x_btn_copy',
                height: 600,
                width: 1000,
                autoScroll: true,
                layout: 'fit',
                modal: true,
                maximizable: true,
                html: html,
                bodyStyle: window.Theme === 'crisp' ? 'padding: 0 5px 0 0;' : 'background:#fff; padding: 5px',
                buttons: [
                    Ext.create('Ext.Button', {
                        text: 'Продолжить',
                        hidden: !cfg.continueFn,
                        handler: function() {
                            KsLib.tryRun(cfg.continueFn);
                            wndw.close();
                        }
                    }),
                    Ext.create('Ext.Button', {
                        text: 'Закрыть',
                        handler: function() {
                            if (cfg.waitCloseFn) {
                                KsLib.tryRun(cfg.closeFn, this, f => wndw.close());
                            } else {
                                wndw.close();
                            }
                        }
                    })
                ],
                tbar: tbar,
                listeners: {
                    afterrender: afterRender
                }
            });
        wndw.show();
    } else {
        let view = Ext.create('Ext.panel.Panel',
            {
                border: 0,
                closable: true,
                title: title + ' - Детализация',
                iconCls: 'x_btn_copy',
                padding: 10,
                autoScroll: true,
                userCls: 'ks-body',
                html: html,
                tbar: tbar,
                listeners: {
                    afterrender: afterRender
                }
            });
        me.parentView.add(view);
        view.show(me.parentView);
        view.updateLayout();
    }  
}

window.info = function (text, fn) {
    Ext.MessageBox.show({
        title: KS.L10n.attention,
        msg: text,
        fn: fn,
        buttons: Ext.MessageBox.OK,
        icon: Ext.MessageBox.INFO
    });
};

window.quickSort = function (list, field, desc, childField) {
    if (!field) field = [];
    else if (!Ext.isArray(field)) field = [field];
    var get = function (item) {
            for (p = 0; p < fLen; p++) {
                item = item[field[p]];
            }
            return item;
        },
        sort = function (ar, low, high) {
            var i = low,
                j = high,
                pivot = get(ar[Math.floor((low + high) / 2)]),
                swap = function (items, firstIndex, secondIndex) {
                    var temp = items[firstIndex];
                    items[firstIndex] = items[secondIndex];
                    items[secondIndex] = temp;
                };
            do { // partition
                while (desc ? get(ar[i]) > pivot : get(ar[i]) < pivot) {
                    i++;
                }
                while (desc ? get(ar[j]) < pivot : get(ar[j]) > pivot) {
                    j--;
                }
                if (i <= j) {
                    swap(ar, i, j);
                    i++;
                    j--;
                }

            } while (i <= j);
            if (low < j) sort(ar, low, j);
            if (i < high) sort(ar, i, high);
        },
        fLen = field.length,
        p;

    if ((list) && (list.length)) {
        var list1 = [],
            list2 = [];
        for (var k = 0, kLen = list.length; k < kLen; k++) {
            if ((childField) && (list[k][childField])) {
                list[k][childField] = quickSort(list[k][childField], field, desc, childField);
            }
            if (typeof get(list[k]) === 'undefined') {
                list2.push(list[k]);
            } else {
                list1.push(list[k]);
            }
        }
        if (list1.length > 1) {
            sort(list1, 0, list1.length - 1);
        }
        return list1.concat(list2);
    }
    return [];
};

//Сортировка по коду (числовые коды сортирует как числа)
 window.sortByCode = function(row1, row2) {
	let s1 = (row1.CODE + '').replace(/(\d+)/g, "0000000000$1").replace(/0*(\d{10,})/g, "$1");
	let s2 = (row2.CODE + '').replace(/(\d+)/g, "0000000000$1").replace(/0*(\d{10,})/g, "$1");
	return (s1 > s2) ? 1 : ((s2 > s1) ? -1 : 0);
}

window.setColumnsSettings = function (columns, setts) {
    var colSett = setts.Column,
        groupSett = setts.Group,
        sorting = [];
    for (var k = 0, kLen = columns.length; k < kLen; k++) {
        if ((columns[k].columns) && (columns[k].columns.length)) {
            sorting = sorting.concat(setColumnsSettings(columns[k].columns, setts));
        }
        var isFind = false;
        for (var j = 0, jLen = colSett.length; j < jLen; j++) {
            if (colSett[j].key == columns[k].dataIndex) {
                isFind = true;
                columns[k].index = colSett[j].RowLayout.OriginX;
                columns[k].width = colSett[j].width;
                columns[k].hideable = colSett[j].hideable;
                columns[k].hidden = !colSett[j].visibility;

                switch (colSett[j].sorting) {
                    case 'Ascending':
                        sorting.push({
                            property: columns[k].dataIndex,
                            direction: 'ASC',
                            sorting_order: colSett[j].sorting_order
                        });
                        break;
                    case 'Descending':
                        sorting.push({
                            property: columns[k].dataIndex,
                            direction: 'DESC',
                            sorting_order: colSett[j].sorting_order
                        });
                        break;
                }
                ;
                break;
            }
        }

        if ((groupSett) && (!isFind)) {
            for (var i = 0, len = groupSett.length; i < len; i++) {
                if ((groupSett[i].key == columns[k].text) && (groupSett[i].columns)) {
                    columns[k].index = groupSett[i].RowLayout.OriginX;
                    columns[k].width = groupSett[i].width;
                    columns[k].hidden = !groupSett[i].visibility;
                    break;
                }
            }
        }
    }
    return quickSort(sorting, 'sorting_order');
};

window.getExtStyle = function (ext) {
    const clsContain = ' rks-background-contain ';
    if (ext) {
        switch (ext) {
            case 'doc':
            case 'docx':
            case 'dot':
            case 'rtf':
                return 'x_btn_doc' + clsContain;
            case 'xls':
            case 'xlsx':
            case 'xlt':
                return 'x_btn_xls'+ clsContain;
            case 'exe':
                return 'x_btn_exe'+ clsContain;
            case 'rar':
            case '7z':
            case 'zip':
                return 'x_btn_archive'+ clsContain;
            case 'pdf':
                return 'x_btn_pdf'+ clsContain;
            case 'sql':
                return 'x_btn_ssms'+ clsContain;
            default:
                return 'x_btn_def'+ clsContain;
        }
    } else {
        return '';
    }
};

window.concatDictionary = function (a, b) {
    var c = {};
    for (var d in a) c[d] = a[d];
    for (var e in b) c[e] = b[e];
    return c;
};

window.swapRows = function (store, row1, row2) {
    if (row1 && row2 && store) {
        var index1 = row1.index,
            index2 = row2.index;
        store.remove(row1);
        store.remove(row2);
        row1.index = index2;
        row2.index = index1;
        store.insert(index1, row2);
        store.insert(index2, row1);
    }
};

window.moveRowToFirst = function (store, row) {
    if (row && store) {
        store.remove(row);
        var items = store.data.items;
        for (var i = 0; i < items.length; i++) {
            items[i].index = i + 1;
        }
        row.index = 0;
        store.insert(0, row);
    }
};

window.moveRowToLast = function (store, row) {
    if (row && store) {
        store.remove(row);
        var items = store.data.items;
        for (var i = 0; i < items.length; i++) {
            items[i].index = i;
        }
        row.index = items.length;
        store.insert(items.length, row);
    }
};

window.relationsMsg = function (name, notDel, links, tabMode, parentView, limitLinks, continueFunc) {
    var text = '',
        related = false;
    Ext.each(notDel,
        function (el) {
            text += (el.name === '()' ? '' : (el.name + ': ')) + el.text + '<br>';
            related = related || el.related;
        });
    var msgView = Ext.create('Ext.window.Window',
        {
            title: KS.L10n.attention,
            iconCls: Ext.MessageBox.ERROR,
            bodyPadding: 10,
            resizable: false,
            modal: true,
            items: [Ext.create('Ext.form.Label', {bodyPadding: 10, html: text})],
            buttons: [
                Ext.create('Ext.Button',
                    {
                        text: Ext.isFunction(continueFunc) ? KS.L10n.otmena : 'ОК',
                        handler: function () {
                            msgView.close();
                        }
                    }),
                Ext.create('Ext.Button',
                    {
                        text: KS.L10n.prodolgit,
                        hidden: !Ext.isFunction(continueFunc),
                        handler: function () {
                            continueFunc();
                            msgView.close();
                        }
                    }),
                Ext.create('Ext.Button',
                    {
                        text: KS.L10n.pokazat,
                        hidden: !related,
                        handler: function () {
                            Ext.create('RevizorRelationsView',
                                {
                                    tabMode: tabMode,
                                    parentView: parentView,
                                    title: KS.L10n.svyazi,
                                    code: dnl[name] || name,
                                    links: links,
                                    limitLinks: limitLinks
                                });

                            msgView.close();
                        }
                    })
            ]
        });
    msgView.show(parentView,
        function () {
            if (msgView.getX() < 0) msgView.setX(0);
            if (msgView.getY() < 0) msgView.setY(0);
        });
};

window.addHist = function (table, callBack) {
    PeriodLib.addHist(table, callBack);
};

window.extraSelect = function (selected, grid) {
    var model = grid.getSelectionModel(),
        store = grid.getStore(),
        view = grid.view;
    if (!model.store) {
        model.store = store;
        if (!model.views.length) {
            model.views = [view];
        }
    }

    selected && model.select(selected);
};

window.selectDialogShow = function (title, text, yesFunc, noFunc, parent, callBack) {
    Ext.Msg.show({
        title: title,
        msg: text,
        buttons: Ext.MessageBox.YESNO,
        animateTarget: parent,
        fn: function (buttonId) {
            if (buttonId == 'yes' && yesFunc) yesFunc();
            if ((buttonId == 'no' || buttonId == 'cancel') && noFunc) noFunc();
            if (callBack) callBack();
        },
        icon: Ext.MessageBox.QUESTION
    });
};

window.selectDialogShowAsync = function (title, text, defaultBtn = 'yes') {
	return new Ext.Promise(function (resolve) {
		Ext.Msg.show({
			title: title,
			msg: text,
			buttons: Ext.MessageBox.YESNO,
			fn: function (buttonId) {
				resolve(buttonId);
			},
			icon: Ext.MessageBox.QUESTION,
			defaultFocus: '#' + defaultBtn,
		});
	});
}

/**
 * Асинхронное отображение диалога с кнопками
 * @param cfg
 * @returns {Ext.Promise}
 */
window.dialogShowAsync = function (cfg) {
	return new Ext.Promise(function (resolve) {
		let initCfg = {
			buttons: Ext.MessageBox.YESNO,
			fn: function (buttonId) {
				resolve(buttonId);
			},
			icon: Ext.MessageBox.QUESTION,
		};

		Ext.apply(initCfg, cfg);
		if (cfg.defaultBtn) initCfg.defaultFocus = '#' + cfg.defaultBtn;
		Ext.Msg.show(initCfg);
	});
}

window.failureShow = function (result, title) {
    var commentText;
    const html = result.responseText || result.statusText;
    const message = result.messageText || 'Произошла ошибка в приложении.'
    const win = Ext.create('Ext.window.Window',
        {
            title: title,
            iconCls: Ext.MessageBox.ERROR,
            closable: true,
            border: 0,
            bodyBorer: false,
            padding: 5,
            minHeight: 150,
            minWidth: 400,
            modal: true,
            width: 500,
            maximizable: true,
            autoRender: true,
            layout: {type: 'vbox', align: 'stretch'},
            items: [
                {
                    xtype: 'label',
                    readOnly: true,
                    border: 0,
                    padding: '5 0 10 10',
                    html: message + '\r\nПожалуйста отправьте отчёт разработчикам для быстрого решения проблемы',
                },
                commentText = Ext.create('Ext.form.field.Text',
                    {
                        emptyText: 'Добавьте ваш комментарий (это не обязательно)',
                        growMax: 150,
                        grow: true
                    }),
                Ext.create('Ext.form.FieldSet',
                    {
                        title: 'Подробнее',
                        flex: 1,
                        layout: { type: 'vbox', align: 'stretch' },
                        collapsible: true,
                        collapsed: true, 
                        items: [
                            {
                                xtype: 'panel',
                                header: false,
                                hideCollapseTool: true,
                                border: 0,
                                maxHeight: 400,
                                overflowY: "auto",
                                overflowX: "auto",
                                html
                            }
                        ]
                    }),
                
            ],
            buttons: [
                Ext.create('Ext.Button',
                    {
                        text: 'Закрыть',
                        handler: function () {
                            win.close();
                        }
                    }),
                Ext.create('Ext.Button',
                    {
                        text: 'Oтправить отчёт разработчикам',
                        handler: function () {
                            let comment = commentText.getValue();

                            ajaxRequest({
                                url: 'data/SendErrorReport_A',
                                params: {
                                    comment,
                                    html
                                },
                                success: () => {
                                    QuickTip.show({
                                        title: 'Отчет успешно отправлен, спасибо!',
                                        width: 300,
                                        iconCls: 'x_btn_ok'
                                    });
                                    win.close();
                                },
                            });


                        }
                    })
            ]
        });
    win.show();
};

window.getCntDaysInPeriod = function (dt1, dt2, sOrg, successFunc, failureFunc, callback) {
    ajaxRequest({
        url: 'data/GetCntDaysInPeriod_A',
        params: {dt1: dt1, dt2: dt2, sOrg: sOrg},
        success: successFunc,
        failure: failureFunc,
        callback: callback
    });
};

window.getCntDaysInPeriodMany = function (dictStr, sOrg, successFunc, failureFunc, callback) {
    ajaxRequest({
        url: 'data/GetCntDaysInPeriodMany_A',
        params: {dictStr: dictStr, sOrg: sOrg},
        success: successFunc,
        failure: failureFunc,
        callback: callback
    });
};

window.rendererCell = function (val, metaData, record) {
    return val ? renderDate(val, metaData, record) : '';
};

window.rendererFile = function (v, m, r, fieldExt) {
    var ext = r.get(fieldExt || 'TEMP_EXT');
    return ext ? '<img class="x-action-col-icon ' + getExtStyle(ext) + '">' : '';
};

window.renderDate = function (val, metaData, record) {
    return Ext.isDate(val) || metaData.column.xtype === 'datecolumn' ? Ext.util.Format.date(val, metaData.column.format) : val;    
};

window.allColumnAdapted = function (columns, grid) {
    var colFn = function(col) {
        if (col.isSummary) {
            col.summaryRenderer = function(value, summaryData, dataIndex) {
                let allCols = columns.slice();
                Ext.each(columns, parentCol => {
                    if (parentCol.columns) {
                        Ext.each(parentCol.columns, childCol => {
                            allCols.push(childCol);
                        });
                    }
                });
                let cols = allCols.filter((c) => { return c.dataIndex === dataIndex; });
                let isSum = cols[0].summaryType && cols[0].summaryType.length;
                let val = cols[0].xtype === 'decimalcolumn' ? convertToDecimal(value ?? '', cols[0].decimalData) : value;
                return isSum ? `∑ = ${val}` : '';
                //return Ext.String.format('{0} student{1}', value, value !== 1 ? 's' : ''); 
            }
        }

        if (col.xtype == 'checkcolumn' && col.readOnly) {
            delete col.readOnly;
            if (!col.listeners) col.listeners = {};
            col.listeners.beforecheckchange = function () {
                return false;
            };
        }
        if ((!col.dataIndex) && ((!col.columns) || (!col.columns.length))) {
            columns.splice(i, 1);
        }
        //todo скрытие периода действия
        if (['Период действия', 'Создано', 'Изменено'].indexOf(col.text) !== -1) {
            col.hidden = true;
            if (col.columns) {
                for (var j = 0, len = col.columns.length; j < len; j++) {
                    col.columns[j].hidden = true;
                }
            }
        }
        
        if (col.columns && col.columns.length) {
            for (var j = 0, len = col.columns.length; j < len; j++) {
                colFn(col.columns[j]);
            }
        }
    };

    //добавим аналог rowSelector в вине, будет отступ от крайней левой колонки + плюс иконка в левом верхнем меню грида
    if (!(grid instanceof Ext.tree.Panel)) {
        window.addRowNumbererClm(grid, columns);
    }
    else {
        const colTree = columns.filter(col => col.dataIndex === 'tree')[0];
        if (colTree != null) {
            colTree.text = '<span class="ks-column-header-icon x_btn_grid_menu"></span>';
            colTree.menuDisabled = true;
            colTree.onTitleElClick = function (e) {
                grid.columnSettings?.show();
                e.stopEvent();
            }
        }
    }
    for (var i = columns.length - 1; i > -1; i--) {
        colFn(columns[i]);        
    }
    return columns;
};

window.addRowNumbererClm = function(grid, columns){
    //добавим аналог rowSelector в вине, будет отступ от крайней левой колонки + плюс иконка в левом верхнем меню грида
    if (grid && ArrayLib.find(columns, ['dataIndex'], 'rowNumberer') === -1){
        columns.unshift({
            xtype: 'rks-grid-column-rownumberer',
            index: -100,
            dataIndex: 'rowNumberer',
            onTitleElClick(e) {
            if (!e.target.classList.contains('x_btn_clear_filter') && !e.target.querySelector('.x_btn_clear_filter')){
                    grid.columnSettings?.show();
                }                
                e.stopEvent();
            },
        });
    }
}

window.parsUrl = function (url) {
    if (url[0] !== '/') url = '/' + url;
    return url;
};

window.ajaxRequest = function (cfg) {
    if (!cfg.params) cfg.params = {};
    if (SignalR.connect) {
        cfg.params.hubConnectionId = SignalR.connection.connection.connectionId;
        cfg.params.rid = SignalR.getRID();
        SignalR.addCallBack(cfg.params.rid, cfg);
        Ext.Ajax.request({
            async: cfg.async,
            url: urlPrefix + parsUrl(cfg.url),
            params: cfg.params,
            success: function (result) {
                window.ksPingFailure = 0;

                var data = result && result.responseText && result.responseText !== 'false'
                    ? jQuery.parseJSON(result.responseText)
                    : null;
                if (data) window.ajaxCallBack(data.id, data.rid, data.gzipData);
            },
            failure: function (ex) {
                if (ex.status === 0) return;
                Log.sendLog(wmc.get('errorByUrl', cfg.url, ex.status, ex.responseText));
                if (ex.status === 500) {
                    LoadMask.hide();
                    cfg.ignoreError ? _ : this.failureShow(ex, 'Ошибка');
                }
                if (cfg.failure) {
                    cfg.failure.apply(cfg, arguments);
                }
                if (cfg.callback) {
                    cfg.callback(null, arguments);
                }
            }
        });
    } else {
        cfg.params.rid = '';
        Ext.Ajax.request({
            async: cfg.async,
            url: urlPrefix + parsUrl(cfg.url),
            timeout: cfg.timeout,
            params: cfg.params,
            success: function (result) {
                window.ksPingFailure = 0;
                Log.sendLog(wmc.get('backByUrl', cfg.url, cfg.params.rid));
                if (cfg.success) {
                    var data = result && result.responseText && result.responseText !== 'false'
                        ? jQuery.parseJSON(result.responseText)
                        : null;
                    if (!data && result.status === 0) warning(wmc.get('TimeOut'));
                    cfg.success(data, arguments);

                    if (cfg.callback) {
                        cfg.callback(data, arguments);
                    }
                } else {
                    if (cfg.callback) {
                        cfg.callback(result && result.responseText && result.responseText !== 'false'
                            ? jQuery.parseJSON(result.responseText)
                            : null,
                            arguments);
                    }
                }
            },
            failure: function (ex) {
                Log.sendLog(wmc.get('errorByUrl', cfg.url, ex.status));
                if (ex.status === 500) {
                    !cfg.ignoreError && this.failureShow(ex, ex.statusText);
                }
                if (cfg.failure) {
                    cfg.failure.apply(cfg, arguments);
                }
                if (cfg.callback) {
                    cfg.callback(null, arguments);
                }
            }
        });
    }
    Log.sendLog(wmc.get('sendByUrl', cfg.url, JSON.stringify(cfg.params), cfg.params.rid));
    return cfg.params.rid;
};

window.ajaxRequestAsync = function (cfg) {
	return new Ext.Promise(function (resolve, reject) {
		cfg.success = (result) => {		    
			const data = result && result.responseText && result.responseText !== 'false'
				? Ext.JSON.decode(result.responseText, true)
				: null;
			cfg.callback && cfg.callback(data, arguments);			
			resolve(data)
		};
		cfg.failure = (ex) => {            
			if (ex.status === 500) {
				!cfg.ignoreError && this.failureShow(ex, ex.statusText);
			}
			reject(ex);
		};		
		Ext.Ajax.request(cfg);        
	})
},
window.objCopy = function (obj) {
    var res = {};
    for (var key in obj) res[key] = obj[key];
    return res;
};

window.loadProfile = function (cfg) {
    /*cfg: prefix, code, gateCode, controlName, profileKey, callBack*/
    var cacheKey = (cfg.prefix ? cfg.prefix + '_' : '') + (cfg.gateCode ? cfg.gateCode + '_' : '') + cfg.profileKey;
    /*if (cfg.profileKey && !LocalStorage.get(cacheKey, true)) {
        ajaxRequest({
            url: 'data/GetProfile_A',
            params: {
                code: cfg.code || '',
                key: cfg.profileKey,
                gateCode: cfg.gateCode || '',
                controlName: cfg.controlName || ''
            },
            success: function(result) {
                if (result) {
                    LocalStorage.set(cacheKey, result, true);
                }
            },
            callback: function() {
                if (cfg.callBack) {
                    cfg.callBack(LocalStorage.get(cacheKey), cfg);
                }
            }
        });
    } else*/
    {
        if (cfg.callBack) {
            cfg.callBack(LocalStorage.get(cacheKey), cfg);
        }
        else
            LocalStorage.get(cacheKey);
    }
};

window.setProfile = function (cfg) {
    /*cfg: code, key, gateCode, controlName, profile*/
    if (cfg.profile !== undefined) {
        ajaxRequest({
            url: 'data/SaveProfile_A',
            params: {
                code: cfg.code || '',
                key: cfg.key || '',
                gateCode: cfg.gateCode || '',
                controlName: cfg.controlName || '',
                profile: lzw.compress(JSON.stringify(cfg.profile))
            }
        });
    }
};

window.getTextEditor = function (callBack, maxLength) {
    if (!window.textEditor) {
        window.textEditor = Ext.create('Ext.window.Window',
            {
                items: [
                    window.textEditorTextArea = Ext.create('Ext.form.field.TextArea',
                        {
                            flex: 1,
                            enforceMaxLength: true
                        })
                ],
                bodyPadding: 5,
                layout: {type: 'vbox', align: 'stretch'},
                setValue: function (text) {
                    window.textEditorTextArea.setValue(text);
                },
                minWidth: 200,
                minHeight: 200,
                modal: true,
                maximizable: true,
                closeAction: 'hide',
                buttons: [
                    {
                        text: 'Применить',
                        handler: function () {
                            window.textEditor.close();
                        }
                    },
                    {
                        text: 'Отмена',
                        handler: function () {
                            window.textEditorTextArea.isCancel = true;
                            window.textEditor.close();
                        }
                    }
                ],
                listeners: {
                    show: function () {
                        window.textEditorTextArea.isCancel = false;
                    },
                    hide: function () {
                        if (window.textEditor.callBack && !window.textEditorTextArea.isCancel)
                            window.textEditor.callBack(window.textEditorTextArea.getValue());
                    }
                }
            });
    }
    window.textEditorTextArea.maxLength = maxLength || Number.MAX_VALUE;
    window.textEditor.callBack = callBack;
    return window.textEditor;
};

window.showTextEditor = function (text, callBack, title, maxLength) {
    var te = getTextEditor(callBack, maxLength);
    te.setValue(text);
    te.setTitle(title);
    te.show();
};

window.getTextViewer = function () {
    if (!window.textViewer) {
        window.textViewer = Ext.create('Ext.window.Window',
            {
                items: [window.textViewerTextArea = Ext.create('Ext.form.field.TextArea', {flex: 1, readOnly: true})],
                bodyPadding: 5,
                layout: {type: 'vbox', align: 'stretch'},
                setValue: function (text) {
                    window.textViewerTextArea.setValue(text);
                },
                minWidth: 200,
                minHeight: 200,
                modal: true,
                maximizable: true,
                closeAction: 'hide'
            });
    }
    return window.textViewer;
};

window.showTextViewer = function (text, title) {
    var te = getTextViewer();
    te.setValue(text);
    te.setTitle(title);
    te.show();
};

window.getI = function (v) {
    return v ? v.substring(0, 1) + '.' : '';
};

window.getFI = function (pers, prefix) {
    var res = '';
    prefix = prefix || '';
    Ext.each(pers,
        function (p) {
            if (res) res += ', ';
            res += p[prefix + 'LASTNAME'] + ' ' + getI(p[prefix + 'FIRSTNAME']) + getI(p[prefix + 'PATRONYMIC']);
        });
    return res;
};

(function () {
    try {
        var a = new Uint8Array(1);
        return; //no need
    } catch (e) {
    }

    function subarray(start, end) {
        return this.slice(start, end);
    }

    function set_(array, offset) {
        if (arguments.length < 2) offset = 0;
        for (var i = 0, n = array.length; i < n; ++i, ++offset)
            this[offset] = array[i] & 0xFF;
    }

    // we need typed arrays
    function TypedArray(arg1) {
        var result;
        if (typeof arg1 === "number") {
            result = new Array(arg1);
            for (var i = 0; i < arg1; ++i)
                result[i] = 0;
        } else
            result = arg1.slice(0);
        result.subarray = subarray;
        result.buffer = result;
        result.byteLength = result.length;
        result.set = set_;
        if (typeof arg1 === "object" && arg1.buffer)
            result.buffer = arg1.buffer;

        return result;
    }

    window.Uint8Array = TypedArray;
    window.Uint32Array = TypedArray;
    window.Int32Array = TypedArray;
})();

window.getNodeByPath = function (path, store) {
    store = store || objs.subNavigator.store;
    if (Ext.isString(path)) {
        path = path.split('/');
    }
    var root = store.getRootNode(),
        findFn = function (node, lvl) {
            if (node) {
                var res;
                node.eachChild(function (cNode) {
                    if (cNode.get('text') === path[lvl]) {
                        if (lvl === path.length - 1) {
                            res = cNode;
                            return false;
                        } else {
                            res = findFn(cNode, lvl + 1);
                            if (res) {
                                return false;
                            }
                        }
                    }
                });
                return res;
            }
            return null;
        };
    return findFn(root, 0);
};

//поиск строки в сырых древовидных данных
window.getRawRowByLink = function (nodes, link) {
    var me = this,
        res,
        children = [];

    Ext.each(nodes,
        function (n) {
            if (n.LINK == link) {
                res = {node: n, parent: nodes};
                return false;
            }
            if (n.children) children.push(n.children);
            return true;
        });

    if (res) return res;

    Ext.each(children,
        function (ch) {
            return !(res = me.getRawRowByLink(ch, link));
        });

    return res;
};

window.getMaskWhereArgs = function (link, code, filter) {
    return code && filter
        ? {
            Mask: {
                value: JSON.stringify({link: link || 0, code: code, filter: filter}),
                type: 'mask'
            }
        }
        : _;
};

/**
 * Функция фильтрации нодов. проверяет себя и детей (!ignoreHierarchy)
 * Eсли среди детей есть записи, подходящие под фильтр, родитель также подходит под фильтр
 * @param filterFunc {void} функция фильтра по данным
 * @param node {object} нод, на который происходит наложение фильтра
 * @param ignoreHierarchy {bool} проверять детей
 * */
window.filterCompound = (filterFunc, node, ignoreHierarchy)=>{
    let match = filterFunc(node);
    if (match) return match;

    if (!ignoreHierarchy && node.childNodes && node.childNodes.length) {

        let matchChild = false;
        for(let i = 0; i<node.childNodes.length; i++){
            if (filterCompound(filterFunc, node.childNodes[i])){
                matchChild = true;
                break;
            }
        }
        if (matchChild) match = true;
    }
    return match;
}

/**
 * Функция форматирования сумм
 * @param value {object} значение
 * @param decimalData {object} содержит в себе инфу по разделителю для знаков до сепаратора, сам сепаратор и кол-во знаков после сепаратора
 * */
window.convertToDecimal = function(value, decimalData) {
    if (value === null || value === undefined) return "";
    value = value.toString();
    if (!value.length) return "";
    
    value = (value).replace(/,/g, '.');
    value = (value + '').replace(/[^0-9+\-Ee.]/g, '');
    
    var n = isNaN(+value) ? 0 : +value,
        decLen = decimalData.decimals,
        result = '',
        toFixedFix = function(n, decLen) {
            var k = Math.pow(10, decLen);
            return '' + (Math.round(n * k) / k).toFixed(decLen);
        };
    
    result = (decLen ? toFixedFix(n, decLen) : '' + Math.round(n)).split('.');
    
    if (result[0].length > 3) {
        result[0] = result[0].replace(/\B(?=(?:\d{3})+(?!\d))/g, decimalData.groupSep);
    }
    
    if ((result[1] || '').length < decLen) {
        result[1] = result[1] || '';
        result[1] += new Array(decLen - result[1].length + 1).join('0');
    }
    
    return result.join(decimalData.decimalSep);
}

//ie не поддерживает startsWith
if (!String.prototype.startsWith) {
    String.prototype.startsWith = function (text) {
        return this.lastIndexOf(text, 0) === 0;
    };
}

String.prototype.capitalize = function() {
    return this.charAt(0).toUpperCase() + this.slice(1).toLowerCase();
}

/**
 * Преобразовать строку в float
 * @param val
 * @returns {number|number}
 */
window.strToNum = function(val) {
    return val ? parseFloat((val + '').replace(regSpace, '')) : 0;
}

window.getTextByVisibleFields = function(code, visibleFields, value, field) {
    let me = this,
        vfs = visibleFields ?? (code && dictListController[code]?.getVisibleFields 
            ? dictListController[code].getVisibleFields()
            : _);

    if (!value) return '';
    if (!vfs) return value[field];

    let reg = new RegExp('(?<name>[A-Za-z0-9А-Яа-я_]+)', 'g'),
        vf = (vfs).split(',').filter(vf => { return vf.length; }),
        res = '',
        lastSpace = true;

    Ext.each(vf, visibleField => {
        let lst = visibleField.match(reg);

        Ext.each(lst, l => {
            if (value.hasOwnProperty(l)) {
                let strToReplace = value[l];
                //Для колонки с датой - применим форматирование, что бы совпадало с Смарт  
                if (l === "DT" && !/\d\d\.\d\d\.\d{2,4}$/.test(strToReplace) && !isNaN(new Date(strToReplace).getDate())){
                    strToReplace = (new Date(strToReplace)).toLocaleDateString(); 
                }
                visibleField = visibleField.replace(l, strToReplace || '');
            }
        });

        res += ((lastSpace ? '' : ' ') + visibleField);
        lastSpace = res[res.length - 1] == " ";
    });

    return res;
}

/**
 * Учет размеров страницы при показе формы для корректного
   в окне будет выставлен scrollable: true, полосы прокрутки будут отображены, если размер окна < размера содержимого
 * @param view {Ext.window.Window} диалоговое окно
 * @param viewMinSizeCfg {Array} - [minWidth, minHeight]
 */
window.adaptDialogSize = function (view, viewMinSizeCfg){
	if (!view) return;
	if (!view.scrollable) view.setScrollable(true);
	if (!viewMinSizeCfg || !viewMinSizeCfg.length) viewMinSizeCfg = [0, 0]
	   
	let minWidthCfg = viewMinSizeCfg[0],
		minHeightCfg = viewMinSizeCfg[1],
		screenSize = Ext.getBody().getViewSize(),
		width = view.getWidth(),
		height = view.el.getHeight(),
		initWidth = width,
		initHeight = height,
		margin = 5;

	if (view.minWidth > screenSize.width - margin) {
		view.setMinWidth(screenSize.width - margin);
	}

	if (width < minWidthCfg)
		width = minWidthCfg;
	if (width > screenSize.width - margin)
		width = screenSize.width - margin;
	if (width !== initWidth) {
		view.el?.setWidth(width);
		view.body.el?.setWidth(width);
	}

	//мин высоту выставляем по ширине страницы (если превышает) 
	if (view.minHeight > screenSize.height - margin) {
		view.setMinHeight(screenSize.height - margin);
	}

	if (height < minHeightCfg)
		height = minHeightCfg;
	if (height > screenSize.height - margin)
		height = screenSize.height - margin;
	if (height !== initHeight) {
		//высоту окна выставляем по высоте страницы (если превышает) /мин высоте (если занижает) 
		view.el?.setHeight(height);
		//высоту содержимого окна выставляем по высоте страницы - высота заголовка (24) - высота тулбара (24) - отступы (2x2)
		view.body?.el?.setHeight(height - 52);
	}
}

window.copyTextToClipboard = async function({ text, showToast = false }) {
    try {
        if (navigator.clipboard) {
            await navigator.clipboard.writeText(text);
        } else {
            const area = document.createElement('textarea');
            area.innerHTML = text;
            document.body.appendChild(area);
            area.select();

            setTimeout(async () => {
                await document.execCommand('copy');
                document.body.removeChild(area);
            }, 1000);
        }
        if (showToast) QuickMsgs.showSuccess('Скопировано');
    } catch (err) {
        console.log('Ошибка при копировании в буфер', err);
    }
}

window.getFileForm = function() {
    return this.fileForm || (this.fileForm = Ext.create('Ext.form.Panel', { items: [Ext.create('Ext.form.field.File')] }).getForm());
}

window.parseUrl = function(url) {
    return urlPrefix + parsUrl(url);
}

window.getReportFile = function(guid, code) {
    getFileForm.call(this).submit({
        method: 'POST',
        url: parseUrl('Report/GetReportWeb'),
        params: {
            guid: guid,
            code: code
        },
        failure: function(form, action) {
            if (action.failureType === Ext.form.action.Action.SERVER_INVALID) {
                warning(action.result.msg);
            }
        }
    });
}