﻿Ext.define('Keysystems.FileEditorWindow', {
	constructor: function(cfg) {
		var me = this;
		me.objs = {};
		Ext.apply(me, cfg);
		me.initConfig(cfg);
		me.createWin();
		me.addViewEvents();
	},
	createWin: function() {
		var me = this;
		me.winCfg();
		me.objs.win = Ext.create('Ext.window.Window', me.objs.winCfg);
	},

	winCfg: function() {
		var me = this,
			objs = me.objs;
		objs.winCfg = {
			title: me.name,
			autoShow: true,
			resizable: false,
			draggable: true,
			layout: 'fit',
			padding: 0,
			bodyPadding: 0,
			code: '',
			link: '',
			id: '',
			name: '',
			nextID: '',
			doubleSave: '',
			width: 900,
			height: 650,
			saveChanges: true,
			items: me.createFrame(),
			listeners: {
				close: function() {
					if (!window.top.document.customButtonClick) {
						ajaxRequest({
							url: 'Uploader/ClearDocumentCache_A',
							params: { name: me.name }
							//success: callback
						});
					}
					window.top.document.documentChanged = false;
				}
			}
		};
		return objs.winCfg;
	},

	createFrame: function() {
		var me = this;
		return Ext.create('Ext.ux.IFrame', {
			src: Ext.urlAppend("http://localhost:58464/Uploader/Index", Ext.Object.toQueryString({ code: me.code, link: me.link, id: me.id, name: me.name, nextID: me.nextID, doubleSave: me.doubleSave }))
		});
	},
	addViewEvents: function() {
		var me = this,
			objs = me.objs;
		objs.win.on('beforeclose', function() {
			if (window.top.document.documentChanged) { // добавить сюда проверку на нажатие кнопки "Сохранить измененеия"  <script id="dxss_185242750" type="text/javascript">
				if (!window.top.document.customButtonClick) { // получение состояния напрямую из элемента Spreadsheet
					me.changeMsgShow({
						yes: function() {
							ajaxRequest({
								url: 'Uploader/CustomSave_A',
								params: { code: me.code, link: me.link, id: me.id, name: me.name, nextID: me.nextID, doubleSave: me.doubleSave }
								//success: callback
							});
							window.top.document.customButtonClick = true;
							(me.win || objs.win).close();
						},
						no: function() {
							window.top.document.documentChanged = false;
							(me.win || objs.win).close();
						}
					});
					return false;
				}
			}
			return true;
		});
	},
	changeMsgShow: function(cfg) {
		Ext.Msg.show({
			title: wmc.get('Attention'),
			msg: wmc.get('SaveChanges'),
			buttons: Ext.MessageBox.YESNOCANCEL,
			fn: function(buttonId) {
				var fn = cfg[buttonId] || cfg.default;
				if (fn) fn();
			},
			icon: Ext.MessageBox.QUESTION
		});
	}
});