Ext.define('Keysystems.EDSServiceModule', {
	extend: 'Ext.Component',

	config: {
		code: null,
		links: null,
		mode: null,
		extParams: null,
		code_eds_list: null,
		modal: false,
		target: null,
		silentMode: false
	},

	execute: function (cfg) {
		const me = this;
		Ext.apply(me, cfg);
		
		switch (me.mode) {
			case 'EDS_SET':
				me.sign(cfg);
				break;
			case 'EDS_DELETE':
				me.serverCall({
					waitMessage: KS.L10n["BaseRevizorPresenter_UnSign_Снятие_подписи"]
				})
				break;
			case 'SIGN_LIST':
				me.showSignList();
				break;
			case 'SIGNATURE_INFO_PROTOCOL':
			case 'EDS_EXTINFO':
				me.serverCall({
					waitMessage: KS.L10n["BaseRevizorPresenter_OnGetInfoCompleted_Информация_по_ЭП"]
				})
				break;
		}		
	},
	
	executeAsync: async function(cfg){
		const me = this;
		if (!cfg) cfg = {};
		return new Ext.Promise(function (resolve) {
			const onSuccessOwner = cfg.onSuccess;
			cfg.onSuccess = (response) => {
				if (onSuccessOwner  != null) onSuccessOwner(response);
				resolve(response);
			}
			me.execute(cfg);
		});
	},

	serverCall: function (cfg) {
		const me = this;
		const settings = {
			code: me.code,
			links: me.links,
			mode: me.mode,
			extParams: me.extParams,
			fromEditMode: me.fromEditMode
		};	

		const loadMask = new Ext.LoadMask({
			msg: cfg.waitMessage ?? KS.L10n.loading_data,
			target: me.target,
			autoShow: true,
			rid: ajaxRequest({
				params: {data: JSON.stringify(settings)},
				url: 'SSign/EDSServiceModule_A',
				success: function (value) {
					if (!value) {
						loadMask.destroy();
						window.failureShow({
							messageText: "Ошибка при выполнении."
						}, KS.L10n.attention);
						return;
					}
					
					if (!me.silentMode) {
						const htmlCfg = {
							text: value.htmlProtocol,
							title: KS.L10n["BaseRevizorPresenter_OnSignCompleted_Протокол_выполнения"],
							hasIgnoreButton: false,
							noPreStyle: true,
							width: 800,
							height: 600
						};
						ChooseBox.ShowHTMLLog(htmlCfg);
					}

					if (me.onSuccess) me.onSuccess(value);
				},
				callback: function () {
					loadMask.destroy();
				}
			})
		});
	},

	showSignList: function () {
		const me = this;
		const dict = dictListController[me.code_eds_list];
		const cfg =
			{
				code: me.code_eds_list,
				GateCode: me.code_eds_list,
				title: dict.title,
				tabMode: !me.modal,
				parentView: me.target,
				checkModel: false,
				handler: 'Keysystems.Base.List',
				linkCode: dict.linkCode,
				getWhereArgs: function () {
					return {
						DocLinks: {value: JSON.stringify(me.links), type: 'List_int'},
						ObjCode: {value: me.code, type: 'string'}
					}
				},
			};
		dictFunc(cfg);
	},

	sign: function(cfg) {
		const me = this;
		const certData = cfg?.certData;

		me.waitMessage = KS.L10n["BaseRevizorPresenter_Sign_Подписывание_документов"];
		if (!certData) {
			me.selectCertificate((cert) => {
					delete cert.id;
					me.signData(cert);
				}
			)
		}
		else{
			me.signData(certData);
		}
	},
	
	signData: async function(certData) {
		const me = this;

		const settings = {
			code: me.code,
			links: me.links,
			extParams: me.extParams,
			fromEditMode: me.fromEditMode
		};
		const loadMask = new Ext.LoadMask({
			msg: 'Получение данных для подписи...',
			target: me.target
		});
		loadMask.show();

		let data = await ajaxRequestAsync({
			params: {data: JSON.stringify(settings)},
			url: 'SSign/GetDataForSign_A'
		});

		if (!me.checkError(data, "Ошибка при получении данных для подписывания.")) {
			loadMask.destroy();
			return;
		}
		data.forEach(v => v.CertificateInfo = certData);
		loadMask.setMsg("Подпись данных...");

		data = await ajaxRequestAsync({
			params: {data: JSON.stringify(data)},
			url: 'SSign/DownloadHash_A'
		});
		if (!me.checkError(data, "Ошибка при вычислении хэша подписи.")) {
			loadMask.destroy();
			return;
		}

		let promises = [];
		data.forEach(row => {
			//для отчетов/файлов получаем хэш файла, подписываем хэш.
			//	при подписи хэша в зависимости от настроек сервиса первичек выставляем параметр CertIncluded
			//для текстовых данных подписываем данные в base64
			//	(при подписи в сыром виде возникает проблема с кодировкой, криптомодуль подписывает в utf, сервис первичек по умолчанию проверяет в 1251, пробросить иную кодировку для проверки в текущей реализации нет возможности)
			promises.push(new Promise(function (resolve) {
				const signer = row.IsFile
					? window.Signer.SignHash.Data
					: window.Signer.Detached.Data
				signer.Sign2({
					data: row.Hash ?? row.Data,
					B64: true,
					signParams: {
						CertInclude: row.SigType?.CertIncluded,
					},
					certSubj: certData.serial,
					onSuccess: function (hash) {
						resolve(hash);
					},
					onError: function (err) {
						me.checkError([{"Error": err}], "Ошибка при подписывании");
						loadMask.destroy();
					}
				})
			}));
		});

		const hashes = await Promise.all(promises);
		const dataSigned = data.map(function (item, i) {
			item.Signature = hashes[i];
			return item;
		});

		loadMask.setMsg("Сохранение подписи...");
		const value = await ajaxRequestAsync({
			params: {
				data: JSON.stringify(dataSigned),
				settings: JSON.stringify(settings)
			},
			url: 'SSign/Sign_A'
		});
		loadMask.destroy();
		if (!value) return;
		
		if (value.htmlProtocol && !me.silentMode) {
			const cfg = {
				text: value.htmlProtocol,
				title: KS.L10n["BaseRevizorPresenter_OnSignCompleted_Протокол_выполнения"],
				hasIgnoreButton: false,
				noPreStyle: true,
				width: 800,
				height: 600
			};
			ChooseBox.ShowHTMLLog(cfg);
		}
		if (me.onSuccess) {
			value.certData = certData;
			me.onSuccess(value);
		}
		window.Signer.Clear({});
	},

	selectCertificate: function (callBack) {
		const me = this;

		const loadMask = new Ext.LoadMask(
			{
				msg: 'Получение дополнительных параметров',
				target: me.target,
				rid: ajaxRequest({
					url: '/Data/GetSignSettings_A',
					success: function (result) {
						if (result.signSettings) {
							KS.edsType = result.edsType;

							KS.apply(result.signSettings, {
								noNeedFilter: true,
								noNeedParams: true,
								noNeedReestr: true,
								NastrKeyId: '',
								target: me.target
							});
							KS.XCrypt.viewContext = this;
							KS.XCrypt.initialize(result.signSettings,
								() => {
									KS.XCrypt.selectCertificate((data) => {
										if (data.notbefore) data.notbefore = PeriodLib.stringToDate(data.notbefore,'dd.MM.yyyy', '.').toDateString();
										if (data.notafter) data.notafter = PeriodLib.stringToDate(data.notafter,'dd.MM.yyyy', '.').toDateString();
										
										if (callBack) callBack(data);
									}, this)
								}, this, 'login');

						}
					},
					callback: function () {
						loadMask.destroy();
					}
				})
			});


	},

	checkError: function (result, text) {
		if (!result || !result.length || result[0].Error) {
			window.failureShow({
				statusText: result[0].Error,
				messageText: text + (result.length ? result[0].Error : '')
			}, KS.L10n.attention);
			return false;
		}
		return true;
	}
})