﻿import LocalStorage from "./LocalStorage";

Ext.define('Keysystems.Panel.Desktop', {
	extend: 'Ext.panel.Panel',
	title: 'Рабочий стол',
	iconCls: 'x_btn_desktop',
	/*autoScroll: true,
	autoRender: true,*/
	closable: true,
	flex: 1,
	border: 0,
	bodyPadding: 10,

	_ignoreWidgetKeys: ['window', 'dict', 'children', 'reportView', 'chart'],

	_ignoreKeysAtConvert: ['isFolder', 'isEodOut', 'isEodIn', 'isEds', 'PASSPORTORG'],

	initComponent: function() {
		var me = this;

		//me.tbar = [];

		me.widgetItems = [];
		me.items = [];

		if (me.widgetList) Ext.each(me.widgetList, function(wdgt) { me.pushWidget(me.createWidget(wdgt)); });

		return me.callParent(arguments);
	},

	initEvents: function() {
		var me = this;
		me.on('beforeclose', function() {
			if (!me.isExit) {
				selectDialogShow(wmc.get('Attention'), wmc.get('CloseDesktop'), function() {
					me.isExit = true;
					me.close();
				});
				return false;
			}

			ArrayLib.remove(Desktop.UI.items, me);
			Desktop.save();

			return true;
		});
		me.on('activate', function() {
			var showList = [];
			Ext.each(me.widgetItems, function(el) {
				if (el.widgetCfg.dict && !el.widgetCfg.dict.objs.view.rendered) {
					showList.push(el);
					el.hide();
				}
			});
			if (showList.length) setTimeout(function() { Ext.each(showList, function(el) { el.show(); }); }, 10);
			//todo надо найти способ сделать нормально, а не через это говно
		});
		me.callParent(arguments);
	},

	//#region Виджеты

	pushWidget: function(w) {
		var me = this;
		if (Ext.isArray(me.items)) {
			me.items.push(w);
		} else {
			me.add(w);
		}
		me.widgetItems.push(w);
		w.show();
	},

	fillWidget: function(w, cfg) {
		switch (cfg.type) {
		case 'dict':
			w.setLayout(Ext.layout.Layout.create('anchor'));
			w.setIconCls(cfg.iconCls || 'x_btn_dict');
			dictFunc({
				closable: false,
				tabMode: true,
				checkModel: false,
				code: cfg.code,
				parentView: w,
				controlName: cfg.controlName || 'Widget',
				GateCode: cfg.GateCode,
				head: false,
				viewCfg: function() {
					var res = this.callParent(arguments);
					delete res.iconCls;
					delete res.title;
					res.closable = false;
					return res;
				}
			}, _, function(dict) { cfg.dict = dict; });
			break;
		case 'report':
			w.setIconCls(cfg.iconCls || 'x_btn_report_query');
			w.add(cfg.reportView = Ext.create('Revizor.ReportView', {
				link_var: cfg.link_var,
				flex: 1,
				iconCls: '',
				border: 0,
				closable: false,
				code: cfg.code,
				id: cfg.code + '-' + Ext.id()
			}));
			break;
		case 'chart':
			w.setIconCls(cfg.iconCls || 'x_btn_diagram');
			cfg.flex = 1;
			w.add(cfg.chart = Ext.create('Keysystems.Chart', cfg));

			cfg.chart.refreshData();
			break;
		}
	},

	getWidgetBar: function(cfg) {
		var me = this,
			res = [
				Ext.create('Ext.Button', {
					iconCls: 'x_btn_exit',
					tooltip: 'Выход',
					tooltipType: 'title',
					handler: function() { cfg.window.close(); }
				}),
				Ext.create('Ext.Button', {
					iconCls: 'x_btn_font_style_und',
					tooltip: 'Переименовать',
					tooltipType: 'title',
					handler: function() {
						Ext.Msg.show({
							title: 'Переименование',
							msg: wmc.get('EnterNewName'),
							prompt: true,
							buttons: Ext.Msg.OKCANCEL,
							value: cfg.title,
							fn: function(bid, v) {
								if (bid === 'ok' && v) {
									cfg.window.setTitle(cfg.title = v);
									me.runSave();
								}
							},
							icon: Ext.MessageBox.QUESTION
						});
					}
				}),
				Ext.create('Ext.Button', {
					iconCls: 'x_btn_showtabs',
					tooltip: 'В отдельную вкладку',
					tooltipType: 'title',
					handler: function() { me.toGeneralTab(cfg); }
				})
			];

		switch (cfg.type) {
		case 'dict':
			res.push(Ext.create('Ext.Button', {
				iconCls: 'x_btn_diagram',
				tooltip: 'Создать график',
				tooltipType: 'title',
				//hidden: true,
				handler: function() {
					me.settingChart(cfg, function(v) {
						v.type = 'chart';
						me.pushWidget(me.createWidget(v));
						me.runSave();
					});
				}
			}));
			break;
		case 'chart':
			res.push(
				Ext.create('Ext.Button', {
					iconCls: 'x_btn_settings_blue',
					tooltip: 'Настройки',
					tooltipType: 'title',
					//hidden: true,
					handler: function() {
						me.settingChart(cfg, function(v) {
							var w = cfg.window;
							w.remove(cfg.chart);
							w.widgetCfg = cfg = v;

							var p = w.getPosition(),
								s = w.getSize();
							cfg.x = p[0];
							cfg.y = p[1];
							cfg.w = s.width;
							cfg.h = s.height;
							cfg.window = w;
							cfg.type = 'chart';
							w.setTitle(cfg.title || '');
							me.fillWidget(w, cfg);
							me.runSave();
						});
					}
				}),
				Ext.create('Ext.button.Split', {
					iconCls: 'x_btn_import',
					tooltip: 'Сохранить изображение',
					tooltipType: 'title',
					hidden: true,
					handler: function() { cfg.chart.save({ type: 'image/png' }); },
					menu: [
						{ text: 'png', handler: function() { cfg.chart.save({ type: 'image/png' }); } },
						{ text: 'jpeg', handler: function() { cfg.chart.save({ type: 'image/jpeg' }); } },
						{ text: 'svg', handler: function() { cfg.chart.save({ type: 'image/svg' }); } }
					]
				})
			);
			break;
		}

		return res;
	},

	toGeneralTab: function(cfg) {
		cfg = cfg || {};
		switch (cfg.type) {
		case 'dict':
			dictFunc({
				tabMode: true,
				checkModel: false,
				code: cfg.code,
				title: cfg.title,
				parentView: window.tabView,
				controlName: cfg.controlName || 'Widget',
				GateCode: cfg.GateCode
			});
			break;
		case 'report':
			window.tabView.add(Ext.create('Revizor.ReportView', {
				link_var: cfg.link_var,
				flex: 1,
				border: 0,
				title: cfg.title,
				code: cfg.code,
				id: cfg.code + '-' + Ext.id()
			}));
			break;
		case 'chart':
			cfg.iconCls = 'x_btn_diagram';
			cfg.border = 0;
			window.tabView.add(Ext.create('Keysystems.Chart', cfg)).refreshData();
			break;
		}
	},

	createWidget: function(cfg) {
		cfg = cfg || {};
		var me = this,
			w = Ext.create('Ext.window.Window', {
				title: cfg.title || 'Widget',
				lbar: me.getWidgetBar(cfg),
				layout: { type: 'vbox', align: 'stretch' },
				width: cfg.w || 200,
				height: cfg.h || 200,
				widgetCfg: cfg,
				autoScroll: true,
				autoRender: true,
				shadow: false,
				cls: 'ks-login',
				x: cfg.x,
				y: cfg.y,
				listeners: {
					move: function(th, x, y) {
						if (x < me.bodyPadding) this.setX(me.bodyPadding);
						if (y < me.bodyPadding) this.setY(me.bodyPadding);


						cfg.x = x;
						cfg.y = y;
						me.runSave();
					},
					beforeclose: function() {
						if (!w.isExit) {
							selectDialogShow(wmc.get('Attention'), wmc.get('CloseWidget'), function() {
								w.isExit = true;
								w.close();
							});
							return false;
						}

						ArrayLib.remove(me.items, this);
						ArrayLib.remove(me.widgetItems, this);
						me.runSave();

						return true;
					},
					resize: {
						buffer: 500,
						fn: function(th, width, h) {
							cfg.w = width;
							cfg.h = h;
							me.runSave();
						}
					}
				}
			});

		cfg.window = w;
		me.fillWidget(w, cfg);

		return w;
	},

	getWidgetForJson: function(cfg) {
		var ignore = this._ignoreWidgetKeys,
			c = {};
		for (var k in cfg) if (ignore.indexOf(k) === -1) c[k] = cfg[k];
		return c;
	},

	getWidgets: function() {
		var me = this,
			res = [];
		Ext.each(me.widgetItems, function(el) { if (el.widgetCfg) res.push(me.getWidgetForJson(el.widgetCfg)); });
		return res;
	},

	convertToWidget: function(item) {
		var f;
		Ext.each(this._ignoreKeysAtConvert, function(k) { return !(f = item[k]); });
		if (f) return _;

		if (item.isRepAll) return Ext.apply({ type: 'report', title: item.text }, item);

		return {
			type: 'dict',
			title: item.text,
			iconCls: item.iconCls,
			code: item.code,
			GateCode: item.GateCode,
			controlName: item.controlName
		};
	},

	addWidget: function(item) {
		var me = this,
			wdgt = me.convertToWidget(item);
		if (wdgt) me.pushWidget(me.createWidget(wdgt));
	},

	//#region Графики

	settingChart: function(cfg, callback) {
		Ext.create('Keysystems.Chart.Settings', {
			autoShow: true,
			widgetCfg: cfg,
			callback: callback
		});
	},

	//#endregion Графики

	//#endregion Виджеты

	getDesktopForSave: function() {
		var me = this;
		return { title: me.title, widgetList: me.getWidgets() };
	},

	runSave: function() {
		var me = this;
		if (me.saveTimeout) clearTimeout(me.saveTimeout);
		setTimeout(function() {
			delete me.saveTimeout;
			Desktop.save();
		}, 1000);
	}
});

window.Desktop = {
	UI: {
		items: [],
		createPanel: function(cfg) {
			var me = this,
				p = Ext.create('Keysystems.Panel.Desktop', cfg);
			me.items.push(p);
			return p;
		}
	},
	add: function(cfg) { window.tabView.add(this.UI.createPanel(cfg)); },
	newDesktop: function() {
		this.add();
		this.save();
	},
	show: function() {
		var me = this;
		Ext.each(LocalStorage.get(me.saveKey), function(el) { me.add(el); });
	},
	getSaveList: function() {
		var res = [];
		Ext.each(this.UI.items, function(p) { res.push(p.getDesktopForSave()); });
		return res;
	},
	saveKey: 'DesktopList',
	save: function() {
		var me = this;
		LocalStorage.set(me.saveKey, me.getSaveList());
	}
};

export default Desktop;