﻿;
window.ChooseBox = {
	preStyle: '<style type="text/css">BODY{font-family: COURIER NEW, COURIER;font-size: X-SMALL;color: BLACK;}PRE{font-family: COURIER NEW, COURIER;font-size: X-SMALL;color: BLACK;}H1{font-size: SMALL;margin: 0;padding: 2 2 4 2;}HR{height: 1;color: GRAY;}.QUOTE{background: #DDDDFF;}#WARN{color: RED;font-weight: BOLD;}#INFO{color: BLUE;font-weight: BOLD;}#good{color: GREEN;font-weight: BOLD;}#LOCK{color: GRAY;font-weight: BOLD;}#NONE{color: BLACK;}TABLE.GRID{font-family: COURIER NEW, COURIER;font-size: X-SMALL;border: 1 GRAY SOLID;}TH{color: BLACK;}TR.SUBTITLE{background: #EFEFEF;}TR.ODD{background: WHITE;}TR.EVEN{background: #EFEFFF;}TD.CELL{border: 0;}TABLE.GRID_IN{font-family: COURIER NEW, COURIER;font-size: X-SMALL;border: 1 GRAY SOLID;width: 100%;}TR.TITLE TH{background: SILVER;color: BLACK;border-bottom: 1 GRAY SOLID;padding: 0 4 0 4;}.hrefstyle{cursor: pointer;text-decoration: underline;color: blue;}.error{color: #cc0000;}.warn{color: #999900;font-weight: BOLD;}.xlnum{mso-number-format: \#\,\#\#0\.00;text-align: right;}.good{color: GREEN;font-weight: BOLD;}.tableCodes{font-size:0.8rem;margin-bottom:10px;}.captionTable{color: BLUE;font-weight: BOLD;padding-bottom:5px}.columnData{padding-bottom:10px;}.columnName{width: 200px;vertical-align:top;}.error{color: RED;font-weight: BOLD;}.caption{padding-bottom:2px;}.trace{font-size:0.8rem;margin-top:5px;margin-bottom:5px;}</style>',
	ShowHTML: function(cfg) {
		var me = this,
			c = {
				title: cfg.caption || KS.L10n.attention,
				msg: me.preStyle + cfg.text,
				icon: cfg.icon || (cfg.warnOrErrorIcon ? Ext.MessageBox.WARNING : Ext.MessageBox.ERROR),
				buttons: Ext.MessageBox.OK
			};
		if (cfg.resizable) c.resizable = true;
		if (cfg.maximizable) c.maximizable = true;
		if (cfg.hasIgnoreButton) {
			c.buttons = Ext.MessageBox.OKCANCEL;
			c.buttonText = {ok: 'Продолжить', cancel: 'Отмена'};
			c.icon = Ext.MessageBox.WARNING;
			c.fn = function(bId) { if (bId === 'ok' && cfg.nextFn) cfg.nextFn(); };
		}
		if (cfg.info) {
			c.icon = _;
			c.title = _;
		}
		Ext.MessageBox.show(c);
	},

	/**
	 * Отобразить html-лог
	 * @param cfg {object}
	 * @param cfg.text {string} html-текст
	 * @param cfg.title {string} заголовок окна
	 * @param cfg.hasIgnoreButton {boolean} отображать кнопку Продолжить (действие - cfg.nextFn)
	 * @param cfg.noPreStyle {boolean} не использовать preStyle стили
	 * @param cfg.modal {boolean} в модальном окне
	 * @param cfg.height {number} высота окна
	 * @param cfg.width {number} ширина окна
	 */
	ShowHTMLLog: function(cfg) {
		let me = this,
			html = cfg.noPreStyle ? cfg.text :  me.preStyle + cfg.text;

		const afterRender = function () {
			//копия HtmlProtocolMaker.DEFJSCRIPT. требуется для корректного сворачивания/разворачивания лога, extjs игнорит встраиваемый в html-текст окна скрипт 
			let o=document.currentScript&&document.currentScript.parentElement||document,
				e=function(e){let r=e.cls,c=e.btnSelector;Array.prototype.slice.call(o.querySelectorAll(".".concat(r))).forEach((function(o){var e=o.querySelector(c);e&&e.addEventListener("click",(function(){return function(o,e){var r=!!~Array.prototype.slice.call(o.classList).indexOf(e);o.classList[r?"remove":"add"](e)}(o,"".concat(r,"--expanded"))}))}))};
			e({cls:"protocol-file",btnSelector:".protocol-file-header > .protocol-file-header__toggle-btn"}),e({cls:"protocol-card",btnSelector:".protocol-card-header > .protocol-card-header__toggle-btn"}),e({cls:"protocol-grid",btnSelector:".protocol-grid-header > .protocol-grid-header__toggle-btn"}),e({cls:"protocol-accordion",btnSelector:".protocol-accordion-header > .protocol-accordion-header__toggle-btn"});
		};
		const window = Ext.create('Ext.window.Window', {
			height: cfg.height ?? 400,
			width: cfg.width ?? 600,
			modal: cfg.modal !== undefined ? cfg.modal : true,
			maximizable: true,
			scrollable: true,
			title: cfg.title,
			tbar: [
				{
					iconCls: 'x_btn_save',
					tooltip: 'Сохранить',
					tooltipType: 'title',
					handler: function () {
						let uploader = Ext.create('Keysystems.Uploader.DataUploader', {
							parseUrl: function (url) {
								return urlPrefix + parsUrl(url);
							}
						});
						uploader.getFileFromHTML(html, cfg.title);
					}
				},
				Ext.create('Ext.Button', {
					iconCls: 'x_btn_print',
					tooltip: 'Печать',
					tooltipType: 'title',
					handler: function () {
						let win = window.open('', 'snapshot');
						win.document.open();
						win.document.write(html);
						win.document.close();
						win.print();
					}
				})
			],
			items: [
				Ext.create('Ext.panel.Panel', {
					layout: 'fit',
					border: 0,
					bodyStyle: 'border:0; padding: 0 5px;',
					html: html,
				})
			],
			buttons: [
				Ext.create('Ext.Button', {
					text: 'Продолжить',
					hidden: !cfg.hasIgnoreButton,
					handler: function () {
						window.close();
						if (cfg.nextFn) {
							cfg.nextFn();
						}
					}
				}),
				Ext.create('Ext.Button', {
					text: 'Закрыть',
					handler: function () {
						window.close();
					}
				})
			],
			listeners: {
				afterrender: afterRender
			}
		});
		window.show();
	},
	
	ShowCheckCodeMessage: function(checkCodeResult, callBack) {
		if (!checkCodeResult.Info) {
			if (callBack) callBack(checkCodeResult);
			return;
		}
		
		let ccMessage = checkCodeResult.Info,
			buttonText = {},
			btns = 0;
		for (let i = 0; i < ccMessage.Actions.length; i++) {
			btns += Math.pow(2, i);
			buttonText[Ext.Msg.buttonIds[i]] = window.miscTypes.CheckAction[ccMessage.Actions[i]];
		}
		Ext.Msg.show({
			title: KS.L10n.attention,
			buttons: btns,
			buttonText: buttonText,
			msg: ccMessage.Text.replace(/\r\n/g, '<br \/>'),
			fn: function (buttonId) {
				const res = +KsLib.getKeyByValue(miscTypes.CheckAction, buttonText[buttonId]);
				checkCodeResult.Info = null;
				checkCodeResult.Action = res;
				
				switch(res){
					case 1: //Добавить
						if (ccMessage.CanCloseDH) {
							selectDialogShow(KS.L10n.attention, KS.L10n.Закрыть_период_действия_старой_записи, function () {
								checkCodeResult.DHModeAdd = 1; //Close;
								if (callBack) callBack(checkCodeResult);
							});
							return;
						}
					case 3: //Заменить
						if (ccMessage.CanCloseDH) {
							selectDialogShow(KS.L10n.attention, KS.L10n.Расширить_период_действия_, function () {
								checkCodeResult.DHModeReplace = 5; //Close;
								if (callBack) callBack(checkCodeResult);
							});
							return;
						}
				}
				if (callBack) callBack(checkCodeResult);
			},
			checkVisible: ccMessage.ShowCheck,
			checkHandler: function (th, v) {
				check = v;
			},
			icon: Ext.MessageBox.QUESTION
		})
	},

	ShowCheckStampMessage: function(checkStampResult, callBack) {
		if (!checkStampResult.Info) {
			if (callBack) callBack(checkStampResult);
			return;
		}
		let ccMessage = checkStampResult.Info,
			buttonText = {},
			btns = 0;
		for (let i = 0; i < ccMessage.Actions.length; i++) {
			btns += Math.pow(2, i);
			buttonText[Ext.Msg.buttonIds[i]] = window.miscTypes.RestoreAction[ccMessage.Actions[i]];
		}
		Ext.Msg.show({
			title: KS.L10n.attention,
			buttons: btns,
			buttonText: buttonText,
			msg: ccMessage.Text.replace(/\r\n/g, '<br \/>'),
			fn: function (buttonId) {
				const res = +KsLib.getKeyByValue(miscTypes.RestoreAction, buttonText[buttonId]);
				checkStampResult.Info = null;
				checkStampResult.Action = res;
				if (callBack) callBack(checkStampResult);
			},
			checkVisible: false,
			icon: Ext.MessageBox.QUESTION
		})
	}
	
	
};