﻿Ext.define('Keysystems.ux.CacheEngine', {
	extend: 'Ext.util.Observable',

	cache: {},

	constructor: function(config) {

		/*  RWEB-112  this.addEvents({
		       added: true,
		       updated: true,
		       removed: true,
		       expired: true
		   }); */

		Ext.apply(this, config);

		var cacheTask = {
			run: function() {
				// Get current time
				var now = new Date().getTime();

				// Remove items
				var removed = [];

				for (var key in this.cache) {
					var item = this.cache[key];
					if (item.expires < now) {
						removed.push({
							key: item.key,
							value: item.value
						});
						delete this.cache[key];
					}
				}

				// Fire event
				// if (removed.length) this.fireEvent('expired', this, removed); //RWEB-112
			},
			interval: 60000,
			scope: this
		};

		Ext.TaskManager.start(cacheTask);

		// Call our superclass constructor to complete construction process.
		this.callParent(arguments);
	},

	clear: function() {
		this.cache = {};
	},

	get: function(key) {
		var item = this.cache[key];
		if (item) item = item.value;
		return item;
	},

	set: function(key, value, timeout /*seconds*/) {
		timeout = timeout || 3600;
		var item = this.cache[key];
		this.cache[key] = {
			value: value,
			expires: new Date().getTime() + (timeout * 1000)
		};
		this.fireEvent(item ? 'updated' : 'added', this);
	},

	remove: function(key) {
		var item = this.cache[key];
		if (item) {
			delete this.cache[key];
			this.fireEvent('removed', this);
			return true;
		}
		return false;
	},

	removeByCode: function(code) {
		for (let obj in this.cache) {
			try {
				let key = JSON.parse(obj);
				if (key.code === code) this.remove(obj);
			}
			catch (e) {}
		}		
	},

	has: function(key) {
		return !!this.cache[key];
	}
});