Ext.define('Keysystems.NotificationManager', {
	extend: 'Ext.panel.Panel',
	xtype: 'ks-notificationmanager',
	alias: 'widget.ks-notificationmanager',
	floating: true,
	defaultAlign: 'tl-tr',
	height: '100%',
	width: 400,
	title: KS.L10n.tsentropoveshchenii,
	closable: true,
	closeAction: 'Hide',
	layout: 'fit',
	maxNotificationsCount: 50,
	bodyStyle: {
		borderLeftWidth: '0px',
		borderRightWidth: '0px'
	},
	config: {
		store: null,
		anchor: null,
		isShown: false,
		cacheKey: null,
		unreadCount: 0,	
	},
	bind: {
		store: '{notifications}',
		unreadCount: '{unreadCount}',
		isShown: '{panelVisible}'
	},
	viewModel: {
		data: {
			selection: null
		},
		stores: {
			notifications: {
				fields: [],
				data: []
			},
			notificationsView: {
				type: 'chained',
				source: '{notifications}',
				sorters: {
					property: 'creationDate',
					direction: 'DESC'
				},
			}
		},
		formulas: {
			unreadCount: {
				bind: {
					bindTo: '{notifications}',
					deep: true
				},
				get: function (store) {
					var count = 0;

					if (store.count()) {
						count = store.getRange().filter(function (rec) {
							return rec.get('unread');
						}).length;
					}

					return count;
				}
			},
			unreadCountTitle: {
				bind: {
					bindTo: '{unreadCount}'
				},
				get: function (count) {
					return count ? KS.L10n.neprochitannikhopoveshchenii + count : KS.L10n.netneprochitannikhsoobshchenii;
				}
			}
		}
	},

	dockedItems: [
		{
			xtype: 'toolbar',
			dock: 'top',
			height: 40,
			padding: '0 14',
			layout: {
				type: 'hbox',
				align: 'center'
			},
			items: [
				{
					xtype: 'displayfield',
					fieldStyle: 'margin: 0',
					bind: '{unreadCountTitle}'
				},
				'->',
				{
					iconCls: 'x_btn_task',
					bind: {
						disabled: '{!notifications.count}'
					},
					menu: {
						plain: true,
						items: [
							{
								text: KS.L10n.vibratvse,
								handler: function () {
									this.up('ks-notificationmanager').SelectNotifications();
								}
							},
							{
								text: KS.L10n.neprochitannie,
								handler: function () {
									this.up('ks-notificationmanager').SelectNotifications('unread');
								}
							},
							{
								text: KS.L10n.prochitannie,
								handler: function () {
									this.up('ks-notificationmanager').SelectNotifications('read');
								}
							}
						]
					}
				},
				{
					margin: '0 12',
					tooltip: KS.L10n.pometitvsekakprochitannie,
					bind: {
						iconCls: '{ unreadCount > 0 ? "x_btn_mark_read" : "x_btn_mark" }',
						disabled: '{!unreadCount}'
					},
					handler: function () {
						this.up('ks-notificationmanager').MarkAllAsRead();
					}
				},
				{
					iconCls: 'x_btn_delete',
					tooltip: KS.L10n.udalitvibrannieopoveshcheniya,
					bind: {
						disabled: '{!selection}'
					},
					handler: function () {
						this.up('ks-notificationmanager').RemoveSelectedNotifications();
					}
				}
			]
		}
	],

	items: [
		{
			xtype: 'ks-notificationsview',
			bind: {
				store: '{notificationsView}',
				selection: '{selection}'
			}
		}
	],

	icons: {
		'default': 'notificate',
		'database': 'database',
		'database_toast': 'database_manager48',
		'news': 'news',
		'mail': 'letter'
	},

	updateUnreadCount(value) {
		const me = this;
		me.fireEvent('changeunradcount', me, value);
		me.unreadCount = value;
		return value;
	},

	GetPosX: function (isShown) {
		var me = this,
			viewportWidth = Ext.getViewportWidth();

		isShown = isShown === void 0 ? me.getIsShown() : isShown;
		return isShown ? viewportWidth - ((me.getWidth && me.getWidth.call ? me.getWidth() : me.width) || 400) : viewportWidth + 20;
	},

	getView: function () {
		return this.down('ks-notificationsview');
	},

	GetIconByType: function (type) {
		var icons = this.icons || {};
		if (!type) type = 'default';

		return 'x_btn_' + (icons[type] || icons.default);
	},

	GetToastIcon: function (type) {
		return this.icons[type + '_toast'] ? 'x_btn_' + this.icons[type + '_toast'] : this.GetIconByType(type) + '52';
	},

	onRender: function () {
		var me = this;
		me.callParent(arguments);
		me.InitResizeEvent();
		me.InitStoreConfig();
		me.InitEvents();
		me.OnAlignTargetResize();
		// setTimeout(function () {
		// 	me.CheckIDB();
		// }, 1000);

	},

	InitResizeEvent: function () {
		var me = this;

		me.alignTarget.on({
			resize: function () {
				me.OnAlignTargetResize();
			}
		});
	},

	InitEvents: function () {
		var me = this,
			store = me.getStore() || me.getViewModel().get('notifications'),
			view = me.getView();

		store.on({
			add: function (store, records) {
				records.forEach(function (rec) {
					if (rec.get('showToast') !== false && rec.get('unread')) {
						me.ShowToast({
							title: rec.get('title'),
							text: rec.get('description'),
							author: rec.get('author'),
							icon: me.GetToastIcon(rec.get('type')),
							buttonText: rec.get('buttonText')
						});
					}

					!rec.get('cacheKey') && me.SaveNotificationInIDB(rec);
				});
			},

			update: function (store, record, operation, fields) {
				if (!fields || !fields.includes || fields.includes('action')) return;

				me.SaveNotificationInIDB(record);
			},

			remove: function (store, records) {
				records.forEach(function (rec) {
					me.DeleteNotificationFormIDB(rec);
				});
			}
		});

		view.on({
			itemclickclose: function (view, notification) {
				me.DoNotificationEventFn(notification, 'close');

				me.getStore().remove(notification);
			},

			itembuttonclick: function (view, notification) {
				var result = false;

				if (notification.get('fulltext')) {
					me.ShowFullText(notification);
					result = true;
				} else {
					result = me.DoNotificationEventFn(notification, 'buttonclick');
				}

				result && me.ToggleUnread(notification, false);

			},

			itemclicktogglereadstate: function (view, notification) {
				me.ToggleUnread(notification);
			},

			itemdblclick: function (view, notification) {
				if (!notification || !notification.isModel) return;

				var eventName = notification.get('fireButtonEventOnCardDblClick') ? 'buttonclick' : 'notificationdblclick';

				me.DoNotificationEventFn(notification, eventName);
			}
		});

		// Dashboard.MainPanel.el.on('click', function (e, target) {
		// 	if (me.getIsShown()) {
		// 		var cmp = Ext.get(target).component ? Ext.get(target).component : {},
		// 			isMe = me.contains(cmp, true) || e.getTarget('.ks-dashboard-header-notification-btn');
		//
		// 		!isMe && me.Hide();
		// 	}
		// });
	},

	InitStoreConfig: function () {
		var me = this,
			store = store = me.getStore() || me.getViewModel().get('notifications'),
			fields = [
				{
					name: 'unread',
					type: 'boolean',
					defaultValue: true
				}, {
					name: 'important',
					type: 'boolean',
					defaultValue: false
				}, {
					name: 'title',
					type: 'string'
				},
				{
					name: 'description',
					type: 'string'
				},
				{
					name: 'fulltext',
					type: 'string',
					convert: function (value) {
						return value ? Replace(value, '\n', '') : '';
					}
				},
				{
					name: 'type',
					type: 'string',
					defaultValue: 'default'
				},
				{
					name: 'author',
					type: 'string'
				},

				{
					name: 'iconCustom',
					type: 'string'
				},
				//тип иконки - зависит от типа или iconCustom
				{
					name: 'iconCls',
					type: 'string',
					calculate: function (data) {
						return data.iconCustom || me.GetIconByType(data.type);
					}
				},
				//дата создания
				{
					name: 'creationDate',
					type: 'date'
				},
				{
					name: 'showToast',
					type: 'boolean',
					defaultValue: true
				},

				{
					name: 'notSave',
					type: 'boolean',
					defaultValue: false
				},
				{
					name: 'cacheKey',
					type: 'string',
					defaultValue: null
				},
				//событие клика на кнопку при двойном клике на оповещение
				{
					name: 'fireButtonEventOnCardDblClick',
					type: 'boolean',
					defaultType: false
				},
				{
					name: 'closeManagerAfterClick',
					type: 'boolean',
					defaultType: false
				},
				{
					name: 'events',
					defaultValue: {}
				}, //close notificationdblclick buttonclick markasread 
				'buttonConfig' //iconCls text
			];

		store.setFields(fields);
	},

	ShowFullText: function (notification) {
		var text = notification.get('fulltext'),
			title = notification.get('title'),
			win;

		if (Ext.isString(text)) {
			win = ExtUtils.ShowText(text, {title: title});
		}

		win && win.setAlwaysOnTop && win.setAlwaysOnTop(true);
	},

	DoNotificationEventFn: function (notification, eventName) {
		if (!notification || !notification.isModel || !eventName) return;

		try {
			var events = notification.get('events'),
				eventFn = events ? events[eventName] : null,
				result = false;

			if (eventFn && eventFn.call) {
				eventFn.call(null, notification);
				result = true;
			}

			result && eventName.includes('click') && notification.get('closeManagerAfterClick') && this.Hide();

			return result;
		} catch (e) {
			console.warn(KS.L10n.oshibkavipolneniyafunktsii + eventName + KS.L10n.opoveshcheniya + e.message);
			events[eventName] = null;
			return false;
		}

	},

	ToggleUnread: function (notification, newValue) {
		if (!notification || !notification.isModel) return;

		newValue = newValue !== void 0 ? newValue : !notification.get('unread');

		notification.set('unread', newValue);

		if (notification.get('unread') === false) {
			this.DoNotificationEventFn(notification, 'markasread');

			notification.get('events').markasread = null;
		}
	},

	GetNotificationCacheKey: function (id) {
		var salt = Ext.String.format('{0}-{1}', id, new Date().toISOString());

		return SparkMD5.hash('notifications_' + salt);
	},

	OnAlignTargetResize: function () {
		var me = this,
			alignTarget = me.alignTarget,
			alignTargetY = alignTarget.getY(),
			x = me.GetPosX(),
			y = alignTargetY;

		if (me.rendered) {
			me.setHeight && me.setHeight.call && me.setHeight(alignTarget.getHeight());

			me.setXY && me.setXY.call && me.setXY([x, y]);
		}
	},

	//panel visible
	Toggle: function () {
		var me = this,
			isShown = me.getIsShown();

		isShown ? me.Hide() : me.Show();
	},

	Show: function () {
		var me = this;

		if (me.rendered && !me.getIsShown()) {
			me.setIsShown(true);
			me.SlidePanel(true);
		}
	},

	Hide: function () {
		var me = this;

		if (me.rendered && me.getIsShown()) {
			me.setIsShown(false);
			me.SlidePanel();
		}
	},

	SlidePanel: function (showAction) {
		var me = this,
			startX = me.GetPosX(!showAction),
			endX = me.GetPosX(showAction),
			posY = me.alignTarget.getY();

		me.el.animate({
			from: {
				x: startX,
				y: posY,
				//opacity: +!showAction
			},
			to: {
				x: endX,
				y: posY,
				//opacity: +showAction
			},
			ease: 'easeOut',
			duration: 200,
			dynamic: true
		});
	},

	//toast

	ShowToast: function (p) {
		if (!p) return;

		p.align = 'br';

		Keysystems.Bubble.showWithDelay(p);
	},

	//select, mark, remove
	SelectNotifications: function (type) {
		var me = this,
			view = me.getView(),
			notifications = me.getStore().getRange();

		if (!notifications.length) return;

		if (type) {
			var isUnread = type === 'unread';
			notifications = notifications.filter(function (rec) {
				return rec.get('unread') === isUnread;
			});
		}

		view.setSelection(notifications.length ? notifications : false);
	},

	MarkAllAsRead: function () {
		var me = this,
			store = me.getStore();

		store.each(function (notification) {
			me.ToggleUnread(notification, false);
		});
	},

	RemoveSelectedNotifications: function () {
		var me = this,
			view = me.getView(),
			selection = view.getSelection();

		if (!selection.length) return;

		selection.forEach(function (notification) {
			me.RemoveNotification(notification);
		});
	},

	//IDB

	CheckIDB: function () {
		var me = this;

		IDB.GetAll(me.getIDBName(), null, function (data) {
			if (!data || !data.length) return;

			data.forEach(function (recData) {
				var notification = me.ParceNotificationsFormIDB(recData.Content);

				if (notification) {
					me.store.add(notification);
				}
			});
		});
	},

	SaveNotificationInIDB(notification) {
		if (notification.get('notSave') === true) {
			return;
		}

		let cacheKey = notification.get('cacheKey');

		if (!cacheKey) {
			cacheKey = this.GetNotificationCacheKey(notification.id);

			notification.set({cacheKey});
		}

		const data = this.ConvertNotificationDataToIDB(notification.getData());

		IDB.Set(this.getIDBName(), cacheKey, data);
	},

	DeleteNotificationFormIDB: function (notification, cb) {
		var cacheKey = notification.get('cacheKey');

		cacheKey && IDB.Delete(this.getIDBName(), cacheKey, cb);
	},

	ConvertNotificationDataToIDB: function (data) {
		if (!data) return;

		var recData = Ext.clone(data),
			events = recData.events,
			fn;

		if (events) {
			for (var key in events) {
				fn = events[key];

				if (fn && fn.call) {
					events[key] = fn.toString();
				}
			}
		}

		return recData;
	},

	ParceNotificationsFormIDB: function (recData) {
		if (!recData) return;

		if (recData.events) {
			var fn;

			for (var key in recData.events) {
				fn = recData.events[key];
				try {
					fn = eval('(' + fn + ')');
					recData.events[key] = fn.call ? fn : null;
				} catch (e) {
					recData.events[key] = null;
				}

			}
		}
		return recData;
	},

	//public

	GetNotificationById: function (id) {
		return this.getStore().getById(id);
	},

	AddNotification: function (p) {
		if (!p) return console.warn(KS.L10n.neukazaniparametri);

		var me = this;

		if (p.unread === void 0 || p.unread === null) {
			p.unread = true;
		}

		var store = me.getStore() || me.getViewModel().get('notifications');

		if (!store) return console.warn(KS.L10n.oshibkanetstore);

		if (!p.creationDate) p.creationDate = new Date();

		if (!p.id) {
			p.id = Ext.id(null, p.type + '_' + new Date().getTime());
		}

		return store.add(p);
	},

	RemoveNotification: function (p) {
		if (!p) return console.warn(KS.L10n.netparametra);

		var me = this,
			store = me.getStore(),
			notification = p.isModel ? p : me.GetNotificationById(p);

		if (!notification) return console.warn(KS.L10n.netparametra);

		store.remove(notification);

		return notification;
	},

	EditNotification: function (p) {
		if (!p) return console.warn(KS.L10n.neukazaniparametri);

		var me = this,
			id = p.id,
			params = p.params,
			notification = me.GetNotificationById(id);

		if (!notification) return console.warn(KS.L10n.opoveshchenienenaideno);

		notification.set(params);

		me.SaveNotificationInIDB(notification);

		return notification;
	}
});