Ext.define('Keysystems.NotificationList', {
	extend: 'Ext.view.View',
	alias: 'widget.notificationsview',
	xtype: 'ks-notificationsview',
	itemSelector: 'div.notification-card',
	style: {
		backgroundColor: '#fff'
	},
	overItemCls: 'notification-card-over',
	selectedItemCls: 'notification-card-selected',
	scrollable: 'y',
	trackOver: true,
	selectionModel: {
		type: 'dataviewmodel',
		mode: 'MULTI',
		allowDeselect: true
	},
	initComponent: function () {
		KS.L10n.vagno = 'Важно';
		KS.L10n.pokazat = 'Показать';
		this.callParent(arguments);
	},
	listeners: {
		itemclick: function (me, notification, item, index, e) {
			var action = e.target.dataset.action || e.target.parentElement.dataset.action;
			if (!action) return;
			me.fireEvent(action, me, notification);
		}
	},

	itemTpl: new Ext.XTemplate(
		'<div class="notification-card {[values.unread ? "notification-card_unread" : "notification-card_read"]}">',
		'<div class="notification-card__line" data-action="itemclicktogglereadstate"></div>',
		'<div class="notification-card__remove-btn" data-action="itemclickclose">',
		'<div class="ks-icon-small_close_default notification-card__remove-btn-icon  notification-card__remove-btn_default-icon"></div>',
		'<div class="ks-icon-small_close_hover notification-card__remove-btn-icon  notification-card__remove-btn_over-icon"></div>',
		'</div>',
		//date
		'<div class="notification-card__block notification-card__header">',
		'<div class="notification-card__icon {[this.getIcon(values)]}"></div>',
		'<span class="notification-card__creation-date">{creationDate:date("d.m.Y H:i")}</span>',
		'</div>',
		//title
		'<div class="notification-card__block">',
		'<p class="notification-card__title">',
		'{[values.important ? this.getImportantBadge() : ""]}  {title}',
		'</p>',
		'</div>',
		//text
		'<tpl if="description">',
		'<div class="notification-card__block">',
		'<p class="notification-card__description">{description}</p>',
		'</div>',
		'</tpl>',
		//action
		'<tpl if="this.isHasBtn(values)">',
		'<div class="notification-card__block">{[this.getBtn(values)]}</div>',
		'</tpl>',
		'</div>',
		{
			getIcon: function (values) {
				return values.iconCls;
			},
			getImportantBadge: function () {
				return `<span class="notification-card__important-badge">${KS.L10n.vagno}</span>`;
			},
			isHasBtn: function (values) {
				var config = values.buttonConfig,
					fulltext = values.fulltext;

				return !!(config || fulltext);
			},
			getBtn: function (values) {
				var config = values.buttonConfig,
					fulltext = values.fulltext,
					icon,
					text;

				if (config) {
					icon = config.iconCls;
					text = config.text;
				} else if (fulltext) {
					icon = '';
					text = KS.L10n.pokazat;
				}

				if (!icon && !text) return '';

				var iconEl = '';
				if (icon) {
					iconEl = '<div class="notification-card__icon ' + icon + '"></div>';
				}
				text = '<span class="notification-card__action-btn-text">' + text + '</span>';
				return '<button class="notification-card__action-btn" data-action="itembuttonclick">' + iconEl + text + '</button>';
			}
		}
	)
});