﻿UpdaterLib = {
	subVersion: 1, //ключ для принудительного обновления у клиентов

	isFileLoaded: {}, //Загруженные ранее файлы

	jsContent: '',
	cssContent: '',

	files: [
		{
			name: 'GlobalCss',
			url: '/Content/combined.css',
			verKey: 'build',
			useSubVer: true,
			type: 'css'
		},
		{
			name: 'ExtJs',
			url: '/wwwroot/Scripts/Ext/ext-all.js',
			verKey: 'extVer',
			type: 'js'
		},
		{
			name: 'GlobalJs',
			url: '/wwwroot/Scripts/combined.js',
			verKey: 'build',
			useSubVer: true,
			type: 'js'
		}
	],

	init: function() {
		var me = this;
		IndexedDBLib.get('info', function(v) {
			me.info = v = v && v !== -1 ? v : {};
			var isMissing = me.checkMissing(v),
				isUpdate = me.checkUpdate(v);
			if (isMissing || !isUpdate || me.info.__update) {
				me.runFill(true);
			} else {
				me.renderView();
			}
		});
	},

	afterFill: function() {
		var me = this;
		me.incrementCssFile(me.cssContent, function() {
			me.incrementJsFile(me.jsContent, function() {
				if (me.view) {
					document.body.removeChild(me.view);
					delete me.view;
					delete me.mainDom;
					delete me.progressDom;
					delete me.progressNameDom;
					delete me.progressValueDom;
					delete me.checkUpdateDom;
				}
			});
		});
	},

	checkMissing: function(info) {
		var me = this;
		for (var i = 0, l = me.files.length; i < l; i++) {
			if (!info[me.files[i].name]) return true;
			if (window.alwaysUpdateClientFiles && me.files[i].useSubVer) return true;
		}
		return false;
	},

	checkUpdate: function(info) {
		var me = this;
		for (var i = 0, l = me.files.length; i < l; i++) {
			var file = me.files[i],
				newVer = me.getNewVersion(file);
			if (info[file.name] !== newVer) return true;
		}
		return false;
	},

	getNewVersion: function(param) { return window[param.verKey] + (param.useSubVer ? this.subVersion : ''); },

	runFill: function(isUpdate) {
		var me = this;
		me.fill(function() { me.afterFill(); }, isUpdate);
	},

	fill: function(callback, isUpdate) {
		var me = this;
		if (!me.files.length) {
			callback && callback();
			return;
		}
		var param = me.files.shift(),
			newVer = param.newVer = me.getNewVersion(param),
			oldVer = param.oldVer = me.info[param.name];

		if (window.alwaysUpdateClientFiles && param.useSubVer && oldVer) {
			IndexedDBLib.del(param.name + oldVer);
			oldVer = param.oldVer = '';
		}

		if (!oldVer || (isUpdate && oldVer !== newVer)) {
			me.runDownLoad(param.name, param.url, function(content) {
				me.saveAndIncrementFile(param, content, function() { me.fill(callback, isUpdate); });
			});
		} else {
			IndexedDBLib.get(param.name + oldVer, function(content) {
				me.incrementFile(param, content);
				me.fill(callback, isUpdate);
			});
		}
	},

	runDownLoad: function(name, url, callback) {
		var me = this;

		if (!me.view) {
			me.renderView(function() { me.downLoadFile(name, url, callback); });
		} else {
			me.downLoadFile(name, url, callback);
		}
	},

	downLoadFile: function(name, url, callback) {
		var me = this;

		me.mainDom.classList.add('progress');
		me.progressNameDom.innerHTML = name;
		me.loadFileFrom(
			url,
			function(v) { callback && callback(v); },
			function(e) {
				me.mainDom.classList.add('error');
				console.log(e);
			},
			function(e) {
				me.progressDom.max = e.total;
				me.progressDom.value = e.loaded;
				me.progressValueDom.innerHTML = (e.loaded / e.total) * 100 | 0;
			});
	},

	loadFileFrom: function(url, onLoad, onError, onProgress) {
		var me = this;
		if (me.isFileLoaded[url]) {
			onLoad && onLoad(me.isFileLoaded[url]);
			return;
		}

		var isError = false, xhr, status;

		xhr = typeof XMLHttpRequest === 'undefined' ? new ActiveXObject('Microsoft.XMLHTTP') : new XMLHttpRequest();
		xhr.onprogress = onProgress;
		xhr.onloadend = function() {
			status = (xhr.status === 1223)
				? 204
				: (xhr.status === 0 && ((self.location || {}).protocol == 'file:' || (self.location || {}).protocol == 'ionp:'))
				? 200 :
				xhr.status;

			if (!isError && (status > 199 && status < 300) || (status === 304)) {
				me.isFileLoaded[url] = xhr.responseText;

				onLoad && onLoad(me.isFileLoaded[url]);
			}
		};
		xhr.onerror = onError;

		try {
			xhr.open('GET', me.getUrlPrefix() + url, true);
			xhr.send(null);
		} catch (e) {
			isError = true;
		}

		if (isError && onError) onError();
	},

	getUrlPrefix: function() {
		if (!this.urlPrefix) {
			// Учет префикса url-адреса
			var urlPrefix = location.pathname.length === 1 && location.pathname === '/' ? location.pathname.substring(1, location.pathname.length) : location.pathname;
			if (urlPrefix[urlPrefix.length - 1] === '/') urlPrefix = urlPrefix.substring(0, urlPrefix.length - 1);
			this.urlPrefix = urlPrefix;
		}
		return this.urlPrefix;
	},

	renderView: function(callback) {
		var me = this,
			iframe = me.view = document.createElement('iframe');
		iframe.style.position = 'absolute';
		iframe.style.border = 0;
		iframe.style.left = 0;
		iframe.style.top = 0;
		iframe.style.height = '100%';
		iframe.style.width = '100%';
		iframe.src = me.getUrlPrefix() + '/Home/UpdaterView';
		iframe.onload = function() { me.frameBind(this.contentDocument, callback); };
		document.body.appendChild(iframe);
	},

	callOldVer: function() { this.runFill(false); },
	callUpdate: function() { this.runFill(true); },

	frameBind: function(doc, callback) {
		var me = this,
			updBtn = doc.getElementsByClassName('update')[0],
			oldBtn = doc.getElementsByClassName('submit')[0],
			checkUpdate = doc.getElementById('alwaysUpdate');

		me.mainDom = doc.getElementById('main');
		me.progressDom = doc.getElementById('progress');
		me.progressNameDom = doc.getElementById('progress_name');
		me.progressValueDom = doc.getElementById('progress_value');

		updBtn.addEventListener('click', function() { me.callUpdate(); });
		oldBtn.addEventListener('click', function() { me.callOldVer(); });
		checkUpdate.addEventListener('click', function(e) {
			me.info.__update = e.target.checked;
			IndexedDBLib.set('info', me.info);
		});

		callback && callback();
	},

	incrementJsFile: function(content, callback) {
		var sc = document.createElement('script');
		sc.innerHTML = content;
		sc.onload = callback;
		document.body.appendChild(sc);
	},

	incrementCssFile: function(content, callback) {
		var style = document.createElement('style');
		style.type = 'text/css';
		style.innerHTML = content;
		document.body.appendChild(style);
		callback && callback();
	},

	incrementFile: function(param, content) {
		var me = this;
		switch (param.type) {
		case 'js':
			me.jsContent += content; //me.incrementJsFile(, callback);
			break;
		case 'css':
			me.cssContent += content; //me.incrementCssFile(, callback);
			break;
		}
	},

	saveAndIncrementFile: function(param, content, callback) {
		var me = this;
		IndexedDBLib.set(param.name + param.newVer, content, function() {
			me.incrementFile(param, content);
			me.info[param.name] = param.newVer;
			IndexedDBLib.set('info', me.info, function() {
				param.oldVer && IndexedDBLib.del(param.name + param.oldVer);
				callback && callback();
			});
		});
	}
};

UpdaterLib.init();

window.UpdaterLib = UpdaterLib;