﻿Ext.define('Keysystems.Sql.Manager', {
	extend: 'Ext.panel.Panel',

	flex: 1,
	layout: 'border',
	border: 0,
	title: 'Редактор SQL-запросов',
	iconCls: 'x_btn_sql_gen',

	initComponent: function() {
		var me = this;

		me.wIconCls = me.iconCls;
		me.wTitle = me.title;
		me.iconCls = '';
		me.title = '';

		me.items = [
			me.createSqlPanel(),
			me.resultPanel = Ext.create('Ext.tab.Panel', { region: 'south', split: true, flex: 1 })
		];

		return me.callParent(arguments);
	},

	//#region sql

	createSqlTBar: function() {
		return [
			Ext.create('Ext.Button', {
				iconCls: 'x_btn_wow',
				tooltip: 'Запустить (F5/F9)',
				tooltipType: 'title',
				text: 'Запустить',
				handler: this.execSql,
				scope: this
			})
		];
	},

	execSql: function() {
		var me = this;
		const loadMask = new Ext.LoadMask({
			msg: wmc.getMask('ExecSql'),
			target: me,
			autoShow:true,
			rid: ajaxRequest({
				url: 'Sql/ExecuteCommand_A',
				params: { command: me.sqlTextEditor.getSelectionText() || me.sqlTextEditor.getValue() },
				success: function(result) { me.showResult(result); },
				callback: function() {
					loadMask.destroy();
					me.sqlTextEditor.focus();
				}
			})
		});
	},

	createSqlPanel: function() {
		var me = this;
		return Ext.create('Ext.panel.Panel', {
			layout: { type: 'vbox', align: 'stretch' },
			tbar: me.createSqlTBar(),
			border: 0,
			region: 'center',
			items: me.sqlTextEditor = Ext.create('Ext.form.field.TextArea', {
				flex: 1,
				enableKeyEvents: true,
				listeners: {
					keydown: function(th, e) {
						var k = e.getKey();
						if (k === e.F5 || k === e.F9) {
							me.execSql();
							e.preventDefault();
						}
					}
				}
			})
		});
	},

	//#endregion sql

	parseResult: function(table) { Ext.each(table, function(row) { for (var k in row) if (row[k] && row[k].length > 1000) row[k] = wmc.get('SqlLengthError'); }); },

	createResultGrid: function(table, tableName) {
		if (table && table.length) {
			this.parseResult(table);
			var fields = [],
				columns = [],
				row = table[0];

			for (var k in row) {
				fields.push(k);
				columns.push({ dataIndex: k, text: k });
			}

			return Ext.create('Ext.grid.Panel', {
				title: tableName + ' Rows:' + table.length,
				tbar: [],
				autoScroll: true,
				autoRender: true,
				border: 0,
				plugins: ['bufferedrenderer'],
				store: Ext.create('Ext.data.Store', { fields: fields, data: table, proxy: 'memory' }),
				columns: columns,
				columnLines: true
			});
		}

		return _;
	},

	showResult: function(result) {
		var me = this;
		me.resultPanel.removeAll();
		if (result !== '{}') {
			result = JSON.parse(result);

			for (var tn in result) me.resultPanel.add(me.createResultGrid(result[tn], tn));
		}
	},

	show: function() {
		var me = this;

		Ext.create('Ext.window.Window', {
			layout: { type: 'vbox', align: 'stretch' },
			width: 500,
			height: 300,
			maximizable: true,
			title: me.wTitle,
			iconCls: me.wIconCls,
			items: me
		}).show();
		//Ext.create('Keysystems.Sql.Manager').show();
	}
});