﻿Ext.define('Keysystems.Profile.Manager', {
	extend: 'Ext.container.Container',

	profileKey: 'extraProfile',
	timeout: 500,

	setProfile: function(v) {
		var me = this;
		try {
			v = v && Ext.isString(v) ? JSON.parse(v) : v;
			me.profile = v || null;
			v && cacheEngine.set(me.getProfileKey(), v, 180);
		} catch (e) {
			try {
				v = lzw.decompress(v);
				v = v && Ext.isString(v) ? JSON.parse(v) : v;
				me.profile = v || null;
				v && cacheEngine.set(me.getProfileKey(), v, 180);
				return _;
			} catch (e) {

			} 

			me.profile = null;
		}
	},

	getProfile: function() { 
		return this.profile || (this.profile = cacheEngine.get(this.getProfileKey()) || {}); 
		},

	set: function(key, v, toJson) {
		v = toJson ? JSON.stringify(v) : v;
		var p = this.getProfile();
		if (p[key] !== v) {
			p[key] = v;
			this.saveProfile();
		}
	},

	get: function(key, isJson) {
		var v = this.getProfile()[key];
		return v && isJson ? JSON.parse(v) : v;
	},

	getProfileKey: function() { return JSON.stringify(this.getOwnerParam()); },

	getOwnerParam: function() {
		var ownerCt = this.ownerCt;
		return {
			code: ownerCt.profileCode || ownerCt.code || '',
			key: ownerCt.profileKey,
			gateCode: ownerCt.GateCode || '',
			controlName: ownerCt.controlName || ''
		};
	},

	runSaveProfile: function(profile) {
		var params = this.getOwnerParam();
		params.profile = profile;

		// console.warn('Сохранение профиля в БД');
		// console.warn(profile);
		ajaxRequest({ url: 'data/SaveProfile_A', params: params });

		cacheEngine.set(this.getProfileKey(), JSON.parse(profile), 180);
	},

	saveProfile: function() {
		var me = this,
			ownerCt = me.ownerCt;
		if (!ownerCt) return;
		if (me.saveTimeoutId) clearTimeout(me.saveTimeoutId);
		var profile = JSON.stringify(me.getProfile());
		if (profile !== '{}') {
			me.saveTimeoutId = setTimeout(function() {
				delete me.saveTimeoutId;
				me.runSaveProfile(profile);
			}, saveProfileTimeOut);
		}
	},

	profileListeners: [],

	getProfileMethod: function(methodName, profileKey, controlName, control) {
		var me = this;
		var res = me.ownerCt.getProfileMethod(methodName, profileKey, controlName, control);
		if (res) return res;

		switch (methodName) {
		case 'resizeH':
			return {
				eventName: 'resize',
				eventFn: function(th, w, h) { me.set(profileKey, h); },
				loadFn: function(v) { this.setHeight(v); }
			};
		case 'resizeW':
			return {
				eventName: 'resize',
				eventFn: function(th, w) { me.set(profileKey, w); },
				loadFn: function(v) { this.setWidth(v); }
			};
		case 'resizeH_expandCollapse': //изменение высоты панели с признаком collabsible = true 
			return {
				eventName: 'resize',
				eventFn: function(th, w, h) { me.set(profileKey, this.collapsed ? 0 : h); },
				loadFn: function(v) {
					this.collapsed = !v;
					this.setHeight(v); }
			};
			case 'tabchange': //активация вкладки, в профиль пишем itemId
				return {
					eventName: 'tabchange',
					eventFn: function( th, newCard) {
						me.set(profileKey, newCard.itemId); 
					},
					loadFn: function(v) {
						this.setActiveTab(v);
					}
				};
			case 'FormParam':
			control.FormParams = {};
			return [
				{
					eventName: 'resize',
					eventFn: function(th, w, h) {
						if (th.maximized || (w === th.FormParams.width && h === th.FormParams.height)) return;
						th.FormParams.height = h;
						th.FormParams.width = w;
						me.set(profileKey, th.FormParams, 1);
					},
					loadFn: function(p) {
						this.FormParams = p = p ? JSON.parse(p) : {};
						this.setSize(p.width || this.minWidth, p.height || this.minHeight);
					}
				},
				{
					eventName: 'maximize',
					eventFn: function(th) {
						if (!th.FormParams.maximized) {
							th.FormParams.maximized = true;
							me.set(profileKey, th.FormParams, 1);
						}
					},
					loadFn: function(p) {
						this.FormParams = p = p ? JSON.parse(p) : {};
						if (p.maximized) this.maximized = true;
					}
				},
				{
					eventName: 'restore',
					eventFn: function(th) {
						if (th.FormParams.maximized) {
							th.FormParams.maximized = false;
							me.set(profileKey, th.FormParams, 1);
						}
					},
					loadFn: function(p) {
						this.FormParams = p = p ? JSON.parse(p) : {};
						if (p.maximized) this.maximized = false;
					}
				},
				{
					eventName: 'move',
					eventFn: function(th, x, y) {
						if (!th.maximized && (th.FormParams.x !== x || th.FormParams.y !== y)) {
							th.FormParams.x = x;
							th.FormParams.y = y;
							me.set(profileKey, th.FormParams, 1);
						}
					},
					loadFn: function(p) {
						this.FormParams = p = p ? JSON.parse(p) : {};
						if (p.x) this.x = p.x;
						if (p.y) this.y = p.y;
					}
				}
			];
		case 'KsPeriodChange':
			return {
				eventName: 'ksChange',
				eventFn: function(d1, d2) { me.set(profileKey, { d1: d1, d2: d2 }, 1); },
				loadFn: function(v) {
					v = JSON.parse(v);
					let func = () => control.setValue(new Date(v.d1), new Date(v.d2));
					if (me.timeout)
						setTimeout(() => func(), me.timeout);
					else
						func();
				}
			};
		//Для комбобоксов тоже подходит
		case 'ksCheckBoxChange':
			return {
				eventName: 'change',
				eventFn: function(th, newVal) { me.set(profileKey, newVal); },
				loadFn: function(v) {
					let func = () => control.setValue(v);
					if (me.timeout)
						setTimeout(() => func(), me.timeout);
					else
						func();
				}
			};
		//Для справочников
		case 'ksDictChange':
			return {
				eventName: 'change',
				eventFn: function(th, newVal) { me.set(profileKey, newVal, 1); },
				loadFn: function(v) {
					let func = ()=>control.setValue(v);
					if (me.timeout)
						setTimeout(() => func(), me.timeout);
					else
						func();
				}
			};
		default:
			return _;
		}
	},

	gksc: function(name) {
		var ownerCt = this.ownerCt;
		if (!ownerCt) return _;
		return ownerCt.gksc(name) || ownerCt.objs[name];
	},

	/**
	 * Обработать параметры фильтрации, сохраняемые в профиле:
	 * установить значения в профильных контролах и подписаться на изменение
	 * @param withoutDelay {boolean} true - sync set, false - async set	 
	 * */
	updateProfileListeners: function(withoutDelay) {
		let  me = this,
			defaultTimeout = me.timeout;

		if (withoutDelay) me.timeout = 0;
		Ext.each(me.profileListeners, function(po) {
			var c = me.gksc(po.name);
			if (c && !c.isKsProfile) {
				c.isKsProfile = true;
				var profileKey = po.name + '_' + po.method,
					mArr = me.getProfileMethod(po.method, profileKey, c.controlName, c);

				if (mArr) {
					if (!Ext.isArray(mArr)) mArr = [mArr];
					var v = me.get(profileKey, po.method === 'ksDictChange');
					Ext.each(mArr, function(m) {
						if (v) m.loadFn.call(c, v);
						c.on(m.eventName, m.eventFn, _, withoutDelay ? {} : { buffer: me.timeout });
					});
				}
			}
		});
		if (withoutDelay) me.timeout = defaultTimeout;
	},
	
	clearProfile: function(){
		cacheEngine.removeByCode(this.ownerCt.profileCode || this.ownerCt.code);
	}
});