﻿//Библиотека работы с периодами, аналогия DateManager из win.
window.PeriodLib = {
	//Пересекаются ли периоды
	//periodFields - ключ периода, по умолчанию dh1, но бывает и DT1
	//toDateFormat - для случая данных из базы - DT1 надо перевести в Date
	getPeriodsCross: function(dh1, dh2, periodFields, toDateFormat) {
		var periodField = periodFields || 'dh';
		if (toDateFormat) {
			dh1[periodField + '1'] = new Date(dh1[periodField + '1']);
			dh1[periodField + '2'] = new Date(dh1[periodField + '2']);
			dh2[periodField + '1'] = new Date(dh2[periodField + '1']);
			dh2[periodField + '2'] = new Date(dh2[periodField + '2']);
		}
		return (dh1[periodField + '1'] <= dh2[periodField + '2'] && dh1[periodField + '2'] >= dh2[periodField + '1']);
	},

	//Проверка на пренадлежность периоду
	//если пересекает период, то True
	contain: function(d, d1, d2, field) {
		if (!d) return false;
		if (!Ext.isDate(d)) d = new Date(d);
		if (d1) {
			if (!(Ext.isDate(d1) || Ext.isNumeric(d1))) {
				field = field || 'dh';
				if (d1[field + '1'] && d1[field + '2']) {
					d2 = d1[field + '2'];
					d1 = d1[field + '1'];
				}
			}
		} else {
			d1 = longPeriod.begin;
			if (!d2) d2 = longPeriod.end;
		}
		if (!Ext.isDate(d1)) d1 = new Date(d1);
		if (!Ext.isDate(d2)) d2 = new Date(d2);

		return !(d < d1 || d > d2);
	},

	// Получить объединение периодов
	getPeriodsUnion: function(dh1, dh2) {
		var dh = [].concat(dh1, dh2),
			max = Ext.Array.max(dh),
			min = Ext.Array.min(dh);

		Ext.each(dh, function(rec) {
			if (rec < min) min = rec;
			if (rec > max) max = rec;
		});

		return {
			'min': min,
			'max': max
		};
	},
	convertToDateString: function(array) {
		var i, len;
		if (!Ext.isArray(array)) return array;

		for (i = 0, len = array.length; i < len; i++) {
			array[i] = (array[i].toDateString ? array[i] : new Date(array[i])).toDateString();
		}
		return array;
	},
	//mirArr - массив начал периодов
	//maxArr - массив концов периодов
	//MAX - крайняя максимальная граница периода
	//MAX - крайняя минимальная граница периода
	findMinMaxPeriod: function(minArr, maxArr, MAX, MIN) {
		var min, max, tmp, i, len;

		MIN = new Date(MIN);
		MAX = new Date(MAX);

		//Перевод обоих массивов в dateString, иначе не работает indexOf :'(
		minArr = PeriodLib.convertToDateString(minArr);
		maxArr = PeriodLib.convertToDateString(maxArr);

		for (i = 0, len = maxArr.length; i < len; i++) {
			tmp = new Date(maxArr[i]);
			tmp.setDate(tmp.getDate() + 1);
			if (tmp < MAX) {
				tmp = tmp.toDateString();
				if (minArr.indexOf(tmp) === -1) {
					min = new Date(tmp);
					break;
				}
			}
		}

		min = min || MIN;

		for (i = 0, len = minArr.length; i < len; i++) {
			tmp = new Date(minArr[i]);
			tmp.setDate(tmp.getDate() - 1);
			if (tmp > MIN) {
				tmp = tmp.toDateString();
				if (maxArr.indexOf(tmp) === -1) {
					max = new Date(tmp);
					break;
				}
			}
		}

		max = max ? max < min ? MAX : max : MAX;

		return {
			'min': min,
			'max': max
		};
	},
	//Находит максимальную дату на отрезке
	findMaxData: function(array) {
		var max = new Date(array[0]),
			i,
			ln,
			item;

		for (i = 0, ln = array.length; i < ln; i++) {
			item = new Date(array[i]);
			if (item > max) {
				max = item;
			}
		}
		return max;
	},
	//Находит минимальную дату на отрезке
	findMinData: function(array) {
		var min = new Date(array[0]),
			i,
			ln,
			item;

		for (i = 0, ln = array.length; i < ln; i++) {
			item = new Date(array[i]);
			if (item < min) {
				min = item;
			}
		}
		return min;
	},
	//Аналог find из ArrayLib только для дат. Потому что в формате дат надо сравнивать через Ext.Date.isEqual(val,find)
	findData: function(source, adv, find, i, childFields) {
		if ((link === undefined) || (source.length == 0)) return -1;
		if (i === undefined) i = 0;
		if (!adv) adv = [];
		if (i < 0) i += source.length;
		if (i < 0) i = 0;
		var val, j, len = adv.length, k, cLen = childFields ? childFields.length : 0, cVal;
		for (var n = source.length; i < n; i++) {
			val = source[i];
			for (j = 0; j < len; j++) {
				if (val) {
					val = val[adv[j]];
				}
			}
			if (Ext.Date.isEqual(val, find))
				return i;
			if (childFields && cLen) {
				cVal = source[i][childFields[0]];
				for (k = 1; k < cLen; k++) {
					cVal = cVal[childFields[k]];
				}
				if (cVal) {
					var res = ArrayLib.find(cVal, adv, find, 0, childFields);
					if (res != -1) {
						if (Ext.isArray(res)) {
							res.unshift(i);
							return res;
						} else {
							return [i, res];
						}
					}
				}
			}
		}
		return -1;
	},

	//Создание нового периода
	addHist: function(table, callBack) {
		if (!callBack) return;
		if (table.length) {
			ajaxRequest({
				url: 'data/AddHist_A',
				params: { table: JSON.stringify(table) },
				success: function(hist) { callBack(hist); }
			});
		} else {
			callBack([{ DH1: longPeriod.begin, DH2: longPeriod.end, LINK: 0 }]);
		}
	},

	/**
	 * Добавить дни к дате 
	 * @param {Date} date дата
	 * @param {number} days дни
	 * @returns {Date}
	 */
	addDays(date, days) {
		let result = new Date(date);
		result.setDate(result.getDate() + days);
		return result;
	},
	getNextDay: function (dt1, days, sOrg, successFunc, failureFunc, callback) {
		if (!days) return _;
		ajaxRequest({
			url: 'data/GetNextDay_A',
			params: { dt1: dt1, days: days, sOrg: sOrg },
			success: successFunc,
			failure: failureFunc,
			callback: callback
		});
	},

	//Фильтр по периоду
	filterDataByPeriod: function(source, d1, d2, full, fieldSource, fieldPeriod) {
		var result = [];
		fieldSource = fieldSource || 'DH';
		var fn = full ?
			function(r) {
				return PeriodLib.contain(r[fieldSource + '1'], d1, d2, fieldPeriod) && PeriodLib.contain(r[fieldSource + '2'], d1, d2, fieldPeriod);
			} : function(r) {
				return PeriodLib.contain(r[fieldSource + '1'], d1, d2, fieldPeriod) || PeriodLib.contain(r[fieldSource + '2'], d1, d2, fieldPeriod);
			};
		Ext.each(source, function(r) { if (fn(r)) result.push(r); });
		return result;
	},

	//Подсчет количества календарных дней в периоде
	getCntCDaysInPeriod(dt1, dt2) {
		const oneDay = 24 * 60 * 60 * 1000;
		const diffDays = Math.round(Math.abs((dt1 - dt2) / oneDay)) + 1;
		return diffDays;
	},

	/** Конвертация строки в дату
	* @param {string} date строка в текстовом формате
	* @param {string} format формат вида 'dd.MM.yyyy'
	* @param {string} delimiter разделитель в формате
	* @return {Date}
	*/
	stringToDate: function(date, format, delimiter) {
		let formatItems = format.toLowerCase().split(delimiter),
			dateItems = date.split(delimiter),
			monthIndex = formatItems.indexOf("mm"),
			dayIndex = formatItems.indexOf("dd"),
			yearIndex = formatItems.indexOf("yyyy"),
			month = parseInt(dateItems[monthIndex]) - 1;
		let formatedDate = new Date(dateItems[yearIndex], month, dateItems[dayIndex]);
		return formatedDate;
	},

	/**
	 * Форматировать дату для отображения в формате dd.MM.yyyy
	 * @param dt
	 * @returns {string}
	 */
	dateToDisplay: function(dt){
		if (!dt) return '';
		const date = new Date(dt);
		if (!date || date.toString() === 'Invalid Date') return dt.toString();
		return Ext.Date.format(date, 'd.m.Y');
	},

	/**
	 * Вернуть первый день года
	 * @param dt
	 * @returns {Date}
	 */
	getYearFirstDay: function (dt){
		return new Date(dt.getFullYear(), 0, 1);
	},

	/**
	 * Вернуть последний день года
	 * @param dt
	 * @returns {Date}
	 */
	getYearLastDay: function (dt){
		return new Date(dt.getFullYear(), 11, 31);
	}
};