﻿var PageDataLib = {
	cache: {},

	timeOut: 6e5, //10 мин.

	//todo некоторая путаница с регистром GateCode, пока для формирования корректного ключа проверяем оба варианта
	_arrKeys: ['linkCode', 'GateCode', 'gateCode', 'controlName', 'whereArgs', 'order', 'filter', 'contextWA'],

	getKey: function(params) {
		var key = '';
		if (params) {
			Ext.each(this._arrKeys, function(k) {
				if (params[k]) {
					key += '_';
					key += params[k];
				}
			});
		}

		return lzw.compress(key);
	},

	has: function(key, page, size) {
		var s = (page - 1) * size,
			f = page * size,
			d = this.cache[key],
			b = -1,
			e = -1,
			list = [];
		if (f > d.total) f = d.total;
		for (; s < f; s++) {
			var t = d[s];
			if (t) {
				list.push(JSON.parse(JSON.stringify(t.row)));
			} else {
				if (b === -1) {
					b = s;
					e = s;
				} else e = s;
			}
		}
		return { begin: b, end: e, data: { data: list, total: d.total, totalMaxCount: d.totalMaxCount, banLinks: d.banLinks, result: d.result } };
	},

	set: function(key, page, size, data) {
		var s = (page - 1) * size,
			d = this.cache[key];
		if (!d) d = this.cache[key] = {};
		d.total = data.total;
		d.totalMaxCount = data.totalMaxCount;
		d.maxPageSize = data.maxPageSize;
		d.banLinks = data.banLinks;
		d.result = data;
		if (data.data) {
			for (var i = 0, len = data.data.length; i < len; i++) {
				var t = d[s + i];
				if (!t) t = d[s + i] = { row: data.data[i] };
				if (t.timeout) clearTimeout(t.timeout);
				t.timeout = setTimeout(function(j) { delete d[j]; }, this.timeOut, s + i);
			}
		}
	},

	get: function(params, callBack) {
		var me = this,
			key = me.getKey(params);
		if (params.reload) me.cache[key] = {};
		if (!me.cache[key]) me.cache[key] = {};
		var has = me.has(key, params.page, params.pageSize);
		if (has.begin !== -1) {
			ajaxRequest({
				url: params.linkCode + '/GetData_A',
				//params: { gzipData: JSON.stringify(params) },
				params: { gzipData: SignalR.pack(params) },
				success: function(result) {
					if (result.ErrorMsg) {
						info(result.ErrorMsg);
						LoadMask.hide();
						return;
					}

					me.set(key, params.page, params.pageSize, result);
					has = me.has(key, params.page, params.pageSize);
					if (callBack) callBack(has.data);
				},
				failure: function() { if (callBack) callBack(null); }
			});
		} else {
			if (callBack) callBack(has.data);
		}
	},

	clearByParams: function(params) {
		var me = this,
			key = me.getKey(params),
			clearList = [];

		for (var k in me.cache) if (k.indexOf(key) !== -1) clearList.push(k);

		Ext.each(clearList, function(k1) { delete me.cache[k1]; });
	},

	clear: function() {
		this.cache = {};
	}
}

window.PageDataLib = PageDataLib;