﻿var KsLib = {
	getClientType: function() {
		//if (navigator.userAgent.search('Mobi') !== -1) return 'Mobile';
		//return 'Tablet';
		//if (navigator.userAgent.search('Tablet') !== -1) return 'Tablet';
		return 'PC';
	},

	trueFn: function() { return true; },
	falseFn: function() { return false; },
	nullFn: function() { return null; },
	getKeyByValue: function(s, v) {
		for (var k in s) if (s[k] === v) return k;
		return _;
	},
	isEmptyControl: function(c) {
		c = c || this;
		switch (c.$className) {
		case 'Ext.form.field.Text':
		case 'Ext.form.field.Date':
		case 'Ext.form.field.Number':
		case 'Ext.form.field.ComboBox':
		case 'Keysystems.form.field.Trigger.TextEditor':
		case 'Keysystems.Controls.DocVid.Type':
			return !c.getValue();
		case 'Keysystems.Controls.CalcField':
			return !c.getNumValue();
		case 'Keysystems.Controls.Dict.Edit':
		case 'Keysystems.Controls.DictCode.Edit':
		case 'Keysystems.Controls.PeriodEdit':
			return c.isEmpty();
		default:
			if (c.isEmpty) return c.isEmpty();
		}
		return true;
	},
	tryRun: function(fn, self) { if (Ext.isFunction(fn)) return fn.apply(self || window, Array.prototype.slice.call(arguments, 2)); },
	objCopy: function(v) { return JSON.parse(JSON.stringify(v)); },
	setDictAs: function(data, value, key) {
		Ext.isArray(value) && (value = value[0]);
		if (value) {
			value = value.data || value;
			data[key] = value.LINK;
			data[key + '_CODE'] = value.CODE;
			data[key + '_NAME'] = value.NAME;
		} else {
			delete data[key];
			delete data[key + '_CODE'];
			delete data[key + '_NAME'];
		}
		return value;
	},

	dictRecEqual: function(rec1, rec2, field) { return (rec1 === rec2) || ((rec1.data || rec1)[field || (field = 'LINK')] == (rec2.data || rec2)[field]); },
	fixPromise: function () {
		if (!window.Promise) {
			window.Promise = function(fn) {
				var deferred = $.Deferred();
				fn(function () { deferred.resolveWith(deferred, arguments); }, function () { deferred.rejectWith(deferred, arguments); });
				deferred.promise(this);
				this.catch = this.fail;
			};
		}
	},
	getTaskTypeIconCls: function(t) {
		switch (t) {
			case 1:
				return 'x_btn_document_in';
			case 2:
				return 'x_btn_document_out';
			case 4:
				return 'x_btn_document';
		}
		return '';
	}
};

KsLib.fixPromise();

//Библиотека для проверки актуальности данных
var KsDictBadLib = {
	exec: function(badControls) {
		var list = [],
			controlsList = [];

		Ext.each(badControls, function(el, i) {
			var control = el.control;
			if (control.isEmpty && control.isEmpty()) return;
			var links = control.checkList ? ArrayLib.getLinks(control.checkList, ['LINK'], 1) : control.getLinks(1);
			list.push({
				inLinks: links,
				whereArgs: JSON.stringify(el.initWhereArgs()),
				index: i,
				code: el.code
			});
			controlsList.push({ control: control, index: i });
		});

		list.length && ajaxRequest({
			url: 'Data/CheckBadLinks_A',
			ignoreError: true,
			params: { data: JSON.stringify(list) },
			success: function (result) {
				if (result.error) return console.log('Ошибка при проверке актуальности данных: ' + result.error);

				Ext.each(controlsList, function(el, listIndex) {
					var index = el.index,
						pos = ArrayLib.find(result, ['index'], index),
						oldLinks = el.control.getLinks();

					var whereArgsIsEqual = (JSON.stringify(badControls[index].initWhereArgs()) === list[listIndex].whereArgs);

					el.control.colorizeBad && el.control.colorizeBad(pos !== -1 && whereArgsIsEqual);
				});
			},
			failure: function () {
				console.log('Ошибка при проверке актуальности данных');
			}
		});
	},

	run: function() {
		var me = this;
		if (me.isWait) return;
		setTimeout(function() {
			if (me.badControls && me.badControls.length) {
				me.exec(me.badControls);
				me.badControls = [];
			}
		}, 100);
	},

	restore: function() {
		var me = this;
		setTimeout(function() { me.wait(false); }, 10000);
	},

	wait: function(isWait) {
		var me = this;
		me[(me.isWait = isWait) ? 'restore' : 'run']();
	},

	checkBadLinks: function(control, code, whereArgs) {
		var me = this;

		if (!(code = (code || control.code))) return;
		me.badControls = me.badControls || [];
		var initWhereArgs = function() { return whereArgs || control.initWhereArgs ? control.initWhereArgs() : control.whereArgs; },
			ind = ArrayLib.find(me.badControls, ['control'], control);

		ind === -1 ? me.badControls.push({ control: control, initWhereArgs: initWhereArgs, code: code }) : me.badControls[ind].initWhereArgs = initWhereArgs;
		me.run();
	}
};

window.KsLib = KsLib;
window.KsDictBadLib = KsDictBadLib;