﻿var IndexedDBLib = {
	storeName: 'ObjectStore',
	dbName: 'ObjectBase',
	init: function() {
		var me = this;
		me.indexedDB = window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
	},

	connect: function(success, error) {
		var me = this,
			request = indexedDB.open(me.dbName, 1);
		request.onerror = function(err) { error && error(err); };

		// При успешном открытии вызвали коллбэк передав ему объект БД
		request.onsuccess = function() { success && success(request.result); };

		// Если БД еще не существует, то создаем хранилище объектов.
		request.onupgradeneeded = function(e) {
			e.currentTarget.result.createObjectStore(me.storeName);
			me.connect(success, error);
		};
	},

	get: function(key, seccess, error) {
		var me = this;
		me.connect(function(db) {
			var request = db.transaction([me.storeName], 'readonly').objectStore(me.storeName).get(key);
			request.onerror = error;
			request.onsuccess = function() { seccess && seccess(request.result ? request.result : -1); };
		});
	},

	set: function(key, file, seccess, error) {
		var me = this;
		me.connect(function(db) {
			var request = db.transaction([me.storeName], 'readwrite').objectStore(me.storeName).put(file, key);
			request.onerror = error;
			request.onsuccess = function() { seccess && seccess(request.result); };
		});
	},

	del: function(file, seccess, error) {
		var me = this;
		me.connect(function(db) {
			var request = db.transaction([me.storeName], 'readwrite').objectStore(me.storeName).delete(file);
			request.onerror = error;
			request.onsuccess = seccess;
		});
	},

	clear: function() {
		var me = this;
		me.connect(function(db) { db.transaction([me.storeName], 'readwrite').objectStore(me.storeName).clear(); });
	}
};

IndexedDBLib.init();

window.IndexedDBLib = IndexedDBLib;