﻿window.getMetods = function(store, searchValue) {
	    var res = {},
		    regExp;
	    if (searchValue) {
		    try {
			    regExp = new RegExp(searchValue, 'gi');
		    } catch (e) {
			    searchValue = searchValue.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
			    regExp = new RegExp(searchValue, 'gi');
		    }
	    }
	    for (key in store) {
		    if (regExp) {
			    if (!regExp.test(key)) continue;
		    }
		    if (Ext.isFunction(store[key])) {
			    res[key] = store[key].toString();
		    }
	    }
	    return res;
    };

window.createDict = function(code) {
		var cfg = {
			f: 'new',
			data: null,
			code: code,
			parentView: tabView,
			createTBar: function() {
				var res = this.callParent(arguments);
				res.push('-',
					Ext.create('Ext.Button', {
						iconCls: 'x_btn_dict',
						handler: function() { dictFunc({ parentView: tabView, code: code }); }
					}),
					Ext.create('Ext.form.field.Text', { value: code, readOnly: true })
				);
				return res;
			}
		};
		Ext.apply(cfg, dictListController[code]);
		cfg.title += '[' + code + ': ' + cfg.linkCode + ']';

		if (cfg.editClass) Ext.create(cfg.editClass, cfg);
	};

window.createAllDict = function(inList, ignorList) {
		if (!inList) {
			inList = [];
			for (var key in dictListController) {
				inList.push(key);
			}
		}
		if (!ignorList) ignorList = [];

		var fn = function(i) {
			if (i >= inList.length) return;
			var code = inList[i];
			if (ignorList.indexOf(code) === -1) {
				createDict(code);
				setTimeout(function() {
					fn(i + 1);
				}, 250);
			} else {
				fn(i + 1);
			}
		};

		fn(0);
	};

window.openDictList = function(code, callBack) {
		dictFunc({ checkModel: false, tabMode: true, parentView: window.tabView, code: code });

		var fn = function() {
			setTimeout(function() {
				if (window.lastDictListShow) {
					setTimeout(function() { if (callBack) callBack(window.lastDictListShow); }, 1000);
				} else {
					fn();
				}
			}, 500);
		};
		fn();
	};

window.transWalSearch = function(data, value, path, already, ignore, params) {
		if (!path) path = '';
		if (!already) already = [];
		if (!ignore) ignore = [];
		if (!params) params = {};

		var cList = [];
		for (var row in data) {
			if (params.extraExit) return 'NaN';
			if (ignore.indexOf(row) === -1) {
				try {
					var v = data[row];
					if (already.indexOf(v) === -1) {
						already.push(v);
						if (v === value) {
							return '.' + row;
						} else {
							cList.push(row);
						}
					}
				} catch (e) {

				}
			}
		}
		var l = cList.length;
		for (var i = 0; i < l; i++) {
			var h = transWalSearch(data[cList[i]], value, path + '.' + cList[i], already, ignore);
			if (h && (h !== 'NaN')) return cList[i] + '.' + h;
		}
		return 'NaN';
	};

window.transWalSearch2 = function(value) {
		var already = [],
			params = {},
			ignore = [],
			list = [],
			ignoreFn = function (v) { return params.extraExit || Ext.isString(v) || Ext.isNumber(v) || Ext.isBoolean(v) || Ext.isFunction(v)/* || Ext.isElement(v)*/; },
			fn1 = function (k, v, p) {
				if (ignoreFn(v)) return;
				if (ignore.indexOf(k) === -1) {
					try {
						if (already.indexOf(v) === -1) {
							already.push(v);
							if (v === value) console.log(k);
							list.push({ p: p + '.' + k, v: v });
						}
					} catch (e) {

					}
				}
			},
			fn = function (data, path) {
				if (!path) path = '';

				if (ignoreFn(data)) return;
				if (Ext.isArray(data)) {
					Ext.each(data, function (el, i) { fn1(i, el, path); });
				} else {
					Ext.Object.each(data, function (i, el) { fn1(i, el, path); });
				}

				if (!list.length) {
					console.log('end');
					return;
				}

				setTimeout(function () {
					var v = list.shift();
					fn(v.v, v.p);
				}, 10);
			};

		console.log('start');
		fn(window);
	};

window.creWinFn = function() {
		var ta;
		Ext.create('Ext.window.Window', {
			bodyPadding: 10,
			layout: { type: 'vbox', align: 'stretch' },
			items: [
				ta = Ext.create('Ext.form.field.TextArea', { flex: 1 }),
				Ext.create('Ext.Button', {
					text: 'ПЫЩЬ',
					handler: function() {
						var c = JSON.parse(ta.getValue().replace(/\n/g, '').replace(/ /g, '').replace(/'/g, '"')),
							w = Ext.create('Ext.window.Window', c);
						w.show();
					}
				})
			]
		}).show();
	};

window.ignorErrorExt = function() {
		var emptyFn = function() {};
		window.Sch = { preset: { Manager: { registerPreset: emptyFn } } };
		window.Keysystems = {
			Base: { Edit: { prototype: {} } },
			Documents: {
				Edit: { Reviz: { prototype: {} } },
				Reviz: { Report: { Edit: { prototype: {} } } }
			}
		};
		return window.Ext = {
			Error: { handle: emptyFn },
			emptyFn: emptyFn,
			define: emptyFn,
			onReady: emptyFn,
			ClassManager: { get: emptyFn },
			Loader: { setConfig: emptyFn },
			isFunction: emptyFn,
			EventObjectImpl: { prototype: {} },
			XTemplate: function() { return { compile: emptyFn }; },
			create: function() { return { init: emptyFn }; },
			apply: emptyFn
		};
	};