var Base64Binary = {
	_keyStr: 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=',

	/* will return a  Uint8Array type */
	decodeArrayBuffer: function(input) {
		var bytes = (input.length / 4) * 3,
			ab = new ArrayBuffer(bytes);
		this.decode(input, ab);

		return ab;
	},

	decode: function(input, arrayBuffer) {
		//get last chars to see if are valid
		var lkey1 = this._keyStr.indexOf(input.charAt(input.length - 1)),
			lkey2 = this._keyStr.indexOf(input.charAt(input.length - 2)),

			bytes = (input.length / 4) * 3;
		if (lkey1 === 64) bytes--;
		if (lkey2 === 64) bytes--;

		var uarray = new Uint8Array(arrayBuffer || bytes),
			chr1, chr2, chr3,
			enc1, enc2, enc3, enc4,
			i, j = 0;

		input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");

		for (i = 0; i < bytes; i += 3) {
			//get the 3 octects in 4 ascii chars
			enc1 = this._keyStr.indexOf(input.charAt(j++));
			enc2 = this._keyStr.indexOf(input.charAt(j++));
			enc3 = this._keyStr.indexOf(input.charAt(j++));
			enc4 = this._keyStr.indexOf(input.charAt(j++));

			chr1 = (enc1 << 2) | (enc2 >> 4);
			chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
			chr3 = ((enc3 & 3) << 6) | enc4;

			uarray[i] = chr1;
			if (enc3 !== 64) uarray[i + 1] = chr2;
			if (enc4 !== 64) uarray[i + 2] = chr3;
		}

		return uarray;
	},

	encode: function(s) {
		var length = s.length,
			groupCount = Math.floor(length / 3),
			remaining = length - 3 * groupCount,
			result = '',
			idx = 0,
			b0,
			b1;
		for (var i = 0; i < groupCount; i++) {
			b0 = s[idx++] & 0xff;
			b1 = s[idx++] & 0xff;
			var b2 = s[idx++] & 0xff;
			result += (this._keyStr[b0 >> 2]);
			result += (this._keyStr[(b0 << 4) & 0x3f | (b1 >> 4)]);
			result += (this._keyStr[(b1 << 2) & 0x3f | (b2 >> 6)]);
			result += (this._keyStr[b2 & 0x3f]);
		}

		if (remaining === 0) {
		} else if (remaining === 1) {
			b0 = s[idx++] & 0xff;
			result += (this._keyStr[b0 >> 2]);
			result += (this._keyStr[(b0 << 4) & 0x3f]);
			result += ('==');
		} else if (remaining === 2) {
			b0 = s[idx++] & 0xff;
			b1 = s[idx++] & 0xff;
			result += (this._keyStr[b0 >> 2]);
			result += (this._keyStr[(b0 << 4) & 0x3f | (b1 >> 4)]);
			result += (this._keyStr[(b1 << 2) & 0x3f]);
			result += ('=');
		} else {
			throw 'never happen';
		}
		return result;
	}
};

var utf8 = {
	fixedCharCodeAt: function(str, idx) {
		var code = str.charCodeAt(idx);
		var hi, low;
		if (0xD800 <= code && code <= 0xDBFF) {
			hi = code;
			low = str.charCodeAt(idx + 1);
			if (isNaN(low)) {
				throw 'fixedCharCodeAt: Invalid Encoding';
			}
			return ((hi - 0xD800) * 0x400) + (low - 0xDC00) + 0x10000;
		}
		if (0xDC00 <= code && code <= 0xDFFF) {
			return false;
		}
		return code;
	},
	fixedFromCodePoint: function(codePoints) {
		var chars = [], point, offset, units, i;
		for (i = 0; i < codePoints.length; ++i) {
			point = codePoints[i];
			offset = point - 0x10000;
			units = point > 0xFFFF ?
			[0xD800 + (offset >> 10), 0xDC00 + (offset & 0x3FF)] : [point];
			chars.push(String.fromCharCode.apply(null, units));
		}
		return chars.join('');
	},
	stringToUTF8Bytes: function(str) {
		var bytes = [];
		for (var i = 0; i < str.length; ++i) {
			var codePoint = utf8.fixedCharCodeAt(str, i);
			// already handeled
			if (!codePoint) continue;
			if (codePoint <= 0x7F) {
				bytes.push(codePoint);
			} else if (codePoint <= 0x07FF) {
				bytes.push(0xC0 | (codePoint >> 6));
				bytes.push(0x80 | (codePoint & 0x3F));
			} else if (codePoint <= 0xFFFF) {
				bytes.push(0xE0 | (codePoint >> 12));
				bytes.push(0x80 | (0x3F & (codePoint >> 6)));
				bytes.push(0x80 | (codePoint & 0x3F));
			} else if (codePoint <= 0x1FFFFF) {
				bytes.push(0xF0 | (codePoint >> 18));
				bytes.push(0x80 | (0x3F & (codePoint >> 12)));
				bytes.push(0x80 | (0x3F & (codePoint >> 6)));
				bytes.push(0x80 | (codePoint & 0x3F));
			} else if (codePoint <= 0x3FFFFFF) {
				bytes.push(0xF0 | (codePoint >> 24));
				bytes.push(0x80 | (0x3F & (codePoint >> 18)));
				bytes.push(0x80 | (0x3F & (codePoint >> 12)));
				bytes.push(0x80 | (0x3F & (codePoint >> 6)));
				bytes.push(0x80 | (codePoint & 0x3F));
			} else {
				bytes.push(0xF0 | (0x01 & (codePoint >> 30)));
				bytes.push(0x80 | (0x3F & (codePoint >> 24)));
				bytes.push(0x80 | (0x3F & (codePoint >> 18)));
				bytes.push(0x80 | (0x3F & (codePoint >> 12)));
				bytes.push(0x80 | (0x3F & (codePoint >> 6)));
				bytes.push(0x80 | (codePoint & 0x3F));
			}
		}
		return bytes;
	},
	UTF8BytesToString: function(bytes) {
		var length = bytes.length;
		var getContinuation = function(idx) {
			if (idx > length) throw new Error();
			var b = bytes[idx];
			if ((b & 0xC0) !== 0x80) throw new Error();
			return b & 0x3F;
		};
		var codePoints = [];
		try {
			for (var i = 0; i < length; ++i) {
				var b = bytes[i];
				if (b > 0xFF) return null;
				var code;
				if ((b & 0x80) === 0x00) {
					// First bit not set, so it is a 1-byte char.
					code = b;
				} else if ((b & 0xE0) === 0xC0) {
					// 2 bytes.
					code = ((0x1F & b) << 6) | getContinuation(i + 1);
					i += 1;
				} else if ((b & 0xF0) === 0xE0) {
					// 3 bytes.
					code = ((0x0F & b) << 12) |
						(getContinuation(i + 1) << 6) |
						getContinuation(i + 2);
					i += 2;
				} else if ((b & 0xF8) === 0xF0) {
					// 4 bytes.
					code = ((0x07 & b) << 18) |
						(getContinuation(i + 1) << 12) |
						(getContinuation(i + 2) << 6) |
						getContinuation(i + 3);
					i += 3;
				} else if ((b & 0xFC) === 0xF8) {
					// 5 bytes.
					code = ((0x03 & b) << 24) |
						(getContinuation(i + 1) << 18) |
						(getContinuation(i + 2) << 12) |
						(getContinuation(i + 3) << 6) |
						getContinuation(i + 4);
					i += 4;
				} else if ((b & 0xFE) === 0xFC) {
					// 6 bytes.
					code = ((0x01 & b) << 30) |
						(getContinuation(i + 1) << 24) |
						(getContinuation(i + 2) << 18) |
						(getContinuation(i + 3) << 12) |
						(getContinuation(i + 4) << 6) |
						getContinuation(i + 5);
					i += 5;
				}
				codePoints.push(code);
			}
		} catch (ignored) {
			return null;
		}
		return utf8.fixedFromCodePoint(codePoints);
	}
};

window.Base64Binary = Base64Binary;