﻿var CBDataLib = {
	prefix: 'cbData',
	displayField: 'value',
	valueField: 'index',
	getFields: function(valueType) {
		return [
			{ name: CBDataLib.valueField, type: valueType ?? 'int', useNull: true },
			{ name: CBDataLib.displayField, type: 'string' }
		];
	},
	genData: function(data) {
		var res = [];
		for (var key in data) {
			var v = {};
			v[this.valueField] = key;
			v[this.displayField] = data[key];
			res.push(v);
		}
		return res;
	},
	get: function(key, addNull, source, nullValue) {
		var res,
			t = source || window.miscTypes[key];
		if (t) {
			res = this.genData(t);
		} else {
			res = [];
		}
		if (addNull) {
			var v = {};
			v[this.displayField] = '...';
			v[this.valueField] = nullValue ?? 0;
			res.unshift(v);
		}
		return res;
	},
	set: Ext.emptyFn,
	has: function(key) { return !!window.miscTypes[key]; },

	getStore: function(data, valueType) {
		return Ext.create('Ext.data.Store', {
			fields: CBDataLib.getFields(valueType),
			data: data,
			proxy: 'memory'
		});
	}
};

window.CBDataLib = CBDataLib;