﻿var ArrayLib = {
	equal: function(a, b) {
		if (a === b) return true;
		if (!a || !b) return false;
		if (a.length != b.length) return false;

		for (var i = 0; i < a.length; ++i) {
			var isFind = false;
			for (var j = 0; j < b.length; j++) {
				if (a[i] === b[j]) {
					isFind = true;
					break;
				}
			}
			if (!isFind) {
				return false;
			}
		}
		return true;
	},
	rowsEqual: function(a, b) {
		if (a === b) return true;
		if (!a || !b) return false;
		if (a.length != b.length) return false;

		for (var i = 0; i < a.length; ++i) {
			var isFind = false;
			for (var j = 0; j < b.length; j++) {
				if ((a[i]) && (b[i]) && (a[i].data.LINK === b[j].data.LINK)) {
					isFind = true;
					break;
				}
			}
			if (!isFind) {
				return false;
			}
		}
		return true;
	},
	copy: function(source, lvl, childFields) {
		var copyItem = function(item, l) {
			var res = {};
			for (var k in item) {
				if (lvl > l)
					res[k] = copyItem(item[k], l + 1);
				else res[k] = item[k];
			}
			return res;
		};
		if (lvl) {
			var result = [],
				i = 0,
				len = source.length;
			for (; i < len; i++) {
				result.push(copyItem(source[i], 1));
				if (childFields && childFields.length) {
					var cVal = source[i][childFields[0]];
					for (var j = 1, jLen = childFields.length; j < jLen; j++) {
						cVal = cVal[childFields[j]];
					}
					if (cVal) {
						var cRes = ArrayLib.copy(cVal, lvl, childFields);
						cVal = result[i];
						for (j = 0; j < jLen - 1; j++) {
							cVal = cVal[childFields[j]];
						}
						cVal[childFields[jLen - 1]] = cRes;
					}
				}
			}
			return result;
		} else return source.concat ? source.concat() : KsLib.objCopy(source);
	},
	find: function(source, adv, find, i, childFields) {
		if (source.length == 0) return -1;
		if (i === undefined) i = 0;
		if (!adv) adv = [];
		if (i < 0) i += source.length;
		if (i < 0) i = 0;
		var val, j, len = adv.length, k, cLen = childFields ? childFields.length : 0, cVal;
		for (var n = source.length; i < n; i++) {
			val = source[i];
			for (j = 0; j < len; j++) {
				if (val) {
					val = val[adv[j]];
				}
			}
			if (val == find)
				return i;
			if (childFields && cLen) {
				cVal = source[i][childFields[0]];
				for (k = 1; k < cLen; k++) {
					cVal = cVal[childFields[k]];
				}
				if (cVal) {
					var res = ArrayLib.find(cVal, adv, find, 0, childFields);
					if (res != -1) {
						if (Ext.isArray(res)) {
							res.unshift(i);
							return res;
						} else {
							return [i, res];
						}
					}
				}
			}
		}
		return -1;
	},
	filter: function(source, sign, find, i) {
		if (!source.length) return [];
		if (i === undefined) i = 0;
		if (!sign) sign = [];
		if (i < 0) i = 0;
		var result = [];
		for (var n = source.length; i < n; i++) {
			var val = source[i];
			for (var j = 0, len = sign.length; j < len; j++) {
				val = val[sign[j]];
			}
			if (val == find)
				result.push(source[i]);
		}
		return result;
	},
	diffArrays: function(source, A) {
		var M = source.length, N = A.length, c = 0, C = [];
		for (var i = 0; i < M; i++) {
			var j = 0, k = 0;
			while (A[j] !== source[i] && j < N) j++;
			while (C[k] !== source[i] && k < c) k++;
			if (j == N && k == c) C[c++] = source[i];
		}
		return C;
	},
	insert: function(source, index, value) {
		if ((!index) || (index < 0)) index = 0;
		if (index > source.length) {
			source.push(value);
		} else {
			source.push(source[source.length - 1]);
			for (var i = source.length - 2; i > index; i--) {
				source[i] = source[i - 1];
			}
			source[index] = value;
		}
	},
	remove: function(source, obj) {
		var pos = Ext.Array.indexOf(source, obj);
		if (pos !== -1) {
			source.splice(pos, 1);
		}
	},

	//удаляет массив объектов из источника
	removeList: function(source, removeList) { Ext.each(removeList, function(obj) { ArrayLib.remove(source, obj); }); },

	//копирует поля по ключам из входного объекта в выходной
	copyByKeys: function(keys, inObj, outObj) {
		Ext.each(keys, function(key) { outObj[key] = inObj[key]; });
		return outObj;
	},

	//копирует поля по ключам объекты списка
	copyListByKeys: function (keys, inList, outList) {
		Ext.each(inList, function(obj) { outList.push(ArrayLib.copyByKeys(keys, obj, {})); });
		return outList;
	},

	getLinks: function(source, field, isJson, childFields) {
		if (!field) field = 'LINK';
		var res = [];
		Ext.each(source, function(e) {
			if (childFields && e[childFields]) res = res.concat(ArrayLib.getLinks(e[childFields], field, _, childFields));
			e = (e.data || e)[field];
			if (e) res.push(e);
		});

		if (isJson) res = JSON.stringify(res);

		return res;
	},

	/**
	 * Получить по "деревянной" структуре вида  [parent1: {children: []}, ...]
	 * @param source
	 * @param field
	 * @returns {int[]}
	 */
	getLinksTree: function(source, field){
		let res = [];
		source?.forEach(e => {
			const link = (e.data || e)[field];
			if (link) res.push(link);
			if (e.children?.length) {
				res = res.concat(ArrayLib.getLinksTree(e.children, field));
			}
		});
		return res;
	},

	runLine: function(line, i, metod, callBack) {
		if (i >= line.length) {
			callBack();
			return;
		}
		setTimeout(function() { metod(line[i], function() { ArrayLib.runLine(line, i + 1, metod, callBack); }, i); }, 20);
	},

	//Безопастное извлечение свойства по пути
	getByPath: function(source, path, split) {
		if (Ext.isString(path)) path = path.split(split || '.');
		var res = source;
		Ext.each(path, function(p) { return !!(res = res[p]); });
		return res;
	},

	joinBy: function(source, field, d) {
		var res = '';
		d = d || ',';
		Ext.each(source, function(r) {
			if (res) res += d;
			res += r[field];
		});
		return res;
	},

	recordIndexOf: function(source, rec, field) {
		var res = -1;
		rec = rec.data || rec;
		field = field || 'LINK';
		Ext.each(source, function(sRec, i) {
			var d = sRec.data || sRec;
			if (d[field] == rec[field]) {
				res = i;
				return false;
			}
			return true;
		});
		return res;
	},

	compareSplitLists: function(list1, list2, equalFn) {
		var over1 = list1.concat(),
			over2 = list2.concat(),
			equal = [];

		Ext.each(over1, function(r1) {
			Ext.each(over2, function(r2) {
				if (equalFn(r1, r2)) {
					equal.push(r1);
					ArrayLib.remove(over1, r1);
					ArrayLib.remove(over2, r2);
					return false;
				}
				return true;
			});
		}, _, true);

		return { over1: over1, over2: over2, equal: equal };
	},

	addMissing: function(list1, list2) {
		Ext.each(list2, function (l) { if (list1.indexOf(l) === -1) list1.push(l); });
	}
};

window.ArrayLib = ArrayLib;