﻿/*
Copyright (c) 2014 Keysystems.ru

Contact:  http://www.keysystems.ru/contact

Commercial Usage
Licensees holding valid commercial licenses may use this file in accordance with the Commercial Software License Agreement provided with the Software or, alternatively, in accordance with the terms contained in a written agreement between you and Sencha.

If you are unsure which license is appropriate for your use, please contact the sales department at http://www.keysystems.ru/contact


Авторское право (c) 2014 Keysystems.ru

Контакты:  http://www.keysystems.ru/contact

Коммерческое использование
Лицензиаты имеющие действительные коммерческие лицензии могут использовать этот файл в соответствии с лицензионным соглашением коммерческого программного обеспечения поставляемой с программным обеспечением либо, альтернативно, в соответствии с условиями содержащимися в письменном соглашении между вами и Sencha.

Если вы не уверены, какая лицензию подходит для вашего использования, пожалуйста, свяжитесь с отделом продаж в http://www.keysystems.ru/contact
*/

Ext.define('Keysystems.Controls.TaskGrid', {
	extend: 'Ext.tree.Panel',
	mixins: ['Keysystems.Base.List.Tree'],
	fileColumn: true,
	rootVisible: false,
	isTaskGrid: true,
	rowLines: true,
	columnLines: true,
	columns: [],
	code: 'DOCUMENTS',
	_code: 'DOCUMENTS',
	border: 0,
	iconCls: '',
	autoScroll: true,
	arrDisable: ['newBtn', 'copyBtn', 'delBtn', 'dfAddBtn', 'dfOpenBtn', 'dfBindBtn', 'dfDeleteBtn'],
	needColorize: true,	
	features: [
		{
			ftype: 'summary',
			showSummaryRow: false
		}
	],	

	plugins: ['gridclipboard'],
	config: {
		dfAccess: 0	//доступ к документообороту
	},
	constructor: function(cfg) {
		var me = this;
		Ext.apply(me, cfg);
		me.callParent(arguments);
	},
	
	getFileId: function(rec) { return rec.get(this.fieldExt); },
	getFileName: function (rec) {
		var me = this,
			settingFileMask = me.gksd('SettingFileMask'),
			docVidName = rec.get('S_DOCVID_NAME'),
			number = rec.get('NUMBER'),
			dt = rec.get('DT'),
			fileName = settingFileMask || '{Документ.Вид.Имя}+" № "+ {Документ.Номер} + " от " + ДАТАПРОП({Документ.Дата},4)';

		fileName = fileName.replace('{Документ.Вид.Имя}', '"' + docVidName + '"');
		fileName = fileName.replace('{Документ.Номер}', '"' + number + '"');
		fileName = fileName.replace('ДАТАПРОП({Документ.Дата},4)', '"' + (Ext.isDate(dt) ? Ext.Date.format(dt, 'd.m.Y') : dt) + '"');

		return eval(fileName);
	},
	//#region Подмена code для сохранения файлов через мероприятие

	createFile: function() {
		var me = this,
			code = me.code;
		me.code = me._code;
		var res = Keysystems.Base.List.Tree.prototype.createFile.apply(me, arguments);
		me.code = code;
		return res;
	},
	clearFile: function(rec) {
		var me = this,
			r = rec,
			code = me.code;
		me.code = me._code;
		if (rec) {
			ajaxRequest({
				url: 'data/TaskGridSaveDeleteFile_A',
				params: {
					link: rec.get(me.fieldLink),
					code: me.code,
					file: 0,
					name: ''
				},
				success: function (v) {
					if (v) {
						r.set(me.fieldFile, '');
						r.set(me.fieldExt, v.EXT);
					}
				}
			});
		}

		me.code = code;
	},
	updFileRecord: function (fileObj, rec) {
		var me = this,
			code = me.code,
			r = rec,
			ext = fileObj.ext;
		me.code = me._code;

		if (fileObj && rec) {
			ajaxRequest({
				url: 'data/TaskGridSaveDeleteFile_A',
				params: {
					link: rec.get(me.fieldLink),
					code: me.code,
					file: fileObj.id,
					name: fileObj.name
				},
				callback: function(v) {
					if (v && v.SavedFiles) {
						var fileLink = rec.get(me.fieldFile);
						if (v.mainFileChanged || v.mainFileAdded) {
							r.set(me.fieldFile, v.SavedFiles[0].LINK);
						}
						if (!fileLink || v.mainFileChanged) {
							r.set(me.fieldExt, ext);
						}
						var fw = me.gksc('FileWindow');
						if (fw) fw.setEnableBtns();
					}
				}
			});
		}
		
		me.code = code;
	},

	//#endregion Подмена code для сохранения файлов через мероприятие

	createToolBar: function() {
		var me = this;
		me.ksControls = {};
		if (!me.ToolBar)
			me.ToolBar = Ext.create('Ext.Toolbar', {
				border: 0,
				items: [
					me.newBtn = Ext.create('Ext.Button', {
						disabled: true,
						tooltip: 'Создать',
						tooltipType: 'title',
						iconCls: 'x_btn_new',
						key: 'new',
						handler: function() {
							var sel = me.getSelectionModel().getSelection();
							if (sel.length) {
								sel = sel[0];
							} else {
								return;
							}
							me.edit({ f: 'new' }, sel);
						}
					}),
					me.copyBtn = Ext.create('Ext.Button', {
						disabled: true,
						tooltip: 'Создать подобную',
						tooltipType: 'title',
						iconCls: 'x_btn_copy',
						key: 'copy',
						handler: function() {
							var sel = me.getSelectionModel().getSelection();
							if (sel.length && !sel[0].parentNode.isRoot()) {
								me.edit({ f: 'copy' }, sel[0]);
							}
						}
					}),
					me.editBtn = Ext.create('Ext.Button', {
						tooltip: 'Редактировать',
						tooltipType: 'title',
						iconCls: 'x_btn_edit',
						key: 'edit',
						handler: function() {
							var sel = me.getSelectionModel().getSelection();
							if (sel.length) {
								sel = sel[0];
							} else {
								return;
							}
							if (sel.data.parentId === 'root') return;
							sel.set('readOnly', me.readOnly);
							me.edit({ f: 'edit' }, sel);
						}
					}),
					me.delBtn = Ext.create('Ext.Button', {
						disabled: true,
						tooltip: 'Удалить',
						tooltipType: 'title',
						iconCls: 'x_btn_delete',
						key: 'delete',
						handler: function() {
							var sel = me.getSelectionModel().getSelection(),
								isContainsFile;
							if (!sel.length) {
								return;
							}
							
							if (sel[0].data.parentId === 'root') return;
							let endFunc = function() {
								selectDialogShow(wmc.getQuestion('Delete'), wmc.get('DeleteMessage', 1),
									function () {
										me.rowDelete(sel);
									});
							};
							
							Ext.each(sel, function (rec) {
								if (!isContainsFile) {
									isContainsFile = !!rec.data.TEMP_EXT;
								}
							});
							
							if (isContainsFile) {
								ChooseBox.ShowHTML({
									text: 'У удаляемого документа есть прикрепленные файлы во вкладке "Файлы"',
									warnOrErrorIcon: true,
									hasIgnoreButton: true,
									nextFn: function() {
										endFunc();
									}
								});
							} else {
								endFunc();
							}
						}
					}),
					me.dfSeparator = Ext.create('Ext.toolbar.Separator', { visible: false }),
					me.dfAddBtn = Ext.create('Ext.Button', {
						visible: false,
						disabled: true,
						tooltip: KS.L10n.TaskGrid_InitializeComponent_Создать_на_основе_записи_раздела__Документооборот_,
						tooltipType: 'title',
						iconCls: 'x_btn_doc_new_df',
						key: 'doc_new_df',
						handler: function() {
							let sel = me.getFrstSelect();
							if (!sel) return;
							me.addFromDF({ }, sel);
						}
					}),
					me.dfBindBtn = Ext.create('Ext.Button', {
						visible: false,
						disabled: true,
						tooltip: KS.L10n.TaskGrid_InitializeComponent_Привязать_к_записи_раздела__Документооборот_,
						tooltipType: 'title',
						iconCls: 'x_btn_doc_link',
						key: 'doc_link',
						handler: function() {
							let sel = me.getFrstSelect();
							if (!sel) return;
							me.bindDF({ }, sel);
						},
					}),
					me.dfOpenBtn = Ext.create('Ext.Button', {
						visible: false,
						disabled: true,
						tooltip: KS.L10n.TaskGrid_InitializeComponent_Открыть_запись_раздела__Докуменооборот_,
						tooltipType: 'title',
						iconCls: 'x_btn_message_new',
						key: 'message_new',
						handler: function() {
							let sel = me.getFrstSelect();
							if (!sel) return;

							let cfg = {
								f: 'edit',
								data: {data: {LINK: sel.data.DF_DOCUMENTS}},
								code: dnl.DF_DOCUMENTS,
								parentView: me.objs.view
							};
							Ext.apply(cfg, dictListController.DOCUMENT_DF_DOCUMENTS);
							Ext.create(cfg.editClass, cfg);
						}
					}),
					me.dfDeleteBtn = Ext.create('Ext.Button', {
						visible: false,
						disabled: true,
						tooltip: KS.L10n.TaskGrid_InitializeComponent_Удалить_связь_с_записью_раздела__Документооборот_,
						tooltipType: 'title',
						iconCls: 'x_btn_doc_delete',
						key: 'doc_delete',
						handler: function() {
							let sel = me.getFrstSelect();
							if (!sel) return;
							me.deleteFromDF({ }, sel);
						}
					}),
					{ xtype: 'tbseparator', hidden: !me.visibleBtnExpandCollapse },
					me.expandBtn = Ext.create('Ext.Button', {
						iconCls: 'x_btn_treeexpand',
						tooltipType: 'title',
						tooltip: 'Развернуть все узлы',
						key: 'treeexpand',
						hidden: !me.visibleBtnExpandCollapse,
						handler: function() {
							me.expandAll();
						}
					}),
					me.collapseBtn = Ext.create('Ext.Button', {
						iconCls: 'x_btn_treecollapse',
						tooltipType: 'title',
						tooltip: 'Свернуть все узлы',
						key: 'treecollapse',
						hidden: !me.visibleBtnExpandCollapse,
						handler: function() {
							me.collapseAll();
						}
					}),
					me.signBtn = Ext.create('Ext.Button', {
						disabled: true,
						hidden: !window.useEDS,
						iconCls: 'x_btn_document_protect',
						key: 'document_protect',
						tooltipType: 'title',
						tooltip: 'Электронная подпись',
						menu: [
							{
								text: 'Электронная подпись',
								iconCls: 'x_btn_document_protect',
								handler: function () {
									const sel = me.getFrstSelect();
									if (!sel) return;
									
									const serviceModule = Ext.create('Keysystems.EDSServiceModule', {
										target: me.getLoadMaskTarget(),
										code: "DOCUMENTS",
										links: [sel.data.LINK],
										code_eds_list: "DOCUMENTS_EDS_LIST",
										mode: 'SIGN_LIST',
										modal: window.modalEdit || me.parentView !== window.tabView
									});
									serviceModule.execute();
								}
							},
							{
								text: 'Печать информации об ЭЦП',
								iconCls: 'x_btn_protocol',
								handler: function () {
									const sel = me.getFrstSelect();
									if (!sel) return;

									const serviceModule = Ext.create('Keysystems.EDSServiceModule', {
										target: me.getLoadMaskTarget(),
										code: "DOCUMENTS",
										links: [sel.data.LINK],
										mode: 'SIGNATURE_INFO_PROTOCOL',
									});
									serviceModule.execute();
								}
							},
							{ xtype: 'menuseparator', hidden: true },
							me.subBtnSign = Ext.create('Ext.Action', {
								text: 'Подписать',
								iconCls: 'x_btn_sign',
								handler: async function () {
									const sel = me.getFrstSelect();
									if (!sel) return;
									const result = await Keysystems.Documents.List.prototype.signAsync.call(me, [sel.data]);
									if (result?.doc?.rows?.length){
										sel.set(result?.doc?.rows[0]);
									}
								}
							}),
							me.subBtnUnSign = Ext.create('Ext.Action', { 
								text: 'Снять подпись',
								iconCls: 'x_btn_delete_sign',
								handler: async function () {
									const sel = me.getFrstSelect();
									if (!sel) return;
									const result = await Keysystems.Documents.List.prototype.unSignAsync.call(me, [sel.data]);
									if (result?.doc?.rows?.length){
										sel.set(result?.doc?.rows[0]);
									}
								}
							})
						]
					}),
					{ xtype: 'tbseparator' },
					me.printBtn = Ext.create('Ext.Button', {
						iconCls: 'x_btn_print',
						disabled: true,
						tooltip: 'Печать документа',
						tooltipType: 'title',
						key: 'print',
						handler: function() {
							var activRows = me.getSelectionModel().getSelection();
							if (activRows.length && !activRows[0].parentNode.isRoot()) {
								me.fileEdit(activRows[0]);
							}
						}
					}),
					me.journalBtn = Ext.create('Ext.Button',
						{
							iconCls: 'x_btn_journal',
							tooltip: 'Журнал событий',
							tooltipType: 'title',
							hidden: me.hideJournalBtn,
							key: 'journal',
							handler: function () {
								var sel = me.getSelectionModel().getSelection();
								if (sel.length) {
									sel = sel[0];
								} else {
									return;
								}
								if (sel.data.parentId === 'root') return;

								if (sel) {
									const loadMask = new Ext.LoadMask({
										msg: KS.L10n.loading_data,
										view: me
									});
									loadMask.show();

									ajaxRequest({
										params: {
											code: 'DOCUMENTS',
											links: [sel.data[me.fieldLink]]
										},
										url: 'data/DetailEventsLog_A',
										success: function (html) {
											showDetailEventsLog({
												html: html,
												modal: true,
												title: me.getTitle()
											});
										},
										callback: function () { loadMask.destroy(); }
									});
								}
							}
						})
				]
			});

		me.ksControls.ToolBar = me.ToolBar;
		return me.ToolBar;
	},
	//Костыль для вкладки "Принятые меры" в мероприятиях
	loadData1: function(data) {
		var me = this,
			fields = data.docGridData.fields,
			columns = allColumnAdapted(data.docGridData.columns.slice());

		fields.push({ name: 'OPTIONAL', defaultValue: false }, { name: 'CAN_CREATE_NEXT_TASK', defaultValue: true });

		//if (!me.store.root) {
		if (fields) {
			fields.push({ name: 'checked', defaultValue: null });
			fields.filter(f => ['NUMBER', 'REVIZNUMBER'].indexOf(f.name) >= 0).forEach(f => f.sortType = 'asNatural');
			
			fields = me.fieldsAdapted(fields);
			var iPos = ArrayLib.find(fields, ['name'], 'FILES');
			if (iPos !== -1) fields[iPos].type = 'string';
			me.store.setFields(fields);
		}

		if (columns) {
			var pos = ArrayLib.find(columns, ['dataIndex'], 'DURATIONCOLUMN'),
				tmp;

			if (pos !== -1) {
				tmp = columns[pos];
				columns.splice(pos, 1);
				columns.unshift(tmp);
			}

			pos = ArrayLib.find(columns, ['dataIndex'], 'S_DOCVID_NAME');
			if (pos !== -1) {
				tmp = columns[pos];
				columns.splice(pos, 1);
				tmp.iconCls = 'x-tree-noicon';
				tmp.xtype = 'treecolumn';
				tmp.text = '<b>Регламент</b>/<br>Документ';
				tmp.hasColumnChooser = false;
				tmp.renderer = function(v, metaData, rec) {
					metaData.align = 'left';
					let res = v;

					const sDocVid = rec.get('TYPE');
					if (sDocVid) {
						res = `<span class="x-action-col-icon ks-treecolumn-icon ${KsLib.getTaskTypeIconCls(sDocVid)}"></span><span style="padding-left: 5px">${v}</span>`;
					}

					return res;
				};
				columns.unshift(tmp);
			}

			columns.push({
				xtype: 'actioncolumn',
				dataIndex: 'FileColumn',
				text: 'Файл',
				width: 40,
				align: 'center',
				items: [
					{
						getClass: function(v, meta, rec) { return getExtStyle(rec.get(me.fieldExt)); },
						addCls: function(v, meta, rec) {
						},
						handler: function(grid, rowIndex) {
							var isRoot = grid.getStore().getAt(rowIndex).parentNode.data.root;
							if (!isRoot) me.fileEdit(grid.getStore().getAt(rowIndex));
						}
					}
				]
			});

			let colDF = ArrayLib.find(columns, ['dataIndex'], 'HAS_DF_DOCUMENTS');
			if (colDF !== -1) {
				columns[colDF] = {
					xtype: 'actioncolumn',
					dataIndex: 'IMG_DF_RELATION_NEED',
					align: 'center',
					width: 150,
					text: 'Документооборот',
					tdCls: 'rks-action-col-noaction-td',
					items: [
						{
							getClass: function (v, meta, rec) {
								return rec.get('HAS_DF_DOCUMENTS') ? 'x_btn_message_new' : '';
							},
						}
					]
				};
			}

			columns.forEach(col=> {
				switch (col.dataIndex) {
					case "SUMDOCMONEY":
					case "SUMRESPONS":
						//для суммовых колонок на каждом уровне иерархии задано значение, для строк регламентов значение не отображаем
						col.renderer = function (v, m, r) {
							if (r.parentNode.isRoot()) return '';
							return convertToDecimal(v, m.column.decimalData);
						}
				}
			});			
			
			Ext.create('Keysystems.Controls.Grid.ColumnManager', {
				inputColumns: columns,
				code: me.profileCode,
				prefix: me.profilePrefix,
				gateCode: me.profileGateCode,
				profileKey: me.profileKey + 'Columns',
				grid: me
			});
		}		

		me.store.sortRoot = 'ORD';
		me.setRootNode({
			expanded: true,
			children: me.mergeData(data.taskGridData.data, data.docGridData.data)
		});

		let canReadDF = (me.dfAccess & ObjAccessMask.READ) !== 0;
		let canEditDF = canReadDF & (me.dfAccess & ObjAccessMask.EDIT) !== 0;
		me.dfAddBtn?.setVisible(canEditDF);
		me.dfBindBtn?.setVisible(canEditDF);
		me.dfDeleteBtn?.setVisible(canEditDF);
		me.dfOpenBtn?.setVisible(canReadDF);
		me.dfSeparator?.setVisible(canReadDF);
		
	},
	loadData: function(data) {
		this.loadData1(data);
	},
	mergeData: function(tasks, docs) {
		for (var i = 0, rows = tasks, len = rows.length; i < len; i++) {
			rows[i] = {
				LINK: rows[i].LINK,
				DURATIONCOLUMN: rows[i].DURATIONCOLUMN,
				S_DOCVID_NAME: rows[i].NAME,
				children: ArrayLib.filter(docs, ['S_TASK'], rows[i].LINK),
				S_TASK: rows[i].LINK,
				OPTIONAL: rows[i].OPTIONAL,
				CAN_CREATE_NEXT_TASK: rows[i].CAN_CREATE_NEXT_TASK,
				SUMDOCMONEY: 0,
				SUMRESPONS: 0,
				expanded: true
			};
		}
		return tasks;
	},
	getRowClass: function(record) {
		/*Раскраска регламентов и документов по аналогии с TaskGrid.cs grid_ColorizeRow()*/
		var tempTask = this.tempTask,
			rowStyle = '';
		
		//регламенты
		if (record.parentNode.isRoot()) {
			rowStyle += 'ks-reglament ';
			var taskIdx = ArrayLib.find(tempTask, ['S_TASK'], record.data.LINK);
			if (this.needColorize && taskIdx !== -1) {
				var task = tempTask[taskIdx];
				rowStyle += (!task.DTDONE &&
				(!task.DTEND ||
					Ext.Date.clearTime(new Date(task.DTEND)) < Ext.Date.clearTime(new Date()) ||
					(task.DOC_OVERDUE &&
						Ext.Date.clearTime(new Date(task.DOC_OVERDUE)) < Ext.Date.clearTime(new Date()))))
					? 'ks-overdue'
					: 'ks-notOverdue';

				if (task.OPTIONAL) {
					rowStyle += ' ks-textgray';
				}
			}
		}
		//докменты
		else {
// ReSharper disable UseOfImplicitGlobalInFunctionScope
			rowStyle += Keysystems.Documents.List.prototype.getRowClass(record);
// ReSharper restore UseOfImplicitGlobalInFunctionScope
		}

		return rowStyle;
	}, //end getRowClass

	initComponent: function() {
		var me = this;

		me.beforeInitComponent();
		me.tbar = me.createToolBar();
		if (!me.store) {
			me.store = Ext.create('Ext.data.TreeStore', { fields: [], data: [], proxy: 'memory', defaultRootText: '' });
		}

		me.viewConfig = {
			isLockingView: true,
			toggleOnDblClick: false,
			getRowClass: me.getRowClass.bind(me)
		}; //end me.viewConfig

		me.callParent();

		me.on('select', function(th, rec) { 
			me.printBtn?.setDisabled(rec.parentNode.isRoot());
		});

		me.on('selectionchange', function(th, sels = []) {
			if (me.ToolBar.isDisabled()) return;
			
			if (me.setAccessBtns) me.setAccessBtns(sels);

			let sel = sels.length ? sels[0] : null;
			me.enableTools(sel);
		});

		me.on('itemdblclick', function(th, rec) {
			if (rec.data.parentId === 'root') {
				me.editRoot(rec);
			} else {
				rec.set('readOnly', me.readOnly);
				me.edit({f: 'edit'}, rec);
			}
		});		
	},	
	async enableTools(sel) {
		const me = this;
		const isTask = sel ? sel.parentNode.isRoot() : 0;
		const owner = me.owner ?? me.ownerCt;
		let canAdd = !me.readOnly && sel != null;
		let nextDocvids = [];
		if (canAdd) {
			const val = sel.get('NEXT_DOCVIDS');
			if (val !== null && val !== undefined) {
				nextDocvids = val.split(',').filter(d => d).map(docvid => +docvid);
			} else {
				const result = await ajaxRequestAsync({
					url: 'SDocuments/GetNewTaskDocsData_A',
					params: {
						link: owner.getLink(),
						docCode: owner.code,
						taskLink: sel.data.S_TASK,
						docLink: sel.data.parentId === 'root' ? 0 : sel.data.LINK,
						workLink: owner.gksd('sWork'),
						linksOnly: true
					}
				});
				nextDocvids = result ?? [];
				sel.set('NEXT_DOCVIDS', result.join(','));
			}
		}
		canAdd &= nextDocvids.length > 0;
		me.newBtn?.setDisabled(!canAdd);
		me.copyBtn?.setDisabled(me.readOnly || !sel || isTask);
		me.editBtn?.setDisabled(!sel || isTask);
		me.journalBtn?.setDisabled(me.readOnly || !sel || isTask);
		me.delBtn?.setDisabled(me.readOnly || !sel || isTask || sel.childNodes.length);
		me.signBtn?.setDisabled(!sel || isTask);
		me.subBtnSign.setDisabled(me.readOnly || !sel || isTask);
		me.subBtnUnSign.setDisabled(me.readOnly || !sel || isTask);
		
		const hasDF = (me.dfAccess & ObjAccessMask.READ) !== 0;
		if (hasDF) {
			let canAddDF = false,
				canBindDF = false;
			const dfReadOnly = me.readOnly || (me.dfAccess & ObjAccessMask.EDIT) === 0;
			const dfDocuments = sel ? sel.get('DF_DOCUMENTS') : 0

			canAddDF = !dfReadOnly && sel != null;
			canBindDF = !dfReadOnly && !isTask && !dfDocuments && sel != null;

			if (canAddDF || canBindDF) {
				const res = await ajaxRequestAsync({
					url: 'SDocuments/GetAvailableDfDocuments_A',
					params: {
						reviz: me.ownerCt.getLink()
					}
				});
				const availableDocvidsDF = res ?? [];

				canAddDF &= nextDocvids.filter(docvid => availableDocvidsDF.indexOf(docvid) >= 0).length > 0;
				if (sel) canBindDF &= availableDocvidsDF.indexOf(sel.data.S_DOCVID) >= 0;
			}

			me.dfAddBtn?.setDisabled(!canAddDF);
			me.dfBindBtn?.setDisabled(!canBindDF);
			me.dfOpenBtn?.setDisabled(isTask || !dfDocuments);
			me.dfDeleteBtn?.setDisabled(dfReadOnly || isTask || !dfDocuments);
		}
	},
	editRoot: Ext.emptyFn,
	edit: function(cfg, data) {
		var me = this,
			docCfg = {
				data: data,
				title: 'Документы',
				linkCode: 'SDocuments',
				refreshFunc: function () { me.refresh(); },
				parentView: me,
				//метод сохранения данных
				saveData: function(endFunc, params) {
					this.callParent([
						function(result) {
							me.refreshTask(result.tempTask, result.row.S_TASK);
							if (endFunc) endFunc(result);
						}, params
					]);
				}
			};

		Ext.apply(docCfg, cfg);
		Ext.create('Keysystems.Documents.Edit', docCfg);
	},
	refreshTask: function (tempTask, sTask) {
		if (!tempTask) return;

		var me = this;
		me.tempTask = tempTask;
		//обновление данных по задаче регламента, влияет на подсветку строки регламента
		var taskIdx = ArrayLib.find(me.tempTask, ['S_TASK'], sTask);
		if (taskIdx !== -1) {
			var task = me.tempTask[taskIdx];
			var rowSTask = me.getStore().getRootNode().findChild('S_TASK', sTask);
			if (rowSTask) {
				rowSTask.set('DTDONE', task.DTDONE);
				rowSTask.set('DOC_OVERDUE', task.DOC_OVERDUE);
				//заполняем фиктивную TEMP_, чтобы сработал update на строку. если заполнять DTEND, то в гриде для строки регламента также заполняется соот-я колонка
				rowSTask.set('TEMP_DTEND', task.DTEND);
			}
		}
	},
	rowDelete: function(nodes) {
		for (var i = 0, len = nodes.length; i < len; i++) {
			if (nodes[i].data.parentId !== 'root') {
				nodes[i].parentNode.removeChild(nodes[i], true);
			}
		}
	},

	setReadOnly: function(state) {
		var th = this;
		th.readOnly = state;
		Ext.each(th.arrDisable, function (name) {
			th[name].setDisabled && th[name].setDisabled(state);
		});
		th.editBtn?.setIconCls(state ? 'x_btn_open' : 'x_btn_edit');
		th.editBtn?.setTooltip(state ? 'Открыть' : 'Редактировать');
	},

	setKsReadOnly: function (state){
		const me = this;
		me.ksReadOnly = state;
		me.setReadOnly(state);
		//todo ref #1396 пока закомментировано, иначе идет двойной вызов enableTools		
		//me.enableTools(me.getFrstSelect());
	},

	// Свернуть/развернуть все узлы
	collapseAllNode: function(collapse){
		var th = this;
		if (collapse) th.collapseAll();
		else th.expandAll();
	},
	clearData: function() {
		this.setRootNode({
			expanded: true,
			children: []
		});
	},
	getLoadMaskTarget: function () {
		return this.ownerCt.editHostPanel;
	},
});