﻿Ext.define('Keysystems.Controls.Signal', {
	extend: 'Ext.draw.Component',
	autoRender: true,
	width: 20,
	height: 20,
	activ: 3,
	border: 0,
	animTime: 500,
	goodTime: 10000,
	mediumTime: 30000,
	checkInterval: 30000,
	cls: 'ks-signal',
	listeners: {
		render: function () {
			let me = this,
				scaling = {
				x: 0.03,
				y: 0.03,
				centerX: 1,
				centerY: 1,
			};
			let color = 'black';

			let sprites  = [				
				{
					type: 'path',
					fill: color,
					path: 'M233.503,70.369c93.726-6.75,189.622,28.317,256.515,94.363c8.765,9.023,7.622,24.807-1.625,33.076 c-8.493,10.012-25.501,10.189-34.266,0.436c-57.224-55.091-138.018-84.881-217.35-78.956 c-65.905,4.24-129.749,32.628-177.572,78.096c-4.253,4.347-9.684,7.916-15.938,8.222c-15.666,1.837-30.154-14.536-26.773-29.86 c0.954-5.501,4.487-10.083,8.527-13.747C81.009,108.392,156.172,75.469,233.503,70.369z',
					scaling: scaling					
				},				
				{
					type: 'path',
					fill: color,
					path: 'M231.183,162.282c71.806-7.81,146.369,18.658,197.183,69.968c7.939,9.07,6.95,23.901-1.872,32.052 c-8.046,9.847-24.265,10.953-33.383,2.024c-32.534-32.074-76.518-52.44-122.126-55.774c-55.387-4.594-111.974,16.42-151.411,55.445 c-9.094,9.612-26.033,8.518-34.218-1.708c-8.823-8.327-9.553-23.559-1.084-32.381C123.356,192.802,176.209,167.924,231.183,162.282z',
					scaling: scaling
				},
		
				{
					type: 'path',
					fill: color,
					path: 'M241.796,252.97c45.314-4.499,92.161,12.852,123.693,45.669c8.634,8.987,7.634,24.454-1.461,32.77 c-8.257,9.966-24.807,10.638-33.782,1.296c-17.774-18.245-42.394-29.778-67.884-31.168c-28.929-2.062-58.201,9.365-78.744,29.695 c-5.053,5.679-12.557,9.165-20.237,8.259c-17.833-1.25-30.213-25.056-17.928-39.344C170.26,273.243,205.492,256.575,241.796,252.97z',
					scaling: scaling
				},
		
				{
					type: 'path',
					fill: color,
					path: 'M248.781,337.651c29.201-4.9,58.837,19.213,59.78,48.824c2.709,29.036-22.923,56.589-52.063,55.951 c-26.197,0.908-50.475-20.825-52.772-46.88C199.991,368.194,221.382,340.808,248.781,337.651z',
					scaling: scaling
				}
			];
			this.getSurface().setItems(sprites);

			let items = me.getSurface().getItems();
			me.lastPath = items[2].path;

			me.pathList = [];
			Ext.each(items, function(el) { me.pathList.push(el.path); });

			//todo при первоначальной отрисовке иногда падает с ошибкой, пробуем выставить таймаут по рендерингу  
			setTimeout(me.startCheckSignal(), 2000);
		}
	},
	
	initComponent: function() {
		let me = this;

		me.callParent(arguments);		
		me.on({
			element: 'element',
			//render: 'startCheckSignal',
			mouseenter: 'mouseenter',
			mouseleave: 'mouseleave',			
			scope: me
		});	
		
	},
	
	handler: Ext.emptyFn,

	mouseenter: function(e) {		
		let me = this;
		me.showToolTip(e, wmc.get('StatusSignal', me.activStatus));
		me.isMouseEnter = true;
		setTimeout(function() {
			me.isMouseEnter = false;
			me.hideToolTip();
		}, 5000);
		me.m_animate();
	},
	mouseleave: function(e) {
		this.hideToolTip();
		this.isMouseEnter = false;
	},

	getToolTip: function() { return this.tooltip || (this.tooltip = Ext.create('Ext.tip.ToolTip')); },
	hideToolTip: function() {
		let me = this,
			tip = me.getToolTip();
		if (tip.rendered) tip.disable();
		me.hiddenTip = false;
	},
	showToolTip: function(e, text) {
		let me = this,
			tip = me.getToolTip();

		tip.showAt(e.getXY());
		tip.update(text);
		tip.enable();
	},

	setStatus: function(status) {
		let fn = this['setStatus' + status];
		this.activStatus = status;
		if (Ext.isFunction(fn)) fn.call(this);
	},
	setStatusGood: function() {
		let me = this;
		try {
			Ext.each(me.getSurface().getItems(), function (el) {
				el.setAnimation({
					duration: me.animTime,
					easing: 'easeOut',
				});
				el.setAttributes({
					fill: 'green'
				});
			});
		} catch (ex) {}
		me.stopAnimate();
	},
	setStatusMedium: function() {
		let me = this;
		try {
			Ext.each(me.getSurface().getItems(), function (el) {
				el.setAnimation({
					duration: me.animTime,
					easing: 'easeOut',
				});
				el.setAttributes({
					fill: '#efc411'
				});
			});
		} catch (ex) {}
		me.stopAnimate();
	},
	setStatusNone: function() {
		let me = this;
		try {
			Ext.each(me.getSurface().getItems(), function (el) {
				el.setAnimation({
					duration: me.animTime,
					easing: 'easeOut',
				});
				el.setAttributes({
					fill: 'red'
				});
			});
		} catch (ex) {}
		me.startAnimate();
	},
	startAnimate: function() {
		this.stopAnim = false;
		this.m_animate();
	},
	stopAnimate: function() {
		this.stopAnim = true;
	},

	returnImg: function() {
		let me = this;
		try {
			Ext.each(me.pathList, function (path, i) {
				let el = me.getSurface().getItems()[i];
				el.setAnimation({
					duration: me.animTime,
					easing: 'easeOut',
				});
				el.setAttributes({
					path: path
				});
			});
			me.renderFrame();
		} catch (ex) {}
	},

	m_animate: function() {
		let me = this,
			sprites = me.getSurface().getItems();
		if (me.isAnimRun) return;
		if (me.stopAnim && !me.isMouseEnter) {
			me.returnImg();
			return;
		}
		me.isAnimRun = true;
		let el = sprites[me.activ],
			tmpPath = el.path;

		me.activ = (me.activ + 1) % sprites.length;

		try {
			el.setAnimation({
				duration: me.animTime,
				easing: 'easeOut',
			});
			el.setAttributes({
				path: me.lastPath
			});
		
			me.renderFrame();
		} catch (ex) {}
		me.lastPath = tmpPath;

		setTimeout(function() { me.m_animate(); }, me.animTime);

		me.isAnimRun = false;
	},
	startCheckSignal: function() {		
		let me = this;
		if (!me.checkIntervalId) {
			me.checkSignal();
			me.checkIntervalId = setInterval(function() { me.checkSignal(); }, me.checkInterval);
		}
	},
	stopCheckSignal: function() {
		let me = this;
		if (!me.checkIntervalId) clearInterval(me.checkIntervalId);
	},
	checkSignal: function() {
		let me = this,
			now1 = new Date();
		
		ajaxRequest({
			url: '/Home/Ping_A',
			timeout: me.mediumTime * 1.5,
			callback: function() {
				let now2 = new Date(),
					t = now2 - now1;

				me.setStatus(t < me.goodTime ? 'Good' : t < me.mediumTime ? 'Medium' : 'None');
			}
		});
	}
});